/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.JarLoader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

class SecureJarLoader
extends JarLoader {
    @Nullable
    private ProtectionDomain myProtectionDomain;
    private final Object myProtectionDomainMonitor = new Object();

    SecureJarLoader(URL url, int index2, ClassPath configuration) throws IOException {
        super(url, index2, configuration);
    }

    @Override
    protected Resource instantiateResource(URL url, ZipEntry entry) throws IOException {
        return new MySecureResource(url, (JarEntry)entry);
    }

    @Override
    @NotNull
    protected ZipFile createZipFile(String path2) throws IOException {
        JarFile jarFile = new JarFile(path2);
        if (jarFile == null) {
            SecureJarLoader.$$$reportNull$$$0(0);
        }
        return jarFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/lang/SecureJarLoader", "createZipFile"));
    }

    private class MySecureResource
    extends JarLoader.MyResource {
        MySecureResource(URL url, JarEntry entry) throws IOException {
            super(url, entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() throws IOException {
            byte[] result2;
            JarFile file2 = (JarFile)SecureJarLoader.this.getZipFile();
            InputStream stream = null;
            try {
                stream = file2.getInputStream(this.myEntry);
                result2 = FileUtilRt.loadBytes(stream, (int)this.myEntry.getSize());
                Object object = SecureJarLoader.this.myProtectionDomainMonitor;
                synchronized (object) {
                    if (SecureJarLoader.this.myProtectionDomain == null) {
                        JarEntry jarEntry = file2.getJarEntry(this.myEntry.getName());
                        CodeSource codeSource = new CodeSource(this.myUrl, jarEntry.getCodeSigners());
                        SecureJarLoader.this.myProtectionDomain = new ProtectionDomain(codeSource, new Permissions());
                    }
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                SecureJarLoader.this.releaseZipFile(file2);
            }
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public ProtectionDomain getProtectionDomain() {
            Object object = SecureJarLoader.this.myProtectionDomainMonitor;
            synchronized (object) {
                return SecureJarLoader.this.myProtectionDomain;
            }
        }
    }
}

