/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.AttributeList;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.ContentList;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.ImmutableSameTypeAttributeList;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.Parent;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.filter.ElementFilter;
import org.jetbrains.kotlin.org.jdom.filter.Filter;

class ImmutableElement
extends Element {
    private static final List<Attribute> EMPTY_LIST = new ImmutableSameTypeAttributeList(ArrayUtilRt.EMPTY_STRING_ARRAY, null, Namespace.NO_NAMESPACE);
    private final Content[] myContent;
    private static final Content[] EMPTY_CONTENT = new Content[0];
    private final List<Attribute> myAttributes;

    @Override
    @NotNull
    public List<Content> getContent() {
        List<Content> list2 = Arrays.asList(this.myContent);
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public <T extends Content> List<T> getContent(Filter<T> filter2) {
        return ContainerUtil.filter(this.myContent, filter2::matches);
    }

    @Override
    @NotNull
    public List<Element> getChildren() {
        List<Element> list2 = this.getContent(new ElementFilter());
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Element> getChildren(String name, Namespace ns) {
        List<Element> list2 = this.getContent(new ElementFilter(name, ns));
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public Element getChild(String name, Namespace ns) {
        List<Element> children2 = this.getChildren(name, ns);
        return children2.isEmpty() ? null : children2.get(0);
    }

    @Override
    public String getText() {
        if (this.myContent.length == 0) {
            return "";
        }
        if (this.myContent.length == 1) {
            Content obj = this.myContent[0];
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content content : this.myContent) {
            if (!(content instanceof Text)) continue;
            textContent.append(((Text)content).getText());
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    @Override
    public boolean hasAttributes() {
        return !this.myAttributes.isEmpty();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public Attribute getAttribute(String name, Namespace ns) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).get(name, ns);
        }
        String uri = this.namespace.getURI();
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute a = this.myAttributes.get(i);
            String oldURI = a.getNamespaceURI();
            String oldName = a.getName();
            if (!oldURI.equals(uri) || !oldName.equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    @Nullable
    public String getAttributeValue(String attname) {
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE);
    }

    @Override
    public String getAttributeValue(String attname, String def) {
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE, def);
    }

    @Override
    public String getAttributeValue(String attname, Namespace ns) {
        return this.getAttributeValue(attname, ns, null);
    }

    @Override
    public String getAttributeValue(String name, Namespace ns, String def) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).getValue(name, ns, def);
        }
        Attribute attribute = this.getAttribute(name, ns);
        return attribute == null ? def : attribute.getValue();
    }

    @Override
    public Element clone() {
        Element element = new Element();
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        element.name = this.getName();
        element.namespace = this.getNamespace();
        List<Attribute> attributes = this.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        List<Content> content = this.getContent();
        for (Content c : content) {
            element.content.add(c.clone());
        }
        return element;
    }

    @Override
    public Element getParent() {
        throw ImmutableElement.immutableError(this);
    }

    public boolean attributesEqual(Element element) {
        List<Attribute> attrs = element.getAttributes();
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return this.myAttributes.equals(attrs);
        }
        if (this.myAttributes.size() != attrs.size()) {
            return false;
        }
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute oAttr;
            Attribute attribute = this.myAttributes.get(i);
            if (ImmutableElement.attributesEqual(attribute, oAttr = attrs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributesEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && Comparing.equal(a1.getValue(), a2.getValue()) && a1.getAttributeType() == a2.getAttributeType() && a1.getNamespace().equals(a2.getNamespace());
    }

    @NotNull
    static IncorrectOperationException immutableError(Object element) {
        IncorrectOperationException incorrectOperationException = new IncorrectOperationException("Can't change immutable element: " + element.getClass() + ". To obtain mutable Element call .clone()");
        if (incorrectOperationException == null) {
            ImmutableElement.$$$reportNull$$$0(10);
        }
        return incorrectOperationException;
    }

    @Override
    public Element detach() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setName(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setNamespace(Namespace namespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Parent setContent(int index2, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Element child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull Attribute attribute) {
        if (attribute == null) {
            ImmutableElement.$$$reportNull$$$0(15);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(String name, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    protected Content setParent(Parent parent2) {
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/org/jdom/ImmutableElement";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/org/jdom/ImmutableElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "internAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "internAttributes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

