/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.StringTrimLowering;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrFunctionMatcherContainer;
import org.jetbrains.kotlin.backend.common.lower.matchers.SimpleCalleeMatcher;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/StringTrimLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "maybeComputeTrimIndent", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "maybeComputeTrimMargin", "visitCall", "expression", "Companion", "ir.backend.common"})
public final class StringTrimLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    private static final SimpleCalleeMatcher trimIndentMatcher;
    private static final SimpleCalleeMatcher trimMarginMatcher;
    private static final FqName TRIM_MARGIN_FQ_NAME;
    private static final FqName TRIM_INDENT_FQ_NAME;
    public static final Companion Companion;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return trimIndentMatcher.invoke(expression2) != false ? this.maybeComputeTrimIndent(expression2) : (trimMarginMatcher.invoke(expression2) != false ? this.maybeComputeTrimMargin(expression2) : super.visitCall(expression2));
    }

    private final IrExpression maybeComputeTrimIndent(IrCall call2) {
        IrExpression irExpression = call2.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        String string2 = StringTrimLowering.Companion.getConstantString(irExpression);
        if (string2 == null) {
            return call2;
        }
        String receiverString = string2;
        String newString = StringsKt.trimIndent((String)receiverString);
        return IrConstImpl.Companion.string(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), newString);
    }

    private final IrExpression maybeComputeTrimMargin(IrCall call2) {
        String string2;
        IrExpression irExpression = call2.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        String string3 = StringTrimLowering.Companion.getConstantString(irExpression);
        if (string3 == null) {
            return call2;
        }
        String receiverString = string3;
        IrExpression prefixArgument = call2.getValueArgument(0);
        if (prefixArgument != null) {
            String string4;
            String string5 = StringTrimLowering.Companion.getConstantString(prefixArgument);
            if (string5 == null) {
                return call2;
            }
            String prefixString = string5;
            try {
                string4 = StringsKt.trimMargin((String)receiverString, (String)prefixString);
            }
            catch (IllegalArgumentException e) {
                return call2;
            }
            string2 = string4;
        } else {
            string2 = StringsKt.trimMargin$default((String)receiverString, null, (int)1, null);
        }
        String newString = string2;
        return IrConstImpl.Companion.string(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), newString);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public StringTrimLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    static {
        Companion = new Companion(null);
        trimIndentMatcher = new SimpleCalleeMatcher((Function1<? super IrFunctionMatcherContainer, Unit>)((Function1)Companion.trimIndentMatcher.1.INSTANCE));
        trimMarginMatcher = new SimpleCalleeMatcher((Function1<? super IrFunctionMatcherContainer, Unit>)((Function1)Companion.trimMarginMatcher.1.INSTANCE));
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf((Object[])new String[]{"kotlin", "text", "trimMargin"}));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.fromSegments(list\u2026\", \"text\", \"trimMargin\"))");
        TRIM_MARGIN_FQ_NAME = fqName2;
        FqName fqName3 = FqName.fromSegments(CollectionsKt.listOf((Object[])new String[]{"kotlin", "text", "trimIndent"}));
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"FqName.fromSegments(list\u2026\", \"text\", \"trimIndent\"))");
        TRIM_INDENT_FQ_NAME = fqName3;
    }

    public static final /* synthetic */ FqName access$getTRIM_INDENT_FQ_NAME$cp() {
        return TRIM_INDENT_FQ_NAME;
    }

    public static final /* synthetic */ FqName access$getTRIM_MARGIN_FQ_NAME$cp() {
        return TRIM_MARGIN_FQ_NAME;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/StringTrimLowering$Companion;", "", "()V", "TRIM_INDENT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "TRIM_MARGIN_FQ_NAME", "trimIndentMatcher", "Lorg/jetbrains/kotlin/backend/common/lower/matchers/SimpleCalleeMatcher;", "trimMarginMatcher", "getConstantString", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
    public static final class Companion {
        private final String getConstantString(IrExpression $this$getConstantString) {
            if ($this$getConstantString instanceof IrConst && Intrinsics.areEqual(((IrConst)$this$getConstantString).getKind(), (Object)IrConstKind.String.INSTANCE)) {
                return (String)IrConstKind.String.INSTANCE.valueOf((IrConst)$this$getConstantString);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

