/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.SingleAbstractMethodLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.load.java.JavaVisibilities;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0010\u001a\u00020\nH\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "jvmContext", "getJvmContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isKotlinFunInterface", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "generateEqualsHashCode", "", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "supertype", "functionDelegateField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getAdditionalSupertypes", "", "getSuperTypeForWrapper", "typeOperand", "getWrapperVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "backend.jvm"})
final class JvmSingleAbstractMethodLowering
extends SingleAbstractMethodLowering {
    private final JvmBackendContext getJvmContext() {
        CommonBackendContext commonBackendContext = this.getContext();
        if (commonBackendContext == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.JvmBackendContext");
        }
        return (JvmBackendContext)commonBackendContext;
    }

    @Override
    @NotNull
    public Visibility getWrapperVisibility(@NotNull IrTypeOperatorCall expression2, @NotNull List<? extends ScopeWithIr> scopes) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Visibility visibility = this.getInInlineFunctionScope() ? Visibilities.PUBLIC : JavaVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"if (inInlineFunctionScop\u2026lities.PACKAGE_VISIBILITY");
        return visibility;
    }

    @Override
    @NotNull
    public IrType getSuperTypeForWrapper(@NotNull IrType typeOperand) {
        Intrinsics.checkNotNullParameter((Object)typeOperand, (String)"typeOperand");
        return IrUtilsKt.getDefaultType(org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getErasedUpperBound(typeOperand));
    }

    private final boolean isKotlinFunInterface(IrType $this$isKotlinFunInterface) {
        IrClass irClass2 = IrTypesKt.getClass($this$isKotlinFunInterface);
        return Intrinsics.areEqual((Object)(irClass2 != null ? irClass2.getOrigin() : null), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) ^ true;
    }

    @Override
    @NotNull
    protected List<IrType> getAdditionalSupertypes(@NotNull IrType supertype2) {
        Intrinsics.checkNotNullParameter((Object)supertype2, (String)"supertype");
        return this.isKotlinFunInterface(supertype2) ? CollectionsKt.listOf((Object)IrTypesKt.typeWith((IrClass)this.getJvmContext().getIr().getSymbols().getFunctionAdapter().getOwner(), new IrType[0])) : CollectionsKt.emptyList();
    }

    @Override
    protected void generateEqualsHashCode(@NotNull IrClass klass, @NotNull IrType supertype2, @NotNull IrField functionDelegateField) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)supertype2, (String)"supertype");
        Intrinsics.checkNotNullParameter((Object)functionDelegateField, (String)"functionDelegateField");
        if (!this.isKotlinFunInterface(supertype2)) {
            return;
        }
        new SamEqualsHashCodeMethodsGenerator(this.getJvmContext(), klass, supertype2, (Function2<? super IrBuilderWithScope, ? super IrExpression, ? extends IrExpression>)((Function2)new Function2<IrBuilderWithScope, IrExpression, IrExpression>(functionDelegateField){
            final /* synthetic */ IrField $functionDelegateField;

            @NotNull
            public final IrExpression invoke(@NotNull IrBuilderWithScope $receiver, @NotNull IrExpression receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                return ExpressionHelpersKt.irGetField($receiver, receiver, this.$functionDelegateField);
            }
            {
                this.$functionDelegateField = irField;
                super(2);
            }
        })).generate();
    }

    public JvmSingleAbstractMethodLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }
}

