/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.AnnotationsWhitelistDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.AnnotationsWhitelistDescriptorRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.ParameterConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001|B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HI0\u00050+\"\u0004\b\u0000\u0010I2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0+H\u0007J\"\u0010K\u001a\u0002072\u0006\u0010L\u001a\u0002072\u0006\u0010M\u001a\u00020<2\b\b\u0002\u0010N\u001a\u00020OH\u0002J\u0016\u0010P\u001a\u0002072\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0018\u0010R\u001a\u0002072\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u000207J\u0018\u0010V\u001a\u00020W2\u0006\u0010M\u001a\u00020<2\u0006\u0010X\u001a\u00020WH\u0007J\u0018\u0010Y\u001a\u00020W2\u0006\u0010M\u001a\u00020<2\u0006\u0010X\u001a\u00020WH\u0007J\u0016\u0010Z\u001a\u0002072\u0006\u0010[\u001a\u00020\\2\u0006\u0010N\u001a\u00020OJ \u0010]\u001a\u0002072\b\u0010^\u001a\u0004\u0018\u00010,2\u000e\u0010_\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010`J\u0018\u0010a\u001a\u00020W2\u0006\u0010M\u001a\u00020<2\u0006\u0010X\u001a\u00020WH\u0007J\u0018\u0010b\u001a\u00020W2\u0006\u0010M\u001a\u00020<2\u0006\u0010c\u001a\u00020WH\u0007J\u0018\u0010d\u001a\u0002072\u0006\u0010e\u001a\u00020f2\u0006\u0010N\u001a\u00020OH\u0002J\u0018\u0010g\u001a\u0002072\u0006\u0010h\u001a\u00020i2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010j\u001a\u0002072\u0006\u0010k\u001a\u00020lH\u0002J\u0018\u0010m\u001a\u0002072\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020qH\u0002J,\u0010r\u001a\u0002072\f\u0010s\u001a\b\u0012\u0004\u0012\u00020,0\u00052\f\u0010t\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010u\u001a\u00020vH\u0002J\u0018\u0010w\u001a\u00020W2\u0006\u0010M\u001a\u00020<2\u0006\u0010X\u001a\u00020WH\u0007J\"\u0010x\u001a\u0004\u0018\u00010W2\u0006\u0010M\u001a\u00020<2\u0006\u0010X\u001a\u00020W2\u0006\u0010y\u001a\u00020\\H\u0002J\f\u0010z\u001a\u000207*\u000207H\u0002J\f\u0010z\u001a\u000207*\u00020{H\u0002R\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00050+8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0002008\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0002008\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000204030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers;", "", "()V", "AMBIGUOUS_CALLABLE_REFERENCES", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "AMBIGUOUS_CALLS", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "CLASSES_OR_SEPARATED", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "COMPACT", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartDescriptorRenderer;", "COMPACT_WITHOUT_SUPERTYPES", "COMPACT_WITH_MODIFIERS", "COMPATIBILITY_CANDIDATE", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_NAME_WITH_KIND", "DEPRECATION_RENDERER", "ELEMENT_TEXT", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "EMPTY", "FQ_NAMES_IN_TYPES", "FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST", "Lorg/jetbrains/kotlin/diagnostics/rendering/AnnotationsWhitelistDescriptorRenderer;", "FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MODULE", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "MODULE_WITH_PLATFORM", "NAME", "Lorg/jetbrains/kotlin/descriptors/Named;", "NAME_OF_CONTAINING_DECLARATION_OR_FILE", "RENDER_CLASS_OR_OBJECT", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "RENDER_CLASS_OR_OBJECT_NAME", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "RENDER_COLLECTION_OF_TYPES", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lorg/jetbrains/kotlin/types/KotlinType;", "RENDER_POSITION_VARIANCE", "Lorg/jetbrains/kotlin/types/Variance;", "RENDER_TYPE", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartTypeRenderer;", "RENDER_TYPE_WITH_ANNOTATIONS", "RENDER_WHEN_MISSING_CASES", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "SHORT_NAMES_IN_TYPES", "STRING", "", "THROWABLE", "", "TO_STRING", "TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER", "TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER", "TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER", "TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER", "TYPE_PROJECTION", "Lorg/jetbrains/kotlin/types/TypeProjection;", "VISIBILITY", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "WHEN_MISSING_LIMIT", "", "WITHOUT_MODIFIERS", "commaSeparated", "T", "itemRenderer", "debugMessage", "message", "inferenceErrorData", "verbosity", "Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;", "renderAmbiguousDescriptors", "descriptors", "renderCallInfo", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "typeCall", "renderCannotCaptureTypeParameterError", "Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;", "result", "renderConflictingSubstitutionsInferenceError", "renderConstraintSystem", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "renderExpressionType", "type", "dataFlowTypes", "", "renderNoInformationForParameterError", "renderParameterConstraintError", "renderer", "renderTypeBound", "bound", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "renderTypeBounds", "typeBounds", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "renderTypeConstructor", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "renderTypeVariable", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "includeTypeConstructor", "", "renderTypes", "types", "typeRenderer", "context", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "renderUpperBoundViolatedInferenceError", "renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor", "systemWithoutWeakConstraints", "wrapIntoQuotes", "Lorg/jetbrains/kotlin/name/Name;", "ConstraintSystemRenderingVerbosity", "frontend"})
public final class Renderers {
    @NotNull
    public static final Renderers INSTANCE = new Renderers();
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> TO_STRING;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> EMPTY;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<String> STRING;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Throwable> THROWABLE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Named> NAME;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ModuleDescriptor> MODULE_WITH_PLATFORM;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ModuleDescriptor> MODULE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DescriptorVisibility> VISIBILITY;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> DECLARATION_NAME_WITH_KIND;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> NAME_OF_CONTAINING_DECLARATION_OR_FILE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<PsiElement> ELEMENT_TEXT;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<KtClassOrObject> RENDER_CLASS_OR_OBJECT;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ClassifierDescriptorWithTypeParameters> RENDER_CLASS_OR_OBJECT_NAME;
    @JvmField
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE;
    @JvmField
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE_WITH_ANNOTATIONS;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<TypeProjection> TYPE_PROJECTION;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Variance> RENDER_POSITION_VARIANCE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<CallableDescriptor> COMPATIBILITY_CANDIDATE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends CallableDescriptor>> AMBIGUOUS_CALLABLE_REFERENCES;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends KotlinType>> RENDER_COLLECTION_OF_TYPES;
    private static final int WHEN_MISSING_LIMIT;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<List<? extends WhenMissingCase>> RENDER_WHEN_MISSING_CASES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES;
    @JvmField
    @NotNull
    public static final AnnotationsWhitelistDescriptorRenderer FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITHOUT_SUPERTYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer WITHOUT_MODIFIERS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer SHORT_NAMES_IN_TYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITH_MODIFIERS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer DEPRECATION_RENDERER;

    private Renderers() {
    }

    private final String renderAmbiguousDescriptors(Collection<? extends CallableDescriptor> descriptors) {
        RenderingContext.Impl context2 = new RenderingContext.Impl(descriptors);
        Iterable iterable = descriptors;
        MemberComparator memberComparator = MemberComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)memberComparator, (String)"INSTANCE");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)memberComparator), (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, (Function1)((Function1)new Function1<CallableDescriptor, CharSequence>(context2){
            final /* synthetic */ RenderingContext.Impl $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull CallableDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Renderers.FQ_NAMES_IN_TYPES.render(it, (RenderingContext)this.$context);
            }
        }), (int)28, null);
    }

    @JvmStatic
    @NotNull
    public static final <T> DiagnosticParameterRenderer<Collection<? extends T>> commaSeparated(@NotNull DiagnosticParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkNotNullParameter(itemRenderer, (String)"itemRenderer");
        return DiagnosticParameterRendererKt.ContextDependentRenderer((Function2)new Function2<Collection<? extends T>, RenderingContext, String>(itemRenderer){
            final /* synthetic */ DiagnosticParameterRenderer<T> $itemRenderer;
            {
                this.$itemRenderer = $itemRenderer;
                super(2);
            }

            @NotNull
            public final String invoke(@NotNull Collection<? extends T> collection, @NotNull RenderingContext context2) {
                Intrinsics.checkNotNullParameter(collection, (String)"collection");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                DiagnosticParameterRenderer<T> diagnosticParameterRenderer = this.$itemRenderer;
                boolean bl = false;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder $this$invoke_u24lambda_u2d0 = stringBuilder2;
                boolean bl5 = false;
                Iterator<T> iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    T next = iterator2.next();
                    $this$invoke_u24lambda_u2d0.append(diagnosticParameterRenderer.render(next, context2));
                    if (!iterator2.hasNext()) continue;
                    $this$invoke_u24lambda_u2d0.append(", ");
                }
                String string2 = stringBuilder2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                return string2;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), Renderers.debugMessage$default(INSTANCE, "Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData, null, 4, null));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> collection = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem)");
        Collection<TypeSubstitutor> substitutors = collection;
        for (TypeSubstitutor substitutor2 : substitutors) {
            CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
            Intrinsics.checkNotNullExpressionValue((Object)substitutor2, (String)"substitutor");
            CallableDescriptor substitutedDescriptor = (CallableDescriptor)callableDescriptor.substitute(substitutor2);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeVariable firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(inferenceErrorData.constraintSystem);
        if (firstConflictingVariable == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData, null, 4, null));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingVariable.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            KotlinType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            boolean bl = false;
            HashSet<ConstraintPosition> errorPositions = new HashSet<ConstraintPosition>();
            ArrayList<KotlinType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                KotlinType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<KotlinType>)parameterTypes, arg_0 -> Renderers.renderConflictingSubstitutionsInferenceError$lambda-0(errorPositions, arg_0));
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderParameterConstraintError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer renderer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConstraintError it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        List<ConstraintError> constraintErrors = inferenceErrorData.constraintSystem.getStatus().getConstraintErrors();
        Iterable $this$filter$iv = constraintErrors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintError)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof ParameterConstraintError)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConstraintError)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConstraintPosition constraintPosition = it.getConstraintPosition();
            collection.add(constraintPosition);
        }
        List errorPositions = (List)destination$iv$iv;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, arg_0 -> Renderers.renderParameterConstraintError$lambda-3(errorPositions, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)tabledDescriptorRenderer, (String)"renderer.table(\n            TabledDescriptorRenderer\n                .newTable()\n                .descriptor(inferenceErrorData.descriptor)\n                .text(\"cannot be applied to\")\n                .functionArgumentTypeList(inferenceErrorData.receiverArgumentType,\n                                          inferenceErrorData.valueArgumentsTypes,\n                                          { errorPositions.contains(it) })\n        )");
        return tabledDescriptorRenderer;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Iterable $this$firstOrNull$iv = inferenceErrorData.constraintSystem.getTypeVariables();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TypeVariable variable2 = (TypeVariable)element$iv;
                boolean bl = false;
                if (!inferenceErrorData.constraintSystem.getTypeBounds(variable2).getValues().isEmpty()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object object = v0;
        if (object == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer = result2;
            boolean bl = false;
            boolean bl2 = false;
            TabledDescriptorRenderer $this$renderNoInformationForParameterError_u24lambda_u2d5 = tabledDescriptorRenderer;
            boolean bl3 = false;
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData, null, 4, null));
            return tabledDescriptorRenderer;
        }
        TypeVariable firstUnknownVariable = object;
        object = result2.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownVariable.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result\n            .text(\n                newText().normal(\"Not enough information to infer parameter \")\n                    .strong(firstUnknownVariable.name)\n                    .normal(\" in \")\n            )\n            .table(\n                newTable()\n                    .descriptor(inferenceErrorData.descriptor)\n                    .text(\"Please specify it explicitly.\")\n            )");
        return object;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v0;
        Object $this$firstOrNull$iv;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status2;
        block8: {
            Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"inferenceErrorData.constraintSystem");
            ConstraintSystem constraintSystem2 = constraintSystem;
            status2 = constraintSystem2.getStatus();
            LOG.assertTrue(status2.hasViolatedUpperBound(), Renderers.debugMessage$default(INSTANCE, "Upper bound violated renderer is applied for incorrect status", inferenceErrorData, null, 4, null));
            systemWithoutWeakConstraints = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem2, ConstraintPositionKind.TYPE_BOUND_POSITION);
            List<TypeParameterDescriptor> list2 = inferenceErrorData.descriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"inferenceErrorData.descriptor.typeParameters");
            $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv;
                boolean bl = false;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, typeParameterDescriptor, inferenceErrorData.call, true))) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v0;
        if (typeParameterDescriptor == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            if (inferenceErrorData.descriptor instanceof TypeAliasConstructorDescriptor && ($this$firstOrNull$iv = INSTANCE.renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(inferenceErrorData, result2, systemWithoutWeakConstraints)) != null) {
                Object $i$f$firstOrNull = $this$firstOrNull$iv;
                boolean bl = false;
                boolean element$iv = false;
                Object object = $i$f$firstOrNull;
                boolean bl2 = false;
                return object;
            }
            if (status2.hasConflictingConstraints()) {
                tabledDescriptorRenderer = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
            } else {
                LOG.error(INSTANCE.debugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData, ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE));
                tabledDescriptorRenderer = result2;
            }
            return tabledDescriptorRenderer;
        }
        Call $i$f$firstOrNull = inferenceErrorData.call;
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$firstOrNull, (String)"inferenceErrorData.call");
        TypeVariable typeVariable2 = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, TypeVariableKt.toHandle($i$f$firstOrNull), typeParameterDescriptor);
        KotlinType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeVariable2).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData, null, 4, null));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        KotlinType violatedUpperBound = null;
        for (KotlinType kotlinType : typeParameterDescriptor.getUpperBounds()) {
            KotlinType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(kotlinType, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData, null, 4, null));
            return result2;
        }
        Object[] objectArray = new Object[]{inferredValueForTypeParameter, violatedUpperBound};
        RenderingContext context2 = RenderingContext.Companion.of(objectArray);
        DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer = result2.getTypeRenderer();
        Intrinsics.checkNotNullExpressionValue(diagnosticParameterRenderer, (String)"result.typeRenderer");
        DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer2 = diagnosticParameterRenderer;
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(diagnosticParameterRenderer2.render(inferredValueForTypeParameter, context2)).normal(" is not a subtype of ").strong(diagnosticParameterRenderer2.render(violatedUpperBound, context2)));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final TabledDescriptorRenderer renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2, ConstraintSystem systemWithoutWeakConstraints) {
        Object[] it;
        void $this$mapTo$iv$iv;
        CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"inferenceErrorData.descriptor");
        CallableDescriptor descriptor2 = callableDescriptor;
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            LOG.error(Intrinsics.stringPlus((String)"Type alias constructor descriptor expected: ", (Object)descriptor2));
            return result2;
        }
        List<TypeParameterDescriptor> list2 = ((TypeAliasConstructorDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.typeParameters");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Call call2 = inferenceErrorData.call;
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"inferenceErrorData.call");
            CallHandle callHandle = TypeVariableKt.toHandle(call2);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            TypeVariable typeVariable2 = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, callHandle, (TypeParameterDescriptor)it);
            KotlinType kotlinType = systemWithoutWeakConstraints.getTypeBounds(typeVariable2).getValue();
            collection.add(kotlinType);
        }
        List inferredTypesForTypeParameters = (List)destination$iv$iv;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(descriptor2, inferredTypesForTypeParameters){
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ List<KotlinType> $inferredTypesForTypeParameters;
            {
                this.$descriptor = $descriptor;
                this.$inferredTypesForTypeParameters = $inferredTypesForTypeParameters;
            }

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                TypeProjectionImpl typeProjectionImpl;
                Annotated annotated;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ClassifierDescriptor classifierDescriptor = key.getDeclarationDescriptor();
                TypeParameterDescriptor typeParameterDescriptor = annotated = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                if (annotated == null) {
                    return null;
                }
                TypeParameterDescriptor typeDescriptor = annotated;
                if (!Intrinsics.areEqual((Object)typeDescriptor.getContainingDeclaration(), (Object)((TypeAliasConstructorDescriptor)this.$descriptor).getTypeAliasDescriptor())) {
                    return null;
                }
                annotated = this.$inferredTypesForTypeParameters.get(typeDescriptor.getIndex());
                if (annotated == null) {
                    typeProjectionImpl = null;
                } else {
                    classifierDescriptor = annotated;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClassifierDescriptor p0 = classifierDescriptor;
                    boolean bl3 = false;
                    typeProjectionImpl = new TypeProjectionImpl((KotlinType)((Object)p0));
                }
                return typeProjectionImpl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"val descriptor = inferenceErrorData.descriptor\n        if (descriptor !is TypeAliasConstructorDescriptor) {\n            LOG.error(\"Type alias constructor descriptor expected: $descriptor\")\n            return result\n        }\n\n        val inferredTypesForTypeParameters = descriptor.typeParameters.map {\n            val typeVariable = systemWithoutWeakConstraints.descriptorToVariable(inferenceErrorData.call.toHandle(), it)\n            systemWithoutWeakConstraints.getTypeBounds(typeVariable).value\n        }\n        val inferredTypeSubstitutor = TypeSubstitutor.create(object : TypeConstructorSubstitution() {\n            override fun get(key: TypeConstructor): TypeProjection? {\n                val typeDescriptor = key.declarationDescriptor as? TypeParameterDescriptor ?: return null\n                if (typeDescriptor.containingDeclaration != descriptor.typeAliasDescriptor) return null\n                return inferredTypesForTypeParameters[typeDescriptor.index]?.let(::TypeProjectionImpl)\n            }\n        })");
        TypeSubstitutor inferredTypeSubstitutor2 = typeSubstitutor2;
        for (ConstraintError constraintError : inferenceErrorData.constraintSystem.getStatus().getConstraintErrors()) {
            Object item$iv$iv;
            ValidityConstraintForConstituentType $i$f$mapTo2 = ConstraintPositionKt.getValidityConstraintForConstituentType(constraintError.getConstraintPosition());
            if ($i$f$mapTo2 == null) continue;
            ValidityConstraintForConstituentType constraintInfo = $i$f$mapTo2;
            KotlinType kotlinType = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getBound(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"inferredTypeSubstitutor.safeSubstitute(constraintInfo.bound, Variance.INVARIANT)");
            KotlinType violatedUpperBound = kotlinType;
            item$iv$iv = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getTypeArgument(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue(item$iv$iv, (String)"inferredTypeSubstitutor.safeSubstitute(constraintInfo.typeArgument, Variance.INVARIANT)");
            Object violatingInferredType = item$iv$iv;
            it = new Object[]{violatingInferredType, violatedUpperBound};
            RenderingContext context2 = RenderingContext.Companion.of(it);
            DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer = result2.getTypeRenderer();
            Intrinsics.checkNotNullExpressionValue(diagnosticParameterRenderer, (String)"result.typeRenderer");
            DiagnosticParameterRenderer<KotlinType> typeRenderer = diagnosticParameterRenderer;
            result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(constraintInfo.getTypeParameter().getName()).normal(" in type inferred from type alias expansion for ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
            result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render((KotlinType)violatingInferredType, context2)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound, context2)));
            return result2;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        CapturedTypeConstructor capturedTypeConstructor;
        Object v2;
        Object element$iv22;
        TypeVariable typeVariableWithCapturedConstraint;
        Object element$iv3;
        block6: {
            Object v0;
            ConstraintSystem system2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
                Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"inferenceErrorData.constraintSystem");
                system2 = constraintSystem;
                List<ConstraintError> errors = system2.getStatus().getConstraintErrors();
                Iterable $this$firstIsInstanceOrNull$iv = errors;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv3 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv3 instanceof CannotCapture)) continue;
                    v0 = element$iv3;
                    break block5;
                }
                v0 = null;
            }
            CannotCapture cannotCapture = v0;
            TypeVariable typeVariable2 = typeVariableWithCapturedConstraint = cannotCapture == null ? null : cannotCapture.getTypeVariable();
            if (typeVariableWithCapturedConstraint == null) {
                LOG.error(Renderers.debugMessage$default(INSTANCE, "An error 'cannot capture type parameter' is not found in errors", inferenceErrorData, null, 4, null));
                return result2;
            }
            TypeBounds typeBounds = system2.getTypeBounds(typeVariableWithCapturedConstraint);
            Iterable $this$firstOrNull$iv = typeBounds.getBounds();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv22 : $this$firstOrNull$iv) {
                TypeBounds.Bound it = (TypeBounds.Bound)element$iv22;
                boolean bl = false;
                if (!CapturedTypeConstructorKt.isCaptured(it.getConstrainingType())) continue;
                v2 = element$iv22;
                break block6;
            }
            v2 = null;
        }
        TypeBounds.Bound boundWithCapturedType = v2;
        element$iv3 = boundWithCapturedType;
        TypeConstructor $i$f$firstOrNull = element$iv3 == null ? null : ((element$iv22 = ((TypeBounds.Bound)element$iv3).getConstrainingType()) == null ? null : ((KotlinType)element$iv22).getConstructor());
        CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor = $i$f$firstOrNull instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)$i$f$firstOrNull : null;
        if (capturedTypeConstructor == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData, null, 4, null));
            return result2;
        }
        TypeParameterDescriptor typeParameter = typeVariableWithCapturedConstraint.getOriginalTypeParameter();
        element$iv22 = TypeIntersector.getUpperBoundsAsType(typeParameter);
        Intrinsics.checkNotNullExpressionValue((Object)element$iv22, (String)"getUpperBoundsAsType(typeParameter)");
        Object upperBound = element$iv22;
        boolean element$iv22 = !KotlinBuiltIns.isNullableAny((KotlinType)upperBound) && capturedTypeConstructor.getProjection().getProjectionKind() == Variance.IN_VARIANCE;
        boolean bl = false;
        if (_Assertions.ENABLED && !element$iv22) {
            boolean bl2 = false;
            String string2 = "There is the only reason to report TYPE_INFERENCE_CANNOT_CAPTURE_TYPES";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Object[] objectArray = new Object[]{upperBound};
        String explanation = "Type parameter has an upper bound " + INSTANCE.wrapIntoQuotes(result2.getTypeRenderer().render((KotlinType)upperBound, RenderingContext.Companion.of(objectArray))) + " that cannot be satisfied capturing 'in' projection";
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText();
        StringBuilder stringBuilder2 = new StringBuilder();
        objectArray = typeParameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"typeParameter.name");
        StringBuilder stringBuilder3 = stringBuilder2.append(INSTANCE.wrapIntoQuotes((Name)objectArray)).append(" cannot capture ");
        objectArray = new Object[]{capturedTypeConstructor.getProjection()};
        result2.text(textRenderer.normal(stringBuilder3.append(INSTANCE.wrapIntoQuotes(result2.getTypeProjectionRenderer().render(capturedTypeConstructor.getProjection(), RenderingContext.Companion.of(objectArray)))).append(". ").append(explanation).toString()));
        return result2;
    }

    private final String renderTypes(Collection<? extends KotlinType> types2, DiagnosticParameterRenderer<? super KotlinType> typeRenderer, RenderingContext context2) {
        String string2 = StringUtil.join(types2, arg_0 -> Renderers.renderTypes$lambda-11(typeRenderer, context2, arg_0), ", ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(types, { typeRenderer.render(it, context) }, \", \")");
        return string2;
    }

    @NotNull
    public final String renderConstraintSystem(@NotNull ConstraintSystem constraintSystem, @NotNull ConstraintSystemRenderingVerbosity verbosity) {
        Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
        Intrinsics.checkNotNullParameter((Object)((Object)verbosity), (String)"verbosity");
        boolean bl = false;
        LinkedHashSet<TypeBounds> typeBounds = new LinkedHashSet<TypeBounds>();
        for (TypeVariable variable2 : constraintSystem.getTypeVariables()) {
            typeBounds.add(constraintSystem.getTypeBounds(variable2));
        }
        String separator = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n\n" : "\n";
        return "type parameter bounds:\n" + CollectionsKt.joinToString$default((Iterable)typeBounds, (CharSequence)separator, null, null, (int)0, null, (Function1)((Function1)new Function1<TypeBounds, CharSequence>(verbosity){
            final /* synthetic */ ConstraintSystemRenderingVerbosity $verbosity;
            {
                this.$verbosity = $verbosity;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull TypeBounds it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Renderers.access$renderTypeBounds(Renderers.INSTANCE, it, this.$verbosity);
            }
        }), (int)30, null) + "\n\nstatus:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    private final String renderTypeBounds(TypeBounds typeBounds, ConstraintSystemRenderingVerbosity verbosity) {
        String string2;
        String renderedTypeVariable = this.renderTypeVariable(typeBounds.getTypeVariable(), verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE);
        if (typeBounds.getBounds().isEmpty()) {
            string2 = renderedTypeVariable;
        } else {
            String boundsPrefix = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n" : " ";
            String boundsSeparator = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n" : ", ";
            String renderedBounds2 = CollectionsKt.joinToString$default((Iterable)typeBounds.getBounds(), (CharSequence)boundsSeparator, null, null, (int)0, null, (Function1)((Function1)new Function1<TypeBounds.Bound, CharSequence>(verbosity){
                final /* synthetic */ ConstraintSystemRenderingVerbosity $verbosity;
                {
                    this.$verbosity = $verbosity;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TypeBounds.Bound it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Renderers.access$renderTypeBound(Renderers.INSTANCE, it, this.$verbosity);
                }
            }), (int)30, null);
            string2 = renderedTypeVariable + boundsPrefix + renderedBounds2;
        }
        return string2;
    }

    private final String renderTypeVariable(TypeVariable typeVariable2, boolean includeTypeConstructor) {
        Object object = typeVariable2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeVariable.name.asString()");
        String typeVariableName = object;
        if (!includeTypeConstructor) {
            return typeVariableName;
        }
        StringBuilder stringBuilder2 = new StringBuilder().append("TypeVariable ").append(typeVariableName).append(", descriptor = ").append(typeVariable2.getFreshTypeParameter$frontend()).append(", typeConstructor = ");
        object = typeVariable2.getFreshTypeParameter$frontend().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeVariable.freshTypeParameter.typeConstructor");
        return stringBuilder2.append(this.renderTypeConstructor((TypeConstructor)object)).toString();
    }

    private final String renderTypeBound(TypeBounds.Bound bound, ConstraintSystemRenderingVerbosity verbosity) {
        String string2;
        String string3;
        DescriptorRenderer typeRendered = verbosity == ConstraintSystemRenderingVerbosity.COMPACT ? DescriptorRenderer.SHORT_NAMES_IN_TYPES : DescriptorRenderer.FQ_NAMES_IN_TYPES;
        TypeBounds.BoundKind boundKind = bound.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[boundKind.ordinal()];
        switch (n) {
            case 1: {
                string3 = ">: ";
                break;
            }
            case 2: {
                string3 = "<: ";
                break;
            }
            default: {
                string3 = ":= ";
            }
        }
        String arrow = string3;
        String initialBoundRender = arrow + typeRendered.renderType(bound.getConstrainingType()) + (!bound.isProper() ? "*" : "");
        ConstraintSystemRenderingVerbosity constraintSystemRenderingVerbosity = verbosity;
        int n2 = WhenMappings.$EnumSwitchMapping$1[constraintSystemRenderingVerbosity.ordinal()];
        switch (n2) {
            case 1: {
                string2 = initialBoundRender;
                break;
            }
            case 2: {
                string2 = initialBoundRender + " (" + bound.getPosition() + ") ";
                break;
            }
            case 3: {
                StringBuilder stringBuilder2 = new StringBuilder().append(initialBoundRender).append(" (").append(bound.getPosition()).append(")\nConstraining type additional info: ").append(this.renderTypeConstructor(bound.getConstrainingType().getConstructor())).append("\nSupertypes of constraining type:\n");
                Set<KotlinType> set = TypeUtils.getAllSupertypes(bound.getConstrainingType());
                Intrinsics.checkNotNullExpressionValue(set, (String)"getAllSupertypes(bound.constrainingType)");
                string2 = stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinType, CharSequence>(typeRendered){
                    final /* synthetic */ DescriptorRenderer $typeRendered;
                    {
                        this.$typeRendered = $typeRendered;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(KotlinType it) {
                        StringBuilder stringBuilder2 = new StringBuilder().append("- ");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        return stringBuilder2.append(this.$typeRendered.renderType(it)).append(", TypeConstructor info: ").append(Renderers.access$renderTypeConstructor(Renderers.INSTANCE, it.getConstructor())).toString();
                    }
                }), (int)30, null)).append('\n').toString();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String renderTypeConstructor(TypeConstructor typeConstructor2) {
        AbstractTypeConstructor abstractTypeConstructor = typeConstructor2 instanceof AbstractTypeConstructor ? (AbstractTypeConstructor)typeConstructor2 : null;
        return typeConstructor2 + '[' + typeConstructor2.getClass().getName() + "], " + (abstractTypeConstructor == null ? null : abstractTypeConstructor.renderAdditionalDebugInformation());
    }

    private final String debugMessage(String message2, InferenceErrorData inferenceErrorData, ConstraintSystemRenderingVerbosity verbosity) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$debugMessage_u24lambda_u2d12 = stringBuilder2;
        boolean bl5 = false;
        $this$debugMessage_u24lambda_u2d12.append(message2);
        $this$debugMessage_u24lambda_u2d12.append("\nConstraint system: \n");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"inferenceErrorData.constraintSystem");
        $this$debugMessage_u24lambda_u2d12.append(INSTANCE.renderConstraintSystem(constraintSystem, verbosity));
        $this$debugMessage_u24lambda_u2d12.append("\nDescriptor:\n");
        $this$debugMessage_u24lambda_u2d12.append(inferenceErrorData.descriptor);
        $this$debugMessage_u24lambda_u2d12.append("\nExpected type:\n");
        RenderingContext.Empty context2 = RenderingContext.Empty.INSTANCE;
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            $this$debugMessage_u24lambda_u2d12.append(inferenceErrorData.expectedType);
        } else {
            object = inferenceErrorData.expectedType;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inferenceErrorData.expectedType");
            $this$debugMessage_u24lambda_u2d12.append(RENDER_TYPE_WITH_ANNOTATIONS.render((KotlinType)object, (RenderingContext)context2));
        }
        $this$debugMessage_u24lambda_u2d12.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            object = inferenceErrorData.receiverArgumentType;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inferenceErrorData.receiverArgumentType");
            $this$debugMessage_u24lambda_u2d12.append(RENDER_TYPE_WITH_ANNOTATIONS.render((KotlinType)object, (RenderingContext)context2)).append(".");
        }
        StringBuilder stringBuilder3 = $this$debugMessage_u24lambda_u2d12.append("(");
        object = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inferenceErrorData.valueArgumentsTypes");
        stringBuilder3.append(INSTANCE.renderTypes((Collection)object, RENDER_TYPE_WITH_ANNOTATIONS, context2)).append(")");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    static /* synthetic */ String debugMessage$default(Renderers renderers, String string2, InferenceErrorData inferenceErrorData, ConstraintSystemRenderingVerbosity constraintSystemRenderingVerbosity, int n, Object object) {
        if ((n & 4) != 0) {
            constraintSystemRenderingVerbosity = ConstraintSystemRenderingVerbosity.DEBUG;
        }
        return renderers.debugMessage(string2, inferenceErrorData, constraintSystemRenderingVerbosity);
    }

    private final String wrapIntoQuotes(String $this$wrapIntoQuotes) {
        return '\'' + $this$wrapIntoQuotes + '\'';
    }

    private final String wrapIntoQuotes(Name $this$wrapIntoQuotes) {
        return '\'' + $this$wrapIntoQuotes.asString() + '\'';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderExpressionType(@Nullable KotlinType type2, @Nullable Set<? extends KotlinType> dataFlowTypes) {
        void $this$mapTo$iv$iv;
        if (type2 == null) {
            return "Type is unknown";
        }
        if (dataFlowTypes == null) {
            return DescriptorRenderer.DEBUG_TEXT.renderType(type2);
        }
        Iterable $this$map$iv = dataFlowTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = DescriptorRenderer.DEBUG_TEXT.renderType((KotlinType)it);
            collection.add(string2);
        }
        Set set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        boolean bl2 = false;
        Set $this$renderExpressionType_u24lambda_u2d14 = set;
        boolean bl3 = false;
        $this$renderExpressionType_u24lambda_u2d14.add(DescriptorRenderer.DEBUG_TEXT.renderType(type2));
        Set typesAsString = set;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)typesAsString), (CharSequence)" & ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String renderCallInfo(@Nullable FqNameUnsafe fqName2, @NotNull String typeCall) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)typeCall, (String)"typeCall");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$renderCallInfo_u24lambda_u2d15 = stringBuilder2;
        boolean bl5 = false;
        FqNameUnsafe fqNameUnsafe = fqName2;
        $this$renderCallInfo_u24lambda_u2d15.append("fqName: " + (fqNameUnsafe == null ? "fqName is unknown" : ((string2 = fqNameUnsafe.asString()) == null ? "fqName is unknown" : string2)) + "; ");
        $this$renderCallInfo_u24lambda_u2d15.append(Intrinsics.stringPlus((String)"typeCall: ", (Object)typeCall));
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    private static final boolean renderConflictingSubstitutionsInferenceError$lambda-0(HashSet $errorPositions, ConstraintPosition it) {
        Intrinsics.checkNotNullParameter((Object)$errorPositions, (String)"$errorPositions");
        return $errorPositions.contains(it);
    }

    private static final boolean renderParameterConstraintError$lambda-3(List $errorPositions, ConstraintPosition it) {
        Intrinsics.checkNotNullParameter((Object)$errorPositions, (String)"$errorPositions");
        return $errorPositions.contains(it);
    }

    private static final String renderTypes$lambda-11(DiagnosticParameterRenderer $typeRenderer, RenderingContext $context, KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)$typeRenderer, (String)"$typeRenderer");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return $typeRenderer.render(it, $context);
    }

    public static final /* synthetic */ String access$renderTypeBounds(Renderers $this, TypeBounds typeBounds, ConstraintSystemRenderingVerbosity verbosity) {
        return $this.renderTypeBounds(typeBounds, verbosity);
    }

    public static final /* synthetic */ String access$renderTypeBound(Renderers $this, TypeBounds.Bound bound, ConstraintSystemRenderingVerbosity verbosity) {
        return $this.renderTypeBound(bound, verbosity);
    }

    public static final /* synthetic */ String access$renderTypeConstructor(Renderers $this, TypeConstructor typeConstructor2) {
        return $this.renderTypeConstructor(typeConstructor2);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$wrapIntoQuotes(Renderers $this, String $receiver) {
        return $this.wrapIntoQuotes($receiver);
    }

    public static final /* synthetic */ String access$renderAmbiguousDescriptors(Renderers $this, Collection descriptors) {
        return $this.renderAmbiguousDescriptors(descriptors);
    }

    public static final /* synthetic */ String access$renderTypes(Renderers $this, Collection types2, DiagnosticParameterRenderer typeRenderer, RenderingContext context2) {
        return $this.renderTypes(types2, typeRenderer, context2);
    }

    public static final /* synthetic */ int access$getWHEN_MISSING_LIMIT$p() {
        return WHEN_MISSING_LIMIT;
    }

    static {
        Logger logger = Logger.getInstance(Renderers.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(Renderers::class.java)");
        LOG = logger;
        TO_STRING = DiagnosticParameterRendererKt.Renderer(TO_STRING.1.INSTANCE);
        EMPTY = DiagnosticParameterRendererKt.Renderer(EMPTY.1.INSTANCE);
        STRING = DiagnosticParameterRendererKt.Renderer(STRING.1.INSTANCE);
        THROWABLE = DiagnosticParameterRendererKt.Renderer(THROWABLE.1.INSTANCE);
        NAME = DiagnosticParameterRendererKt.Renderer(NAME.1.INSTANCE);
        MODULE_WITH_PLATFORM = DiagnosticParameterRendererKt.Renderer(MODULE_WITH_PLATFORM.1.INSTANCE);
        MODULE = DiagnosticParameterRendererKt.Renderer(MODULE.1.INSTANCE);
        VISIBILITY = DiagnosticParameterRendererKt.Renderer(VISIBILITY.1.INSTANCE);
        DECLARATION_NAME_WITH_KIND = DiagnosticParameterRendererKt.Renderer(DECLARATION_NAME_WITH_KIND.1.INSTANCE);
        CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM = DiagnosticParameterRendererKt.Renderer(CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM.1.INSTANCE);
        NAME_OF_CONTAINING_DECLARATION_OR_FILE = DiagnosticParameterRendererKt.Renderer(NAME_OF_CONTAINING_DECLARATION_OR_FILE.1.INSTANCE);
        ELEMENT_TEXT = DiagnosticParameterRendererKt.Renderer(ELEMENT_TEXT.1.INSTANCE);
        DECLARATION_NAME = DiagnosticParameterRendererKt.Renderer(DECLARATION_NAME.1.INSTANCE);
        RENDER_CLASS_OR_OBJECT = DiagnosticParameterRendererKt.Renderer(RENDER_CLASS_OR_OBJECT.1.INSTANCE);
        RENDER_CLASS_OR_OBJECT_NAME = DiagnosticParameterRendererKt.Renderer(RENDER_CLASS_OR_OBJECT_NAME.1.INSTANCE);
        RENDER_TYPE = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)RENDER_TYPE.1.INSTANCE)));
        RENDER_TYPE_WITH_ANNOTATIONS = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)RENDER_TYPE_WITH_ANNOTATIONS.1.INSTANCE)));
        TYPE_PROJECTION = DiagnosticParameterRendererKt.Renderer(TYPE_PROJECTION.1.INSTANCE);
        RENDER_POSITION_VARIANCE = DiagnosticParameterRendererKt.Renderer(RENDER_POSITION_VARIANCE.1.INSTANCE);
        AMBIGUOUS_CALLS = DiagnosticParameterRendererKt.Renderer(AMBIGUOUS_CALLS.1.INSTANCE);
        COMPATIBILITY_CANDIDATE = DiagnosticParameterRendererKt.Renderer(COMPATIBILITY_CANDIDATE.1.INSTANCE);
        AMBIGUOUS_CALLABLE_REFERENCES = DiagnosticParameterRendererKt.Renderer(AMBIGUOUS_CALLABLE_REFERENCES.1.INSTANCE);
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER.1.INSTANCE);
        CLASSES_OR_SEPARATED = DiagnosticParameterRendererKt.Renderer(CLASSES_OR_SEPARATED.1.INSTANCE);
        RENDER_COLLECTION_OF_TYPES = DiagnosticParameterRendererKt.ContextDependentRenderer(RENDER_COLLECTION_OF_TYPES.1.INSTANCE);
        WHEN_MISSING_LIMIT = 7;
        RENDER_WHEN_MISSING_CASES = DiagnosticParameterRendererKt.Renderer(RENDER_WHEN_MISSING_CASES.1.INSTANCE);
        FQ_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES);
        FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST = AnnotationsWhitelistDescriptorRendererKt.withAnnotationsWhitelist$default(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS, null, 1, null);
        FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS);
        COMPACT = RenderersKt.asRenderer(DescriptorRenderer.COMPACT);
        COMPACT_WITHOUT_SUPERTYPES = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITHOUT_SUPERTYPES);
        WITHOUT_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)WITHOUT_MODIFIERS.1.INSTANCE)));
        SHORT_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        COMPACT_WITH_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITH_MODIFIERS);
        DEPRECATION_RENDERER = RenderersKt.asRenderer(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)DEPRECATION_RENDERER.1.INSTANCE)));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;", "", "(Ljava/lang/String;I)V", "COMPACT", "DEBUG", "EXTRA_VERBOSE", "frontend"})
    public static final class ConstraintSystemRenderingVerbosity
    extends Enum<ConstraintSystemRenderingVerbosity> {
        public static final /* enum */ ConstraintSystemRenderingVerbosity COMPACT = new ConstraintSystemRenderingVerbosity();
        public static final /* enum */ ConstraintSystemRenderingVerbosity DEBUG = new ConstraintSystemRenderingVerbosity();
        public static final /* enum */ ConstraintSystemRenderingVerbosity EXTRA_VERBOSE = new ConstraintSystemRenderingVerbosity();
        private static final /* synthetic */ ConstraintSystemRenderingVerbosity[] $VALUES;

        public static ConstraintSystemRenderingVerbosity[] values() {
            ConstraintSystemRenderingVerbosity[] constraintSystemRenderingVerbosityArray = $VALUES;
            ConstraintSystemRenderingVerbosity[] constraintSystemRenderingVerbosityArray2 = new ConstraintSystemRenderingVerbosity[constraintSystemRenderingVerbosityArray.length];
            System.arraycopy(constraintSystemRenderingVerbosityArray, 0, constraintSystemRenderingVerbosityArray2, 0, constraintSystemRenderingVerbosityArray.length);
            return constraintSystemRenderingVerbosityArray2;
        }

        public static ConstraintSystemRenderingVerbosity valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(ConstraintSystemRenderingVerbosity.class, value2);
        }

        static {
            $VALUES = constraintSystemRenderingVerbosityArray = new ConstraintSystemRenderingVerbosity[]{ConstraintSystemRenderingVerbosity.COMPACT, ConstraintSystemRenderingVerbosity.DEBUG, ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 1;
            nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConstraintSystemRenderingVerbosity.values().length];
            nArray[ConstraintSystemRenderingVerbosity.COMPACT.ordinal()] = 1;
            nArray[ConstraintSystemRenderingVerbosity.DEBUG.ordinal()] = 2;
            nArray[ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

