/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(JO\u0010)\u001a\u00020$\"\b\b\u0000\u0010**\u00020+2\u001e\u0010,\u001a\u001a\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020.0-2\u0006\u00100\u001a\u0002H*2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00103R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkClassHeader", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiver", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkParameterBounds", "checkProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkSupertypes", "checkTypeAlias", "", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "reportExposure", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;", "element", "elementVisibility", "restrictingDescriptor", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "frontend"})
public final class ExposedVisibilityChecker {
    @Nullable
    private final BindingTrace trace;

    public ExposedVisibilityChecker(@Nullable BindingTrace trace) {
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(BindingTrace bindingTrace, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bindingTrace = null;
        }
        this(bindingTrace);
    }

    private final <E extends PsiElement> void reportExposure(DiagnosticFactory3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace != null) {
            bindingTrace.report(diagnostic.on(element, elementVisibility, restrictingDescriptor, restrictingDescriptor.effectiveVisibility()));
        }
    }

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor) {
        ClassConstructorDescriptor classConstructorDescriptor;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        boolean result2 = this.checkSupertypes(klass, classDescriptor);
        result2 &= this.checkParameterBounds(klass, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor2 == null) {
            return result2;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor = classConstructorDescriptor2;
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, constructor2, constructorDescriptor, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        return modifierListOwner instanceof KtFunction && descriptor2 instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor2, visibility2) : (modifierListOwner instanceof KtProperty && descriptor2 instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor2, visibility2) : true);
    }

    public final void checkTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        EffectiveVisibility typeAliasVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(typeAliasDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(expandedType2, typeAliasVisibility);
        if (restricting != null) {
            Object object = Errors.EXPOSED_TYPEALIAS_EXPANDED_TYPE;
            Intrinsics.checkNotNullExpressionValue(object, (String)"EXPOSED_TYPEALIAS_EXPANDED_TYPE");
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = object;
            object = typeAlias.getNameIdentifier();
            this.reportExposure(diagnosticFactory3, object == null ? (PsiElement)typeAlias : object, typeAliasVisibility, restricting);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DescriptorVisibility visibility2) {
        List<ValueParameterDescriptor> restricting;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        EffectiveVisibility functionVisibility = null;
        functionVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(functionDescriptor, visibility2, false, 2, null);
        if (functionDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"functionDescriptor.constructedClass");
            if (DescriptorUtilKt.isSealed(classDescriptor) && KtPsiUtilKt.visibilityModifier(function2) == null) {
                functionVisibility = EffectiveVisibility.Private.INSTANCE;
            }
        }
        boolean result2 = false;
        result2 = true;
        if (!(function2 instanceof KtConstructor)) {
            Object object = functionDescriptor.getReturnType();
            List<ValueParameterDescriptor> list2 = restricting = object == null ? null : EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)object, functionVisibility);
            if (restricting != null) {
                object = Errors.EXPOSED_FUNCTION_RETURN_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EXPOSED_FUNCTION_RETURN_TYPE");
                Object object2 = object;
                object = function2.getNameIdentifier();
                this.reportExposure((DiagnosticFactory3)object2, (PsiElement)(object == null ? (PsiElement)function2 : object), functionVisibility, (DescriptorWithRelation)((Object)restricting));
                result2 = false;
            }
        }
        restricting = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(restricting, (String)"functionDescriptor.valueParameters");
        Iterable $this$forEachIndexed$iv = restricting;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Substitutable<CallableDescriptor> substitutable;
            Object object;
            void parameterDescriptor;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i >= function2.getValueParameters().size()) continue;
            KtParameter valueParameter2 = function2.getValueParameters().get(i);
            Object object3 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameterDescriptor.type");
            DescriptorWithRelation restricting2 = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)object3, functionVisibility);
            if (restricting2 != null) {
                object3 = Errors.EXPOSED_PARAMETER_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"EXPOSED_PARAMETER_TYPE");
                this.reportExposure((DiagnosticFactory3)object3, (PsiElement)valueParameter2, functionVisibility, restricting2);
                result2 = false;
                continue;
            }
            if (!(functionDescriptor instanceof ClassConstructorDescriptor) || !valueParameter2.hasValOrVar()) continue;
            BindingTrace bindingTrace = this.trace;
            PropertyDescriptor propertyDescriptor = bindingTrace == null ? null : (PropertyDescriptor)bindingTrace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor);
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            if (propertyDescriptor2 == null) {
                object = ((ClassConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionDescriptor.constructedClass");
                substitutable = object;
            } else {
                substitutable = propertyDescriptor2;
            }
            EffectiveVisibility propertyOrClassVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(substitutable, null, false, 3, null);
            object = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameterDescriptor.type");
            DescriptorWithRelation restrictingByProperty = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)object, propertyOrClassVisibility);
            if (restrictingByProperty == null) continue;
            object = Errors.EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR");
            this.reportExposure((DiagnosticFactory3)object, (PsiElement)valueParameter2, propertyOrClassVisibility, restrictingByProperty);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor);
    }

    public static /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            DescriptorVisibility descriptorVisibility2 = functionDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"fun checkFunction(\n        function: KtFunction,\n        functionDescriptor: FunctionDescriptor,\n        // for checking situation with modified basic visibility\n        visibility: DescriptorVisibility = functionDescriptor.visibility\n    ): Boolean {\n        var functionVisibility = functionDescriptor.effectiveVisibility(visibility)\n        if (functionDescriptor is ConstructorDescriptor && functionDescriptor.constructedClass.isSealed() && function.visibilityModifier() == null) {\n            functionVisibility = EffectiveVisibility.Private\n        }\n        var result = true\n        if (function !is KtConstructor<*>) {\n            val restricting = functionDescriptor.returnType?.leastPermissiveDescriptor(functionVisibility)\n            if (restricting != null) {\n                reportExposure(EXPOSED_FUNCTION_RETURN_TYPE, function.nameIdentifier ?: function, functionVisibility, restricting)\n                result = false\n            }\n        }\n        functionDescriptor.valueParameters.forEachIndexed { i, parameterDescriptor ->\n            if (i < function.valueParameters.size) {\n                val valueParameter = function.valueParameters[i]\n                val restricting = parameterDescriptor.type.leastPermissiveDescriptor(functionVisibility)\n                if (restricting != null) {\n                    reportExposure(EXPOSED_PARAMETER_TYPE, valueParameter, functionVisibility, restricting)\n                    result = false\n                } else if (functionDescriptor is ClassConstructorDescriptor && valueParameter.hasValOrVar()) {\n                    val propertyDescriptor = trace?.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor)\n                    val propertyOrClassVisibility = (propertyDescriptor ?: functionDescriptor.constructedClass).effectiveVisibility()\n                    val restrictingByProperty = parameterDescriptor.type.leastPermissiveDescriptor(propertyOrClassVisibility)\n                    if (restrictingByProperty != null) {\n                        reportExposure(\n                            EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR, valueParameter, propertyOrClassVisibility, restrictingByProperty\n                        )\n                        result = false\n                    }\n                }\n            }\n        }\n        return result and checkMemberReceiver(function.receiverTypeReference, functionDescriptor)\n    }");
            descriptorVisibility = descriptorVisibility2;
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor, descriptorVisibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(propertyDescriptor, visibility2, false, 2, null);
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"propertyDescriptor.type");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            Object object = Errors.EXPOSED_PROPERTY_TYPE;
            Intrinsics.checkNotNullExpressionValue(object, (String)"EXPOSED_PROPERTY_TYPE");
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = object;
            object = property2.getNameIdentifier();
            this.reportExposure(diagnosticFactory3, object == null ? (PsiElement)property2 : object, propertyVisibility, restricting);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property2.getReceiverTypeReference(), propertyDescriptor);
    }

    public static /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            DescriptorVisibility descriptorVisibility2 = propertyDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"fun checkProperty(\n        property: KtProperty,\n        propertyDescriptor: PropertyDescriptor,\n        // for checking situation with modified basic visibility\n        visibility: DescriptorVisibility = propertyDescriptor.visibility\n    ): Boolean {\n        val propertyVisibility = propertyDescriptor.effectiveVisibility(visibility)\n        val restricting = propertyDescriptor.type.leastPermissiveDescriptor(propertyVisibility)\n        var result = true\n        if (restricting != null) {\n            reportExposure(EXPOSED_PROPERTY_TYPE, property.nameIdentifier ?: property, propertyVisibility, restricting)\n            result = false\n        }\n        return result and checkMemberReceiver(property.receiverTypeReference, propertyDescriptor)\n    }");
            descriptorVisibility = descriptorVisibility2;
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, descriptorVisibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor2 == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor3 = receiverParameterDescriptor = receiverParameterDescriptor2;
        EffectiveVisibility memberVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(memberDescriptor, null, false, 3, null);
        Object object = receiverParameterDescriptor3.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"receiverParameterDescriptor.type");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)object, memberVisibility);
        if (restricting != null) {
            object = Errors.EXPOSED_RECEIVER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EXPOSED_RECEIVER_TYPE");
            this.reportExposure((DiagnosticFactory3)object, (PsiElement)typeReference, memberVisibility, restricting);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor, false, 1, null);
        boolean isInterface = classDescriptor.getKind() == ClassKind.INTERFACE;
        List<KtSuperTypeListEntry> delegationList = klass.getSuperTypeListEntries();
        boolean result2 = false;
        result2 = true;
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"classDescriptor.typeConstructor.supertypes");
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean superIsInterface;
            void superType;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i >= delegationList.size()) {
                return result2;
            }
            ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor((KotlinType)superType);
            if (classDescriptor2 == null) continue;
            ClassDescriptor classDescriptor3 = classDescriptor2;
            ClassDescriptor superDescriptor = classDescriptor3;
            boolean bl3 = superIsInterface = superDescriptor.getKind() == ClassKind.INTERFACE;
            if (superIsInterface != isInterface) continue;
            Intrinsics.checkNotNullExpressionValue((Object)superType, (String)"superType");
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)superType, classVisibility);
            if (restricting == null) continue;
            DiagnosticFactory3<KtSuperTypeListEntry, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = isInterface ? Errors.EXPOSED_SUPER_INTERFACE : Errors.EXPOSED_SUPER_CLASS;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"if (isInterface) EXPOSED_SUPER_INTERFACE else EXPOSED_SUPER_CLASS");
            this.reportExposure(diagnosticFactory3, (PsiElement)delegationList.get(i), classVisibility, restricting);
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor, false, 1, null);
        List<KtTypeParameter> list2 = klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"klass.typeParameters");
        List<KtTypeParameter> typeParameterList = list2;
        boolean result2 = false;
        result2 = true;
        List<TypeParameterDescriptor> list3 = classDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"classDescriptor.declaredTypeParameters");
        Iterable $this$forEachIndexed$iv = list3;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterDescriptor;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i >= typeParameterList.size()) {
                return result2;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                Intrinsics.checkNotNullExpressionValue((Object)upperBound, (String)"upperBound");
                DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(upperBound, classVisibility);
                if (restricting == null) continue;
                DiagnosticFactory3<KtTypeParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPE_PARAMETER_BOUND;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"EXPOSED_TYPE_PARAMETER_BOUND");
                this.reportExposure(diagnosticFactory3, (PsiElement)typeParameterList.get(i), classVisibility, restricting);
                result2 = false;
                continue block0;
            }
        }
        return result2;
    }

    public ExposedVisibilityChecker() {
        this(null, 1, null);
    }
}

