/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.AccessorIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.Actual;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileLocalIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.PublicIdSignature;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrLocalDelegatedPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020(H\u0002J\u000e\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J\u0016\u0010,\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0011J\u0018\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0011H\u0002J\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b042\u0006\u0010-\u001a\u00020.J\u0010\u00105\u001a\u0002062\u0006\u0010$\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010$\u001a\u00020+H\u0002J\u000e\u0010:\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020;J\u0010\u0010<\u001a\u00020;2\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010=\u001a\u00020>2\u0006\u0010-\u001a\u00020.\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b?\u0010@J\u0010\u0010A\u001a\u00020B2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010C\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u000bH\u0002J\u0016\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000bJ\u000e\u0010G\u001a\u00020H2\u0006\u00102\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020J2\u0006\u00102\u001a\u00020\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "actuals", "", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/Actual;", "enqueueLocalTopLevelDeclaration", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "", "handleExpectActualMapping", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializePublicSymbol", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getActuals", "()Ljava/util/List;", "getDeserializePublicSymbol", "()Lkotlin/jvm/functions/Function2;", "deserializedSymbols", "", "getDeserializedSymbols", "()Ljava/util/Map;", "getEnqueueLocalTopLevelDeclaration", "()Lkotlin/jvm/functions/Function1;", "getFileReader", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "getHandleExpectActualMapping", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "deserializeAccessorIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/AccessorIdSignature;", "deserializeFileLocalIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileLocalSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileLocalIdSignature;", "deserializeIdSignature", "index", "", "deserializeIrSymbol", "code", "", "idSig", "symbolKind", "deserializeIrSymbolData", "idSignature", "deserializeIrSymbolToDeclare", "Lkotlin/Pair;", "deserializePublicIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/PublicIdSignature;", "deserializeScopeLocalIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$ScopeLocalDeclaration;", "deserializeSignatureData", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "loadSignatureProto", "parseSymbolData", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData;", "parseSymbolData-9x8F8T0", "(J)J", "readSignature", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "referenceDeserializedSymbol", "referenceLocalIrSymbol", "symbol", "signature", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "ir.serialization.common"})
public final class IrSymbolDeserializer {
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final IrLibraryFile fileReader;
    @NotNull
    private final List<Actual> actuals;
    @NotNull
    private final Function1<org.jetbrains.kotlin.ir.util.IdSignature, Unit> enqueueLocalTopLevelDeclaration;
    @NotNull
    private final Function2<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol, IrSymbol> handleExpectActualMapping;
    @NotNull
    private final Function2<org.jetbrains.kotlin.ir.util.IdSignature, BinarySymbolData.SymbolKind, IrSymbol> deserializePublicSymbol;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> deserializedSymbols;

    public IrSymbolDeserializer(@NotNull ReferenceSymbolTable symbolTable, @NotNull IrLibraryFile fileReader, @NotNull List<Actual> actuals, @NotNull Function1<? super org.jetbrains.kotlin.ir.util.IdSignature, Unit> enqueueLocalTopLevelDeclaration, @NotNull Function2<? super org.jetbrains.kotlin.ir.util.IdSignature, ? super IrSymbol, ? extends IrSymbol> handleExpectActualMapping, @NotNull Function2<? super org.jetbrains.kotlin.ir.util.IdSignature, ? super BinarySymbolData.SymbolKind, ? extends IrSymbol> deserializePublicSymbol) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter(actuals, (String)"actuals");
        Intrinsics.checkNotNullParameter(enqueueLocalTopLevelDeclaration, (String)"enqueueLocalTopLevelDeclaration");
        Intrinsics.checkNotNullParameter(handleExpectActualMapping, (String)"handleExpectActualMapping");
        Intrinsics.checkNotNullParameter(deserializePublicSymbol, (String)"deserializePublicSymbol");
        this.symbolTable = symbolTable;
        this.fileReader = fileReader;
        this.actuals = actuals;
        this.enqueueLocalTopLevelDeclaration = enqueueLocalTopLevelDeclaration;
        this.handleExpectActualMapping = handleExpectActualMapping;
        this.deserializePublicSymbol = deserializePublicSymbol;
        boolean bl = false;
        this.deserializedSymbols = new LinkedHashMap();
    }

    @NotNull
    public final ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrLibraryFile getFileReader() {
        return this.fileReader;
    }

    @NotNull
    public final List<Actual> getActuals() {
        return this.actuals;
    }

    @NotNull
    public final Function1<org.jetbrains.kotlin.ir.util.IdSignature, Unit> getEnqueueLocalTopLevelDeclaration() {
        return this.enqueueLocalTopLevelDeclaration;
    }

    @NotNull
    public final Function2<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol, IrSymbol> getHandleExpectActualMapping() {
        return this.handleExpectActualMapping;
    }

    @NotNull
    public final Function2<org.jetbrains.kotlin.ir.util.IdSignature, BinarySymbolData.SymbolKind, IrSymbol> getDeserializePublicSymbol() {
        return this.deserializePublicSymbol;
    }

    @NotNull
    public final Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> getDeserializedSymbols() {
        return this.deserializedSymbols;
    }

    @NotNull
    public final IrSymbol deserializeIrSymbol(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        IrSymbol irSymbol2;
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
        Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> $this$getOrPut$iv = this.deserializedSymbols;
        boolean $i$f$getOrPut = false;
        IrSymbol value$iv = $this$getOrPut$iv.get(idSig);
        if (value$iv == null) {
            boolean bl = false;
            IrSymbol symbol2 = this.referenceDeserializedSymbol(symbolKind, idSig);
            IrSymbol answer$iv = (IrSymbol)this.getHandleExpectActualMapping().invoke((Object)idSig, (Object)symbol2);
            $this$getOrPut$iv.put(idSig, answer$iv);
            irSymbol2 = answer$iv;
        } else {
            irSymbol2 = value$iv;
        }
        return irSymbol2;
    }

    private final IrSymbol referenceDeserializedSymbol(BinarySymbolData.SymbolKind symbolKind, org.jetbrains.kotlin.ir.util.IdSignature idSig) {
        IrBindableSymbol irBindableSymbol;
        ReferenceSymbolTable referenceSymbolTable = this.symbolTable;
        boolean bl = false;
        boolean bl2 = false;
        ReferenceSymbolTable $this$referenceDeserializedSymbol_u24lambda_u2d1 = referenceSymbolTable;
        boolean bl3 = false;
        BinarySymbolData.SymbolKind symbolKind2 = symbolKind;
        int n = WhenMappings.$EnumSwitchMapping$0[symbolKind2.ordinal()];
        switch (n) {
            case 1: {
                irBindableSymbol = new IrAnonymousInitializerSymbolImpl(null, 1, null);
                break;
            }
            case 2: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceClassFromLinker(idSig);
                break;
            }
            case 3: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceConstructorFromLinker(idSig);
                break;
            }
            case 4: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceTypeParameterFromLinker(idSig);
                break;
            }
            case 5: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceEnumEntryFromLinker(idSig);
                break;
            }
            case 6: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceFieldFromLinker(idSig);
                break;
            }
            case 7: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceFieldFromLinker(idSig);
                break;
            }
            case 8: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceSimpleFunctionFromLinker(idSig);
                break;
            }
            case 9: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referenceTypeAliasFromLinker(idSig);
                break;
            }
            case 10: {
                irBindableSymbol = $this$referenceDeserializedSymbol_u24lambda_u2d1.referencePropertyFromLinker(idSig);
                break;
            }
            case 11: {
                irBindableSymbol = new IrVariableSymbolImpl(null, 1, null);
                break;
            }
            case 12: {
                irBindableSymbol = new IrValueParameterSymbolImpl(null, 1, null);
                break;
            }
            case 13: {
                irBindableSymbol = new IrValueParameterSymbolImpl(null, 1, null);
                break;
            }
            case 14: {
                irBindableSymbol = new IrLocalDelegatedPropertySymbolImpl(null, 1, null);
                break;
            }
            default: {
                String string2 = "Unexpected classifier symbol kind: " + (Object)((Object)symbolKind) + " for signature " + idSig;
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return irBindableSymbol;
    }

    public final void referenceLocalIrSymbol(@NotNull IrSymbol symbol2, @NotNull org.jetbrains.kotlin.ir.util.IdSignature signature2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        boolean bl = signature2.isLocal();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.deserializedSymbols.putIfAbsent(signature2, symbol2);
    }

    @NotNull
    public final IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        return (IrSimpleFunctionSymbol)this.deserializeIrSymbolData(idSignature, BinarySymbolData.SymbolKind.FUNCTION_SYMBOL);
    }

    @NotNull
    public final IrPropertySymbol referencePropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.util.IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        return (IrPropertySymbol)this.deserializeIrSymbolData(idSignature, BinarySymbolData.SymbolKind.PROPERTY_SYMBOL);
    }

    private final IrSymbol deserializeIrSymbolData(org.jetbrains.kotlin.ir.util.IdSignature idSignature, BinarySymbolData.SymbolKind symbolKind) {
        if (idSignature.isLocal()) {
            IrSymbol irSymbol2;
            if (idSignature.getHasTopLevel()) {
                this.enqueueLocalTopLevelDeclaration.invoke((Object)idSignature.topLevelSignature());
            }
            Map<org.jetbrains.kotlin.ir.util.IdSignature, IrSymbol> $this$getOrPut$iv = this.deserializedSymbols;
            boolean $i$f$getOrPut = false;
            IrSymbol value$iv = $this$getOrPut$iv.get(idSignature);
            if (value$iv == null) {
                boolean bl = false;
                IrSymbol answer$iv = this.referenceDeserializedSymbol(symbolKind, idSignature);
                $this$getOrPut$iv.put(idSignature, answer$iv);
                irSymbol2 = answer$iv;
            } else {
                irSymbol2 = value$iv;
            }
            return irSymbol2;
        }
        return (IrSymbol)this.deserializePublicSymbol.invoke((Object)idSignature, (Object)symbolKind);
    }

    @NotNull
    public final Pair<IrSymbol, org.jetbrains.kotlin.ir.util.IdSignature> deserializeIrSymbolToDeclare(long code) {
        long symbolData = this.parseSymbolData-9x8F8T0(code);
        org.jetbrains.kotlin.ir.util.IdSignature signature2 = this.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
        return new Pair((Object)this.deserializeIrSymbolData(signature2, BinarySymbolData.getKind-impl(symbolData)), (Object)signature2);
    }

    public final long parseSymbolData-9x8F8T0(long code) {
        return BinarySymbolData.Companion.decode-9x8F8T0(code);
    }

    @NotNull
    public final IrSymbol deserializeIrSymbol(long code) {
        long symbolData = this.parseSymbolData-9x8F8T0(code);
        org.jetbrains.kotlin.ir.util.IdSignature signature2 = this.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
        return this.deserializeIrSymbolData(signature2, BinarySymbolData.getKind-impl(symbolData));
    }

    private final CodedInputStream readSignature(int index2) {
        return BasicIrModuleDeserializerKt.getCodedInputStream(this.fileReader.signature(index2));
    }

    private final IdSignature loadSignatureProto(int index2) {
        IdSignature idSignature = IdSignature.parseFrom(this.readSignature(index2), ExtensionRegistryLite.newInstance());
        Intrinsics.checkNotNullExpressionValue((Object)idSignature, (String)"parseFrom(readSignature(index), ExtensionRegistryLite.newInstance())");
        return idSignature;
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.util.IdSignature deserializeIdSignature(int index2) {
        IdSignature sigData = this.loadSignatureProto(index2);
        return this.deserializeSignatureData(sigData);
    }

    private final IdSignature.PublicSignature deserializePublicIdSignature(PublicIdSignature proto) {
        List<Integer> list2 = proto.getPackageFqNameList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.packageFqNameList");
        String pkg = IrFileDeserializerKt.deserializeFqName(this.fileReader, list2);
        List<Integer> list3 = proto.getDeclarationFqNameList();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.declarationFqNameList");
        String cls = IrFileDeserializerKt.deserializeFqName(this.fileReader, list3);
        Long memberId = proto.hasMemberUniqId() ? Long.valueOf(proto.getMemberUniqId()) : null;
        return new IdSignature.PublicSignature(pkg, cls, memberId, proto.getFlags());
    }

    private final IdSignature.AccessorSignature deserializeAccessorIdSignature(AccessorIdSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature propertySignature = this.deserializeIdSignature(proto.getPropertySignature());
        boolean bl = propertySignature instanceof IdSignature.PublicSignature;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "For public accessor corresponding property supposed to be public as well";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String name = IrFileDeserializerKt.deserializeString(this.fileReader, proto.getName());
        long hash = proto.getAccessorHashId();
        long mask = proto.getFlags();
        IdSignature.PublicSignature accessorSignature = new IdSignature.PublicSignature(((IdSignature.PublicSignature)propertySignature).getPackageFqName(), ((IdSignature.PublicSignature)propertySignature).getDeclarationFqName() + '.' + name, hash, mask);
        return new IdSignature.AccessorSignature(propertySignature, accessorSignature);
    }

    private final IdSignature.FileLocalSignature deserializeFileLocalIdSignature(FileLocalIdSignature proto) {
        return new IdSignature.FileLocalSignature(this.deserializeIdSignature(proto.getContainer()), proto.getLocalId());
    }

    private final IdSignature.ScopeLocalDeclaration deserializeScopeLocalIdSignature(int proto) {
        return new IdSignature.ScopeLocalDeclaration(proto, null, 2, null);
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.util.IdSignature deserializeSignatureData(@NotNull IdSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature idSignature;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IdSignature.IdsigCase idsigCase = proto.getIdsigCase();
        int n = idsigCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[idsigCase.ordinal()];
        switch (n) {
            case 1: {
                PublicIdSignature publicIdSignature = proto.getPublicSig();
                Intrinsics.checkNotNullExpressionValue((Object)publicIdSignature, (String)"proto.publicSig");
                idSignature = this.deserializePublicIdSignature(publicIdSignature);
                break;
            }
            case 2: {
                AccessorIdSignature accessorIdSignature = proto.getAccessorSig();
                Intrinsics.checkNotNullExpressionValue((Object)accessorIdSignature, (String)"proto.accessorSig");
                idSignature = this.deserializeAccessorIdSignature(accessorIdSignature);
                break;
            }
            case 3: {
                FileLocalIdSignature fileLocalIdSignature = proto.getPrivateSig();
                Intrinsics.checkNotNullExpressionValue((Object)fileLocalIdSignature, (String)"proto.privateSig");
                idSignature = this.deserializeFileLocalIdSignature(fileLocalIdSignature);
                break;
            }
            case 4: {
                idSignature = this.deserializeScopeLocalIdSignature(proto.getScopedLocalSig());
                break;
            }
            default: {
                String string2 = Intrinsics.stringPlus((String)"Unexpected IdSignature kind: ", (Object)proto.getIdsigCase());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return idSignature;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
            nArray[BinarySymbolData.SymbolKind.ANONYMOUS_INIT_SYMBOL.ordinal()] = 1;
            nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 2;
            nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 3;
            nArray[BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL.ordinal()] = 4;
            nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 5;
            nArray[BinarySymbolData.SymbolKind.STANDALONE_FIELD_SYMBOL.ordinal()] = 6;
            nArray[BinarySymbolData.SymbolKind.FIELD_SYMBOL.ordinal()] = 7;
            nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 8;
            nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 9;
            nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 10;
            nArray[BinarySymbolData.SymbolKind.VARIABLE_SYMBOL.ordinal()] = 11;
            nArray[BinarySymbolData.SymbolKind.VALUE_PARAMETER_SYMBOL.ordinal()] = 12;
            nArray[BinarySymbolData.SymbolKind.RECEIVER_PARAMETER_SYMBOL.ordinal()] = 13;
            nArray[BinarySymbolData.SymbolKind.LOCAL_DELEGATED_PROPERTY_SYMBOL.ordinal()] = 14;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IdSignature.IdsigCase.values().length];
            nArray[IdSignature.IdsigCase.PUBLIC_SIG.ordinal()] = 1;
            nArray[IdSignature.IdsigCase.ACCESSOR_SIG.ordinal()] = 2;
            nArray[IdSignature.IdsigCase.PRIVATE_SIG.ordinal()] = 3;
            nArray[IdSignature.IdsigCase.SCOPED_LOCAL_SIG.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

