/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00c2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u001a\u001e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u001a \u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0012\u0010\u001c\u001a\u00020\u0003*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0010\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e*\u00020\u001f\u001a\u0018\u0010 \u001a\u0004\u0018\u00010!*\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u000e\u001a\u00020\u001f\u001a\u001c\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#*\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001c\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010#*\u0006\u0012\u0002\b\u00030%2\u0006\u0010\u000e\u001a\u00020\u001f\u001a \u0010&\u001a\u0004\u0018\u0001H'\"\n\b\u0000\u0010'\u0018\u0001*\u00020(*\u00020)H\u0086\b\u00a2\u0006\u0002\u0010*\u001a\u000e\u0010+\u001a\u0004\u0018\u00010,*\u0004\u0018\u00010-\u001a\f\u0010.\u001a\u00020\u0003*\u00020/H\u0002\u001a\u0012\u00100\u001a\u000201*\u0002022\u0006\u0010\u000e\u001a\u00020\u001f\u001a\u0012\u00103\u001a\u00020\u0003*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b\u001a\n\u00104\u001a\u00020\u0003*\u000202\u001a\u001c\u00105\u001a\u00020\u0003*\u0002062\u0006\u0010\u000e\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000106\u001a\u0012\u00109\u001a\u00020\u0003*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b\u001a\"\u0010:\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u001e2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001c\u0010:\u001a\u00020\u0003*\u0002062\u0006\u0010\u000e\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000106\u001a\u0010\u0010<\u001a\u0004\u0018\u000101*\u0006\u0012\u0002\b\u00030\u001e\u001a\u001c\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e*\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u000e\u001a\u00020\u001f\u001a\u001c\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u00010>*\u0006\u0012\u0002\b\u00030>2\u0006\u0010\u000e\u001a\u00020\u001f\u001a(\u0010?\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030A0@*\u00020B2\n\u0010C\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u000e\u001a\u00020\u001f\u001a\u0014\u0010D\u001a\u0004\u0018\u00010E*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0014\u0010D\u001a\u0004\u0018\u00010E*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0014\u0010D\u001a\u0004\u0018\u00010E*\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\n\u0010F\u001a\u00020G*\u000201\u001a\f\u0010H\u001a\u0004\u0018\u00010,*\u00020G\u001a\u0018\u0010I\u001a\u00020J*\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u000e\u001a\u00020\u001fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\u0003*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006K"}, d2={"INLINE_ONLY_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "hasValOrVar", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getHasValOrVar", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Z", "isComponentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "isIterator", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "isSubtypeForTypeMismatch", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "subtype", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "supertype", "isSubtypeOfForFunctionalTypeReturningUnit", "lowerThanBound", "argument", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "throwableClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "canHaveSubtypes", "findClosestClassOrObject", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "findNonInterfaceSupertype", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "followAllAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getContainingClass", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "getDeclaration", "T", "", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Ljava/lang/Object;", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "hasBody", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "implicitModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isInline", "isInlineOnly", "isSubtypeOf", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "isSubtypeOfThrowable", "isSupertypeOf", "other", "modality", "outerClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "overriddenFunctions", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "containingClass", "toRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "toToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "toVisibilityOrNull", "unsubstitutedScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkers"})
public final class FirHelpersKt {
    @NotNull
    private static final ClassId INLINE_ONLY_ANNOTATION_CLASS_ID;

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClass<?> $this$unsubstitutedScope, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false);
    }

    public static final boolean isSupertypeOf(@NotNull FirClass<?> $this$isSupertypeOf, @NotNull FirClass<?> other, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean bl = false;
        return FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf, session2, other, new LinkedHashSet());
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeClassLikeType $this$toRegularClass, @NotNull FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeSymbol<?> $this$safeAs$iv = LookupTagUtilsKt.toSymbol($this$toRegularClass.getLookupTag(), session2);
        boolean $i$f$safeAs = false;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
        if (!(firClassLikeSymbol instanceof FirRegularClassSymbol)) {
            firClassLikeSymbol = null;
        }
        return (firRegularClassSymbol = (FirRegularClassSymbol)firClassLikeSymbol) == null ? null : (FirRegularClass)firRegularClassSymbol.getFir();
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeKotlinType $this$toRegularClass, @NotNull FirSession session2) {
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2;
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType $this$safeAs$iv = $this$toRegularClass;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (coneClassLikeType2 = (ConeClassLikeType)coneKotlinType) == null ? null : ((coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType2, session2, null, 2, null)) == null ? null : FirHelpersKt.toRegularClass(coneClassLikeType, session2));
    }

    public static final boolean isInline(@NotNull ConeKotlinType $this$isInline, @NotNull FirSession session2) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isInline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirRegularClass firRegularClass = FirHelpersKt.toRegularClass($this$isInline, session2);
        if (firRegularClass == null) {
            bl = null;
        } else {
            FirRegularClass $this$isInline$iv = firRegularClass;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getStatus().isInline();
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull FirTypeRef $this$toRegularClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirHelpersKt.toRegularClass(FirTypeUtilsKt.getConeType($this$toRegularClass), session2);
    }

    public static final /* synthetic */ Object getDeclaration(FirQualifiedAccessExpression $this$getDeclaration) {
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaration, (String)"<this>");
        boolean $i$f$getDeclaration = false;
        Object $this$safeAs$iv = $this$getDeclaration.getCalleeReference();
        boolean $i$f$safeAs = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof FirResolvedNamedReference)) {
            object = null;
        }
        Object $this$safeAs$iv2 = (firResolvedNamedReference = (FirResolvedNamedReference)object) == null ? null : (($this$safeAs$iv = firResolvedNamedReference.getResolvedSymbol()) == null ? null : ((AbstractFirBasedSymbol)$this$safeAs$iv).getFir());
        boolean $i$f$safeAs2 = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return $this$safeAs$iv2;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> getContainingClass(@NotNull FirSymbolOwner<?> $this$getContainingClass, @NotNull CheckerContext context2) {
        Object object;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        Intrinsics.checkNotNullParameter($this$getContainingClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirSymbolOwner<?> $this$safeAs$iv = $this$getContainingClass;
        boolean $i$f$safeAs = false;
        FirSymbolOwner<?> firSymbolOwner = $this$safeAs$iv;
        if (!(firSymbolOwner instanceof FirCallableMemberDeclaration)) {
            firSymbolOwner = null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag = (object = (FirCallableMemberDeclaration)firSymbolOwner) == null ? null : ClassMembersKt.containingClass(object);
        return coneClassLikeLookupTag == null ? null : ((object = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object).getFir());
    }

    @Nullable
    public static final FirClassLikeSymbol<?> outerClass(@NotNull FirClassLikeSymbol<?> $this$outerClass, @NotNull CheckerContext context2) {
        ClassId classId;
        Intrinsics.checkNotNullParameter($this$outerClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!($this$outerClass instanceof FirClassSymbol)) {
            return null;
        }
        ClassId classId2 = $this$outerClass.getClassId().getOuterClassId();
        if (classId2 == null) {
            return null;
        }
        ClassId outerClassId = classId = classId2;
        return MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(outerClassId);
    }

    @Nullable
    public static final FirClass<?> outerClass(@NotNull FirClass<?> $this$outerClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$outerClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.outerClass((FirClassLikeSymbol)$this$outerClass.getSymbol(), context2);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
        return firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> followAllAlias(@NotNull FirClassLikeDeclaration<?> $this$followAllAlias, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$followAllAlias, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeDeclaration<?> it = $this$followAllAlias;
        while (it instanceof FirTypeAlias) {
            it = FirSupertypesResolutionKt.firClassLike(((FirTypeAlias)it).getExpandedTypeRef(), session2);
        }
        return it;
    }

    @Nullable
    public static final FirClass<?> findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)$this$findClosestClassOrObject, (String)"<this>");
        for (FirDeclaration it : CollectionsKt.asReversed($this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirSimpleFunction $this$overriddenFunctions, @NotNull FirClass<?> containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$overriddenFunctions, (String)"<this>");
        Intrinsics.checkNotNullParameter(containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirTypeScope firTypeScope = KotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), true);
        boolean bl = false;
        List overriddenFunctions2 = new ArrayList();
        firTypeScope.processFunctionsByName(((FirSimpleFunction)$this$overriddenFunctions.getSymbol().getFir()).getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)overriddenFunctions.1.INSTANCE));
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions.getSymbol(), (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ List<FirFunctionSymbol<?>> $overriddenFunctions;
            {
                this.$overriddenFunctions = $overriddenFunctions;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$overriddenFunctions.add(it);
                return ProcessorAction.NEXT;
            }
        }));
        return overriddenFunctions2;
    }

    @Nullable
    public static final Visibility getVisibility(@Nullable KtModifierList $this$getVisibility) {
        KtModifierKeywordToken ktModifierKeywordToken;
        KtModifierList ktModifierList = $this$getVisibility;
        return ktModifierList == null ? null : ((ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType(ktModifierList)) == null ? null : FirHelpersKt.toVisibilityOrNull(ktModifierKeywordToken));
    }

    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toVisibilityOrNull, (String)"<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    @Nullable
    public static final Modality modality(@NotNull FirClass<?> $this$modality) {
        Modality modality;
        Intrinsics.checkNotNullParameter($this$modality, (String)"<this>");
        FirClass<?> firClass = $this$modality;
        if (firClass instanceof FirRegularClass) {
            FirRegularClass $this$modality$iv = (FirRegularClass)$this$modality;
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }

    @NotNull
    public static final Modality implicitModality(@NotNull FirMemberDeclaration $this$implicitModality, @NotNull CheckerContext context2) {
        LighterASTNode lighterASTNode2;
        Intrinsics.checkNotNullParameter((Object)$this$implicitModality, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$implicitModality instanceof FirRegularClass && (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.CLASS || ((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.OBJECT)) {
            if (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        FirClass<?> firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Modality.FINAL;
        }
        FirClass<?> klass = firClass;
        FirSourceElement firSourceElement = $this$implicitModality.getSource();
        if (firSourceElement == null) {
            return Modality.FINAL;
        }
        FirSourceElement source = firSourceElement;
        FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
        if (LightTreePositioningStrategiesKt.overrideModifier(tree, source.getLighterASTNode()) != null) {
            IElementType iElementType;
            FirSourceElement firSourceElement2 = klass.getSource();
            if (firSourceElement2 == null) {
                iElementType = null;
            } else {
                FirSourceElement firSourceElement3 = firSourceElement2;
                boolean bl = false;
                boolean bl2 = false;
                FirSourceElement it = firSourceElement3;
                boolean bl3 = false;
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.modalityModifier(tree, it.getLighterASTNode());
                iElementType = lighterASTNode3 == null ? null : lighterASTNode3.getTokenType();
            }
            IElementType klassModalityTokenType = iElementType;
            if (Intrinsics.areEqual(klassModalityTokenType, (Object)KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, (Object)KtTokens.OPEN_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, (Object)KtTokens.SEALED_KEYWORD)) {
                return Modality.OPEN;
            }
        }
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((Object)((lighterASTNode2 = LightTreePositioningStrategiesKt.visibilityModifier(tree, source.getLighterASTNode())) == null ? null : lighterASTNode2.getTokenType()), (Object)KtTokens.PRIVATE_KEYWORD)) {
            return FirHelpersKt.hasBody($this$implicitModality) ? Modality.OPEN : Modality.ABSTRACT;
        }
        return Modality.FINAL;
    }

    private static final boolean hasBody(FirDeclaration $this$hasBody) {
        FirPropertyAccessor firPropertyAccessor;
        FirBlock firBlock;
        FirDeclaration firDeclaration = $this$hasBody;
        boolean bl = firDeclaration instanceof FirSimpleFunction ? ((FirSimpleFunction)$this$hasBody).getBody() != null && !(((FirSimpleFunction)$this$hasBody).getBody() instanceof FirEmptyExpressionBlock) : (firDeclaration instanceof FirProperty ? !((firBlock = (firPropertyAccessor = ((FirProperty)$this$hasBody).getSetter()) == null ? null : firPropertyAccessor.getBody()) == null ? true : firBlock instanceof FirEmptyExpressionBlock) || !((firBlock = (firPropertyAccessor = ((FirProperty)$this$hasBody).getGetter()) == null ? null : firPropertyAccessor.getBody()) == null ? true : firBlock instanceof FirEmptyExpressionBlock) : false);
        return bl;
    }

    @Nullable
    public static final FirTypeRef findNonInterfaceSupertype(@NotNull FirClass<?> $this$findNonInterfaceSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$findNonInterfaceSupertype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (FirTypeRef superTypeRef : $this$findNonInterfaceSupertype.getSuperTypeRefs()) {
            Object fir;
            Object object;
            ConeClassLikeLookupTag coneClassLikeLookupTag;
            FirClassLikeSymbol<?> $this$safeAs$iv = FirTypeUtilsKt.getConeType(superTypeRef);
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof ConeClassLikeType)) {
                object2 = null;
            }
            if ((coneClassLikeLookupTag = (object = (ConeClassLikeType)object2) == null ? null : ((ConeClassLikeType)object).getLookupTag()) == null) continue;
            ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
            $this$safeAs$iv = LookupTagUtilsKt.toSymbol(lookupTag, context2.getSession());
            $this$safeAs$iv = $this$safeAs$iv == null ? null : (FirClassLikeDeclaration)$this$safeAs$iv.getFir();
            $i$f$safeAs = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
            if (!(firClassLikeSymbol instanceof FirClass)) {
                firClassLikeSymbol = null;
            }
            if ((object = (FirClass)((Object)firClassLikeSymbol)) == null || (fir = object).getClassKind() == ClassKind.INTERFACE) continue;
            return superTypeRef;
        }
        return null;
    }

    @NotNull
    public static final KtModifierKeywordToken toToken(@NotNull Modality $this$toToken) {
        KtModifierKeywordToken ktModifierKeywordToken;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toToken), (String)"<this>");
        Modality modality = $this$toToken;
        int n = WhenMappings.$EnumSwitchMapping$0[modality.ordinal()];
        switch (n) {
            case 1: {
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.FINAL_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"FINAL_KEYWORD");
                ktModifierKeywordToken = ktModifierKeywordToken2;
                break;
            }
            case 2: {
                KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.SEALED_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"SEALED_KEYWORD");
                ktModifierKeywordToken = ktModifierKeywordToken3;
                break;
            }
            case 3: {
                KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken4, (String)"OPEN_KEYWORD");
                ktModifierKeywordToken = ktModifierKeywordToken4;
                break;
            }
            case 4: {
                KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken5, (String)"ABSTRACT_KEYWORD");
                ktModifierKeywordToken = ktModifierKeywordToken5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktModifierKeywordToken;
    }

    public static final boolean isIterator(@NotNull FirFunctionCall $this$isIterator) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterator, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isIterator.getCalleeReference().getName().asString(), (Object)"<iterator>");
    }

    @NotNull
    public static final ConeClassLikeType throwableClassLikeType(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return session2.getBuiltinTypes().getThrowableType().getType();
    }

    public static final boolean isSubtypeOfThrowable(@NotNull ConeKotlinType $this$isSubtypeOfThrowable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfThrowable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirHelpersKt.isSupertypeOf(FirHelpersKt.throwableClassLikeType(session2), SessionUtilsKt.getTypeContext(session2), TypeExpansionUtilsKt.fullyExpandedType($this$isSubtypeOfThrowable, session2));
    }

    public static final boolean getHasValOrVar(@NotNull FirValueParameter $this$hasValOrVar) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValOrVar, (String)"<this>");
        Object object = $this$hasValOrVar.getSource();
        if (object == null) {
            return false;
        }
        FirSourceElement source = object;
        object = KtParameter.VAL_VAR_TOKEN_SET;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VAL_VAR_TOKEN_SET");
        return FirSourceUtilsKt.getChild$default(source, (TokenSet)object, 0, 0, 6, null) != null;
    }

    public static final boolean isSupertypeOf(@NotNull KotlinTypeMarker $this$isSupertypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupertypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, type2, $this$isSupertypeOf, false, 8, null);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinTypeMarker $this$isSubtypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, $this$isSubtypeOf, type2, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canHaveSubtypes(@NotNull ConeKotlinType $this$canHaveSubtypes, @NotNull FirSession session2) {
        FirRegularClass clazz;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)$this$canHaveSubtypes, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                if (ConeTypeUtilsKt.isMarkedNullable($this$canHaveSubtypes)) {
                    return true;
                }
                FirRegularClass firRegularClass = FirHelpersKt.toRegularClass($this$canHaveSubtypes, session2);
                if (firRegularClass == null) {
                    return true;
                }
                FirRegularClass $this$isEnumClass$iv = clazz = firRegularClass;
                boolean $i$f$isEnumClass = false;
                if ($this$isEnumClass$iv.getClassKind() == ClassKind.ENUM_CLASS) break block19;
                FirMemberDeclaration $this$isExpect$iv = clazz;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) break block19;
                FirRegularClass $this$modality$iv = clazz;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) break block20;
            }
            return true;
        }
        Iterable $this$forEachIndexed$iv = clazz.getTypeParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterRef;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv;
            int idx = n;
            boolean bl2 = false;
            FirTypeParameter typeParameter = (FirTypeParameter)typeParameterRef.getSymbol().getFir();
            ConeTypeProjection typeProjection = $this$canHaveSubtypes.getTypeArguments()[idx];
            if (ConeTypesKt.isStarProjection(typeProjection)) {
                return true;
            }
            Object object = ConeTypesKt.getType(typeProjection);
            Intrinsics.checkNotNull((Object)object);
            ConeKotlinType argument2 = object;
            object = typeParameter.getVariance();
            int n2 = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()];
            block0 : switch (n2) {
                case 1: {
                    ProjectionKind projectionKind = typeProjection.getKind();
                    int n3 = WhenMappings.$EnumSwitchMapping$2[projectionKind.ordinal()];
                    switch (n3) {
                        case 1: {
                            if (!FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter) && !FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 2: {
                            if (!FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter)) break block0;
                            return true;
                        }
                        case 3: {
                            if (!FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 4: {
                            return true;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!(typeProjection.getKind() != ProjectionKind.OUT ? FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter) : FirHelpersKt.canHaveSubtypes(argument2, session2))) break;
                    return true;
                }
                case 3: {
                    if (!(typeProjection.getKind() != ProjectionKind.IN ? FirHelpersKt.canHaveSubtypes(argument2, session2) : FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean lowerThanBound(ConeInferenceContext context2, ConeKotlinType argument2, FirTypeParameter typeParameter) {
        Iterable $this$forEach$iv = typeParameter.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef boundTypeRef = (FirTypeRef)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)argument2, (Object)FirTypeUtilsKt.getConeType(boundTypeRef)) || !FirHelpersKt.isSubtypeOf(argument2, context2, FirTypeUtilsKt.getConeType(boundTypeRef))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInlineOnly(@NotNull FirMemberDeclaration $this$isInlineOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"<this>");
        FirMemberDeclaration $this$isInline$iv = $this$isInlineOnly;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && FirAnnotationUtilsKt.hasAnnotation($this$isInlineOnly, INLINE_ONLY_ANNOTATION_CLASS_ID);
    }

    public static final boolean isComponentCall(@NotNull FirExpression $this$isComponentCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isComponentCall, (String)"<this>");
        return $this$isComponentCall instanceof FirComponentCall;
    }

    public static final boolean isSubtypeForTypeMismatch(@NotNull ConeInferenceContext context2, @NotNull ConeKotlinType subtype, @NotNull ConeKotlinType supertype2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)supertype2, (String)"supertype");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, (KotlinTypeMarker)subtype, (KotlinTypeMarker)supertype2, false, 8, null) || FirHelpersKt.isSubtypeOfForFunctionalTypeReturningUnit(SessionUtilsKt.getTypeContext(context2.getSession()), subtype, supertype2);
    }

    public static final boolean isSubtypeOfForFunctionalTypeReturningUnit(@NotNull ConeInferenceContext context2, @NotNull ConeKotlinType subtype, @NotNull ConeKotlinType supertype2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)supertype2, (String)"supertype");
        if (!InferenceUtilsKt.isBuiltinFunctionalType(supertype2, context2.getSession())) {
            return false;
        }
        ConeTypeProjection functionalTypeReturnType = (ConeTypeProjection)ArraysKt.lastOrNull((Object[])supertype2.getTypeArguments());
        ConeClassLikeType coneClassLikeType = functionalTypeReturnType instanceof ConeClassLikeType ? (ConeClassLikeType)functionalTypeReturnType : null;
        if (Intrinsics.areEqual((Object)(coneClassLikeType == null ? null : Boolean.valueOf(ConeTypeUtilsKt.isUnit(coneClassLikeType))), (Object)true)) {
            List superTypeArgs = ArraysKt.dropLast((Object[])supertype2.getTypeArguments(), (int)1);
            List subTypeArgs = ArraysKt.dropLast((Object[])subtype.getTypeArguments(), (int)1);
            if (superTypeArgs.size() != subTypeArgs.size()) {
                return false;
            }
            int n = 0;
            int n2 = superTypeArgs.size() + -1;
            if (n <= n2) {
                do {
                    int i;
                    ConeKotlinType coneKotlinType;
                    if ((coneKotlinType = ConeTypesKt.getType((ConeTypeProjection)subTypeArgs.get(i = n++))) == null) {
                        return false;
                    }
                    ConeKotlinType subTypeArg = coneKotlinType;
                    ConeKotlinType coneKotlinType2 = ConeTypesKt.getType((ConeTypeProjection)superTypeArgs.get(i));
                    if (coneKotlinType2 == null) {
                        return false;
                    }
                    ConeKotlinType superTypeArg = coneKotlinType2;
                    if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)subTypeArg, (KotlinTypeMarker)superTypeArg, false, 8, null)) continue;
                    return false;
                } while (n <= n2);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isSupertypeOf$isSupertypeOf(FirClass<?> $this$isSupertypeOf_u24isSupertypeOf, FirSession $session, FirClass<?> other, Set<FirClass<?>> exclude) {
        for (FirTypeRef it : other.getSuperTypeRefs()) {
            FirClass candidate2;
            FirClass firClass;
            FirClass firClass2;
            FirClassLikeDeclaration<?> firClassLikeDeclaration = FirSupertypesResolutionKt.firClassLike(it, $session);
            if (firClassLikeDeclaration == null) {
                firClass2 = null;
            } else {
                FirClassLikeDeclaration<?> firClassLikeDeclaration2 = FirHelpersKt.followAllAlias(firClassLikeDeclaration, $session);
                if (firClassLikeDeclaration2 == null) {
                    firClass2 = null;
                } else {
                    void $this$safeAs$iv;
                    FirClassLikeDeclaration<?> firClassLikeDeclaration3 = firClassLikeDeclaration2;
                    boolean $i$f$safeAs = false;
                    Object v1 = $this$safeAs$iv;
                    if (!(v1 instanceof FirClass)) {
                        v1 = null;
                    }
                    firClass2 = v1;
                }
            }
            if ((firClass = firClass2) == null || exclude.contains(candidate2 = firClass)) continue;
            exclude.add(candidate2);
            if (Intrinsics.areEqual((Object)candidate2, $this$isSupertypeOf_u24isSupertypeOf)) {
                return true;
            }
            if (!FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf_u24isSupertypeOf, $session, candidate2, exclude)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.internal.InlineOnly"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(\"kotlin.internal.InlineOnly\"))");
        INLINE_ONLY_ANNOTATION_CLASS_ID = classId;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Modality.values().length];
            nArray[Modality.FINAL.ordinal()] = 1;
            nArray[Modality.SEALED.ordinal()] = 2;
            nArray[Modality.OPEN.ordinal()] = 3;
            nArray[Modality.ABSTRACT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            nArray[ProjectionKind.IN.ordinal()] = 2;
            nArray[ProjectionKind.OUT.ordinal()] = 3;
            nArray[ProjectionKind.STAR.ordinal()] = 4;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

