/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "typeParameterFromError", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getTypeParameterFromError", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTopLevelDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "isKClassTypeWithErrorOrNullableArgument", "", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "checkers"})
public final class FirKClassWithIncorrectTypeArgumentChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirKClassWithIncorrectTypeArgumentChecker INSTANCE = new FirKClassWithIncorrectTypeArgumentChecker();

    private FirKClassWithIncorrectTypeArgumentChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirDeclaration topLevelDeclaration : declaration2.getDeclarations()) {
            if (!(topLevelDeclaration instanceof FirCallableMemberDeclaration)) continue;
            this.checkTopLevelDeclaration((FirCallableMemberDeclaration)topLevelDeclaration, context2, reporter);
        }
    }

    private final void checkTopLevelDeclaration(FirCallableMemberDeclaration<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirSourceElement firSourceElement = declaration2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (source.getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef());
        if (!this.isKClassTypeWithErrorOrNullableArgument(returnType2, InferenceComponentsKt.getInferenceComponents(context2.getSession()).getCtx())) {
            return;
        }
        ConeKotlinType typeArgument = ((ConeKotlinTypeProjection)returnType2.getTypeArguments()[0]).getType();
        FirTypeParameter firTypeParameter = this.getTypeParameterFromError(typeArgument);
        if (firTypeParameter != null) {
            FirTypeParameter firTypeParameter2 = firTypeParameter;
            boolean bl = false;
            boolean bl2 = false;
            FirTypeParameter it = firTypeParameter2;
            boolean bl3 = false;
            DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getKCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE(), it.getSymbol(), context2);
        }
    }

    private final boolean isKClassTypeWithErrorOrNullableArgument(ConeKotlinType $this$isKClassTypeWithErrorOrNullableArgument, ConeInferenceContext context2) {
        ConeKotlinType coneKotlinType;
        if (!InferenceUtilsKt.isKClassType($this$isKClassTypeWithErrorOrNullableArgument)) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = (ConeTypeProjection)CollectionsKt.singleOrNull((List)ArraysKt.toList((Object[])$this$isKClassTypeWithErrorOrNullableArgument.getTypeArguments()));
        if (coneTypeProjection == null) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection2 = coneTypeProjection;
            boolean bl = false;
            boolean bl2 = false;
            ConeTypeProjection it = coneTypeProjection2;
            boolean bl3 = false;
            ConeTypeProjection coneTypeProjection3 = it;
            if (coneTypeProjection3 instanceof ConeStarProjection) {
                coneKotlinType = null;
            } else if (coneTypeProjection3 instanceof ConeKotlinTypeProjection) {
                coneKotlinType = ((ConeKotlinTypeProjection)it).getType();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        if (coneKotlinType2 == null) {
            return false;
        }
        ConeKotlinType argumentType = coneKotlinType2;
        boolean bl = false;
        boolean bl4 = false;
        ConeInferenceContext $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u2d3 = context2;
        boolean bl5 = false;
        FirTypeParameter firTypeParameter = INSTANCE.getTypeParameterFromError(argumentType);
        if (firTypeParameter != null) {
            FirTypeParameter firTypeParameter2 = firTypeParameter;
            boolean bl6 = false;
            boolean bl7 = false;
            FirTypeParameter typeParameter = firTypeParameter2;
            boolean bl8 = false;
            return $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u2d3.isNullableType(FirNestedClassifierScopeKt.toConeType(typeParameter));
        }
        return argumentType instanceof ConeClassErrorType || $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u2d3.isNullableType(argumentType);
    }

    private final FirTypeParameter getTypeParameterFromError(ConeKotlinType $this$typeParameterFromError) {
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess;
        ConeClassErrorType coneClassErrorType = $this$typeParameterFromError instanceof ConeClassErrorType ? (ConeClassErrorType)$this$typeParameterFromError : null;
        Object object = coneClassErrorType == null ? null : coneClassErrorType.getDiagnostic();
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess2 = coneTypeParameterInQualifiedAccess = object instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)object : null;
        return coneTypeParameterInQualifiedAccess == null ? null : ((object = coneTypeParameterInQualifiedAccess.getSymbol()) == null ? null : (FirTypeParameter)((AbstractFirBasedSymbol)object).getFir());
    }
}

