/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeApproximator;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNothingTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableNothingTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001M\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020WH\u0002J\u0014\u0010Y\u001a\u0004\u0018\u00010\u00172\b\u0010Z\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010[\u001a\u0004\u0018\u00010\u00172\b\u0010Z\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\\\u001a\u00020]*\u00020W2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00120_H\u0002J.\u0010`\u001a\u00020\u0013*\u00020W2\b\b\u0002\u0010a\u001a\u00020b2\u000e\b\u0002\u0010c\u001a\b\u0012\u0004\u0012\u00020e0d2\b\b\u0002\u0010f\u001a\u00020]J\u0014\u0010`\u001a\u00020\u0013*\u00020g2\b\b\u0002\u0010a\u001a\u00020bJ\u0014\u0010h\u001a\u00020i*\u00020j2\u0006\u0010a\u001a\u00020bH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0012\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'R\u0012\u0010*\u001a\u00020+X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0012\u0010.\u001a\u00020/X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0012\u00102\u001a\u000203X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u000207X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0012\u0010:\u001a\u00020;X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0012\u0010>\u001a\u00020?X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0012\u0010B\u001a\u00020CX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0012\u0010F\u001a\u00020GX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u00020MX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010NR\u0012\u0010O\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0012\u0010R\u001a\u00020SX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u00a8\u0006k"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "capturedTypeCache", "", "Lorg/jetbrains/kotlin/fir/types/ConeCapturedType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "classIdToSymbolMap", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getClassIdToSymbolMap$fir2ir", "()Ljava/util/Map;", "classIdToTypeMap", "getClassIdToTypeMap$fir2ir", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "errorTypeForCapturedTypeStub", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "getErrorTypeForCapturedTypeStub", "()Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "errorTypeForCapturedTypeStub$delegate", "Lkotlin/Lazy;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeApproximator", "Lorg/jetbrains/kotlin/fir/types/ConeTypeApproximator;", "typeApproximatorConfiguration", "org/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter$typeApproximatorConfiguration$1", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter$typeApproximatorConfiguration$1;", "typeConverter", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "approximateType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "getArrayClassSymbol", "classId", "getBuiltInClassSymbol", "isRecursive", "", "visited", "", "toIrType", "typeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "hasFlexibleNullability", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "fir2ir"})
public final class Fir2IrTypeConverter
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Map<ClassId, IrClassSymbol> classIdToSymbolMap;
    @NotNull
    private final Map<ClassId, IrType> classIdToTypeMap;
    @NotNull
    private final Map<ConeCapturedType, IrType> capturedTypeCache;
    @NotNull
    private final Lazy errorTypeForCapturedTypeStub$delegate;
    @NotNull
    private final ConeTypeApproximator typeApproximator;
    @NotNull
    private final typeApproximatorConfiguration.1 typeApproximatorConfiguration;

    public Fir2IrTypeConverter(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardClassIds.INSTANCE.getNothing(), (Object)this.getIrBuiltIns().getNothingClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getUnit(), (Object)this.getIrBuiltIns().getUnitClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getBoolean(), (Object)this.getIrBuiltIns().getBooleanClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getString(), (Object)this.getIrBuiltIns().getStringClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getAny(), (Object)this.getIrBuiltIns().getAnyClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getLong(), (Object)this.getIrBuiltIns().getLongClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getInt(), (Object)this.getIrBuiltIns().getIntClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getShort(), (Object)this.getIrBuiltIns().getShortClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getByte(), (Object)this.getIrBuiltIns().getByteClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getFloat(), (Object)this.getIrBuiltIns().getFloatClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getDouble(), (Object)this.getIrBuiltIns().getDoubleClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getChar(), (Object)this.getIrBuiltIns().getCharClass()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getArray(), (Object)this.getIrBuiltIns().getArrayClass())};
        this.classIdToSymbolMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)StandardClassIds.INSTANCE.getNothing(), (Object)this.getIrBuiltIns().getNothingType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getUnit(), (Object)this.getIrBuiltIns().getUnitType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getBoolean(), (Object)this.getIrBuiltIns().getBooleanType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getString(), (Object)this.getIrBuiltIns().getStringType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getAny(), (Object)this.getIrBuiltIns().getAnyType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getLong(), (Object)this.getIrBuiltIns().getLongType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getInt(), (Object)this.getIrBuiltIns().getIntType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getShort(), (Object)this.getIrBuiltIns().getShortType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getByte(), (Object)this.getIrBuiltIns().getByteType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getFloat(), (Object)this.getIrBuiltIns().getFloatType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getDouble(), (Object)this.getIrBuiltIns().getDoubleType()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getChar(), (Object)this.getIrBuiltIns().getCharType())};
        this.classIdToTypeMap = MapsKt.mapOf((Pair[])pairArray);
        boolean bl = false;
        this.capturedTypeCache = new LinkedHashMap();
        this.errorTypeForCapturedTypeStub$delegate = LazyKt.lazy((Function0)errorTypeForCapturedTypeStub.2.INSTANCE);
        this.typeApproximator = new ConeTypeApproximator(SessionUtilsKt.getTypeContext(this.getSession()), FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()));
        this.typeApproximatorConfiguration = new TypeApproximatorConfiguration.AllFlexibleSameValue(){

            public boolean getAllFlexible() {
                return true;
            }

            public boolean getErrorType() {
                return true;
            }

            public boolean getIntegerLiteralType() {
                return true;
            }

            public boolean getIntersectionTypesInContravariantPositions() {
                return true;
            }
        };
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    @NotNull
    public final Map<ClassId, IrClassSymbol> getClassIdToSymbolMap$fir2ir() {
        return this.classIdToSymbolMap;
    }

    @NotNull
    public final Map<ClassId, IrType> getClassIdToTypeMap$fir2ir() {
        return this.classIdToTypeMap;
    }

    private final IrErrorType getErrorTypeForCapturedTypeStub() {
        Lazy lazy = this.errorTypeForCapturedTypeStub$delegate;
        boolean bl = false;
        return (IrErrorType)lazy.getValue();
    }

    @NotNull
    public final IrType toIrType(@NotNull FirTypeRef $this$toIrType, @NotNull ConversionTypeContext typeContext2) {
        Intrinsics.checkNotNullParameter((Object)$this$toIrType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        this.capturedTypeCache.clear();
        FirTypeRef firTypeRef = $this$toIrType;
        return !(firTypeRef instanceof FirResolvedTypeRef) ? (IrType)ConversionUtilsKt.createErrorType() : (!(firTypeRef instanceof FirImplicitBuiltinTypeRef) ? Fir2IrTypeConverter.toIrType$default(this, ((FirResolvedTypeRef)$this$toIrType).getType(), typeContext2, $this$toIrType.getAnnotations(), false, 4, null) : (firTypeRef instanceof FirImplicitNothingTypeRef ? this.getIrBuiltIns().getNothingType() : (firTypeRef instanceof FirImplicitUnitTypeRef ? this.getIrBuiltIns().getUnitType() : (firTypeRef instanceof FirImplicitBooleanTypeRef ? this.getIrBuiltIns().getBooleanType() : (firTypeRef instanceof FirImplicitStringTypeRef ? this.getIrBuiltIns().getStringType() : (firTypeRef instanceof FirImplicitAnyTypeRef ? this.getIrBuiltIns().getAnyType() : (firTypeRef instanceof FirImplicitIntTypeRef ? this.getIrBuiltIns().getIntType() : (firTypeRef instanceof FirImplicitNullableAnyTypeRef ? this.getIrBuiltIns().getAnyNType() : (firTypeRef instanceof FirImplicitNullableNothingTypeRef ? this.getIrBuiltIns().getNothingNType() : Fir2IrTypeConverter.toIrType$default(this, ((FirImplicitBuiltinTypeRef)$this$toIrType).getType(), typeContext2, $this$toIrType.getAnnotations(), false, 4, null))))))))));
    }

    public static /* synthetic */ IrType toIrType$default(Fir2IrTypeConverter fir2IrTypeConverter, FirTypeRef firTypeRef, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return fir2IrTypeConverter.toIrType(firTypeRef, conversionTypeContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrType toIrType(@NotNull ConeKotlinType $this$toIrType, @NotNull ConversionTypeContext typeContext2, @NotNull List<? extends FirAnnotationCall> annotations2, boolean hasFlexibleNullability) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$toIrType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        ConeKotlinType coneKotlinType = $this$toIrType;
        if (coneKotlinType instanceof ConeClassErrorType) {
            irType = ConversionUtilsKt.createErrorType();
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            Collection<IrTypeArgument> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Collection collection2;
            IrClassifierSymbol irSymbol2;
            IrClassifierSymbol irClassifierSymbol;
            boolean bl2 = false;
            List typeAnnotations = new ArrayList();
            Collection collection3 = typeAnnotations;
            Object object = this.getAnnotationGenerator();
            boolean bl3 = false;
            boolean bl4 = false;
            AnnotationGenerator $this$toIrType_u24lambda_u2d02 = object;
            boolean bl5 = false;
            object = $this$toIrType_u24lambda_u2d02.toIrAnnotations(annotations2);
            bl3 = false;
            CollectionsKt.addAll((Collection)collection3, (Iterable)object);
            object = this.getBuiltInClassSymbol(ConeTypeUtilsKt.getClassId($this$toIrType));
            if (object == null) {
                IrClassifierSymbol irClassifierSymbol2;
                FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(((ConeLookupTagBasedType)$this$toIrType).getLookupTag(), this.getSession());
                IrClassifierSymbol irClassifierSymbol3 = irClassifierSymbol2 = firClassifierSymbol == null ? null : ConversionUtilsKt.toSymbol(firClassifierSymbol, this.getSession(), this.getClassifierStorage(), typeContext2, (Function1<? super List<? extends FirAnnotationCall>, Unit>)((Function1)new Function1<List<? extends FirAnnotationCall>, Unit>((List<IrConstructorCall>)typeAnnotations, this){
                    final /* synthetic */ List<IrConstructorCall> $typeAnnotations;
                    final /* synthetic */ Fir2IrTypeConverter this$0;
                    {
                        this.$typeAnnotations = $typeAnnotations;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull List<? extends FirAnnotationCall> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        Collection collection = this.$typeAnnotations;
                        Object object = this.this$0.getAnnotationGenerator();
                        boolean bl = false;
                        boolean bl2 = false;
                        AnnotationGenerator $this$invoke_u24lambda_u2d0 = object;
                        boolean bl3 = false;
                        object = $this$invoke_u24lambda_u2d0.toIrAnnotations(it);
                        bl = false;
                        CollectionsKt.addAll((Collection)collection, (Iterable)object);
                    }
                }));
                if (irClassifierSymbol2 == null) {
                    return ConversionUtilsKt.createErrorType();
                }
                irClassifierSymbol = irClassifierSymbol2;
            } else {
                irClassifierSymbol = irSymbol2 = (IrClassifierSymbol)object;
            }
            if (CompilerConeAttributesKt.getHasEnhancedNullability($this$toIrType)) {
                object = this.getBuiltIns().enhancedNullabilityAnnotationConstructorCall$fir2ir();
                if (object != null) {
                    Iterator<FirAnnotationCall> iterator2 = object;
                    boolean bl6 = false;
                    boolean $this$toIrType_u24lambda_u2d02 = false;
                    Iterator<FirAnnotationCall> it = iterator2;
                    boolean bl7 = false;
                    collection2 = typeAnnotations;
                    bl = false;
                    collection2.add(it);
                }
            } else if (hasFlexibleNullability && (object = this.getBuiltIns().flexibleNullabilityAnnotationConstructorCall$fir2ir()) != null) {
                Iterator<FirAnnotationCall> iterator3 = object;
                boolean bl8 = false;
                boolean $this$toIrType_u24lambda_u2d02 = false;
                Iterator<FirAnnotationCall> it22 = iterator3;
                boolean bl9 = false;
                collection2 = typeAnnotations;
                bl = false;
                collection2.add(it22);
            }
            for (FirAnnotationCall attributeAnnotation : CustomAnnotationTypeAttributeKt.getCustomAnnotations($this$toIrType.getAttributes())) {
                IrConstructorCall $i$f$any2;
                boolean bl10;
                Iterable $this$any$iv;
                block33: {
                    $this$any$iv = annotations2;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl10 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ConeClassLikeType coneClassLikeType;
                            FirAnnotationCall it = (FirAnnotationCall)element$iv;
                            boolean bl11 = false;
                            FirAnnotationCall $this$classId$iv = it;
                            boolean $i$f$getClassId = false;
                            Object $this$coneClassLikeType$iv$iv = $this$classId$iv;
                            boolean $i$f$getConeClassLikeType = false;
                            FirTypeRef firTypeRef = ((FirAnnotationCall)$this$coneClassLikeType$iv$iv).getAnnotationTypeRef();
                            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                            ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType2 instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType2 : null;
                            ClassId classId = coneClassLikeType == null ? null : (($this$coneClassLikeType$iv$iv = coneClassLikeType.getLookupTag()) == null ? null : ((ConeClassLikeLookupTag)$this$coneClassLikeType$iv$iv).getClassId());
                            $this$classId$iv = attributeAnnotation;
                            $i$f$getClassId = false;
                            $this$coneClassLikeType$iv$iv = $this$classId$iv;
                            $i$f$getConeClassLikeType = false;
                            firTypeRef = ((FirAnnotationCall)$this$coneClassLikeType$iv$iv).getAnnotationTypeRef();
                            firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                            coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                            ConeClassLikeType coneClassLikeType3 = coneClassLikeType = coneKotlinType2 instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType2 : null;
                            ClassId classId2 = coneClassLikeType == null ? null : (($this$coneClassLikeType$iv$iv = coneClassLikeType.getLookupTag()) == null ? null : ((ConeClassLikeLookupTag)$this$coneClassLikeType$iv$iv).getClassId());
                            if (!Intrinsics.areEqual((Object)classId, classId2)) continue;
                            bl10 = true;
                            break block33;
                        }
                        bl10 = false;
                    }
                }
                if (bl10) continue;
                $this$any$iv = typeAnnotations;
                IrExpression it22 = this.getCallGenerator().convertToIrConstructorCall(attributeAnnotation);
                IrConstructorCall irConstructorCall = $i$f$any2 = it22 instanceof IrConstructorCall ? (IrConstructorCall)it22 : null;
                if ($i$f$any2 == null) continue;
                boolean it22 = false;
                $this$any$iv.add($i$f$any2);
            }
            ConeKotlinType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType($this$toIrType, this.getSession());
            ConeKotlinType approximatedType = this.approximateType(expandedType2);
            ConeTypeProjection[] $this$any$iv = approximatedType.getTypeArguments();
            boolean bl12 = !typeContext2.getDefinitelyNotNull$fir2ir() && ConeTypeUtilsKt.isMarkedNullable(approximatedType);
            IrClassifierSymbol irClassifierSymbol4 = irSymbol2;
            boolean $i$f$map = false;
            void it22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void bl11 = $this$mapTo$iv$iv;
            int n = ((void)bl11).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void $i$f$getConeClassLikeType = item$iv$iv = bl11[i];
                collection = destination$iv$iv;
                boolean bl13 = false;
                IrTypeArgument irTypeArgument = this.toIrTypeArgument((ConeTypeProjection)it, typeContext2);
                collection.add(irTypeArgument);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 16;
            IrTypeAbbreviation irTypeAbbreviation = null;
            List list2 = typeAnnotations;
            List list3 = collection;
            boolean bl14 = bl12;
            IrClassifierSymbol irClassifierSymbol5 = irClassifierSymbol4;
            irType = new IrSimpleTypeImpl(irClassifierSymbol5, bl14, list3, list2, irTypeAbbreviation, n2, defaultConstructorMarker);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeFlexibleType)$this$toIrType).getUpperBound(), typeContext2, null, ((ConeFlexibleType)$this$toIrType).getLowerBound().getNullability() != ((ConeFlexibleType)$this$toIrType).getUpperBound().getNullability(), 2, null);
        } else if (coneKotlinType instanceof ConeCapturedType) {
            IrType cached2 = this.capturedTypeCache.get($this$toIrType);
            if (cached2 == null) {
                IrType irType2;
                boolean bl;
                ConeKotlinType coneKotlinType3;
                Object object = ((ConeCapturedType)$this$toIrType).getLowerType();
                if (object == null) {
                    Object v9;
                    Object supertypes2;
                    block34: {
                        coneKotlinType3 = $this$toIrType;
                        bl = false;
                        boolean bl15 = false;
                        ConeCapturedType $this$toIrType_u24lambda_u2d6 = (ConeCapturedType)coneKotlinType3;
                        boolean bl16 = false;
                        Map<ConeCapturedType, IrType> $i$f$mapTo = this.capturedTypeCache;
                        Object bl11 = this.getErrorTypeForCapturedTypeStub();
                        boolean bl17 = false;
                        $i$f$mapTo.put($this$toIrType_u24lambda_u2d6, (IrType)bl11);
                        bl11 = $this$toIrType_u24lambda_u2d6.getConstructor().getSupertypes();
                        Intrinsics.checkNotNull((Object)bl11);
                        supertypes2 = bl11;
                        Iterable iterable = (Iterable)supertypes2;
                        boolean bl18 = false;
                        Iterable iterable2 = iterable;
                        boolean bl19 = false;
                        for (Object t : iterable2) {
                            ConeKotlinType it = (ConeKotlinType)t;
                            boolean bl20 = false;
                            ConeTypeProjection coneTypeProjection = $this$toIrType_u24lambda_u2d6.getConstructor().getProjection();
                            ConeKotlinTypeProjection coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
                            if (!Intrinsics.areEqual((Object)it, (Object)(coneKotlinTypeProjection == null ? null : coneKotlinTypeProjection.getType()))) continue;
                            v9 = t;
                            break block34;
                        }
                        v9 = null;
                    }
                    ConeKotlinType coneKotlinType4 = v9;
                    ConeKotlinType approximation = coneKotlinType4 == null ? (ConeKotlinType)CollectionsKt.first((List)supertypes2) : coneKotlinType4;
                    irType2 = Fir2IrTypeConverter.toIrType$default(this, approximation, typeContext2, null, false, 6, null);
                } else {
                    irType2 = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)object, typeContext2, null, false, 6, null);
                }
                IrType irType3 = irType2;
                object = this.capturedTypeCache;
                coneKotlinType3 = $this$toIrType;
                bl = false;
                object.put(coneKotlinType3, irType3);
                irType = irType3;
            } else {
                irType = cached2;
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeDefinitelyNotNullType)$this$toIrType).getOriginal(), typeContext2.definitelyNotNull(), null, false, 6, null);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            irType = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toIrType).getIntersectedTypes()), typeContext2, null, false, 6, null);
        } else if (coneKotlinType instanceof ConeStubType) {
            irType = ConversionUtilsKt.createErrorType();
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            irType = ConversionUtilsKt.createErrorType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irType;
    }

    public static /* synthetic */ IrType toIrType$default(Fir2IrTypeConverter fir2IrTypeConverter, ConeKotlinType coneKotlinType, ConversionTypeContext conversionTypeContext, List list2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return fir2IrTypeConverter.toIrType(coneKotlinType, conversionTypeContext, list2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrTypeArgument toIrTypeArgument(ConeTypeProjection $this$toIrTypeArgument, ConversionTypeContext typeContext2) {
        IrTypeArgument irTypeArgument;
        ConeTypeProjection coneTypeProjection = $this$toIrTypeArgument;
        if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            irTypeArgument = IrStarProjectionImpl.INSTANCE;
            return irTypeArgument;
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            IrType irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeKotlinTypeProjectionIn)$this$toIrTypeArgument).getType(), typeContext2, null, false, 6, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, typeContext2.getInvariantProjection$fir2ir() ? Variance.INVARIANT : Variance.IN_VARIANCE);
            return irTypeArgument;
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            IrType irType2 = Fir2IrTypeConverter.toIrType$default(this, ((ConeKotlinTypeProjectionOut)$this$toIrTypeArgument).getType(), typeContext2, null, false, 6, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType2, typeContext2.getInvariantProjection$fir2ir() ? Variance.INVARIANT : Variance.OUT_VARIANCE);
            return irTypeArgument;
        }
        if (!(coneTypeProjection instanceof ConeKotlinType)) throw new NoWhenBranchMatchedException();
        if ($this$toIrTypeArgument instanceof ConeCapturedType) {
            Map<ConeCapturedType, IrType> irType2 = this.capturedTypeCache;
            ConeTypeProjection coneTypeProjection2 = $this$toIrTypeArgument;
            boolean bl = false;
            Map<ConeCapturedType, IrType> map = irType2;
            boolean bl2 = false;
            if (map.containsKey(coneTypeProjection2)) {
                boolean irType2 = false;
                if (this.isRecursive((ConeKotlinType)$this$toIrTypeArgument, new LinkedHashSet())) {
                    irTypeArgument = IrStarProjectionImpl.INSTANCE;
                    return irTypeArgument;
                }
            }
        }
        IrType irType = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)$this$toIrTypeArgument, typeContext2, null, false, 6, null);
        irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.INVARIANT);
        return irTypeArgument;
    }

    private final boolean isRecursive(ConeKotlinType $this$isRecursive, Set<ConeCapturedType> visited2) {
        boolean bl;
        block21: {
            ConeKotlinType coneKotlinType = $this$isRecursive;
            if (coneKotlinType instanceof ConeLookupTagBasedType) {
                ConeTypeProjection[] $this$any$iv = $this$isRecursive.getTypeArguments();
                boolean $i$f$any = false;
                ConeTypeProjection[] coneTypeProjectionArray = $this$any$iv;
                int n = coneTypeProjectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = coneTypeProjectionArray[i];
                    boolean bl2 = false;
                    ConeTypeProjection coneTypeProjection = it;
                    boolean bl3 = coneTypeProjection instanceof ConeKotlinType ? this.isRecursive((ConeKotlinType)it, visited2) : (coneTypeProjection instanceof ConeKotlinTypeProjectionIn ? this.isRecursive(((ConeKotlinTypeProjectionIn)it).getType(), visited2) : (coneTypeProjection instanceof ConeKotlinTypeProjectionOut ? this.isRecursive(((ConeKotlinTypeProjectionOut)it).getType(), visited2) : false));
                    if (!bl3) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            } else if (coneKotlinType instanceof ConeFlexibleType) {
                bl = this.isRecursive(((ConeFlexibleType)$this$isRecursive).getLowerBound(), visited2) || this.isRecursive(((ConeFlexibleType)$this$isRecursive).getUpperBound(), visited2);
            } else if (coneKotlinType instanceof ConeCapturedType) {
                if (visited2.add((ConeCapturedType)$this$isRecursive)) {
                    Boolean bl4;
                    List<ConeKotlinType> $this$any$iv = ((ConeCapturedType)$this$isRecursive).getConstructor().getSupertypes();
                    if ($this$any$iv == null) {
                        bl4 = null;
                    } else {
                        boolean bl5;
                        block22: {
                            Iterable $this$any$iv2 = $this$any$iv;
                            boolean $i$f$any = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl5 = false;
                            } else {
                                for (Object element$iv : $this$any$iv2) {
                                    ConeKotlinType it = (ConeKotlinType)element$iv;
                                    boolean bl6 = false;
                                    if (!this.isRecursive(it, visited2)) continue;
                                    bl5 = true;
                                    break block22;
                                }
                                bl5 = false;
                            }
                        }
                        bl4 = bl5;
                    }
                    bl = Intrinsics.areEqual(bl4, (Object)true);
                } else {
                    bl = true;
                }
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = this.isRecursive(((ConeDefinitelyNotNullType)$this$isRecursive).getOriginal(), visited2);
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$isRecursive).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl7 = false;
                        if (!this.isRecursive(it, visited2)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final IrClassSymbol getArrayClassSymbol(ClassId classId) {
        Object object = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType();
        boolean bl = false;
        ClassId classId2 = object.get(classId);
        if (classId2 == null) {
            return null;
        }
        ClassId primitiveId = classId2;
        IrType irType = this.classIdToTypeMap.get(primitiveId);
        Object object2 = this.getIrBuiltIns().getPrimitiveArrayForType();
        boolean bl2 = false;
        object = object2.get(irType);
        if (object == null) {
            object2 = "Strange primitiveId " + primitiveId + " from array: " + classId;
            bl2 = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        return object;
    }

    private final IrClassSymbol getBuiltInClassSymbol(ClassId classId) {
        Map<ClassId, IrClassSymbol> map = this.classIdToSymbolMap;
        boolean bl = false;
        IrClassSymbol irClassSymbol = map.get(classId);
        return irClassSymbol == null ? this.getArrayClassSymbol(classId) : irClassSymbol;
    }

    private final ConeKotlinType approximateType(ConeKotlinType type2) {
        if (type2 instanceof ConeClassLikeType) {
            ConeTypeProjection[] coneTypeProjectionArray = type2.getTypeArguments();
            boolean bl = false;
            if (coneTypeProjectionArray.length == 0) {
                return type2;
            }
        }
        AbstractConeSubstitutor substitutor2 = new AbstractConeSubstitutor(){

            @Nullable
            public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
                ConeKotlinType coneKotlinType;
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                if (type2 instanceof ConeIntersectionType) {
                    ConeKotlinType coneKotlinType2 = ((ConeIntersectionType)type2).getAlternativeType();
                    if (coneKotlinType2 == null) {
                        coneKotlinType = null;
                    } else {
                        ConeKotlinType coneKotlinType3 = coneKotlinType2;
                        boolean bl = false;
                        boolean bl2 = false;
                        ConeKotlinType it = coneKotlinType3;
                        boolean bl3 = false;
                        coneKotlinType = this.substituteOrSelf(it);
                    }
                } else {
                    coneKotlinType = null;
                }
                return coneKotlinType;
            }
        };
        ConeKotlinType coneKotlinType = substitutor2.substituteOrSelf(type2);
        boolean bl = false;
        boolean bl2 = false;
        ConeKotlinType it = coneKotlinType;
        boolean bl3 = false;
        ConeKotlinType coneKotlinType2 = this.typeApproximator.approximateToSuperType(it, (TypeApproximatorConfiguration)this.typeApproximatorConfiguration);
        return coneKotlinType2 == null ? it : coneKotlinType2;
    }
}

