/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0015\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorMutableIterator;", "T", "", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "builder", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "index", "", "(Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;I)V", "expectedModCount", "lastIteratedIndex", "trieIterator", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "add", "", "element", "(Ljava/lang/Object;)V", "checkForComodification", "checkHasIterated", "next", "()Ljava/lang/Object;", "previous", "remove", "reset", "set", "setupTrieIterator", "kotlinx-collections-immutable"})
public final class PersistentVectorMutableIterator<T>
extends AbstractListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    private int expectedModCount;
    private TrieIterator<? extends T> trieIterator;
    private int lastIteratedIndex;
    private final PersistentVectorBuilder<T> builder;

    @Override
    public T previous() {
        this.checkForComodification();
        this.checkHasPrevious$kotlinx_collections_immutable();
        this.lastIteratedIndex = this.getIndex() - 1;
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + -1);
            return (T)objectArray[persistentVectorMutableIterator.getIndex()];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (this.getIndex() > trieIterator2.getSize()) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + -1);
            return (T)objectArray[persistentVectorMutableIterator.getIndex() - trieIterator2.getSize()];
        }
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        int n = persistentVectorMutableIterator.getIndex();
        persistentVectorMutableIterator.setIndex(n + -1);
        return trieIterator2.previous();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.checkHasNext$kotlinx_collections_immutable();
        this.lastIteratedIndex = this.getIndex();
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            int n = persistentVectorMutableIterator.getIndex();
            persistentVectorMutableIterator.setIndex(n + 1);
            return (T)objectArray[n];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (trieIterator2.hasNext()) {
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            int n = persistentVectorMutableIterator.getIndex();
            persistentVectorMutableIterator.setIndex(n + 1);
            return trieIterator2.next();
        }
        Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        int n = persistentVectorMutableIterator.getIndex();
        persistentVectorMutableIterator.setIndex(n + 1);
        return (T)objectArray[n - trieIterator2.getSize()];
    }

    private final void reset() {
        this.setSize(this.builder.size());
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    private final void setupTrieIterator() {
        Object[] root2 = this.builder.getRoot$kotlinx_collections_immutable();
        if (root2 == null) {
            this.trieIterator = null;
            return;
        }
        int trieSize = UtilsKt.rootSize(this.builder.size());
        int trieIndex = RangesKt.coerceAtMost((int)this.getIndex(), (int)trieSize);
        int trieHeight = this.builder.getRootShift$kotlinx_collections_immutable() / 5 + 1;
        if (this.trieIterator == null) {
            this.trieIterator = new TrieIterator(root2, trieIndex, trieSize, trieHeight);
        } else {
            TrieIterator<T> trieIterator = this.trieIterator;
            if (trieIterator == null) {
                Intrinsics.throwNpe();
            }
            trieIterator.reset$kotlinx_collections_immutable(root2, trieIndex, trieSize, trieHeight);
        }
    }

    @Override
    public void add(T element) {
        this.checkForComodification();
        this.builder.add(this.getIndex(), element);
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        int n = persistentVectorMutableIterator.getIndex();
        persistentVectorMutableIterator.setIndex(n + 1);
        this.reset();
    }

    @Override
    public void remove() {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.remove(this.lastIteratedIndex);
        if (this.lastIteratedIndex < this.getIndex()) {
            this.setIndex(this.lastIteratedIndex);
        }
        this.reset();
    }

    @Override
    public void set(T element) {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.set(this.lastIteratedIndex, element);
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.setupTrieIterator();
    }

    private final void checkForComodification() {
        if (this.expectedModCount != this.builder.getModCount$kotlinx_collections_immutable()) {
            throw (Throwable)new ConcurrentModificationException();
        }
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex == -1) {
            throw (Throwable)new IllegalStateException();
        }
    }

    public PersistentVectorMutableIterator(@NotNull PersistentVectorBuilder<T> builder2, int index2) {
        Intrinsics.checkParameterIsNotNull(builder2, (String)"builder");
        super(index2, builder2.size());
        this.builder = builder2;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }
}

