/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.UpperBoundViolatedReporter;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016JF\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/WarningAwareUpperBoundChecker;", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "()V", "checkBounds", "", "argumentReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasUsageElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "withOnlyCheckForWarning", "", "checkBoundsOfExpandedTypeAlias", "type", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend.java"})
public final class WarningAwareUpperBoundChecker
extends UpperBoundChecker {
    @Override
    public void checkBoundsOfExpandedTypeAlias(@NotNull KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Object object = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"type.constructor.parameters");
        List<TypeParameterDescriptor> typeParameters2 = object;
        object = type2.getArguments().iterator();
        int n = 0;
        while (object.hasNext()) {
            int index2 = n++;
            TypeProjection arg = (TypeProjection)object.next();
            Object object2 = arg.getType();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"arg.type");
            KotlinType kotlinType = object2;
            object2 = typeParameters2.get(index2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"typeParameters[index]");
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object2;
            object2 = TypeSubstitutor.create(type2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(type)");
            this.checkBounds(null, kotlinType, typeParameterDescriptor, (TypeSubstitutor)object2, trace, expression2, true);
        }
    }

    @Override
    public void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.checkBounds(argumentReference, argumentType, typeParameterDescriptor, substitutor2, trace, typeAliasUsageElement, false);
    }

    public final void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, boolean withOnlyCheckForWarning) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (typeParameterDescriptor.getUpperBounds().isEmpty()) {
            return;
        }
        UpperBoundViolatedReporter diagnosticsReporter = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, null, null, 24, null);
        Object object = ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(object, (String)"UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS");
        DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> diagnosticFactory2 = object;
        object = ErrorsJvm.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION_BASED_ON_JAVA_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(object, (String)"UPPER_BOUND_VIOLATED_IN_\u2026BASED_ON_JAVA_ANNOTATIONS");
        UpperBoundViolatedReporter diagnosticsReporterForWarnings = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, diagnosticFactory2, (DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor>)object);
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            if (!withOnlyCheckForWarning) {
                Intrinsics.checkNotNullExpressionValue((Object)bound, (String)"bound");
                boolean isBaseCheckPassed = this.checkBound(bound, argumentType, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporter);
                if (!isBaseCheckPassed) continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bound, (String)"bound");
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(bound);
            if (kotlinType == null) continue;
            KotlinType enhancedBound = kotlinType;
            KotlinType kotlinType2 = TypeWithEnhancementKt.getEnhancementDeeply(argumentType);
            KotlinType argumentTypeEnhancement = kotlinType2 == null ? argumentType : kotlinType2;
            this.checkBound(enhancedBound, argumentTypeEnhancement, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporterForWarnings);
        }
    }

    public static /* synthetic */ void checkBounds$default(WarningAwareUpperBoundChecker warningAwareUpperBoundChecker, KtTypeReference ktTypeReference, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, TypeSubstitutor typeSubstitutor2, BindingTrace bindingTrace, KtElement ktElement, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            ktElement = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        warningAwareUpperBoundChecker.checkBounds(ktTypeReference, kotlinType, typeParameterDescriptor, typeSubstitutor2, bindingTrace, ktElement, bl);
    }
}

