/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationInspectorKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDefaultDeclarationPresenter;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0014J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\rH\u0014J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\rR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector;", "", "presenter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;)V", "functionDeclarations", "", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getFunctionDeclarations", "()Ljava/util/Map;", "otherDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getOtherDeclarations", "getPresenter", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "collect", "", "declaration", "collectFunction", "key", "collectNonFunctionDeclaration", "contains", "", "checkers"})
public class FirDeclarationInspector {
    @NotNull
    private final FirDeclarationPresenter presenter;
    @NotNull
    private final Map<String, List<FirDeclaration>> otherDeclarations;
    @NotNull
    private final Map<String, List<FirSimpleFunction>> functionDeclarations;

    public FirDeclarationInspector(@NotNull FirDeclarationPresenter presenter) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        this.presenter = presenter;
        this.otherDeclarations = new LinkedHashMap();
        this.functionDeclarations = new LinkedHashMap();
    }

    public /* synthetic */ FirDeclarationInspector(FirDeclarationPresenter firDeclarationPresenter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            firDeclarationPresenter = new FirDefaultDeclarationPresenter();
        }
        this(firDeclarationPresenter);
    }

    @NotNull
    protected final FirDeclarationPresenter getPresenter() {
        return this.presenter;
    }

    @NotNull
    public final Map<String, List<FirDeclaration>> getOtherDeclarations() {
        return this.otherDeclarations;
    }

    @NotNull
    public final Map<String, List<FirSimpleFunction>> getFunctionDeclarations() {
        return this.functionDeclarations;
    }

    public final void collect(@NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (FirDeclarationInspectorKt.access$isCollectable(declaration2)) {
            if (declaration2 instanceof FirSimpleFunction) {
                this.collectFunction(this.presenter.represent((FirSimpleFunction)declaration2), (FirSimpleFunction)declaration2);
            } else if (declaration2 instanceof FirRegularClass) {
                this.collectNonFunctionDeclaration(this.presenter.represent((FirRegularClass)declaration2), declaration2);
            } else if (declaration2 instanceof FirTypeAlias) {
                this.collectNonFunctionDeclaration(this.presenter.represent((FirTypeAlias)declaration2), declaration2);
            } else if (declaration2 instanceof FirVariable) {
                this.collectNonFunctionDeclaration(this.presenter.represent((FirVariable)declaration2), declaration2);
            }
        }
    }

    @NotNull
    protected List<FirDeclaration> collectNonFunctionDeclaration(@NotNull String key, @NotNull FirDeclaration declaration2) {
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Map<String, List<FirDeclaration>> $this$getOrPut$iv = this.otherDeclarations;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key, answer$iv);
            list3 = answer$iv;
        } else {
            list3 = value$iv;
        }
        List it = list2 = list3;
        boolean bl = false;
        it.add((FirDeclaration)declaration2);
        return list2;
    }

    @NotNull
    protected List<FirSimpleFunction> collectFunction(@NotNull String key, @NotNull FirSimpleFunction declaration2) {
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Map<String, List<FirSimpleFunction>> $this$getOrPut$iv = this.functionDeclarations;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key, answer$iv);
            list3 = answer$iv;
        } else {
            list3 = value$iv;
        }
        List it = list2 = list3;
        boolean bl = false;
        it.add((FirSimpleFunction)declaration2);
        return list2;
    }

    public final boolean contains(@NotNull FirDeclaration declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirSimpleFunction) {
            Map<String, List<FirSimpleFunction>> map = this.functionDeclarations;
            bl = map.containsKey(this.presenter.represent((FirSimpleFunction)declaration2));
        } else if (firDeclaration instanceof FirRegularClass) {
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            bl = map.containsKey(this.presenter.represent((FirRegularClass)declaration2));
        } else if (firDeclaration instanceof FirTypeAlias) {
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            bl = map.containsKey(this.presenter.represent((FirTypeAlias)declaration2));
        } else if (firDeclaration instanceof FirProperty) {
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            bl = map.containsKey(this.presenter.represent((FirVariable)declaration2));
        } else {
            bl = false;
        }
        return bl;
    }

    public FirDeclarationInspector() {
        this(null, 1, null);
    }
}

