/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.javac.JavaClassWithClassId;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.ResolveHelperKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ2\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0011j\b\u0012\u0004\u0012\u00020\b`\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ResolveHelper;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;Lcom/sun/source/tree/CompilationUnitTree;)V", "findImport", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "pathSegments", "", "", "findInnerOrNested", "javaClass", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkedSupertypes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findJavaOrKotlinClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findPackage", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "getJavaClassFromPathSegments", "findVisibleInnerOrNestedClass", "javac-wrapper"})
public final class ResolveHelper {
    @NotNull
    private final JavacWrapper javac;
    @NotNull
    private final CompilationUnitTree compilationUnit;

    public ResolveHelper(@NotNull JavacWrapper javac2, @NotNull CompilationUnitTree compilationUnit) {
        Intrinsics.checkNotNullParameter((Object)javac2, (String)"javac");
        Intrinsics.checkNotNullParameter((Object)compilationUnit, (String)"compilationUnit");
        this.javac = javac2;
        this.compilationUnit = compilationUnit;
    }

    @Nullable
    public final JavaClass getJavaClassFromPathSegments(@NotNull JavaClass javaClass, @NotNull List<String> pathSegments) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        return pathSegments.size() == 1 ? javaClass : this.findInnerOrNested(javaClass, CollectionsKt.drop((Iterable)pathSegments, (int)1));
    }

    @Nullable
    public final JavaClass findImport(@NotNull List<String> pathSegments) {
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Iterable $this$forEachIndexed$iv = pathSegments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            JavaClass javaClass;
            FqName fqName2;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int index2 = n;
            boolean bl = false;
            if (index2 == CollectionsKt.getLastIndex(pathSegments)) {
                return null;
            }
            String packageFqName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(pathSegments, (int)(index2 + 1)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            FqName fqName3 = this.findPackage(packageFqName);
            if (fqName3 == null) continue;
            FqName pack = fqName2 = fqName3;
            boolean bl2 = false;
            List className2 = CollectionsKt.takeLast(pathSegments, (int)(index2 + 1));
            JavaClass javaClass2 = this.findJavaOrKotlinClass(new ClassId(pack, Name.identifier((String)CollectionsKt.first((List)className2))));
            if (javaClass2 == null) {
                javaClass = null;
            } else {
                JavaClass javaClass3;
                JavaClass javaClass4 = javaClass3 = javaClass2;
                boolean bl3 = false;
                javaClass = this.getJavaClassFromPathSegments(javaClass4, className2);
            }
            return javaClass;
        }
        return null;
    }

    @Nullable
    public final JavaClass findJavaOrKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JavaClass javaClass = JavacWrapper.findClass$default(this.javac, classId, null, 2, null);
        return javaClass == null ? this.javac.getKotlinClassifier(classId) : javaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JavaClass findInnerOrNested(@NotNull JavaClass javaClass, @NotNull Name name, @NotNull HashSet<JavaClass> checkedSupertypes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(checkedSupertypes, (String)"checkedSupertypes");
        Object object = this.findVisibleInnerOrNestedClass(javaClass, name);
        if (object != null) {
            JavaClass javaClass2;
            JavaClass it = javaClass2 = object;
            boolean bl = false;
            checkedSupertypes.addAll((Collection<JavaClass>)ResolveHelperKt.collectAllSupertypes(javaClass));
            return it;
        }
        object = javaClass.getSupertypes();
        boolean $i$f$mapNotNull = false;
        void it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JavaClass javaClass3;
            JavaClass javaClass4;
            JavaClass javaClass5;
            JavaClass javaClass6;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JavaClassifierType it2 = (JavaClassifierType)element$iv$iv;
            boolean bl2 = false;
            JavaClassifier javaClassifier = it2.getClassifier();
            JavaClass javaClass7 = javaClass6 = javaClassifier instanceof JavaClass ? (JavaClass)javaClassifier : null;
            if (javaClass6 == null) {
                javaClass5 = null;
            } else {
                JavaClassifier supertype2 = javaClassifier = javaClass6;
                boolean bl3 = false;
                javaClass5 = !checkedSupertypes.contains(supertype2) ? this.findInnerOrNested((JavaClass)supertype2, name, checkedSupertypes) : null;
            }
            if ((javaClass4 = javaClass5) == null) continue;
            JavaClass it$iv$iv = javaClass3 = javaClass4;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (JavaClass)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public static /* synthetic */ JavaClass findInnerOrNested$default(ResolveHelper resolveHelper, JavaClass javaClass, Name name, HashSet hashSet, int n, Object object) {
        if ((n & 4) != 0) {
            hashSet = new HashSet<JavaClass>();
        }
        return resolveHelper.findInnerOrNested(javaClass, name, hashSet);
    }

    @Nullable
    public final FqName findPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        FqName fqName2 = !StringsKt.isBlank((CharSequence)packageName) ? new FqName(packageName) : FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fqName");
        Object object = this.javac.hasKotlinPackage(fqName2);
        if (object != null) {
            FqName fqName3;
            FqName it = fqName3 = object;
            boolean bl = false;
            return it;
        }
        object = JavacWrapper.findPackage$default(this.javac, fqName2, null, 2, null);
        return object == null ? null : object.getFqName();
    }

    private final JavaClass findVisibleInnerOrNestedClass(JavaClass $this$findVisibleInnerOrNestedClass, Name name) {
        JavaClass javaClass;
        JavaClass javaClass2 = $this$findVisibleInnerOrNestedClass.findInnerClass(name);
        if (javaClass2 == null) {
            javaClass = null;
        } else {
            JavaClass javaClass3;
            JavaClass innerOrNestedClass = javaClass3 = javaClass2;
            boolean bl = false;
            Visibility visibility2 = innerOrNestedClass.getVisibility();
            if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PRIVATE)) {
                javaClass = null;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)JavaDescriptorVisibilities.PACKAGE_VISIBILITY)) {
                String string2;
                Object object = innerOrNestedClass instanceof JavaClassWithClassId ? (JavaClassWithClassId)innerOrNestedClass : null;
                ClassId classId = object == null ? null : object.getClassId();
                if ((object = classId) == null) {
                    string2 = null;
                } else {
                    FqName fqName2 = ((ClassId)object).getPackageFqName();
                    string2 = fqName2.asString();
                }
                object = this.compilationUnit.getPackageName();
                javaClass = Intrinsics.areEqual((Object)string2, (Object)(object == null ? "" : object.toString())) ? (JavaClassWithClassId)innerOrNestedClass : null;
            } else {
                javaClass = innerOrNestedClass;
            }
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    private final JavaClass findInnerOrNested(JavaClass $this$findInnerOrNested, List<String> pathSegments) {
        Iterable $this$fold$iv = pathSegments;
        boolean $i$f$fold = false;
        JavaClass accumulator$iv = $this$findInnerOrNested;
        for (Object element$iv : $this$fold$iv) {
            void it;
            String string2 = (String)element$iv;
            JavaClass javaClass = accumulator$iv;
            boolean bl = false;
            Name name = Name.identifier((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(it)");
            JavaClass javaClass2 = ResolveHelper.findInnerOrNested$default(this, javaClass, name, null, 4, null);
            if (javaClass2 == null) {
                return null;
            }
            accumulator$iv = javaClass2;
        }
        return accumulator$iv;
    }
}

