/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DslScopeViolationCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DslScopeViolationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallImplicitReceiver", "callImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend"})
public final class DslScopeViolationCallChecker
implements CallChecker {
    @NotNull
    public static final DslScopeViolationCallChecker INSTANCE = new DslScopeViolationCallChecker();

    private DslScopeViolationCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Collection collection;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkersSupport)) {
            return;
        }
        Collection callImplicitReceivers = ResolvedCallUtilKt.getImplicitReceivers(resolvedCall2);
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = callImplicitReceivers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReceiverValue receiverValue = (ReceiverValue)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                ReceiverValue receiverValue2 = it.getOriginal();
                collection2.add(receiverValue2);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = callImplicitReceivers;
        }
        Collection originalReceivers = collection;
        for (ReceiverValue callImplicitReceiver : originalReceivers) {
            this.checkCallImplicitReceiver(callImplicitReceiver, resolvedCall2, reportOn, context2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallImplicitReceiver(ReceiverValue callImplicitReceiver, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        Object v3;
        block16: {
            Object v1;
            List dslMarkersFromOuterReceivers;
            Set<FqName> additionalCallDslMarkers;
            Set<FqName> callDslMarkers;
            block14: {
                Iterator $this$mapTo$iv$iv;
                void $this$map$iv;
                List receiversUntilOneFromTheCall2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.mapNotNull(ScopeUtilsKt.getParentsWithSelf(context2.getScope()), (Function1)checkCallImplicitReceiver.receiversUntilOneFromTheCall.1.INSTANCE), (Function1)((Function1)new Function1<ReceiverValue, Boolean>(callImplicitReceiver){
                    final /* synthetic */ ReceiverValue $callImplicitReceiver;
                    {
                        this.$callImplicitReceiver = $callImplicitReceiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ReceiverValue it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !Intrinsics.areEqual((Object)it, (Object)this.$callImplicitReceiver);
                    }
                })));
                if (receiversUntilOneFromTheCall2.isEmpty()) {
                    return;
                }
                DslMarkerUtils.DslMarkersFromReceiver dslMarkersFromReceiver = DslMarkerUtils.INSTANCE.extractDslMarkerFqNames(callImplicitReceiver);
                callDslMarkers = dslMarkersFromReceiver.component1();
                additionalCallDslMarkers = dslMarkersFromReceiver.component2();
                if (callDslMarkers.isEmpty() && additionalCallDslMarkers.isEmpty()) {
                    return;
                }
                Iterable iterable = receiversUntilOneFromTheCall2;
                DslMarkerUtils dslMarkerUtils = DslMarkerUtils.INSTANCE;
                boolean $i$f$map = false;
                void var13_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void p0;
                    Object item$iv$iv = iterator2.next();
                    ReceiverValue receiverValue = (ReceiverValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    DslMarkerUtils.DslMarkersFromReceiver dslMarkersFromReceiver2 = dslMarkerUtils.extractDslMarkerFqNames((ReceiverValue)p0);
                    collection.add(dslMarkersFromReceiver2);
                }
                dslMarkersFromOuterReceivers = (List)destination$iv$iv;
                Iterable $this$firstOrNull$iv = dslMarkersFromOuterReceivers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block13: {
                        DslMarkerUtils.DslMarkersFromReceiver $dstr$dslMarkersFromReceiver$_u24__u24 = (DslMarkerUtils.DslMarkersFromReceiver)element$iv;
                        boolean bl2 = false;
                        Set<FqName> dslMarkersFromReceiver3 = $dstr$dslMarkersFromReceiver$_u24__u24.component1();
                        Iterable $this$any$iv = dslMarkersFromReceiver3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                FqName p0 = (FqName)element$iv2;
                                boolean bl3 = false;
                                if (!callDslMarkers.contains(p0)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v1 = element$iv;
                    break block14;
                }
                v1 = null;
            }
            DslMarkerUtils.DslMarkersFromReceiver closestAnotherReceiverWithSameDslMarker = v1;
            if (closestAnotherReceiverWithSameDslMarker != null) {
                context2.getTrace().report(Errors.DSL_SCOPE_VIOLATION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
                return;
            }
            Set allDslMarkersFromCall = SetsKt.plus(callDslMarkers, (Iterable)additionalCallDslMarkers);
            Iterable $this$firstOrNull$iv = dslMarkersFromOuterReceivers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block15: {
                    DslMarkerUtils.DslMarkersFromReceiver $dstr$dslMarkersFromReceiver$additionalDslMarkersFromReceiver = (DslMarkerUtils.DslMarkersFromReceiver)element$iv;
                    boolean bl4 = false;
                    Set<FqName> dslMarkersFromReceiver = $dstr$dslMarkersFromReceiver$additionalDslMarkersFromReceiver.component1();
                    Set<FqName> additionalDslMarkersFromReceiver = $dstr$dslMarkersFromReceiver$additionalDslMarkersFromReceiver.component2();
                    Set allMarkersFromReceiver = SetsKt.plus(dslMarkersFromReceiver, (Iterable)additionalDslMarkersFromReceiver);
                    Iterable $this$any$iv = allDslMarkersFromCall;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            FqName p0 = (FqName)element$iv3;
                            boolean bl5 = false;
                            if (!allMarkersFromReceiver.contains(p0)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = element$iv;
                break block16;
            }
            v3 = null;
        }
        DslMarkerUtils.DslMarkersFromReceiver closestAnotherReceiverWithSameDslMarkerWithDeprecation = v3;
        if (closestAnotherReceiverWithSameDslMarkerWithDeprecation != null) {
            DiagnosticFactory1<PsiElement, CallableDescriptor> diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkerOnFunctionTypeReceiver) ? Errors.DSL_SCOPE_VIOLATION : Errors.DSL_SCOPE_VIOLATION_WARNING;
            context2.getTrace().report(diagnostic.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
        }
    }
}

