/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.UselessElvisCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UselessElvisCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class UselessElvisCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        KtBinaryExpression ktBinaryExpression;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getName(), (Object)ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
        KtExpression ktExpression = elvisBinaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtElement left = ktElement = ktExpression;
        Object object = elvisBinaryExpression.getRight();
        if (object == null) {
            return;
        }
        KtExpression right = ktExpression = object;
        Object object2 = context2.getTrace().getType((KtExpression)left);
        if (object2 == null) {
            return;
        }
        object = object2;
        Object leftType = object;
        if (KotlinTypeKt.isError((KotlinType)leftType) || TypeUtilsKt.contains((KotlinType)leftType, (Function1<? super UnwrappedType, Boolean>)((Function1)check.1.INSTANCE))) {
            return;
        }
        if (!TypeUtils.isNullableType((KotlinType)leftType)) {
            BindingTrace bindingTrace = context2.getTrace();
            object = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), (KotlinType)leftType);
            Intrinsics.checkNotNullExpressionValue(object, (String)"USELESS_ELVIS.on(elvisBinaryExpression, leftType)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object);
            return;
        }
        DataFlowValue dataFlowValue2 = context2.getDataFlowValueFactory().createDataFlowValue((KtExpression)left, (KotlinType)leftType, context2.getResolutionContext());
        if (context2.getDataFlowInfo().getStableNullability(dataFlowValue2) == Nullability.NOT_NULL) {
            BindingTrace bindingTrace = context2.getTrace();
            object2 = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), (KotlinType)leftType);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"USELESS_ELVIS.on(elvisBinaryExpression, leftType)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object2);
            return;
        }
        if (KtPsiUtil.isNullConstant(right) && !FlexibleTypesKt.isNullabilityFlexible(leftType)) {
            BindingTrace bindingTrace = context2.getTrace();
            object2 = Errors.USELESS_ELVIS_RIGHT_IS_NULL.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression));
            Intrinsics.checkNotNullExpressionValue(object2, (String)"USELESS_ELVIS_RIGHT_IS_N\u2026on(elvisBinaryExpression)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object2);
        }
    }
}

