/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.diagnostics.OffsetsOnlyPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/diagnostics/SourceElementPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "lightTreeStrategy", "Lorg/jetbrains/kotlin/diagnostics/LightTreePositioningStrategy;", "psiStrategy", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "offsetsOnlyPositioningStrategy", "Lorg/jetbrains/kotlin/diagnostics/OffsetsOnlyPositioningStrategy;", "(Lorg/jetbrains/kotlin/diagnostics/LightTreePositioningStrategy;Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;Lorg/jetbrains/kotlin/diagnostics/OffsetsOnlyPositioningStrategy;)V", "isValid", "", "element", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "markDiagnostic", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "hackyIsValid", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "frontend.common-psi"})
public final class SourceElementPositioningStrategy
extends AbstractSourceElementPositioningStrategy {
    @NotNull
    private final LightTreePositioningStrategy lightTreeStrategy;
    @NotNull
    private final PositioningStrategy<?> psiStrategy;
    @NotNull
    private final OffsetsOnlyPositioningStrategy offsetsOnlyPositioningStrategy;

    public SourceElementPositioningStrategy(@NotNull LightTreePositioningStrategy lightTreeStrategy, @NotNull PositioningStrategy<?> psiStrategy, @NotNull OffsetsOnlyPositioningStrategy offsetsOnlyPositioningStrategy) {
        Intrinsics.checkNotNullParameter((Object)lightTreeStrategy, (String)"lightTreeStrategy");
        Intrinsics.checkNotNullParameter(psiStrategy, (String)"psiStrategy");
        Intrinsics.checkNotNullParameter((Object)offsetsOnlyPositioningStrategy, (String)"offsetsOnlyPositioningStrategy");
        this.lightTreeStrategy = lightTreeStrategy;
        this.psiStrategy = psiStrategy;
        this.offsetsOnlyPositioningStrategy = offsetsOnlyPositioningStrategy;
    }

    public /* synthetic */ SourceElementPositioningStrategy(LightTreePositioningStrategy lightTreePositioningStrategy, PositioningStrategy positioningStrategy, OffsetsOnlyPositioningStrategy offsetsOnlyPositioningStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            offsetsOnlyPositioningStrategy = new OffsetsOnlyPositioningStrategy();
        }
        this(lightTreePositioningStrategy, positioningStrategy, offsetsOnlyPositioningStrategy);
    }

    @Override
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull KtDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        AbstractKtSourceElement element = diagnostic.getElement();
        return element instanceof KtPsiSourceElement ? this.psiStrategy.markDiagnostic(diagnostic) : (element instanceof KtLightSourceElement ? this.lightTreeStrategy.markKtDiagnostic((KtSourceElement)element, diagnostic) : this.offsetsOnlyPositioningStrategy.markKtDiagnostic(element, diagnostic));
    }

    @Override
    public boolean isValid(@NotNull AbstractKtSourceElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        AbstractKtSourceElement abstractKtSourceElement = element;
        return abstractKtSourceElement instanceof KtPsiSourceElement ? this.hackyIsValid(this.psiStrategy, ((KtPsiSourceElement)element).getPsi()) : (abstractKtSourceElement instanceof KtLightSourceElement ? this.lightTreeStrategy.isValid(((KtLightSourceElement)element).getLighterASTNode(), ((KtLightSourceElement)element).getTreeStructure()) : true);
    }

    private final boolean hackyIsValid(PositioningStrategy<?> $this$hackyIsValid, PsiElement psi) {
        return $this$hackyIsValid.isValid(psi);
    }
}

