/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingServices;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016JZ\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J@\u0010*\u001a\b\u0012\u0004\u0012\u00020+0$2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J<\u00104\u001a\u0004\u0018\u0001052\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00106\u001a\u0002072\u0006\u0010,\u001a\u00020-2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002JH\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u0002032\u0006\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)J:\u0010<\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)H\u0002Jn\u0010>\u001a\u00020?2*\u0010@\u001a&\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020/0A2\u0006\u0010F\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J8\u0010>\u001a\u00020?2\u0006\u0010F\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\b\u0010(\u001a\u0004\u0018\u00010)J@\u0010G\u001a\u00020?2\u0006\u0010F\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)J:\u0010H\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020J2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)J8\u0010K\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020M2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)JN\u0010N\u001a\b\u0012\u0004\u0012\u00020+0$2\u0006\u0010.\u001a\u00020O2\u0006\u0010P\u001a\u0002012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\f\u0010R\u001a\u00020\u001e*\u000203H\u0002J\u0012\u0010S\u001a\b\u0012\u0004\u0012\u0002030$*\u000203H\u0002J\u000e\u0010T\u001a\u0004\u0018\u000103*\u000203H\u0002J\u001c\u0010U\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010$*\u0002032\u0006\u0010V\u001a\u00020OH\u0002J\f\u0010W\u001a\u000203*\u000203H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "contractParsingServices", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "createConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isPrimary", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "valueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "createValueParameterDescriptors", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getContractProvider", "Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "initializeFunctionDescriptorAndExplicitReturnType", "", "container", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initializeFunctionReturnTypeBasedOnFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "containingDescriptor", "resolveFunctionExpressionDescriptor", "resolvePrimaryConstructorDescriptor", "classElement", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "resolveValueParameters", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterScope", "expectedParameterTypes", "functionTypeExpected", "getContextReceiversTypes", "getReceiverType", "getValueParameters", "owner", "removeParameterNameAnnotation", "frontend"})
public final class FunctionDescriptorResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ModifiersChecker modifiersChecker;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final ContractParsingServices contractParsingServices;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final StorageManager storageManager;

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker, @NotNull OverloadChecker overloadChecker, @NotNull ContractParsingServices contractParsingServices, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkNotNullParameter((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkNotNullParameter((Object)overloadChecker, (String)"overloadChecker");
        Intrinsics.checkNotNullParameter((Object)contractParsingServices, (String)"contractParsingServices");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
        this.overloadChecker = overloadChecker;
        this.contractParsingServices = contractParsingServices;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        if (function2.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function2)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor((Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl>)function5, containingDescriptor, scope2, function2, trace, dataFlowInfo, simpleType2, inferenceSession);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        return this.resolveFunctionDescriptor((Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl>)((Function5)resolveFunctionExpressionDescriptor.1.INSTANCE), containingDescriptor, scope2, function2, trace, dataFlowInfo, expectedFunctionType, inferenceSession);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope2, KtNamedFunction function2, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType, InferenceSession inferenceSession) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function2.getModifierList(), trace);
        Name name = function2.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"function.nameAsSafeName");
        SimpleFunctionDescriptorImpl functionDescriptor = (SimpleFunctionDescriptorImpl)functionConstructor.invoke((Object)containingDescriptor, (Object)annotations2, (Object)name, (Object)CallableMemberDescriptor.Kind.DECLARATION, (Object)KotlinSourceElementKt.toSourceElement(function2));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope2, function2, functionDescriptor, trace, expectedFunctionType, dataFlowInfo, inferenceSession);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope2, function2, functionDescriptor, trace, dataFlowInfo, inferenceSession);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function2, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope2, KtNamedFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType kotlinType;
        boolean bl;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl2 = bl = function2.getTypeReference() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Return type must be initialized early for function: " + function2.getText() + ", at: " + PsiDiagnosticUtils.atLocation(function2);
            throw new AssertionError((Object)string2);
        }
        if (function2.hasBlockBody()) {
            kotlinType = this.builtIns.getUnitType();
        } else if (function2.hasBody()) {
            kotlinType = this.descriptorResolver.inferReturnTypeFromExpressionBody(trace, scope2, dataFlowInfo, function2, functionDescriptor, inferenceSession);
        } else {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor.getName().asString(), (String)"functionDescriptor.name.asString()");
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_TYPE, stringArray);
        }
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"when {\n            funct\u2026ame.asString())\n        }");
        KotlinType inferredReturnType = kotlinType2;
        functionDescriptor.setReturnType(inferredReturnType);
    }

    /*
     * WARNING - void declaration
     */
    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor container, @NotNull LexicalScope scope2, @NotNull KtFunction function2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession) {
        KotlinType it;
        void $this$mapNotNullTo$iv$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Map item$iv$iv2;
        KotlinType kotlinType;
        Object object;
        Object it2;
        List list2;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        LexicalWritableScope headerScope = new LexicalWritableScope(scope2, functionDescriptor, true, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.descriptorResolver.resolveTypeParametersForDescriptor(functionDescriptor, headerScope, scope2, function2.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function2, functionDescriptor, headerScope, typeParameterDescriptors, trace);
        KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(headerScope, receiverTypeRef, trace, true) : (function2 instanceof KtFunctionLiteral ? this.getReceiverType(expectedFunctionType) : null);
        List<KtContextReceiver> list3 = function2.getContextReceivers();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"function.contextReceivers");
        List<KtContextReceiver> contextReceivers = list3;
        if (function2 instanceof KtFunctionLiteral) {
            list2 = this.getContextReceiversTypes(expectedFunctionType);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = contextReceivers;
            boolean $i$f$mapNotNull = false;
            void var17_17 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                KtTypeReference it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl = false;
                it2 = (KtContextReceiver)element$iv$iv;
                boolean bl2 = false;
                if (((KtContextReceiver)it2).typeReference() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it3;
                object2 = (KtTypeReference)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(this.typeResolver.resolveType(headerScope, (KtTypeReference)it3, trace, true));
            }
            list2 = (List)destination$iv$iv;
        }
        List contextReceiverTypes = list2;
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function2, functionDescriptor, headerScope, trace, expectedFunctionType, inferenceSession);
        headerScope.freeze();
        KtTypeReference ktTypeReference = function2.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference it4 = ktTypeReference;
            boolean bl = false;
            kotlinType = this.typeResolver.resolveType(headerScope, it4, trace, true);
        } else {
            kotlinType = null;
        }
        KotlinType returnType2 = kotlinType;
        DescriptorVisibility descriptorVisibility = ModifiersChecker.resolveVisibilityFromModifiers(function2, DescriptorResolver.getDefaultVisibility(function2, container));
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"resolveVisibilityFromMod\u2026ity(function, container))");
        DescriptorVisibility visibility2 = descriptorVisibility;
        Modality modality = ModifiersChecker.resolveMemberModalityFromModifiers(function2, DescriptorResolver.getDefaultModality(container, visibility2, function2.hasBody()), trace.getBindingContext(), container);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"resolveMemberModalityFro\u2026text, container\n        )");
        Modality modality2 = modality;
        LazyContractProvider contractProvider = this.getContractProvider(functionDescriptor, trace, scope2, dataFlowInfo, function2, inferenceSession);
        Map $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u244 = item$iv$iv2 = (Map)new LinkedHashMap();
        boolean bl = false;
        if (contractProvider != null) {
            $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u244.put(ContractProviderKey.INSTANCE, contractProvider);
        }
        if (receiverType != null && this.functionTypeExpected(expectedFunctionType) && !expectedFunctionType.getAnnotations().isEmpty()) {
            $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u244.put(DslMarkerUtils.FunctionTypeAnnotationsKey.INSTANCE, expectedFunctionType.getAnnotations());
        }
        Map userData = item$iv$iv2;
        KotlinType kotlinType2 = receiverType;
        if (kotlinType2 != null) {
            KotlinType it5 = kotlinType2;
            boolean bl4 = false;
            Annotations annotations2 = it5.getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(AnnotationUseSiteTarget.RECEIVER)");
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, annotations2, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            receiverParameterDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(functionDescriptor, it5, splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        } else {
            receiverParameterDescriptor = null;
        }
        ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
        Iterable $this$mapNotNull$iv = contextReceiverTypes;
        boolean $i$f$mapNotNull2 = false;
        Iterable splitter = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ReceiverParameterDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            KotlinType it6 = (KotlinType)element$iv$iv;
            boolean bl6 = false;
            Annotations annotations3 = it6.getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(AnnotationUseSiteTarget.RECEIVER)");
            AnnotationSplitter splitter2 = new AnnotationSplitter(this.storageManager, annotations3, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            if (DescriptorFactory.createContextReceiverParameterForCallable(functionDescriptor, it6, splitter2.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER)) == null) continue;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List contextReceiverDescriptors = (List)destination$iv$iv;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers)) {
            void $this$forEach$iv;
            HashMultimap labelNameToReceiverMap = HashMultimap.create();
            if (receiverTypeRef != null && extensionReceiver != null) {
                String string2 = receiverTypeRef.nameForReceiverLabel();
                if (string2 != null) {
                    it2 = string2;
                    boolean bl8 = false;
                    labelNameToReceiverMap.put(it2, extensionReceiver);
                }
            }
            Iterable $i$f$mapNotNull2 = CollectionsKt.reversed((Iterable)CollectionsKt.zip((Iterable)contextReceiverDescriptors, (Iterable)((Iterable)RangesKt.until((int)0, (int)contextReceivers.size()))));
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it7;
                Pair pair = (Pair)element$iv;
                boolean bl9 = false;
                ReceiverParameterDescriptor contextReceiverDescriptor = (ReceiverParameterDescriptor)pair.component1();
                int i = ((Number)pair.component2()).intValue();
                if (contextReceivers.get(i).name() == null) continue;
                boolean bl10 = false;
                labelNameToReceiverMap.put(it7, contextReceiverDescriptor);
            }
            trace.record(BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP, functionDescriptor, labelNameToReceiverMap);
        }
        Map map = userData;
        Map $this$forEach$iv = map;
        DescriptorVisibility descriptorVisibility2 = visibility2;
        Modality modality3 = modality2;
        KotlinType kotlinType3 = returnType2;
        List<ValueParameterDescriptor> list4 = valueParameterDescriptors;
        List<TypeParameterDescriptorImpl> list5 = typeParameterDescriptors;
        List list6 = contextReceiverDescriptors;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = DescriptorUtils.getDispatchReceiverParameterIfNeeded(container);
        ReceiverParameterDescriptor receiverParameterDescriptor3 = extensionReceiver;
        object = functionDescriptor;
        boolean bl11 = false;
        boolean bl12 = !it.isEmpty();
        ((SimpleFunctionDescriptorImpl)object).initialize(receiverParameterDescriptor3, receiverParameterDescriptor2, list6, (List<? extends TypeParameterDescriptor>)list5, list4, kotlinType3, modality3, descriptorVisibility2, (Map<? extends CallableDescriptor.UserDataKey<?>, ?>)(bl12 ? map : null));
        functionDescriptor.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
        functionDescriptor.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
        functionDescriptor.setExpect(container instanceof PackageFragmentDescriptor && PsiUtilsKt.hasExpectModifier(function2) || container instanceof ClassDescriptor && ((ClassDescriptor)container).isExpect());
        functionDescriptor.setActual(PsiUtilsKt.hasActualModifier(function2));
        KotlinType kotlinType4 = receiverType;
        if (kotlinType4 != null) {
            it = kotlinType4;
            boolean bl13 = false;
            ForceResolveUtil.forceResolveAllContents(it.getAnnotations());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final LazyContractProvider getContractProvider(SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, LexicalScope scope2, DataFlowInfo dataFlowInfo, KtFunction function2, InferenceSession inferenceSession) {
        if (!(function2 instanceof KtNamedFunction)) {
            return null;
        }
        boolean isContractsEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions);
        boolean isAllowedOnMembers = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForNonOverridableMembers);
        if (!isContractsEnabled || !((KtNamedFunction)function2).mayHaveContract(isAllowedOnMembers)) {
            return null;
        }
        return new LazyContractProvider(this.storageManager, (Function0<? extends Object>)((Function0)new Function0<Object>(function2, this, trace, scope2, dataFlowInfo, functionDescriptor, inferenceSession){
            final /* synthetic */ KtFunction $function;
            final /* synthetic */ FunctionDescriptorResolver this$0;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ LexicalScope $scope;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ SimpleFunctionDescriptorImpl $functionDescriptor;
            final /* synthetic */ InferenceSession $inferenceSession;
            {
                this.$function = $function;
                this.this$0 = $receiver;
                this.$trace = $trace;
                this.$scope = $scope;
                this.$dataFlowInfo = $dataFlowInfo;
                this.$functionDescriptor = $functionDescriptor;
                this.$inferenceSession = $inferenceSession;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return AstLoadingFilter.forceAllowTreeLoading(((KtNamedFunction)this.$function).getContainingFile(), () -> getContractProvider.1.invoke$lambda$0(this.this$0, this.$trace, this.$scope, this.$dataFlowInfo, this.$function, this.$functionDescriptor, this.$inferenceSession));
            }

            private static final KotlinType invoke$lambda$0(FunctionDescriptorResolver this$0, BindingTrace $trace, LexicalScope $scope, DataFlowInfo $dataFlowInfo, KtFunction $function, SimpleFunctionDescriptorImpl $functionDescriptor, InferenceSession $inferenceSession) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$trace, (String)"$trace");
                Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
                Intrinsics.checkNotNullParameter((Object)$dataFlowInfo, (String)"$dataFlowInfo");
                Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
                Intrinsics.checkNotNullParameter((Object)$functionDescriptor, (String)"$functionDescriptor");
                return FunctionDescriptorResolver.access$getExpressionTypingServices$p(this$0).getBodyExpressionType($trace, $scope, $dataFlowInfo, $function, $functionDescriptor, $inferenceSession);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType, InferenceSession inferenceSession) {
        List expectedParameterTypes;
        List list2;
        List<ValueParameterDescriptor> expectedValueParameters;
        List<ValueParameterDescriptor> list3 = expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                collection.add(this.removeParameterNameAnnotation(kotlinType));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = expectedParameterTypes = null;
        }
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function2 instanceof KtFunctionLiteral && function2.getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.single(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                Name name = Name.identifier("it");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"it\")");
                List list4 = expectedParameterTypes;
                Intrinsics.checkNotNull((Object)list4);
                KotlinType kotlinType = (KotlinType)CollectionsKt.single((List)list4);
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf((Object)it);
            }
            if (function2.getValueParameters().size() != expectedValueParameters.size()) {
                PsiElement psiElement = function2;
                List list5 = expectedParameterTypes;
                Intrinsics.checkNotNull(list5);
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)psiElement, list5.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function2.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<KtParameter> list6 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list6, (String)"function.valueParameters");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list6, trace, expectedParameterTypes, inferenceSession);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeParameterNameAnnotation(KotlinType $this$removeParameterNameAnnotation) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if ($this$removeParameterNameAnnotation instanceof TypeUtils.SpecialType) {
            return $this$removeParameterNameAnnotation;
        }
        AnnotationDescriptor annotationDescriptor = $this$removeParameterNameAnnotation.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
        if (annotationDescriptor == null) {
            return $this$removeParameterNameAnnotation;
        }
        AnnotationDescriptor parameterNameAnnotation = annotationDescriptor;
        Iterable iterable = $this$removeParameterNameAnnotation.getAnnotations();
        Annotations.Companion companion = Annotations.Companion;
        KotlinType kotlinType = $this$removeParameterNameAnnotation;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)parameterNameAnnotation))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return TypeUtilsKt.replaceAnnotations(kotlinType, companion.create(list2));
    }

    private final boolean functionTypeExpected(KotlinType $this$functionTypeExpected) {
        return !TypeUtils.noExpectedType($this$functionTypeExpected) && FunctionTypesKt.isBuiltinFunctionalType($this$functionTypeExpected);
    }

    private final KotlinType getReceiverType(KotlinType $this$getReceiverType) {
        return this.functionTypeExpected($this$getReceiverType) ? FunctionTypesKt.getReceiverTypeFromFunctionType($this$getReceiverType) : null;
    }

    private final List<KotlinType> getContextReceiversTypes(KotlinType $this$getContextReceiversTypes) {
        return this.functionTypeExpected($this$getContextReceiversTypes) ? FunctionTypesKt.getContextReceiverTypesFromFunctionType($this$getContextReceiversTypes) : CollectionsKt.emptyList();
    }

    private final List<ValueParameterDescriptor> getValueParameters(KotlinType $this$getValueParameters, FunctionDescriptor owner) {
        return this.functionTypeExpected($this$getValueParameters) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($this$getValueParameters)) : null;
    }

    @Nullable
    public final ClassConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor2, @NotNull KtPureClassOrObject classElement, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (classDescriptor2.getKind() == ClassKind.ENUM_ENTRY || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtModifierList ktModifierList = classElement.getPrimaryConstructorModifierList();
        KtPrimaryConstructor ktPrimaryConstructor = classElement.getPrimaryConstructor();
        KtPureElement ktPureElement = ktPrimaryConstructor == null ? (KtPureElement)classElement : (KtPureElement)ktPrimaryConstructor;
        List<KtParameter> list2 = classElement.getPrimaryConstructorParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classElement.primaryConstructorParameters");
        return this.createConstructorDescriptor(scope2, classDescriptor2, true, ktModifierList, ktPureElement, list2, trace, languageVersionSettings, inferenceSession);
    }

    @NotNull
    public final ClassConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor2, @NotNull KtSecondaryConstructor constructor2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        return this.createConstructorDescriptor(scope2, classDescriptor2, false, constructor2.getModifierList(), constructor2, constructor2.getValueParameters(), trace, languageVersionSettings, inferenceSession);
    }

    private final ClassConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope2, ClassDescriptor classDescriptor2, boolean isPrimary, KtModifierList modifierList2, KtPureElement declarationToTrace, List<? extends KtParameter> valueParameters2, BindingTrace trace, LanguageVersionSettings languageVersionSettings, InferenceSession inferenceSession) {
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create(classDescriptor2, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList2, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptorImpl, (String)"create(\n            clas\u2026SourceElement()\n        )");
        ClassConstructorDescriptorImpl constructorDescriptor = classConstructorDescriptorImpl;
        constructorDescriptor.setExpect(classDescriptor2.isExpect());
        KtModifierList ktModifierList = modifierList2;
        constructorDescriptor.setActual((ktModifierList != null ? PsiUtilsKt.hasActualModifier(ktModifierList) : false) || classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS && classDescriptor2.isActual());
        if (declarationToTrace instanceof PsiElement) {
            trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        }
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope2, constructorDescriptor, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.CONSTRUCTOR_HEADER);
        ClassConstructorDescriptorImpl constructor2 = constructorDescriptor.initialize(this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters2, trace, null, inferenceSession), ModifiersChecker.resolveVisibilityFromModifiers(modifierList2, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor2, languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage))));
        constructor2.setReturnType(classDescriptor2.getDefaultType());
        if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters2, trace);
        }
        Intrinsics.checkNotNullExpressionValue((Object)constructor2, (String)"constructor");
        return constructor2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters, BindingTrace trace, List<? extends KotlinType> expectedParameterTypes, InferenceSession inferenceSession) {
        result = new ArrayList<ValueParameterDescriptorImpl>();
        var9_9 = valueParameters.size();
        for (i = 0; i < var9_9; ++i) {
            valueParameter = valueParameters.get(i);
            typeReference = valueParameter.getTypeReference();
            v0 = expectedParameterTypes;
            if (expectedParameterTypes == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-FunctionDescriptorResolver$resolveValueParameters$expectedType$1 = false;
            v1 = i < it.size() ? it.get(i) : null;
            v0 = v1;
            if (v1 != null) {
                it = var14_14 = v0;
                $i$a$-takeUnless-FunctionDescriptorResolver$resolveValueParameters$expectedType$2 = false;
                v2 /* !! */  = !TypeUtils.noExpectedType(it) ? var14_14 : null;
            } else lbl-1000:
            // 2 sources

            {
                v2 /* !! */  = null;
            }
            expectedType = v2 /* !! */ ;
            type = null;
            if (typeReference != null) {
                type = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                if (expectedType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf((KotlinType)expectedType, (KotlinType)type)) {
                    trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter), (KotlinType)expectedType));
                }
            } else if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                containsErrorType = TypeUtils.contains(expectedType, (Function1<UnwrappedType, Boolean>)((Function1)resolveValueParameters.containsErrorType.1.INSTANCE));
                if (expectedType == null || containsErrorType) {
                    trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter)));
                }
                v3 /* !! */  = expectedType;
                if (expectedType == null) {
                    v3 /* !! */  = TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE;
                }
                v4 /* !! */  = v3 /* !! */ ;
                Intrinsics.checkNotNullExpressionValue((Object)v3 /* !! */ , (String)"{\n                    va\u2026AM_TYPE\n                }");
            } else {
                trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter)));
                var14_14 = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)valueParameter.getNameAsSafeName().toString(), (String)"valueParameter.nameAsSafeName.toString()");
                v4 /* !! */  = type = (KotlinType)ErrorUtils.createErrorType(ErrorTypeKind.MISSED_TYPE_FOR_PARAMETER, var14_14);
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                $this$resolveValueParameters_u24lambda_u2416 = this.modifiersChecker.withTrace(trace);
                $i$a$-with-FunctionDescriptorResolver$resolveValueParameters$1 = false;
                $this$resolveValueParameters_u24lambda_u2416.checkParameterHasNoValOrVar(valueParameter, isConstructor != false ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, i, (KotlinType)type, trace, Annotations.Companion.getEMPTY(), inferenceSession), (String)"descriptorResolver.resol\u2026enceSession\n            )");
            ExpressionTypingUtils.checkVariableShadowing(parameterScope, trace, valueParameterDescriptor);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result.add(valueParameterDescriptor);
        }
        return result;
    }

    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$p(FunctionDescriptorResolver $this) {
        return $this.expressionTypingServices;
    }
}

