/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandlerBase;
import org.jetbrains.kotlin.com.intellij.util.io.FileAccessorCache;
import org.jetbrains.kotlin.com.intellij.util.io.ResourceHandle;

public class ZipHandler
extends ZipHandlerBase {
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @Override
        @NotNull
        protected ZipFile createAccessor(ZipHandler handler2) throws IOException {
            File file2 = handler2.getFile();
            BasicFileAttributes attrs = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            handler2.myFileStamp = attrs.lastModifiedTime().toMillis();
            handler2.myFileLength = attrs.size();
            return new ZipFile(file2);
        }

        @Override
        protected void disposeAccessor(@NotNull ZipFile fileAccessor) throws IOException {
            if (fileAccessor == null) {
                1.$$$reportNull$$$0(0);
            }
            fileAccessor.close();
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler$1", "disposeAccessor"));
        }
    };
    private volatile long myFileStamp;
    private volatile long myFileLength;

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            ZipHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        FileAccessorCache.Handle<ZipFile> handle2;
        try {
            FileAccessorCache.Handle<ZipFile> handle3 = ourZipFileFileAccessorCache.get(this);
            File file2 = this.getFile();
            BasicFileAttributes attrs = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (attrs.lastModifiedTime().toMillis() != this.myFileStamp || attrs.size() != this.myFileLength) {
                this.clearCaches();
                handle3.release();
                handle3 = ourZipFileFileAccessorCache.get(this);
            }
            handle2 = handle3;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        if (handle2 == null) {
            ZipHandler.$$$reportNull$$$0(1);
        }
        return handle2;
    }

    @Override
    public void clearCaches() {
        ourZipFileFileAccessorCache.remove(this);
        super.clearCaches();
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myFileStamp;
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

