/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.resolve.calls.smartcasts

import org.jetbrains.kotlin.psi.Call
import org.jetbrains.kotlin.types.KotlinType

interface ExplicitSmartCasts {
    fun type(call: Call?): KotlinType?

    val defaultType: KotlinType?

    operator fun plus(smartCast: SingleSmartCast): ExplicitSmartCasts
}

data class SingleSmartCast(val call: Call?, val type: KotlinType) : ExplicitSmartCasts {
    override fun type(call: Call?) = if (call == this.call) type else null

    override val defaultType: KotlinType get() = type

    override fun plus(smartCast: SingleSmartCast) =
        if (this == smartCast) this
        else MultipleSmartCasts(mapOf(call to type, smartCast.call to smartCast.type))
}

// todo: replace suppress with @ConsistentCopyVisibility annotation after bootstrap
@Suppress("DATA_CLASS_COPY_VISIBILITY_WILL_BE_CHANGED_WARNING")
data class MultipleSmartCasts internal constructor(val map: Map<Call?, KotlinType>) : ExplicitSmartCasts {
    override fun type(call: Call?) = map[call]

    override val defaultType: KotlinType? get() = null

    override fun plus(smartCast: SingleSmartCast) = MultipleSmartCasts(map + mapOf(smartCast.call to smartCast.type))
}