/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\n*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0014\u001a\u00020\n*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\n*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "closureBuilders", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "getFunctionClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getClassClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getClosure", "includeInParent", "", "builder", "closureBuilder", "getClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "collectPotentiallyCapturedTypeParameters", "parentClosureBuilder", "getParentClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilderOrNull", "getClosureBuilderOrNull", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1#2:340\n381#3,3:341\n384#3,4:348\n381#3,3:352\n384#3,4:357\n295#4,2:344\n1863#4,2:346\n1863#4,2:355\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n*L\n173#1:341,3\n173#1:348,4\n198#1:352,3\n198#1:357,4\n189#1:344,2\n191#1:346,2\n203#1:355,2\n*E\n"})
public final class ClosureAnnotator {
    @NotNull
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.closureBuilders = new LinkedHashMap();
        IrElementVisitor irElementVisitor = new ClosureCollectorVisitor();
        ClosureBuilder closureBuilder = this.getClosureBuilderOrNull(declaration);
        if (closureBuilder == null) {
            closureBuilder = this.getParentClosureBuilder(declaration);
        }
        irElement.accept(irElementVisitor, closureBuilder);
    }

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getClosure(declaration);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getClosure(declaration);
    }

    private final Closure getClosure(IrDeclaration declaration) {
        ClosureBuilder closureBuilder = this.closureBuilders.get(declaration);
        if (closureBuilder == null) {
            boolean bl = false;
            throw new AssertionError((Object)("No closure builder for passed declaration " + IrUtilsKt.ir2string(declaration) + '.'));
        }
        return closureBuilder.buildClosure();
    }

    private final void includeInParent(ClosureBuilder builder) {
        ClosureBuilder parentBuilder = this.getParentClosureBuilder(builder.getOwner());
        if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
            parentBuilder.include(builder);
        }
    }

    private final ClosureBuilder getClosureBuilder(IrClass $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            Object v1;
            ClosureBuilder closureBuilder2;
            block10: {
                boolean bl = false;
                closureBuilder2 = new ClosureBuilder($this$closureBuilder);
                this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
                closureBuilder2.declareVariable($this$closureBuilder.getThisReceiver());
                if ($this$closureBuilder.isInner()) {
                    IrValueParameter irValueParameter;
                    IrDeclarationParent parent2 = $this$closureBuilder.getParent();
                    if (parent2 instanceof IrClass) {
                        irValueParameter = ((IrClass)parent2).getThisReceiver();
                    } else if (parent2 instanceof IrScript) {
                        irValueParameter = ((IrScript)parent2).getThisReceiver();
                    } else {
                        throw new IllegalStateException(("unexpected parent " + parent2).toString());
                    }
                    IrValueParameter receiver = irValueParameter;
                    closureBuilder2.declareVariable(receiver);
                    this.includeInParent(closureBuilder2);
                }
                Iterable $this$firstOrNull$iv = $this$closureBuilder.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            IrDeclaration irDeclaration2 = v1;
            if (irDeclaration2 != null) {
                IrDeclaration it = irDeclaration2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                IrConstructor constructor2 = (IrConstructor)it;
                Iterable $this$forEach$iv = constructor2.getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter v = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    closureBuilder2.declareVariable(v);
                }
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final ClosureBuilder getClosureBuilder(IrFunction $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            boolean bl = false;
            ClosureBuilder closureBuilder2 = new ClosureBuilder($this$closureBuilder);
            this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
            Iterable $this$forEach$iv = $this$closureBuilder.getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                closureBuilder2.declareVariable(it);
            }
            closureBuilder2.declareVariable($this$closureBuilder.getDispatchReceiverParameter());
            closureBuilder2.declareVariable($this$closureBuilder.getExtensionReceiverParameter());
            closureBuilder2.seeType($this$closureBuilder.getReturnType());
            if ($this$closureBuilder instanceof IrConstructor) {
                IrDeclarationParent irDeclarationParent = $this$closureBuilder.getParent();
                Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                IrClass constructedClass = (IrClass)irDeclarationParent;
                closureBuilder2.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder classBuilder = this.getClosureBuilder(constructedClass);
                closureBuilder2.include(classBuilder);
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final void collectPotentiallyCapturedTypeParameters(ClosureBuilder closureBuilder) {
        ClosureBuilder current = this.getParentClosureBuilder(closureBuilder.getOwner());
        while (current != null) {
            IrDeclaration container = current.getOwner();
            if (container instanceof IrTypeParametersContainer) {
                for (IrTypeParameter typeParameter : ((IrTypeParametersContainer)container).getTypeParameters()) {
                    closureBuilder.addPotentiallyCapturedTypeParameter(typeParameter);
                }
            }
            current = this.getParentClosureBuilder(container);
        }
    }

    private final ClosureBuilder getParentClosureBuilder(IrDeclaration $this$parentClosureBuilder) {
        IrDeclarationParent p = $this$parentClosureBuilder.getParent();
        return p instanceof IrClass ? this.getClosureBuilder((IrClass)p) : (p instanceof IrFunction ? this.getClosureBuilder((IrFunction)p) : (p instanceof IrDeclaration ? this.getParentClosureBuilder((IrDeclaration)((Object)p)) : null));
    }

    private final ClosureBuilder getClosureBuilderOrNull(IrDeclaration $this$closureBuilderOrNull) {
        IrDeclaration irDeclaration2 = $this$closureBuilderOrNull;
        return irDeclaration2 instanceof IrClass ? this.getClosureBuilder((IrClass)$this$closureBuilderOrNull) : (irDeclaration2 instanceof IrFunction ? this.getClosureBuilder((IrFunction)$this$closureBuilderOrNull) : null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "capturedValues", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "declaredValues", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "potentiallyCapturedTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "capturedTypeParameters", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "buildClosure", "collectConnectedClosures", "", "updateFromIncluded", "", "include", "", "includingBuilder", "declareVariable", "valueDeclaration", "seeVariable", "value", "isExternal", "typeParameter", "addPotentiallyCapturedTypeParameter", "param", "seeType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1#2:340\n865#3,2:341\n865#3,2:343\n1863#3,2:345\n1863#3,2:347\n1863#3,2:349\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n*L\n111#1:341,2\n112#1:343,2\n153#1:345,2\n154#1:347,2\n157#1:349,2\n*E\n"})
    private static final class ClosureBuilder {
        @NotNull
        private final IrDeclaration owner;
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        @NotNull
        private final Set<IrValueDeclaration> declaredValues;
        @NotNull
        private final Set<ClosureBuilder> includes;
        @NotNull
        private final Set<IrTypeParameter> potentiallyCapturedTypeParameters;
        @NotNull
        private final Set<IrTypeParameter> capturedTypeParameters;
        @Nullable
        private Closure closure;

        public ClosureBuilder(@NotNull IrDeclaration owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
            this.capturedValues = new LinkedHashSet();
            this.declaredValues = new LinkedHashSet();
            this.includes = new LinkedHashSet();
            this.potentiallyCapturedTypeParameters = new LinkedHashSet();
            this.capturedTypeParameters = new LinkedHashSet();
        }

        @NotNull
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        @NotNull
        public final Closure buildClosure() {
            boolean changes;
            Closure closure = this.closure;
            if (closure != null) {
                Closure it = closure;
                boolean bl = false;
                return it;
            }
            List<ClosureBuilder> work = this.collectConnectedClosures();
            do {
                changes = false;
                for (ClosureBuilder c : work) {
                    if (!c.updateFromIncluded()) continue;
                    changes = true;
                }
            } while (changes);
            for (ClosureBuilder c : work) {
                c.closure = new Closure(CollectionsKt.toList((Iterable)c.capturedValues), CollectionsKt.toList((Iterable)c.capturedTypeParameters));
            }
            Closure closure2 = this.closure;
            if (closure2 == null) {
                throw new AssertionError((Object)("Closure should have been built for " + RenderIrElementKt.render$default(this.owner, null, 1, null)));
            }
            return closure2;
        }

        private final List<ClosureBuilder> collectConnectedClosures() {
            LinkedHashSet<ClosureBuilder> connected = new LinkedHashSet<ClosureBuilder>();
            connected.add(this);
            ClosureBuilder.collectConnectedClosures$collectRec(connected, this);
            return CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)connected));
        }

        private final boolean updateFromIncluded() {
            if (this.closure != null) {
                throw new AssertionError((Object)("Closure has already been built for " + RenderIrElementKt.render$default(this.owner, null, 1, null)));
            }
            int capturedValuesBefore = this.capturedValues.size();
            int capturedTypeParametersBefore = this.capturedTypeParameters.size();
            for (ClosureBuilder subClosure : this.includes) {
                Object it;
                Iterable $this$filterTo$iv;
                Iterable iterable = subClosure.capturedValues;
                Collection destination$iv = this.capturedValues;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrValueSymbol)element$iv;
                    boolean bl = false;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterTo$iv = subClosure.capturedTypeParameters;
                destination$iv = this.capturedTypeParameters;
                $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    if (!this.isExternal((IrTypeParameter)it)) continue;
                    destination$iv.add(element$iv);
                }
            }
            return this.capturedValues.size() != capturedValuesBefore || this.capturedTypeParameters.size() != capturedTypeParametersBefore;
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkNotNullParameter((Object)includingBuilder, (String)"includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
                this.seeType(valueDeclaration.getType());
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (this.isExternal(value2.getOwner())) {
                this.capturedValues.add(value2);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        public final boolean isExternal(@NotNull IrTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            return this.potentiallyCapturedTypeParameters.contains(typeParameter);
        }

        public final void addPotentiallyCapturedTypeParameter(@NotNull IrTypeParameter param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.potentiallyCapturedTypeParameters.add(param);
        }

        public final void seeType(@NotNull IrType type2) {
            block5: {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                if (!(type2 instanceof IrSimpleType)) {
                    return;
                }
                IrClassifierSymbol classifier = ((IrSimpleType)type2).getClassifier();
                if (classifier instanceof IrTypeParameterSymbol && this.isExternal((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()) && this.capturedTypeParameters.add((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner())) {
                    $this$forEach$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrType p0 = (IrType)element$iv;
                        boolean bl = false;
                        this.seeType(p0);
                    }
                }
                $this$forEach$iv = ((IrSimpleType)type2).getArguments();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    Object object = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (object == null || (object = object.getType()) == null) continue;
                    Object p0 = object;
                    boolean bl2 = false;
                    this.seeType((IrType)p0);
                }
                Object object = ((IrSimpleType)type2).getAbbreviation();
                if (object == null || (object = object.getArguments()) == null) break block5;
                Iterable $this$forEach$iv2 = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    Object object2 = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (object2 == null || (object2 = object2.getType()) == null) continue;
                    Object p0 = object2;
                    boolean bl3 = false;
                    this.seeType((IrType)p0);
                }
            }
        }

        private static final void collectConnectedClosures$collectRec(LinkedHashSet<ClosureBuilder> connected, ClosureBuilder current) {
            for (ClosureBuilder included : current.includes) {
                if (included.closure != null || !connected.add(included)) continue;
                ClosureBuilder.collectConnectedClosures$collectRec(connected, included);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00192\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001f2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010 \u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000b\u001a\u00020\"2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010#\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "visitValueAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "processScriptCapturing", "receiverExpression", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "processMemberAccess", "parentClosure", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
    private final class ClosureCollectorVisitor
    implements IrElementVisitor<Unit, ClosureBuilder> {
        @Override
        public void visitElement(@NotNull IrElement element, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.acceptChildren(this, ClosureAnnotator.this.getClosureBuilder(declaration));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            ClosureBuilder closureBuilder = ClosureAnnotator.this.getClosureBuilder(declaration);
            declaration.acceptChildren(this, closureBuilder);
            ClosureAnnotator.this.includeInParent(closureBuilder);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            for (IrType superType : declaration.getSuperTypes()) {
                ClosureBuilder closureBuilder = data;
                if (closureBuilder == null) continue;
                closureBuilder.seeType(superType);
            }
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.seeVariable(expression2.getSymbol());
            }
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.declareVariable(declaration);
            }
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
            this.processScriptCapturing(expression2.getDispatchReceiver(), ((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
            this.processMemberAccess(expression2.getFunction(), data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable ClosureBuilder data) {
            block1: {
                IrSimpleFunctionSymbol it;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
                if (irSimpleFunctionSymbol != null) {
                    it = irSimpleFunctionSymbol;
                    boolean bl = false;
                    this.processMemberAccess((IrDeclaration)it.getOwner(), data);
                }
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
                if (irSimpleFunctionSymbol2 == null) break block1;
                it = irSimpleFunctionSymbol2;
                boolean bl = false;
                this.processMemberAccess((IrDeclaration)it.getOwner(), data);
            }
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable ClosureBuilder data) {
            block3: {
                ClosureBuilder typeParameterContainerScopeBuilder;
                Object object;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
                ClosureBuilder closureBuilder = data;
                if (closureBuilder != null) {
                    ClosureBuilder closureBuilder2 = closureBuilder;
                    ClosureAnnotator closureAnnotator = ClosureAnnotator.this;
                    ClosureBuilder it = closureBuilder2;
                    boolean bl = false;
                    IrDeclaration irDeclaration2 = it.getOwner();
                    object = irDeclaration2 instanceof IrConstructor ? (IrConstructor)irDeclaration2 : null;
                    if (object == null || (object = closureAnnotator.getClosureBuilder((IrFunction)object)) == null) {
                        object = it;
                    }
                } else {
                    object = null;
                }
                ClosureBuilder closureBuilder3 = typeParameterContainerScopeBuilder = object;
                if (closureBuilder3 == null) break block3;
                closureBuilder3.seeType(expression2.getType());
            }
        }

        private final void processScriptCapturing(IrExpression receiverExpression, IrDeclaration declaration, ClosureBuilder data) {
            block1: {
                IrDeclarationParent parent2;
                block2: {
                    if (receiverExpression != null) break block1;
                    parent2 = declaration.getParent();
                    if (!(parent2 instanceof IrScript)) break block2;
                    ClosureBuilder closureBuilder = data;
                    if (closureBuilder == null) break block1;
                    IrValueParameter irValueParameter = ((IrScript)parent2).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    closureBuilder.seeVariable(irValueParameter.getSymbol());
                    break block1;
                }
                if (!(parent2 instanceof IrClass) || !Intrinsics.areEqual((Object)((IrClass)parent2).getOrigin(), (Object)IrDeclarationOrigin.Companion.getSCRIPT_CLASS())) break block1;
                ClosureBuilder closureBuilder = data;
                if (closureBuilder != null) {
                    IrValueParameter irValueParameter = ((IrClass)parent2).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    closureBuilder.seeVariable(irValueParameter.getSymbol());
                }
            }
        }

        private final void processMemberAccess(IrDeclaration declaration, ClosureBuilder parentClosure) {
            block3: {
                ClosureBuilder builder;
                if (!AdditionalIrUtilsKt.isLocal(declaration)) break block3;
                if (declaration instanceof IrSimpleFunction && !Intrinsics.areEqual((Object)((IrSimpleFunction)declaration).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                    return;
                }
                ClosureBuilder closureBuilder = builder = ClosureAnnotator.this.getClosureBuilderOrNull(declaration);
                if (closureBuilder != null) {
                    ClosureBuilder it = closureBuilder;
                    boolean bl = false;
                    ClosureBuilder closureBuilder2 = parentClosure;
                    if (closureBuilder2 != null) {
                        closureBuilder2.include(builder);
                    }
                }
            }
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitReturnableBlock(this, expression2, data);
        }

        @Override
        public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitConst(@NotNull IrConst<?> expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
        }
    }
}

