/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

@file:Suppress("DEPRECATION", "DEPRECATION_ERROR", "UNCHECKED_CAST", "REDUNDANT_CALL_OF_CONVERSION_METHOD")

package org.jetbrains.kotlin.ir.interpreter.builtins

import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterMethodNotFoundError
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy

/** This file is generated by `./gradlew generateInterpreterMap`. DO NOT MODIFY MANUALLY */

internal fun interpretUnaryFunction(name: String, type: String, a: Any?): Any? {
    when (name) {
        "hashCode" -> when (type) {
            "kotlin.Boolean" -> return (a as Boolean).hashCode()
            "kotlin.Char" -> return (a as Char).hashCode()
            "kotlin.Byte" -> return (a as Byte).hashCode()
            "kotlin.Short" -> return (a as Short).hashCode()
            "kotlin.Int" -> return (a as Int).hashCode()
            "kotlin.Float" -> return (a as Float).hashCode()
            "kotlin.Long" -> return (a as Long).hashCode()
            "kotlin.Double" -> return (a as Double).hashCode()
            "kotlin.String" -> return (a as String).hashCode()
            "kotlin.Any" -> return (a as Any).hashCode()
        }
        "not" -> when (type) {
            "kotlin.Boolean" -> return (a as Boolean).not()
        }
        "toString" -> when (type) {
            "kotlin.Boolean" -> return (a as Boolean).toString()
            "kotlin.Char" -> return (a as Char).toString()
            "kotlin.Byte" -> return (a as Byte).toString()
            "kotlin.Short" -> return (a as Short).toString()
            "kotlin.Int" -> return (a as Int).toString()
            "kotlin.Float" -> return (a as Float).toString()
            "kotlin.Long" -> return (a as Long).toString()
            "kotlin.Double" -> return (a as Double).toString()
            "kotlin.UByte" -> return (a as UByte).toString()
            "kotlin.UShort" -> return (a as UShort).toString()
            "kotlin.UInt" -> return (a as UInt).toString()
            "kotlin.ULong" -> return (a as ULong).toString()
            "kotlin.String" -> return (a as String).toString()
            "kotlin.Any" -> return (a as Any).toString()
            "kotlin.Any?" -> return a?.toString() ?: "null"
            "kotlin.Unit" -> return Unit.toString()
        }
        "dec" -> when (type) {
            "kotlin.Char" -> return (a as Char).dec()
            "kotlin.Byte" -> return (a as Byte).dec()
            "kotlin.Short" -> return (a as Short).dec()
            "kotlin.Int" -> return (a as Int).dec()
            "kotlin.Float" -> return (a as Float).dec()
            "kotlin.Long" -> return (a as Long).dec()
            "kotlin.Double" -> return (a as Double).dec()
        }
        "inc" -> when (type) {
            "kotlin.Char" -> return (a as Char).inc()
            "kotlin.Byte" -> return (a as Byte).inc()
            "kotlin.Short" -> return (a as Short).inc()
            "kotlin.Int" -> return (a as Int).inc()
            "kotlin.Float" -> return (a as Float).inc()
            "kotlin.Long" -> return (a as Long).inc()
            "kotlin.Double" -> return (a as Double).inc()
        }
        "toByte" -> when (type) {
            "kotlin.Char" -> return (a as Char).toByte()
            "kotlin.Byte" -> return (a as Byte).toByte()
            "kotlin.Short" -> return (a as Short).toByte()
            "kotlin.Int" -> return (a as Int).toByte()
            "kotlin.Float" -> return (a as Float).toByte()
            "kotlin.Long" -> return (a as Long).toByte()
            "kotlin.Double" -> return (a as Double).toByte()
            "kotlin.Number" -> return (a as Number).toByte()
            "kotlin.UByte" -> return (a as UByte).toByte()
            "kotlin.UShort" -> return (a as UShort).toByte()
            "kotlin.UInt" -> return (a as UInt).toByte()
            "kotlin.ULong" -> return (a as ULong).toByte()
        }
        "toChar" -> when (type) {
            "kotlin.Char" -> return (a as Char).toChar()
            "kotlin.Byte" -> return (a as Byte).toChar()
            "kotlin.Short" -> return (a as Short).toChar()
            "kotlin.Int" -> return (a as Int).toChar()
            "kotlin.Float" -> return (a as Float).toChar()
            "kotlin.Long" -> return (a as Long).toChar()
            "kotlin.Double" -> return (a as Double).toChar()
            "kotlin.Number" -> return (a as Number).toChar()
        }
        "toDouble" -> when (type) {
            "kotlin.Char" -> return (a as Char).toDouble()
            "kotlin.Byte" -> return (a as Byte).toDouble()
            "kotlin.Short" -> return (a as Short).toDouble()
            "kotlin.Int" -> return (a as Int).toDouble()
            "kotlin.Float" -> return (a as Float).toDouble()
            "kotlin.Long" -> return (a as Long).toDouble()
            "kotlin.Double" -> return (a as Double).toDouble()
            "kotlin.Number" -> return (a as Number).toDouble()
            "kotlin.UByte" -> return (a as UByte).toDouble()
            "kotlin.UShort" -> return (a as UShort).toDouble()
            "kotlin.UInt" -> return (a as UInt).toDouble()
            "kotlin.ULong" -> return (a as ULong).toDouble()
        }
        "toFloat" -> when (type) {
            "kotlin.Char" -> return (a as Char).toFloat()
            "kotlin.Byte" -> return (a as Byte).toFloat()
            "kotlin.Short" -> return (a as Short).toFloat()
            "kotlin.Int" -> return (a as Int).toFloat()
            "kotlin.Float" -> return (a as Float).toFloat()
            "kotlin.Long" -> return (a as Long).toFloat()
            "kotlin.Double" -> return (a as Double).toFloat()
            "kotlin.Number" -> return (a as Number).toFloat()
            "kotlin.UByte" -> return (a as UByte).toFloat()
            "kotlin.UShort" -> return (a as UShort).toFloat()
            "kotlin.UInt" -> return (a as UInt).toFloat()
            "kotlin.ULong" -> return (a as ULong).toFloat()
        }
        "toInt" -> when (type) {
            "kotlin.Char" -> return (a as Char).toInt()
            "kotlin.Byte" -> return (a as Byte).toInt()
            "kotlin.Short" -> return (a as Short).toInt()
            "kotlin.Int" -> return (a as Int).toInt()
            "kotlin.Float" -> return (a as Float).toInt()
            "kotlin.Long" -> return (a as Long).toInt()
            "kotlin.Double" -> return (a as Double).toInt()
            "kotlin.Number" -> return (a as Number).toInt()
            "kotlin.UByte" -> return (a as UByte).toInt()
            "kotlin.UShort" -> return (a as UShort).toInt()
            "kotlin.UInt" -> return (a as UInt).toInt()
            "kotlin.ULong" -> return (a as ULong).toInt()
        }
        "toLong" -> when (type) {
            "kotlin.Char" -> return (a as Char).toLong()
            "kotlin.Byte" -> return (a as Byte).toLong()
            "kotlin.Short" -> return (a as Short).toLong()
            "kotlin.Int" -> return (a as Int).toLong()
            "kotlin.Float" -> return (a as Float).toLong()
            "kotlin.Long" -> return (a as Long).toLong()
            "kotlin.Double" -> return (a as Double).toLong()
            "kotlin.Number" -> return (a as Number).toLong()
            "kotlin.UByte" -> return (a as UByte).toLong()
            "kotlin.UShort" -> return (a as UShort).toLong()
            "kotlin.UInt" -> return (a as UInt).toLong()
            "kotlin.ULong" -> return (a as ULong).toLong()
        }
        "toShort" -> when (type) {
            "kotlin.Char" -> return (a as Char).toShort()
            "kotlin.Byte" -> return (a as Byte).toShort()
            "kotlin.Short" -> return (a as Short).toShort()
            "kotlin.Int" -> return (a as Int).toShort()
            "kotlin.Float" -> return (a as Float).toShort()
            "kotlin.Long" -> return (a as Long).toShort()
            "kotlin.Double" -> return (a as Double).toShort()
            "kotlin.Number" -> return (a as Number).toShort()
            "kotlin.UByte" -> return (a as UByte).toShort()
            "kotlin.UShort" -> return (a as UShort).toShort()
            "kotlin.UInt" -> return (a as UInt).toShort()
            "kotlin.ULong" -> return (a as ULong).toShort()
        }
        "unaryMinus" -> when (type) {
            "kotlin.Byte" -> return (a as Byte).unaryMinus()
            "kotlin.Short" -> return (a as Short).unaryMinus()
            "kotlin.Int" -> return (a as Int).unaryMinus()
            "kotlin.Float" -> return (a as Float).unaryMinus()
            "kotlin.Long" -> return (a as Long).unaryMinus()
            "kotlin.Double" -> return (a as Double).unaryMinus()
        }
        "unaryPlus" -> when (type) {
            "kotlin.Byte" -> return (a as Byte).unaryPlus()
            "kotlin.Short" -> return (a as Short).unaryPlus()
            "kotlin.Int" -> return (a as Int).unaryPlus()
            "kotlin.Float" -> return (a as Float).unaryPlus()
            "kotlin.Long" -> return (a as Long).unaryPlus()
            "kotlin.Double" -> return (a as Double).unaryPlus()
        }
        "inv" -> when (type) {
            "kotlin.Int" -> return (a as Int).inv()
            "kotlin.Long" -> return (a as Long).inv()
            "kotlin.UByte" -> return (a as UByte).inv()
            "kotlin.UShort" -> return (a as UShort).inv()
            "kotlin.UInt" -> return (a as UInt).inv()
            "kotlin.ULong" -> return (a as ULong).inv()
        }
        "length" -> when (type) {
            "kotlin.String" -> return (a as String).length
            "kotlin.CharSequence" -> return (a as CharSequence).length
        }
        "cause" -> when (type) {
            "kotlin.Throwable" -> return (a as Throwable).cause
        }
        "message" -> when (type) {
            "kotlin.Throwable" -> return (a as Throwable).message
        }
        "size" -> when (type) {
            "kotlin.BooleanArray" -> return (a as BooleanArray).size
            "kotlin.CharArray" -> return (a as CharArray).size
            "kotlin.ByteArray" -> return (a as ByteArray).size
            "kotlin.ShortArray" -> return (a as ShortArray).size
            "kotlin.IntArray" -> return (a as IntArray).size
            "kotlin.FloatArray" -> return (a as FloatArray).size
            "kotlin.LongArray" -> return (a as LongArray).size
            "kotlin.DoubleArray" -> return (a as DoubleArray).size
            "kotlin.Array" -> return (a as Array<Any?>).size
        }
        "iterator" -> when (type) {
            "kotlin.BooleanArray" -> return (a as BooleanArray).iterator()
            "kotlin.CharArray" -> return (a as CharArray).iterator()
            "kotlin.ByteArray" -> return (a as ByteArray).iterator()
            "kotlin.ShortArray" -> return (a as ShortArray).iterator()
            "kotlin.IntArray" -> return (a as IntArray).iterator()
            "kotlin.FloatArray" -> return (a as FloatArray).iterator()
            "kotlin.LongArray" -> return (a as LongArray).iterator()
            "kotlin.DoubleArray" -> return (a as DoubleArray).iterator()
            "kotlin.Array" -> return (a as Array<Any?>).iterator()
        }
        "toUByte" -> when (type) {
            "kotlin.Byte" -> return (a as Byte).toUByte()
            "kotlin.Short" -> return (a as Short).toUByte()
            "kotlin.Int" -> return (a as Int).toUByte()
            "kotlin.Long" -> return (a as Long).toUByte()
            "kotlin.UByte" -> return (a as UByte).toUByte()
            "kotlin.UShort" -> return (a as UShort).toUByte()
            "kotlin.UInt" -> return (a as UInt).toUByte()
            "kotlin.ULong" -> return (a as ULong).toUByte()
        }
        "toUInt" -> when (type) {
            "kotlin.Byte" -> return (a as Byte).toUInt()
            "kotlin.Short" -> return (a as Short).toUInt()
            "kotlin.Int" -> return (a as Int).toUInt()
            "kotlin.Float" -> return (a as Float).toUInt()
            "kotlin.Long" -> return (a as Long).toUInt()
            "kotlin.Double" -> return (a as Double).toUInt()
            "kotlin.UByte" -> return (a as UByte).toUInt()
            "kotlin.UShort" -> return (a as UShort).toUInt()
            "kotlin.UInt" -> return (a as UInt).toUInt()
            "kotlin.ULong" -> return (a as ULong).toUInt()
        }
        "toULong" -> when (type) {
            "kotlin.Byte" -> return (a as Byte).toULong()
            "kotlin.Short" -> return (a as Short).toULong()
            "kotlin.Int" -> return (a as Int).toULong()
            "kotlin.Float" -> return (a as Float).toULong()
            "kotlin.Long" -> return (a as Long).toULong()
            "kotlin.Double" -> return (a as Double).toULong()
            "kotlin.UByte" -> return (a as UByte).toULong()
            "kotlin.UShort" -> return (a as UShort).toULong()
            "kotlin.UInt" -> return (a as UInt).toULong()
            "kotlin.ULong" -> return (a as ULong).toULong()
        }
        "toUShort" -> when (type) {
            "kotlin.Byte" -> return (a as Byte).toUShort()
            "kotlin.Short" -> return (a as Short).toUShort()
            "kotlin.Int" -> return (a as Int).toUShort()
            "kotlin.Long" -> return (a as Long).toUShort()
            "kotlin.UByte" -> return (a as UByte).toUShort()
            "kotlin.UShort" -> return (a as UShort).toUShort()
            "kotlin.UInt" -> return (a as UInt).toUShort()
            "kotlin.ULong" -> return (a as ULong).toUShort()
        }
        "CHECK_NOT_NULL" -> when (type) {
            "T0?" -> return a!!
        }
        "code" -> when (type) {
            "kotlin.Char" -> return (a as Char).code
        }
    }
    throw InterpreterMethodNotFoundError("Unknown function: $name($type)")
}

internal fun interpretBinaryFunction(name: String, typeA: String, typeB: String, a: Any?, b: Any?): Any? {
    when (name) {
        "and" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Boolean") return (a as Boolean).and(b as Boolean)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int).and(b as Int)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long).and(b as Long)
            "kotlin.UByte" -> if (typeB == "kotlin.UByte") return (a as UByte).and(b as UByte)
            "kotlin.UShort" -> if (typeB == "kotlin.UShort") return (a as UShort).and(b as UShort)
            "kotlin.UInt" -> if (typeB == "kotlin.UInt") return (a as UInt).and(b as UInt)
            "kotlin.ULong" -> if (typeB == "kotlin.ULong") return (a as ULong).and(b as ULong)
        }
        "compareTo" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Boolean") return (a as Boolean).compareTo(b as Boolean)
            "kotlin.Char" -> if (typeB == "kotlin.Char") return (a as Char).compareTo(b as Char)
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).compareTo(b as Byte)
                "kotlin.Short" -> return (a as Byte).compareTo(b as Short)
                "kotlin.Int" -> return (a as Byte).compareTo(b as Int)
                "kotlin.Long" -> return (a as Byte).compareTo(b as Long)
                "kotlin.Float" -> return (a as Byte).compareTo(b as Float)
                "kotlin.Double" -> return (a as Byte).compareTo(b as Double)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).compareTo(b as Byte)
                "kotlin.Short" -> return (a as Short).compareTo(b as Short)
                "kotlin.Int" -> return (a as Short).compareTo(b as Int)
                "kotlin.Long" -> return (a as Short).compareTo(b as Long)
                "kotlin.Float" -> return (a as Short).compareTo(b as Float)
                "kotlin.Double" -> return (a as Short).compareTo(b as Double)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).compareTo(b as Byte)
                "kotlin.Short" -> return (a as Int).compareTo(b as Short)
                "kotlin.Int" -> return (a as Int).compareTo(b as Int)
                "kotlin.Long" -> return (a as Int).compareTo(b as Long)
                "kotlin.Float" -> return (a as Int).compareTo(b as Float)
                "kotlin.Double" -> return (a as Int).compareTo(b as Double)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Byte" -> return (a as Float).compareTo(b as Byte)
                "kotlin.Short" -> return (a as Float).compareTo(b as Short)
                "kotlin.Int" -> return (a as Float).compareTo(b as Int)
                "kotlin.Long" -> return (a as Float).compareTo(b as Long)
                "kotlin.Float" -> return (a as Float).compareTo(b as Float)
                "kotlin.Double" -> return (a as Float).compareTo(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).compareTo(b as Byte)
                "kotlin.Short" -> return (a as Long).compareTo(b as Short)
                "kotlin.Int" -> return (a as Long).compareTo(b as Int)
                "kotlin.Long" -> return (a as Long).compareTo(b as Long)
                "kotlin.Float" -> return (a as Long).compareTo(b as Float)
                "kotlin.Double" -> return (a as Long).compareTo(b as Double)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Byte" -> return (a as Double).compareTo(b as Byte)
                "kotlin.Short" -> return (a as Double).compareTo(b as Short)
                "kotlin.Int" -> return (a as Double).compareTo(b as Int)
                "kotlin.Long" -> return (a as Double).compareTo(b as Long)
                "kotlin.Float" -> return (a as Double).compareTo(b as Float)
                "kotlin.Double" -> return (a as Double).compareTo(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).compareTo(b as UByte)
                "kotlin.UShort" -> return (a as UByte).compareTo(b as UShort)
                "kotlin.UInt" -> return (a as UByte).compareTo(b as UInt)
                "kotlin.ULong" -> return (a as UByte).compareTo(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).compareTo(b as UByte)
                "kotlin.UShort" -> return (a as UShort).compareTo(b as UShort)
                "kotlin.UInt" -> return (a as UShort).compareTo(b as UInt)
                "kotlin.ULong" -> return (a as UShort).compareTo(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).compareTo(b as UByte)
                "kotlin.UShort" -> return (a as UInt).compareTo(b as UShort)
                "kotlin.UInt" -> return (a as UInt).compareTo(b as UInt)
                "kotlin.ULong" -> return (a as UInt).compareTo(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).compareTo(b as UByte)
                "kotlin.UShort" -> return (a as ULong).compareTo(b as UShort)
                "kotlin.UInt" -> return (a as ULong).compareTo(b as UInt)
                "kotlin.ULong" -> return (a as ULong).compareTo(b as ULong)
            }
            "kotlin.String" -> if (typeB == "kotlin.String") return (a as String).compareTo(b as String)
            "kotlin.Comparable" -> if (typeB == "T") return (a as Comparable<Any?>).compareTo(b)
        }
        "equals" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Any?") return (a as Boolean).equals(b)
            "kotlin.Char" -> if (typeB == "kotlin.Any?") return (a as Char).equals(b)
            "kotlin.Byte" -> if (typeB == "kotlin.Any?") return (a as Byte).equals(b)
            "kotlin.Short" -> if (typeB == "kotlin.Any?") return (a as Short).equals(b)
            "kotlin.Int" -> if (typeB == "kotlin.Any?") return (a as Int).equals(b)
            "kotlin.Float" -> if (typeB == "kotlin.Any?") return (a as Float).equals(b)
            "kotlin.Long" -> if (typeB == "kotlin.Any?") return (a as Long).equals(b)
            "kotlin.Double" -> if (typeB == "kotlin.Any?") return (a as Double).equals(b)
            "kotlin.UByte" -> if (typeB == "kotlin.Any?") return (a as UByte).equals(b)
            "kotlin.UShort" -> if (typeB == "kotlin.Any?") return (a as UShort).equals(b)
            "kotlin.UInt" -> if (typeB == "kotlin.Any?") return (a as UInt).equals(b)
            "kotlin.ULong" -> if (typeB == "kotlin.Any?") return (a as ULong).equals(b)
            "kotlin.String" -> if (typeB == "kotlin.Any?") return (a as String).equals(b)
            "kotlin.Any" -> if (typeB == "kotlin.Any?") return (a as Any).equals(b)
        }
        "or" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Boolean") return (a as Boolean).or(b as Boolean)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int).or(b as Int)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long).or(b as Long)
            "kotlin.UByte" -> if (typeB == "kotlin.UByte") return (a as UByte).or(b as UByte)
            "kotlin.UShort" -> if (typeB == "kotlin.UShort") return (a as UShort).or(b as UShort)
            "kotlin.UInt" -> if (typeB == "kotlin.UInt") return (a as UInt).or(b as UInt)
            "kotlin.ULong" -> if (typeB == "kotlin.ULong") return (a as ULong).or(b as ULong)
        }
        "xor" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Boolean") return (a as Boolean).xor(b as Boolean)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int).xor(b as Int)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long).xor(b as Long)
            "kotlin.UByte" -> if (typeB == "kotlin.UByte") return (a as UByte).xor(b as UByte)
            "kotlin.UShort" -> if (typeB == "kotlin.UShort") return (a as UShort).xor(b as UShort)
            "kotlin.UInt" -> if (typeB == "kotlin.UInt") return (a as UInt).xor(b as UInt)
            "kotlin.ULong" -> if (typeB == "kotlin.ULong") return (a as ULong).xor(b as ULong)
        }
        "minus" -> when (typeA) {
            "kotlin.Char" -> when (typeB) {
                "kotlin.Char" -> return (a as Char).minus(b as Char)
                "kotlin.Int" -> return (a as Char).minus(b as Int)
            }
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).minus(b as Byte)
                "kotlin.Short" -> return (a as Byte).minus(b as Short)
                "kotlin.Int" -> return (a as Byte).minus(b as Int)
                "kotlin.Long" -> return (a as Byte).minus(b as Long)
                "kotlin.Float" -> return (a as Byte).minus(b as Float)
                "kotlin.Double" -> return (a as Byte).minus(b as Double)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).minus(b as Byte)
                "kotlin.Short" -> return (a as Short).minus(b as Short)
                "kotlin.Int" -> return (a as Short).minus(b as Int)
                "kotlin.Long" -> return (a as Short).minus(b as Long)
                "kotlin.Float" -> return (a as Short).minus(b as Float)
                "kotlin.Double" -> return (a as Short).minus(b as Double)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).minus(b as Byte)
                "kotlin.Short" -> return (a as Int).minus(b as Short)
                "kotlin.Int" -> return (a as Int).minus(b as Int)
                "kotlin.Long" -> return (a as Int).minus(b as Long)
                "kotlin.Float" -> return (a as Int).minus(b as Float)
                "kotlin.Double" -> return (a as Int).minus(b as Double)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Byte" -> return (a as Float).minus(b as Byte)
                "kotlin.Short" -> return (a as Float).minus(b as Short)
                "kotlin.Int" -> return (a as Float).minus(b as Int)
                "kotlin.Long" -> return (a as Float).minus(b as Long)
                "kotlin.Float" -> return (a as Float).minus(b as Float)
                "kotlin.Double" -> return (a as Float).minus(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).minus(b as Byte)
                "kotlin.Short" -> return (a as Long).minus(b as Short)
                "kotlin.Int" -> return (a as Long).minus(b as Int)
                "kotlin.Long" -> return (a as Long).minus(b as Long)
                "kotlin.Float" -> return (a as Long).minus(b as Float)
                "kotlin.Double" -> return (a as Long).minus(b as Double)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Byte" -> return (a as Double).minus(b as Byte)
                "kotlin.Short" -> return (a as Double).minus(b as Short)
                "kotlin.Int" -> return (a as Double).minus(b as Int)
                "kotlin.Long" -> return (a as Double).minus(b as Long)
                "kotlin.Float" -> return (a as Double).minus(b as Float)
                "kotlin.Double" -> return (a as Double).minus(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).minus(b as UByte)
                "kotlin.UShort" -> return (a as UByte).minus(b as UShort)
                "kotlin.UInt" -> return (a as UByte).minus(b as UInt)
                "kotlin.ULong" -> return (a as UByte).minus(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).minus(b as UByte)
                "kotlin.UShort" -> return (a as UShort).minus(b as UShort)
                "kotlin.UInt" -> return (a as UShort).minus(b as UInt)
                "kotlin.ULong" -> return (a as UShort).minus(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).minus(b as UByte)
                "kotlin.UShort" -> return (a as UInt).minus(b as UShort)
                "kotlin.UInt" -> return (a as UInt).minus(b as UInt)
                "kotlin.ULong" -> return (a as UInt).minus(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).minus(b as UByte)
                "kotlin.UShort" -> return (a as ULong).minus(b as UShort)
                "kotlin.UInt" -> return (a as ULong).minus(b as UInt)
                "kotlin.ULong" -> return (a as ULong).minus(b as ULong)
            }
        }
        "plus" -> when (typeA) {
            "kotlin.Char" -> if (typeB == "kotlin.Int") return (a as Char).plus(b as Int)
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).plus(b as Byte)
                "kotlin.Short" -> return (a as Byte).plus(b as Short)
                "kotlin.Int" -> return (a as Byte).plus(b as Int)
                "kotlin.Long" -> return (a as Byte).plus(b as Long)
                "kotlin.Float" -> return (a as Byte).plus(b as Float)
                "kotlin.Double" -> return (a as Byte).plus(b as Double)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).plus(b as Byte)
                "kotlin.Short" -> return (a as Short).plus(b as Short)
                "kotlin.Int" -> return (a as Short).plus(b as Int)
                "kotlin.Long" -> return (a as Short).plus(b as Long)
                "kotlin.Float" -> return (a as Short).plus(b as Float)
                "kotlin.Double" -> return (a as Short).plus(b as Double)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).plus(b as Byte)
                "kotlin.Short" -> return (a as Int).plus(b as Short)
                "kotlin.Int" -> return (a as Int).plus(b as Int)
                "kotlin.Long" -> return (a as Int).plus(b as Long)
                "kotlin.Float" -> return (a as Int).plus(b as Float)
                "kotlin.Double" -> return (a as Int).plus(b as Double)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Byte" -> return (a as Float).plus(b as Byte)
                "kotlin.Short" -> return (a as Float).plus(b as Short)
                "kotlin.Int" -> return (a as Float).plus(b as Int)
                "kotlin.Long" -> return (a as Float).plus(b as Long)
                "kotlin.Float" -> return (a as Float).plus(b as Float)
                "kotlin.Double" -> return (a as Float).plus(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).plus(b as Byte)
                "kotlin.Short" -> return (a as Long).plus(b as Short)
                "kotlin.Int" -> return (a as Long).plus(b as Int)
                "kotlin.Long" -> return (a as Long).plus(b as Long)
                "kotlin.Float" -> return (a as Long).plus(b as Float)
                "kotlin.Double" -> return (a as Long).plus(b as Double)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Byte" -> return (a as Double).plus(b as Byte)
                "kotlin.Short" -> return (a as Double).plus(b as Short)
                "kotlin.Int" -> return (a as Double).plus(b as Int)
                "kotlin.Long" -> return (a as Double).plus(b as Long)
                "kotlin.Float" -> return (a as Double).plus(b as Float)
                "kotlin.Double" -> return (a as Double).plus(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).plus(b as UByte)
                "kotlin.UShort" -> return (a as UByte).plus(b as UShort)
                "kotlin.UInt" -> return (a as UByte).plus(b as UInt)
                "kotlin.ULong" -> return (a as UByte).plus(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).plus(b as UByte)
                "kotlin.UShort" -> return (a as UShort).plus(b as UShort)
                "kotlin.UInt" -> return (a as UShort).plus(b as UInt)
                "kotlin.ULong" -> return (a as UShort).plus(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).plus(b as UByte)
                "kotlin.UShort" -> return (a as UInt).plus(b as UShort)
                "kotlin.UInt" -> return (a as UInt).plus(b as UInt)
                "kotlin.ULong" -> return (a as UInt).plus(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).plus(b as UByte)
                "kotlin.UShort" -> return (a as ULong).plus(b as UShort)
                "kotlin.UInt" -> return (a as ULong).plus(b as UInt)
                "kotlin.ULong" -> return (a as ULong).plus(b as ULong)
            }
            "kotlin.String" -> if (typeB == "kotlin.Any?") return (a as String).plus(b)
        }
        "rangeTo" -> when (typeA) {
            "kotlin.Char" -> if (typeB == "kotlin.Char") return (a as Char).rangeTo(b as Char)
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).rangeTo(b as Byte)
                "kotlin.Short" -> return (a as Byte).rangeTo(b as Short)
                "kotlin.Int" -> return (a as Byte).rangeTo(b as Int)
                "kotlin.Long" -> return (a as Byte).rangeTo(b as Long)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).rangeTo(b as Byte)
                "kotlin.Short" -> return (a as Short).rangeTo(b as Short)
                "kotlin.Int" -> return (a as Short).rangeTo(b as Int)
                "kotlin.Long" -> return (a as Short).rangeTo(b as Long)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).rangeTo(b as Byte)
                "kotlin.Short" -> return (a as Int).rangeTo(b as Short)
                "kotlin.Int" -> return (a as Int).rangeTo(b as Int)
                "kotlin.Long" -> return (a as Int).rangeTo(b as Long)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).rangeTo(b as Byte)
                "kotlin.Short" -> return (a as Long).rangeTo(b as Short)
                "kotlin.Int" -> return (a as Long).rangeTo(b as Int)
                "kotlin.Long" -> return (a as Long).rangeTo(b as Long)
            }
        }
        "div" -> when (typeA) {
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).div(b as Byte)
                "kotlin.Short" -> return (a as Byte).div(b as Short)
                "kotlin.Int" -> return (a as Byte).div(b as Int)
                "kotlin.Long" -> return (a as Byte).div(b as Long)
                "kotlin.Float" -> return (a as Byte).div(b as Float)
                "kotlin.Double" -> return (a as Byte).div(b as Double)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).div(b as Byte)
                "kotlin.Short" -> return (a as Short).div(b as Short)
                "kotlin.Int" -> return (a as Short).div(b as Int)
                "kotlin.Long" -> return (a as Short).div(b as Long)
                "kotlin.Float" -> return (a as Short).div(b as Float)
                "kotlin.Double" -> return (a as Short).div(b as Double)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).div(b as Byte)
                "kotlin.Short" -> return (a as Int).div(b as Short)
                "kotlin.Int" -> return (a as Int).div(b as Int)
                "kotlin.Long" -> return (a as Int).div(b as Long)
                "kotlin.Float" -> return (a as Int).div(b as Float)
                "kotlin.Double" -> return (a as Int).div(b as Double)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Byte" -> return (a as Float).div(b as Byte)
                "kotlin.Short" -> return (a as Float).div(b as Short)
                "kotlin.Int" -> return (a as Float).div(b as Int)
                "kotlin.Long" -> return (a as Float).div(b as Long)
                "kotlin.Float" -> return (a as Float).div(b as Float)
                "kotlin.Double" -> return (a as Float).div(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).div(b as Byte)
                "kotlin.Short" -> return (a as Long).div(b as Short)
                "kotlin.Int" -> return (a as Long).div(b as Int)
                "kotlin.Long" -> return (a as Long).div(b as Long)
                "kotlin.Float" -> return (a as Long).div(b as Float)
                "kotlin.Double" -> return (a as Long).div(b as Double)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Byte" -> return (a as Double).div(b as Byte)
                "kotlin.Short" -> return (a as Double).div(b as Short)
                "kotlin.Int" -> return (a as Double).div(b as Int)
                "kotlin.Long" -> return (a as Double).div(b as Long)
                "kotlin.Float" -> return (a as Double).div(b as Float)
                "kotlin.Double" -> return (a as Double).div(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).div(b as UByte)
                "kotlin.UShort" -> return (a as UByte).div(b as UShort)
                "kotlin.UInt" -> return (a as UByte).div(b as UInt)
                "kotlin.ULong" -> return (a as UByte).div(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).div(b as UByte)
                "kotlin.UShort" -> return (a as UShort).div(b as UShort)
                "kotlin.UInt" -> return (a as UShort).div(b as UInt)
                "kotlin.ULong" -> return (a as UShort).div(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).div(b as UByte)
                "kotlin.UShort" -> return (a as UInt).div(b as UShort)
                "kotlin.UInt" -> return (a as UInt).div(b as UInt)
                "kotlin.ULong" -> return (a as UInt).div(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).div(b as UByte)
                "kotlin.UShort" -> return (a as ULong).div(b as UShort)
                "kotlin.UInt" -> return (a as ULong).div(b as UInt)
                "kotlin.ULong" -> return (a as ULong).div(b as ULong)
            }
        }
        "rem" -> when (typeA) {
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).rem(b as Byte)
                "kotlin.Short" -> return (a as Byte).rem(b as Short)
                "kotlin.Int" -> return (a as Byte).rem(b as Int)
                "kotlin.Long" -> return (a as Byte).rem(b as Long)
                "kotlin.Float" -> return (a as Byte).rem(b as Float)
                "kotlin.Double" -> return (a as Byte).rem(b as Double)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).rem(b as Byte)
                "kotlin.Short" -> return (a as Short).rem(b as Short)
                "kotlin.Int" -> return (a as Short).rem(b as Int)
                "kotlin.Long" -> return (a as Short).rem(b as Long)
                "kotlin.Float" -> return (a as Short).rem(b as Float)
                "kotlin.Double" -> return (a as Short).rem(b as Double)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).rem(b as Byte)
                "kotlin.Short" -> return (a as Int).rem(b as Short)
                "kotlin.Int" -> return (a as Int).rem(b as Int)
                "kotlin.Long" -> return (a as Int).rem(b as Long)
                "kotlin.Float" -> return (a as Int).rem(b as Float)
                "kotlin.Double" -> return (a as Int).rem(b as Double)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Byte" -> return (a as Float).rem(b as Byte)
                "kotlin.Short" -> return (a as Float).rem(b as Short)
                "kotlin.Int" -> return (a as Float).rem(b as Int)
                "kotlin.Long" -> return (a as Float).rem(b as Long)
                "kotlin.Float" -> return (a as Float).rem(b as Float)
                "kotlin.Double" -> return (a as Float).rem(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).rem(b as Byte)
                "kotlin.Short" -> return (a as Long).rem(b as Short)
                "kotlin.Int" -> return (a as Long).rem(b as Int)
                "kotlin.Long" -> return (a as Long).rem(b as Long)
                "kotlin.Float" -> return (a as Long).rem(b as Float)
                "kotlin.Double" -> return (a as Long).rem(b as Double)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Byte" -> return (a as Double).rem(b as Byte)
                "kotlin.Short" -> return (a as Double).rem(b as Short)
                "kotlin.Int" -> return (a as Double).rem(b as Int)
                "kotlin.Long" -> return (a as Double).rem(b as Long)
                "kotlin.Float" -> return (a as Double).rem(b as Float)
                "kotlin.Double" -> return (a as Double).rem(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).rem(b as UByte)
                "kotlin.UShort" -> return (a as UByte).rem(b as UShort)
                "kotlin.UInt" -> return (a as UByte).rem(b as UInt)
                "kotlin.ULong" -> return (a as UByte).rem(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).rem(b as UByte)
                "kotlin.UShort" -> return (a as UShort).rem(b as UShort)
                "kotlin.UInt" -> return (a as UShort).rem(b as UInt)
                "kotlin.ULong" -> return (a as UShort).rem(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).rem(b as UByte)
                "kotlin.UShort" -> return (a as UInt).rem(b as UShort)
                "kotlin.UInt" -> return (a as UInt).rem(b as UInt)
                "kotlin.ULong" -> return (a as UInt).rem(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).rem(b as UByte)
                "kotlin.UShort" -> return (a as ULong).rem(b as UShort)
                "kotlin.UInt" -> return (a as ULong).rem(b as UInt)
                "kotlin.ULong" -> return (a as ULong).rem(b as ULong)
            }
        }
        "times" -> when (typeA) {
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).times(b as Byte)
                "kotlin.Short" -> return (a as Byte).times(b as Short)
                "kotlin.Int" -> return (a as Byte).times(b as Int)
                "kotlin.Long" -> return (a as Byte).times(b as Long)
                "kotlin.Float" -> return (a as Byte).times(b as Float)
                "kotlin.Double" -> return (a as Byte).times(b as Double)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).times(b as Byte)
                "kotlin.Short" -> return (a as Short).times(b as Short)
                "kotlin.Int" -> return (a as Short).times(b as Int)
                "kotlin.Long" -> return (a as Short).times(b as Long)
                "kotlin.Float" -> return (a as Short).times(b as Float)
                "kotlin.Double" -> return (a as Short).times(b as Double)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).times(b as Byte)
                "kotlin.Short" -> return (a as Int).times(b as Short)
                "kotlin.Int" -> return (a as Int).times(b as Int)
                "kotlin.Long" -> return (a as Int).times(b as Long)
                "kotlin.Float" -> return (a as Int).times(b as Float)
                "kotlin.Double" -> return (a as Int).times(b as Double)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Byte" -> return (a as Float).times(b as Byte)
                "kotlin.Short" -> return (a as Float).times(b as Short)
                "kotlin.Int" -> return (a as Float).times(b as Int)
                "kotlin.Long" -> return (a as Float).times(b as Long)
                "kotlin.Float" -> return (a as Float).times(b as Float)
                "kotlin.Double" -> return (a as Float).times(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).times(b as Byte)
                "kotlin.Short" -> return (a as Long).times(b as Short)
                "kotlin.Int" -> return (a as Long).times(b as Int)
                "kotlin.Long" -> return (a as Long).times(b as Long)
                "kotlin.Float" -> return (a as Long).times(b as Float)
                "kotlin.Double" -> return (a as Long).times(b as Double)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Byte" -> return (a as Double).times(b as Byte)
                "kotlin.Short" -> return (a as Double).times(b as Short)
                "kotlin.Int" -> return (a as Double).times(b as Int)
                "kotlin.Long" -> return (a as Double).times(b as Long)
                "kotlin.Float" -> return (a as Double).times(b as Float)
                "kotlin.Double" -> return (a as Double).times(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).times(b as UByte)
                "kotlin.UShort" -> return (a as UByte).times(b as UShort)
                "kotlin.UInt" -> return (a as UByte).times(b as UInt)
                "kotlin.ULong" -> return (a as UByte).times(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).times(b as UByte)
                "kotlin.UShort" -> return (a as UShort).times(b as UShort)
                "kotlin.UInt" -> return (a as UShort).times(b as UInt)
                "kotlin.ULong" -> return (a as UShort).times(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).times(b as UByte)
                "kotlin.UShort" -> return (a as UInt).times(b as UShort)
                "kotlin.UInt" -> return (a as UInt).times(b as UInt)
                "kotlin.ULong" -> return (a as UInt).times(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).times(b as UByte)
                "kotlin.UShort" -> return (a as ULong).times(b as UShort)
                "kotlin.UInt" -> return (a as ULong).times(b as UInt)
                "kotlin.ULong" -> return (a as ULong).times(b as ULong)
            }
        }
        "shl" -> when (typeA) {
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int).shl(b as Int)
            "kotlin.Long" -> if (typeB == "kotlin.Int") return (a as Long).shl(b as Int)
            "kotlin.UInt" -> if (typeB == "kotlin.Int") return (a as UInt).shl(b as Int)
            "kotlin.ULong" -> if (typeB == "kotlin.Int") return (a as ULong).shl(b as Int)
        }
        "shr" -> when (typeA) {
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int).shr(b as Int)
            "kotlin.Long" -> if (typeB == "kotlin.Int") return (a as Long).shr(b as Int)
            "kotlin.UInt" -> if (typeB == "kotlin.Int") return (a as UInt).shr(b as Int)
            "kotlin.ULong" -> if (typeB == "kotlin.Int") return (a as ULong).shr(b as Int)
        }
        "ushr" -> when (typeA) {
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int).ushr(b as Int)
            "kotlin.Long" -> if (typeB == "kotlin.Int") return (a as Long).ushr(b as Int)
        }
        "get" -> when (typeA) {
            "kotlin.BooleanArray" -> if (typeB == "kotlin.Int") return (a as BooleanArray).get(b as Int)
            "kotlin.CharArray" -> if (typeB == "kotlin.Int") return (a as CharArray).get(b as Int)
            "kotlin.ByteArray" -> if (typeB == "kotlin.Int") return (a as ByteArray).get(b as Int)
            "kotlin.ShortArray" -> if (typeB == "kotlin.Int") return (a as ShortArray).get(b as Int)
            "kotlin.IntArray" -> if (typeB == "kotlin.Int") return (a as IntArray).get(b as Int)
            "kotlin.FloatArray" -> if (typeB == "kotlin.Int") return (a as FloatArray).get(b as Int)
            "kotlin.LongArray" -> if (typeB == "kotlin.Int") return (a as LongArray).get(b as Int)
            "kotlin.DoubleArray" -> if (typeB == "kotlin.Int") return (a as DoubleArray).get(b as Int)
            "kotlin.Array" -> if (typeB == "kotlin.Int") return (a as Array<Any?>).get(b as Int)
            "kotlin.String" -> if (typeB == "kotlin.Int") return (a as String).get(b as Int)
            "kotlin.CharSequence" -> if (typeB == "kotlin.Int") return (a as CharSequence).get(b as Int)
        }
        "floorDiv" -> when (typeA) {
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).floorDiv(b as Byte)
                "kotlin.Short" -> return (a as Byte).floorDiv(b as Short)
                "kotlin.Int" -> return (a as Byte).floorDiv(b as Int)
                "kotlin.Long" -> return (a as Byte).floorDiv(b as Long)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).floorDiv(b as Byte)
                "kotlin.Short" -> return (a as Short).floorDiv(b as Short)
                "kotlin.Int" -> return (a as Short).floorDiv(b as Int)
                "kotlin.Long" -> return (a as Short).floorDiv(b as Long)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).floorDiv(b as Byte)
                "kotlin.Short" -> return (a as Int).floorDiv(b as Short)
                "kotlin.Int" -> return (a as Int).floorDiv(b as Int)
                "kotlin.Long" -> return (a as Int).floorDiv(b as Long)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).floorDiv(b as Byte)
                "kotlin.Short" -> return (a as Long).floorDiv(b as Short)
                "kotlin.Int" -> return (a as Long).floorDiv(b as Int)
                "kotlin.Long" -> return (a as Long).floorDiv(b as Long)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).floorDiv(b as UByte)
                "kotlin.UShort" -> return (a as UByte).floorDiv(b as UShort)
                "kotlin.UInt" -> return (a as UByte).floorDiv(b as UInt)
                "kotlin.ULong" -> return (a as UByte).floorDiv(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).floorDiv(b as UByte)
                "kotlin.UShort" -> return (a as UShort).floorDiv(b as UShort)
                "kotlin.UInt" -> return (a as UShort).floorDiv(b as UInt)
                "kotlin.ULong" -> return (a as UShort).floorDiv(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).floorDiv(b as UByte)
                "kotlin.UShort" -> return (a as UInt).floorDiv(b as UShort)
                "kotlin.UInt" -> return (a as UInt).floorDiv(b as UInt)
                "kotlin.ULong" -> return (a as UInt).floorDiv(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).floorDiv(b as UByte)
                "kotlin.UShort" -> return (a as ULong).floorDiv(b as UShort)
                "kotlin.UInt" -> return (a as ULong).floorDiv(b as UInt)
                "kotlin.ULong" -> return (a as ULong).floorDiv(b as ULong)
            }
        }
        "mod" -> when (typeA) {
            "kotlin.Byte" -> when (typeB) {
                "kotlin.Byte" -> return (a as Byte).mod(b as Byte)
                "kotlin.Short" -> return (a as Byte).mod(b as Short)
                "kotlin.Int" -> return (a as Byte).mod(b as Int)
                "kotlin.Long" -> return (a as Byte).mod(b as Long)
            }
            "kotlin.Short" -> when (typeB) {
                "kotlin.Byte" -> return (a as Short).mod(b as Byte)
                "kotlin.Short" -> return (a as Short).mod(b as Short)
                "kotlin.Int" -> return (a as Short).mod(b as Int)
                "kotlin.Long" -> return (a as Short).mod(b as Long)
            }
            "kotlin.Int" -> when (typeB) {
                "kotlin.Byte" -> return (a as Int).mod(b as Byte)
                "kotlin.Short" -> return (a as Int).mod(b as Short)
                "kotlin.Int" -> return (a as Int).mod(b as Int)
                "kotlin.Long" -> return (a as Int).mod(b as Long)
            }
            "kotlin.Float" -> when (typeB) {
                "kotlin.Float" -> return (a as Float).mod(b as Float)
                "kotlin.Double" -> return (a as Float).mod(b as Double)
            }
            "kotlin.Long" -> when (typeB) {
                "kotlin.Byte" -> return (a as Long).mod(b as Byte)
                "kotlin.Short" -> return (a as Long).mod(b as Short)
                "kotlin.Int" -> return (a as Long).mod(b as Int)
                "kotlin.Long" -> return (a as Long).mod(b as Long)
            }
            "kotlin.Double" -> when (typeB) {
                "kotlin.Float" -> return (a as Double).mod(b as Float)
                "kotlin.Double" -> return (a as Double).mod(b as Double)
            }
            "kotlin.UByte" -> when (typeB) {
                "kotlin.UByte" -> return (a as UByte).mod(b as UByte)
                "kotlin.UShort" -> return (a as UByte).mod(b as UShort)
                "kotlin.UInt" -> return (a as UByte).mod(b as UInt)
                "kotlin.ULong" -> return (a as UByte).mod(b as ULong)
            }
            "kotlin.UShort" -> when (typeB) {
                "kotlin.UByte" -> return (a as UShort).mod(b as UByte)
                "kotlin.UShort" -> return (a as UShort).mod(b as UShort)
                "kotlin.UInt" -> return (a as UShort).mod(b as UInt)
                "kotlin.ULong" -> return (a as UShort).mod(b as ULong)
            }
            "kotlin.UInt" -> when (typeB) {
                "kotlin.UByte" -> return (a as UInt).mod(b as UByte)
                "kotlin.UShort" -> return (a as UInt).mod(b as UShort)
                "kotlin.UInt" -> return (a as UInt).mod(b as UInt)
                "kotlin.ULong" -> return (a as UInt).mod(b as ULong)
            }
            "kotlin.ULong" -> when (typeB) {
                "kotlin.UByte" -> return (a as ULong).mod(b as UByte)
                "kotlin.UShort" -> return (a as ULong).mod(b as UShort)
                "kotlin.UInt" -> return (a as ULong).mod(b as UInt)
                "kotlin.ULong" -> return (a as ULong).mod(b as ULong)
            }
        }
        "less" -> when (typeA) {
            "kotlin.Char" -> if (typeB == "kotlin.Char") return (a as Char) < (b as Char)
            "kotlin.Byte" -> if (typeB == "kotlin.Byte") return (a as Byte) < (b as Byte)
            "kotlin.Short" -> if (typeB == "kotlin.Short") return (a as Short) < (b as Short)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int) < (b as Int)
            "kotlin.Float" -> if (typeB == "kotlin.Float") return (a as Float) < (b as Float)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long) < (b as Long)
            "kotlin.Double" -> if (typeB == "kotlin.Double") return (a as Double) < (b as Double)
        }
        "lessOrEqual" -> when (typeA) {
            "kotlin.Char" -> if (typeB == "kotlin.Char") return (a as Char) <= (b as Char)
            "kotlin.Byte" -> if (typeB == "kotlin.Byte") return (a as Byte) <= (b as Byte)
            "kotlin.Short" -> if (typeB == "kotlin.Short") return (a as Short) <= (b as Short)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int) <= (b as Int)
            "kotlin.Float" -> if (typeB == "kotlin.Float") return (a as Float) <= (b as Float)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long) <= (b as Long)
            "kotlin.Double" -> if (typeB == "kotlin.Double") return (a as Double) <= (b as Double)
        }
        "greater" -> when (typeA) {
            "kotlin.Char" -> if (typeB == "kotlin.Char") return (a as Char) > (b as Char)
            "kotlin.Byte" -> if (typeB == "kotlin.Byte") return (a as Byte) > (b as Byte)
            "kotlin.Short" -> if (typeB == "kotlin.Short") return (a as Short) > (b as Short)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int) > (b as Int)
            "kotlin.Float" -> if (typeB == "kotlin.Float") return (a as Float) > (b as Float)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long) > (b as Long)
            "kotlin.Double" -> if (typeB == "kotlin.Double") return (a as Double) > (b as Double)
        }
        "greaterOrEqual" -> when (typeA) {
            "kotlin.Char" -> if (typeB == "kotlin.Char") return (a as Char) >= (b as Char)
            "kotlin.Byte" -> if (typeB == "kotlin.Byte") return (a as Byte) >= (b as Byte)
            "kotlin.Short" -> if (typeB == "kotlin.Short") return (a as Short) >= (b as Short)
            "kotlin.Int" -> if (typeB == "kotlin.Int") return (a as Int) >= (b as Int)
            "kotlin.Float" -> if (typeB == "kotlin.Float") return (a as Float) >= (b as Float)
            "kotlin.Long" -> if (typeB == "kotlin.Long") return (a as Long) >= (b as Long)
            "kotlin.Double" -> if (typeB == "kotlin.Double") return (a as Double) >= (b as Double)
        }
        "EQEQ" -> when (typeA) {
            "kotlin.Any?" -> if (typeB == "kotlin.Any?") return a == b
        }
        "EQEQEQ" -> when (typeA) {
            "kotlin.Any?" -> if (typeB == "kotlin.Any?") return if (a is Proxy && b is Proxy) a.state === b.state else a === b
        }
        "ieee754equals" -> when (typeA) {
            "kotlin.Float?" -> if (typeB == "kotlin.Float?") return (a as Float?) == (b as Float?)
            "kotlin.Double?" -> if (typeB == "kotlin.Double?") return (a as Double?) == (b as Double?)
        }
        "ANDAND" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Boolean") return (a as Boolean) && (b as Boolean)
        }
        "OROR" -> when (typeA) {
            "kotlin.Boolean" -> if (typeB == "kotlin.Boolean") return (a as Boolean) || (b as Boolean)
        }
    }
    throw InterpreterMethodNotFoundError("Unknown function: $name($typeA, $typeB)")
}

internal fun interpretTernaryFunction(name: String, typeA: String, typeB: String, typeC: String, a: Any?, b: Any?, c: Any?): Any {
    when (name) {
        "subSequence" -> when (typeA) {
            "kotlin.String" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Int") return (a as String).subSequence(b as Int, c as Int)
            "kotlin.CharSequence" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Int") return (a as CharSequence).subSequence(b as Int, c as Int)
        }
        "set" -> when (typeA) {
            "kotlin.BooleanArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Boolean") return (a as BooleanArray).set(b as Int, c as Boolean)
            "kotlin.CharArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Char") return (a as CharArray).set(b as Int, c as Char)
            "kotlin.ByteArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Byte") return (a as ByteArray).set(b as Int, c as Byte)
            "kotlin.ShortArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Short") return (a as ShortArray).set(b as Int, c as Short)
            "kotlin.IntArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Int") return (a as IntArray).set(b as Int, c as Int)
            "kotlin.FloatArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Float") return (a as FloatArray).set(b as Int, c as Float)
            "kotlin.LongArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Long") return (a as LongArray).set(b as Int, c as Long)
            "kotlin.DoubleArray" -> if (typeB == "kotlin.Int" && typeC == "kotlin.Double") return (a as DoubleArray).set(b as Int, c as Double)
            "kotlin.Array" -> if (typeB == "kotlin.Int" && typeC == "T") return (a as Array<Any?>).set(b as Int, c)
        }
    }
    throw InterpreterMethodNotFoundError("Unknown function: $name($typeA, $typeB, $typeC)")
}

