/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.jvm;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.pipeline.AbstractConfigurationPhase;
import org.jetbrains.kotlin.cli.pipeline.ArgumentsPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.ConfigurationPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmConfigurationUpdater;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmFrontendPipelinePhase;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.modules.Module;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmConfigurationPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/AbstractConfigurationPhase;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "<init>", "()V", "executePhase", "Lorg/jetbrains/kotlin/cli/pipeline/ConfigurationPipelineArtifact;", "input", "Lorg/jetbrains/kotlin/cli/pipeline/ArgumentsPipelineArtifact;", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "provideCustomScriptingPluginOptions", "", "", "arguments", "cli"})
public final class JvmConfigurationPipelinePhase
extends AbstractConfigurationPhase<K2JVMCompilerArguments> {
    @NotNull
    public static final JvmConfigurationPipelinePhase INSTANCE = new JvmConfigurationPipelinePhase();

    private JvmConfigurationPipelinePhase() {
        super("JvmConfigurationPipelinePhase", null, SetsKt.setOf((Object)CheckCompilationErrors.CheckMessageCollector.INSTANCE), CollectionsKt.listOf((Object)JvmConfigurationUpdater.INSTANCE), 2, null);
    }

    @Override
    @Nullable
    public ConfigurationPipelineArtifact executePhase(@NotNull ArgumentsPipelineArtifact<K2JVMCompilerArguments> input) {
        String dumpModelDir;
        CompilerConfiguration configuration;
        ConfigurationPipelineArtifact configurationPipelineArtifact;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        ConfigurationPipelineArtifact it = configurationPipelineArtifact = super.executePhase(input);
        boolean bl = false;
        ConfigurationPipelineArtifact configurationPipelineArtifact2 = it;
        CompilerConfiguration compilerConfiguration = configuration = configurationPipelineArtifact2 != null ? configurationPipelineArtifact2.getConfiguration() : null;
        String string = dumpModelDir = compilerConfiguration != null ? compilerConfiguration.get(CommonConfigurationKeys.DUMP_MODEL) : null;
        if (dumpModelDir != null) {
            ModuleChunk moduleChunk = CLIConfigurationKeysKt.getModuleChunk(configuration);
            Intrinsics.checkNotNull((Object)moduleChunk);
            List<Module> list = moduleChunk.getModules();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
            JvmFrontendPipelinePhase.INSTANCE.dumpModel(dumpModelDir, list, configuration, input.getArguments());
        }
        return configurationPipelineArtifact;
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new MetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    @NotNull
    protected List<String> provideCustomScriptingPluginOptions(@NotNull K2JVMCompilerArguments arguments) {
        List list;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        List $this$provideCustomScriptingPluginOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String[] stringArray = arguments.getScriptTemplates();
        boolean bl2 = stringArray != null ? !(stringArray.length == 0) : false;
        if (bl2) {
            StringBuilder stringBuilder = new StringBuilder().append("plugin:kotlin.scripting:script-templates=");
            Object[] objectArray = arguments.getScriptTemplates();
            Intrinsics.checkNotNull((Object)objectArray);
            $this$provideCustomScriptingPluginOptions_u24lambda_u240.add(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        String[] stringArray2 = arguments.getScriptResolverEnvironment();
        boolean bl3 = stringArray2 != null ? !(stringArray2.length == 0) : false;
        if (bl3) {
            StringBuilder stringBuilder = new StringBuilder().append("plugin:kotlin.scripting:script-resolver-environment=");
            Object[] objectArray = arguments.getScriptResolverEnvironment();
            Intrinsics.checkNotNull((Object)objectArray);
            $this$provideCustomScriptingPluginOptions_u24lambda_u240.add(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        return CollectionsKt.build((List)list);
    }
}

