/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.ListLikeMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u0006\u0010\u0011\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/CompilerPluginFilesCache;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "workingDir", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "sourceFilesReferencedByPlugins", "Lorg/jetbrains/kotlin/incremental/ListLikeMap;", "outputFilesGeneratedForPlugins", "getSourceFilesReferencedByPlugins", "", "recordSourceFilesReferencedByPlugins", "", "files", "recordOutputFilesGeneratedByPlugins", "removeOutputsGeneratedByPlugins", "Companion", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nCompilerPluginFilesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerPluginFilesCache.kt\norg/jetbrains/kotlin/incremental/CompilerPluginFilesCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1915#2,2:88\n*S KotlinDebug\n*F\n+ 1 CompilerPluginFilesCache.kt\norg/jetbrains/kotlin/incremental/CompilerPluginFilesCache\n*L\n58#1:88,2\n*E\n"})
public final class CompilerPluginFilesCache
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final ListLikeMap sourceFilesReferencedByPlugins;
    @NotNull
    private final ListLikeMap outputFilesGeneratedForPlugins;

    public CompilerPluginFilesCache(@NotNull File workingDir, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(workingDir);
        this.icContext = icContext;
        this.sourceFilesReferencedByPlugins = (ListLikeMap)this.registerMap((BasicMap)new ListLikeMap(this.getStorageFile("sources-referenced-by-plugins"), this.icContext.getFileDescriptorForSourceFiles(), this.icContext));
        this.outputFilesGeneratedForPlugins = (ListLikeMap)this.registerMap((BasicMap)new ListLikeMap(this.getStorageFile("outputs-generated-for-plugins"), this.icContext.getFileDescriptorForOutputFiles(), this.icContext));
    }

    @NotNull
    public final List<File> getSourceFilesReferencedByPlugins() {
        return this.sourceFilesReferencedByPlugins.getValue();
    }

    public final void recordSourceFilesReferencedByPlugins(@NotNull List<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.sourceFilesReferencedByPlugins.setValue(files2);
    }

    public final void recordOutputFilesGeneratedByPlugins(@NotNull List<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.outputFilesGeneratedForPlugins.setValue(files2);
    }

    public final void removeOutputsGeneratedByPlugins() {
        List<File> value2 = this.outputFilesGeneratedForPlugins.getAndRemoveValue();
        Iterable $this$forEach$iv = value2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            ICReporterKt.debug(this.icContext.getReporter(), (Function0<String>)((Function0)() -> CompilerPluginFilesCache.removeOutputsGeneratedByPlugins$lambda$0$0(it)));
            CompilationTransaction compilationTransaction = this.icContext.getTransaction();
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            compilationTransaction.deleteFile(path);
        }
    }

    private static final String removeOutputsGeneratedByPlugins$lambda$0$0(File $it) {
        return "Deleting " + $it + " on clearing cache for plugin outputs";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/CompilerPluginFilesCache$Companion;", "", "<init>", "()V", "SOURCES_REFERENCED_BY_PLUGINS", "", "OUTPUTS_GENERATED_FOR_PLUGINS", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

