/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.kotlin.io.vavr.collection.Collections;
import org.jetbrains.kotlin.io.vavr.collection.IndexedSeq;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.JavaConverters;
import org.jetbrains.kotlin.io.vavr.collection.Seq;
import org.jetbrains.kotlin.io.vavr.collection.Vector;

public final class CharSeq
implements IndexedSeq<Character>,
Serializable,
CharSequence,
Comparable<CharSeq> {
    private static final long serialVersionUID = 1L;
    private static final CharSeq EMPTY = new CharSeq("");
    private final String back;

    private CharSeq(String javaString) {
        this.back = javaString;
    }

    public static CharSeq empty() {
        return EMPTY;
    }

    public static Collector<Character, ArrayList<Character>, CharSeq> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Character> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, CharSeq> finisher = CharSeq::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static CharSeq of(CharSequence sequence2) {
        Objects.requireNonNull(sequence2, "sequence is null");
        if (sequence2 instanceof CharSeq) {
            return (CharSeq)sequence2;
        }
        return sequence2.length() == 0 ? CharSeq.empty() : new CharSeq(sequence2.toString());
    }

    public static CharSeq ofAll(Iterable<? extends Character> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (Collections.isEmpty(elements)) {
            return EMPTY;
        }
        if (elements instanceof CharSeq) {
            return (CharSeq)elements;
        }
        if (elements instanceof JavaConverters.ListView && ((JavaConverters.ListView)elements).getDelegate() instanceof CharSeq) {
            return (CharSeq)((JavaConverters.ListView)elements).getDelegate();
        }
        StringBuilder sb = new StringBuilder();
        java.util.Iterator<? extends Character> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            char character = iterator2.next().charValue();
            sb.append(character);
        }
        return CharSeq.of(sb);
    }

    public CharSeq append(Character element) {
        char c2 = element.charValue();
        return CharSeq.of(this.back + c2);
    }

    public CharSeq appendAll(Iterable<? extends Character> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (Collections.isEmpty(elements)) {
            return this;
        }
        StringBuilder sb = new StringBuilder(this.back);
        java.util.Iterator<? extends Character> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            char element = iterator2.next().charValue();
            sb.append(element);
        }
        return CharSeq.of(sb);
    }

    public CharSeq filter(Predicate<? super Character> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.back.length(); ++i2) {
            char ch = this.get(i2).charValue();
            if (!predicate.test(Character.valueOf(ch))) continue;
            sb.append(ch);
        }
        if (sb.length() == 0) {
            return EMPTY;
        }
        if (sb.length() == this.length()) {
            return this;
        }
        return CharSeq.of(sb);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    public CharSeq insert(int index, Character element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e)");
        }
        if (index > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e) on String of length " + this.length());
        }
        char c2 = element.charValue();
        return CharSeq.of(new StringBuilder(this.back).insert(index, c2).toString());
    }

    public CharSeq insertAll(int index, Iterable<? extends Character> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements)");
        }
        if (index > this.length()) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements) on String of length " + this.length());
        }
        StringBuilder sb = new StringBuilder(this.back.substring(0, index));
        java.util.Iterator<? extends Character> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            char element = iterator2.next().charValue();
            sb.append(element);
        }
        sb.append(this.back.substring(index));
        return CharSeq.of(sb);
    }

    @Override
    public Iterator<Character> iterator() {
        return Iterator.ofAll(this.toCharArray());
    }

    @Override
    public <U> IndexedSeq<U> map(Function<? super Character, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Seq result2 = Vector.empty();
        for (int i2 = 0; i2 < this.length(); ++i2) {
            result2 = result2.append(mapper.apply(this.get(i2)));
        }
        return result2;
    }

    @Override
    public String mkString() {
        return this.back;
    }

    public CharSeq remove(Character element) {
        if (element == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        boolean found = false;
        for (int i2 = 0; i2 < this.length(); ++i2) {
            char c2 = this.get(i2).charValue();
            if (!found && c2 == element.charValue()) {
                found = true;
                continue;
            }
            sb.append(c2);
        }
        return sb.length() == 0 ? EMPTY : (sb.length() == this.length() ? this : CharSeq.of(sb));
    }

    @Override
    public CharSeq removeAt(int index) {
        String removed = this.back.substring(0, index) + this.back.substring(index + 1);
        return removed.isEmpty() ? EMPTY : CharSeq.of(removed);
    }

    public CharSeq removeAll(Iterable<? extends Character> elements) {
        return Collections.removeAll(this, elements);
    }

    public CharSeq retainAll(Iterable<? extends Character> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public CharSeq reverse() {
        return CharSeq.of(new StringBuilder(this.back).reverse().toString());
    }

    public CharSeq sorted(Comparator<? super Character> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(CharSeq.collector());
    }

    @Override
    public CharSeq tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty string");
        }
        return CharSeq.of(this.back.substring(1));
    }

    @Override
    public CharSeq take(int n2) {
        if (n2 <= 0) {
            return EMPTY;
        }
        if (n2 >= this.length()) {
            return this;
        }
        return CharSeq.of(this.back.substring(0, n2));
    }

    public CharSeq update(int index, Character element) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("update(" + index + ")");
        }
        char c2 = element.charValue();
        return CharSeq.of(this.back.substring(0, index) + c2 + this.back.substring(index + 1));
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.back.charAt(index));
    }

    @Override
    public int indexOf(Character element, int from2) {
        return this.back.indexOf(element.charValue(), from2);
    }

    @Override
    public int lastIndexOf(Character element, int end) {
        return this.back.lastIndexOf(element.charValue(), end);
    }

    @Override
    public Character head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty string");
        }
        return this.get(0);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.back.isEmpty();
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    public boolean equals(Object o2) {
        return Collections.equals(this, o2);
    }

    public int hashCode() {
        return Collections.hashOrdered(this);
    }

    @Override
    public char charAt(int index) {
        return this.get(index).charValue();
    }

    @Override
    public int length() {
        return this.back.length();
    }

    @Override
    public int compareTo(CharSeq anotherString) {
        return this.back.compareTo(anotherString.back);
    }

    @Override
    public CharSeq subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("begin index " + beginIndex + " < 0");
        }
        if (endIndex > this.length()) {
            throw new IndexOutOfBoundsException("endIndex " + endIndex + " > length " + this.length());
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new IllegalArgumentException("beginIndex " + beginIndex + " > endIndex " + endIndex);
        }
        if (beginIndex == 0 && endIndex == this.length()) {
            return this;
        }
        return CharSeq.of(this.back.subSequence(beginIndex, endIndex));
    }

    @Override
    public String stringPrefix() {
        return "CharSeq";
    }

    @Override
    public String toString() {
        return this.back;
    }

    public char[] toCharArray() {
        return this.back.toCharArray();
    }

    public Character[] toJavaArray() {
        return this.toJavaList().toArray(new Character[0]);
    }
}

