/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumEntryInstancesLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "createEnumEntryInstanceVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EnumEntryInstancesLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,588:1\n75#2,4:589\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EnumEntryInstancesLowering\n*L\n318#1:589,4\n*E\n"})
public final class EnumEntryInstancesLowering
implements DeclarationTransformer {
    @NotNull
    private final JsCommonBackendContext context;

    public EnumEntryInstancesLowering(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrEnumEntry && IrJsUtilsKt.isInstantiableEnum(irClass = IrUtilsKt.getParentAsClass(declaration))) {
            Object[] objectArray = new IrDeclaration[]{declaration, this.createEnumEntryInstanceVariable(irClass, (IrEnumEntry)declaration)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        return null;
    }

    private final IrField createEnumEntryInstanceVariable(IrClass irClass, IrEnumEntry enumEntry) {
        IrField irField;
        String string = irClass.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        String enumName = string;
        IrFactory $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$createEnumEntryInstanceVariable_u24lambda_u240 = $this$buildField_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier(enumName + '_' + enumEntry.getName().getIdentifier() + "_instance");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$createEnumEntryInstanceVariable_u24lambda_u240.setName(name2);
        $this$createEnumEntryInstanceVariable_u24lambda_u240.setType(IrTypesKt.makeNullable(EnumClassLoweringKt.access$getType(enumEntry, irClass)));
        $this$createEnumEntryInstanceVariable_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRY());
        $this$createEnumEntryInstanceVariable_u24lambda_u240.setStatic(true);
        IrField $this$createEnumEntryInstanceVariable_u24lambda_u241 = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u241$iv);
        boolean bl3 = false;
        $this$createEnumEntryInstanceVariable_u24lambda_u241.setParent(irClass);
        $this$createEnumEntryInstanceVariable_u24lambda_u241.setInitializer(null);
        IrField result2 = irField;
        JsIrAttributesKt.setCorrespondingField(enumEntry, result2);
        JsIrAttributesKt.setCorrespondingEnumEntry(result2, enumEntry);
        return result2;
    }
}

