/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.ir.declarations.DescriptorMetadataSource;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@PhaseDescription(name="ProcessOptionalAnnotations")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\u0007*\u00020\u000bH\u0002J\f\u0010\r\u001a\u00020\u0007*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ProcessOptionalAnnotations;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "registerOptionalAnnotations", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "processClassDescriptors", "processClassFir", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nProcessOptionalAnnotations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessOptionalAnnotations.kt\norg/jetbrains/kotlin/backend/jvm/lower/ProcessOptionalAnnotations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class ProcessOptionalAnnotations
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ProcessOptionalAnnotations(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!(declaration instanceof IrClass) || !JvmIrUtilsKt.isOptionalAnnotationClass((IrClass)declaration)) continue;
            this.registerOptionalAnnotations((IrClass)declaration);
        }
    }

    private final void registerOptionalAnnotations(IrClass $this$registerOptionalAnnotations) {
        if (this.context.getConfig().getUseFir()) {
            this.processClassFir($this$registerOptionalAnnotations);
        } else {
            this.processClassDescriptors($this$registerOptionalAnnotations);
        }
        for (IrDeclaration declaration : $this$registerOptionalAnnotations.getDeclarations()) {
            if (!(declaration instanceof IrClass) || !JvmIrUtilsKt.isOptionalAnnotationClass((IrClass)declaration)) continue;
            this.registerOptionalAnnotations((IrClass)declaration);
        }
    }

    private final void processClassDescriptors(IrClass $this$processClassDescriptors) {
        ClassDescriptor descriptor;
        MetadataSource classMetadata;
        MetadataSource metadataSource = classMetadata = $this$processClassDescriptors.getMetadata();
        if (!(metadataSource == null ? true : metadataSource instanceof DescriptorMetadataSource.Class)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("IrClass has unexpected metadata: ");
            MetadataSource metadataSource2 = classMetadata;
            Intrinsics.checkNotNull((Object)metadataSource2);
            String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(metadataSource2.getClass()).getSimpleName()).toString();
            throw new IllegalArgumentException(string.toString());
        }
        if (classMetadata != null && OptionalAnnotationUtil.shouldGenerateExpectClass(descriptor = ((DescriptorMetadataSource.Class)classMetadata).getDescriptor())) {
            ((Collection)this.context.getOptionalAnnotations()).add(classMetadata);
        }
    }

    private final void processClassFir(IrClass $this$processClassFir) {
        MetadataSource classMetadata;
        MetadataSource metadataSource = classMetadata = $this$processClassFir.getMetadata();
        if (!(metadataSource == null ? true : metadataSource instanceof MetadataSource.Class)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("IrClass has unexpected metadata: ");
            MetadataSource metadataSource2 = classMetadata;
            Intrinsics.checkNotNull((Object)metadataSource2);
            String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(metadataSource2.getClass()).getSimpleName()).toString();
            throw new IllegalArgumentException(string.toString());
        }
        if (classMetadata != null && IrUtilsKt.isAnnotationClass($this$processClassFir) && $this$processClassFir.isExpect() && IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$processClassFir, OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME())) {
            ((Collection)this.context.getOptionalAnnotations()).add(classMetadata);
        }
    }
}

