/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.ir.backend.js.lower.coroutines

import org.jetbrains.kotlin.backend.common.lower.coroutines.AbstractAddContinuationToFunctionCallsLowering
import org.jetbrains.kotlin.backend.common.lower.coroutines.AddContinuationToLocalSuspendFunctionsLowering
import org.jetbrains.kotlin.backend.common.lower.coroutines.AddContinuationToNonLocalSuspendFunctionsLowering
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction

/**
 * Replace suspend function calls with calls with continuation.
 *
 * Requires [AddContinuationToLocalSuspendFunctionsLowering] and
 * [AddContinuationToNonLocalSuspendFunctionsLowering] to transform function declarations first.
 */
@PhasePrerequisites(AddContinuationToLocalSuspendFunctionsLowering::class, AddContinuationToNonLocalSuspendFunctionsLowering::class)
class AddContinuationToFunctionCallsLowering(
    override val context: JsCommonBackendContext
) : AbstractAddContinuationToFunctionCallsLowering() {
    override fun IrSimpleFunction.isContinuationItself(): Boolean = overriddenSymbols.any { overriddenSymbol ->
        overriddenSymbol.owner.name.asString() == "doResume" && overriddenSymbol.owner.parent == context.symbols.coroutineImpl.owner
    }

    override val IrSimpleFunction.continuationOwner: IrSimpleFunction
        get() = if (origin == YIELDED_WRAPPER_FUNCTION) parent as IrSimpleFunction else this
}
