/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner;", "", "<init>", "()V", "contract", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "getContract", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "receiverType", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "valueParameterCount", "", "getValueParameterCount", "()I", "valueParameters", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "getValueParameters", "()Ljava/util/List;", "contextParameters", "getContextParameters", "Function", "PropertyAccessor", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner$Function;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner$PropertyAccessor;", "decompiler-to-stubs"})
public abstract class ClsContractOwner {
    private ClsContractOwner() {
    }

    @NotNull
    public abstract ProtoBuf.Contract getContract();

    @Nullable
    public abstract ProtoBuf.Type receiverType(@NotNull TypeTable var1);

    public abstract int getValueParameterCount();

    @NotNull
    public abstract List<ProtoBuf.ValueParameter> getValueParameters();

    @NotNull
    public abstract List<ProtoBuf.ValueParameter> getContextParameters();

    public /* synthetic */ ClsContractOwner(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner$Function;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner;", "functionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;)V", "getFunctionProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "contract", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "getContract", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "receiverType", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "valueParameterCount", "", "getValueParameterCount", "()I", "valueParameters", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "getValueParameters", "()Ljava/util/List;", "contextParameters", "getContextParameters", "decompiler-to-stubs"})
    public static final class Function
    extends ClsContractOwner {
        @NotNull
        private final ProtoBuf.Function functionProto;

        public Function(@NotNull ProtoBuf.Function functionProto) {
            Intrinsics.checkNotNullParameter((Object)functionProto, (String)"functionProto");
            super(null);
            this.functionProto = functionProto;
        }

        @NotNull
        public final ProtoBuf.Function getFunctionProto() {
            return this.functionProto;
        }

        @Override
        @NotNull
        public ProtoBuf.Contract getContract() {
            ProtoBuf.Contract contract = this.functionProto.getContract();
            Intrinsics.checkNotNullExpressionValue((Object)contract, (String)"getContract(...)");
            return contract;
        }

        @Override
        @Nullable
        public ProtoBuf.Type receiverType(@NotNull TypeTable typeTable) {
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
            return ProtoTypeTableUtilKt.receiverType(this.functionProto, typeTable);
        }

        @Override
        public int getValueParameterCount() {
            return this.functionProto.getValueParameterCount();
        }

        @Override
        @NotNull
        public List<ProtoBuf.ValueParameter> getValueParameters() {
            List<ProtoBuf.ValueParameter> list = this.functionProto.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameterList(...)");
            return list;
        }

        @Override
        @NotNull
        public List<ProtoBuf.ValueParameter> getContextParameters() {
            List<ProtoBuf.ValueParameter> list = this.functionProto.getContextParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContextParameterList(...)");
            return list;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner$PropertyAccessor;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsContractOwner;", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "isGetter", "", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;Z)V", "getPropertyProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "()Z", "contract", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "getContract", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "receiverType", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "valueParameterCount", "", "getValueParameterCount", "()I", "contextParameters", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "getContextParameters", "()Ljava/util/List;", "valueParameters", "getValueParameters", "decompiler-to-stubs"})
    public static final class PropertyAccessor
    extends ClsContractOwner {
        @NotNull
        private final ProtoBuf.Property propertyProto;
        private final boolean isGetter;

        public PropertyAccessor(@NotNull ProtoBuf.Property propertyProto, boolean isGetter) {
            Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
            super(null);
            this.propertyProto = propertyProto;
            this.isGetter = isGetter;
        }

        @NotNull
        public final ProtoBuf.Property getPropertyProto() {
            return this.propertyProto;
        }

        public final boolean isGetter() {
            return this.isGetter;
        }

        @Override
        @NotNull
        public ProtoBuf.Contract getContract() {
            ProtoBuf.Contract contract;
            if (this.isGetter) {
                ProtoBuf.Contract contract2 = this.propertyProto.getGetterContract();
                contract = contract2;
                Intrinsics.checkNotNull((Object)contract2);
            } else {
                ProtoBuf.Contract contract3 = this.propertyProto.getSetterContract();
                contract = contract3;
                Intrinsics.checkNotNull((Object)contract3);
            }
            return contract;
        }

        @Override
        @Nullable
        public ProtoBuf.Type receiverType(@NotNull TypeTable typeTable) {
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
            return ProtoTypeTableUtilKt.receiverType(this.propertyProto, typeTable);
        }

        @Override
        public int getValueParameterCount() {
            return this.isGetter ? 0 : 1;
        }

        @Override
        @NotNull
        public List<ProtoBuf.ValueParameter> getContextParameters() {
            List<ProtoBuf.ValueParameter> list = this.propertyProto.getContextParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContextParameterList(...)");
            return list;
        }

        @Override
        @NotNull
        public List<ProtoBuf.ValueParameter> getValueParameters() {
            return this.isGetter ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.propertyProto.getSetterValueParameter());
        }
    }
}

