/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonIrAttributesKt;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.ConstructorDelegationKind;
import org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalFunctionsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDelegatedPropertiesLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.backend.common.lower.VisibilityPolicy;
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RemapTypesKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SetDeclarationsParentVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTypeTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@PhasePrerequisites(value={SharedVariablesLowering.class, LocalDelegatedPropertiesLowering.class})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0017\u0018\u0000 =2\u00020\u0001:\n=>?@ABCDEFB\u00a5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\n\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\n\u0012\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\n\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000bH\u0016J\u001e\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u0011H\u0016J\u0012\u00102\u001a\b\u0012\u0004\u0012\u00020403*\u000205H\u0014J\u0014\u00106\u001a\u000207*\u0002082\u0006\u00109\u001a\u000207H\u0002J\u0014\u0010:\u001a\u00020&*\u0002082\u0006\u0010;\u001a\u00020*H\u0002J\u0014\u0010<\u001a\u00020&*\u0002082\u0006\u0010;\u001a\u00020*H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001c\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "visibilityPolicy", "Lorg/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;", "forceFieldsForInlineCaptures", "", "remapCapturedTypesInExtractedLocalDeclarations", "closureBuilders", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "transformedDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "newParameterToCaptured", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "newParameterToOld", "oldParameterToNew", "considerRichFunctionReferenceInvokeFunctionsAsLocal", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;ZZLjava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getVisibilityPolicy", "()Lorg/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;", "getForceFieldsForInlineCaptures", "()Z", "getRemapCapturedTypesInExtractedLocalDeclarations", "getClosureBuilders", "()Ljava/util/Map;", "getTransformedDeclarations", "getNewParameterToCaptured", "getNewParameterToOld", "getOldParameterToNew", "getConsiderRichFunctionReferenceInvokeFunctionsAsLocal", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "closestParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getReplacementSymbolForCaptured", "symbol", "getConstructorsThatCouldCaptureParamsWithoutFieldCreating", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "remapType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "type", "remapAllTypes", "body", "remapOnlyOwnTypeParameters", "Companion", "LocalContext", "LocalContextWithClosureAsParameters", "LocalFunctionContext", "LocalClassConstructorContext", "PotentiallyUnusedField", "LocalClassContext", "LocalClassMemberContext", "LocalDeclarationsTransformer", "DeclarationKeyForScope", "ir.backend.common"})
public class LocalDeclarationsLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoweringContext context;
    @NotNull
    private final VisibilityPolicy visibilityPolicy;
    private final boolean forceFieldsForInlineCaptures;
    private final boolean remapCapturedTypesInExtractedLocalDeclarations;
    @NotNull
    private final Map<IrDeclaration, ClosureAnnotator.ClosureBuilder> closureBuilders;
    @NotNull
    private final Map<IrSymbolOwner, IrDeclaration> transformedDeclarations;
    @NotNull
    private final Map<IrValueParameter, IrValueSymbol> newParameterToCaptured;
    @NotNull
    private final Map<IrValueParameter, IrValueParameter> newParameterToOld;
    @NotNull
    private final Map<IrValueParameter, IrValueParameter> oldParameterToNew;
    private final boolean considerRichFunctionReferenceInvokeFunctionsAsLocal;
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE = new IrDeclarationOriginImpl("FIELD_FOR_CAPTURED_VALUE", true);
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE = new IrDeclarationOriginImpl("FIELD_FOR_CROSSINLINE_CAPTURED_VALUE", true);

    public LocalDeclarationsLowering(@NotNull LoweringContext context2, @NotNull VisibilityPolicy visibilityPolicy, boolean forceFieldsForInlineCaptures, boolean remapCapturedTypesInExtractedLocalDeclarations, @NotNull Map<IrDeclaration, ClosureAnnotator.ClosureBuilder> closureBuilders, @NotNull Map<IrSymbolOwner, IrDeclaration> transformedDeclarations, @NotNull Map<IrValueParameter, IrValueSymbol> newParameterToCaptured, @NotNull Map<IrValueParameter, IrValueParameter> newParameterToOld, @NotNull Map<IrValueParameter, IrValueParameter> oldParameterToNew, boolean considerRichFunctionReferenceInvokeFunctionsAsLocal) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)visibilityPolicy, (String)"visibilityPolicy");
        Intrinsics.checkNotNullParameter(closureBuilders, (String)"closureBuilders");
        Intrinsics.checkNotNullParameter(transformedDeclarations, (String)"transformedDeclarations");
        Intrinsics.checkNotNullParameter(newParameterToCaptured, (String)"newParameterToCaptured");
        Intrinsics.checkNotNullParameter(newParameterToOld, (String)"newParameterToOld");
        Intrinsics.checkNotNullParameter(oldParameterToNew, (String)"oldParameterToNew");
        this.context = context2;
        this.visibilityPolicy = visibilityPolicy;
        this.forceFieldsForInlineCaptures = forceFieldsForInlineCaptures;
        this.remapCapturedTypesInExtractedLocalDeclarations = remapCapturedTypesInExtractedLocalDeclarations;
        this.closureBuilders = closureBuilders;
        this.transformedDeclarations = transformedDeclarations;
        this.newParameterToCaptured = newParameterToCaptured;
        this.newParameterToOld = newParameterToOld;
        this.oldParameterToNew = oldParameterToNew;
        this.considerRichFunctionReferenceInvokeFunctionsAsLocal = considerRichFunctionReferenceInvokeFunctionsAsLocal;
    }

    public /* synthetic */ LocalDeclarationsLowering(LoweringContext loweringContext, VisibilityPolicy visibilityPolicy, boolean bl, boolean bl2, Map map, Map map2, Map map3, Map map4, Map map5, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            visibilityPolicy = VisibilityPolicy.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 0x20) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 0x40) != 0) {
            map3 = new LinkedHashMap();
        }
        if ((n & 0x80) != 0) {
            map4 = new LinkedHashMap();
        }
        if ((n & 0x100) != 0) {
            map5 = new LinkedHashMap();
        }
        if ((n & 0x200) != 0) {
            bl3 = false;
        }
        this(loweringContext, visibilityPolicy, bl, bl2, map, map2, map3, map4, map5, bl3);
    }

    @NotNull
    public LoweringContext getContext() {
        return this.context;
    }

    @NotNull
    public final VisibilityPolicy getVisibilityPolicy() {
        return this.visibilityPolicy;
    }

    public final boolean getForceFieldsForInlineCaptures() {
        return this.forceFieldsForInlineCaptures;
    }

    public final boolean getRemapCapturedTypesInExtractedLocalDeclarations() {
        return this.remapCapturedTypesInExtractedLocalDeclarations;
    }

    @NotNull
    public final Map<IrDeclaration, ClosureAnnotator.ClosureBuilder> getClosureBuilders() {
        return this.closureBuilders;
    }

    @NotNull
    public final Map<IrSymbolOwner, IrDeclaration> getTransformedDeclarations() {
        return this.transformedDeclarations;
    }

    @NotNull
    public final Map<IrValueParameter, IrValueSymbol> getNewParameterToCaptured() {
        return this.newParameterToCaptured;
    }

    @NotNull
    public final Map<IrValueParameter, IrValueParameter> getNewParameterToOld() {
        return this.newParameterToOld;
    }

    @NotNull
    public final Map<IrValueParameter, IrValueParameter> getOldParameterToNew() {
        return this.oldParameterToNew;
    }

    public final boolean getConsiderRichFunctionReferenceInvokeFunctionsAsLocal() {
        return this.considerRichFunctionReferenceInvokeFunctionsAsLocal;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix$default(this, irFile, false, 2, null);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        new LocalDeclarationsTransformer(this, irBody, container, this.transformedDeclarations, this.newParameterToCaptured, this.newParameterToOld, this.oldParameterToNew, null, false, 192, null).lowerLocalDeclarations();
    }

    public final void lower(@NotNull IrBlock irBlock, @NotNull IrDeclaration container, @NotNull IrDeclarationParent closestParent) {
        Intrinsics.checkNotNullParameter((Object)irBlock, (String)"irBlock");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)closestParent, (String)"closestParent");
        new LocalDeclarationsTransformer(this, irBlock, container, this.transformedDeclarations, this.newParameterToCaptured, this.newParameterToOld, this.oldParameterToNew, closestParent, true).lowerLocalDeclarations();
    }

    @NotNull
    public IrValueSymbol getReplacementSymbolForCaptured(@NotNull IrDeclaration container, @NotNull IrValueSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return symbol;
    }

    @NotNull
    protected Iterable<IrConstructor> getConstructorsThatCouldCaptureParamsWithoutFieldCreating(@NotNull IrClass $this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating) {
        Intrinsics.checkNotNullParameter((Object)$this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating, (String)"<this>");
        return CollectionsKt.listOfNotNull((Object)IrUtilsKt.getPrimaryConstructor($this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating));
    }

    private final IrType remapType(LocalContext $this$remapType, IrType type) {
        if ($this$remapType.getCapturedTypeParameterToTypeParameter().isEmpty()) {
            return type;
        }
        return $this$remapType.getTypeRemapper().remapType(type);
    }

    private final void remapAllTypes(LocalContext $this$remapAllTypes, IrBody body) {
        if ($this$remapAllTypes.getCapturedTypeParameterToTypeParameter().isEmpty()) {
            return;
        }
        RemapTypesKt.remapTypes(body, $this$remapAllTypes.getTypeRemapper());
    }

    private final void remapOnlyOwnTypeParameters(LocalContext $this$remapOnlyOwnTypeParameters, IrBody body) {
        if ($this$remapOnlyOwnTypeParameters.getOwnTypeParameterMap().isEmpty()) {
            return;
        }
        RemapTypesKt.remapTypes(body, $this$remapOnlyOwnTypeParameters.getOwnTypeParameterRemapper());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$Companion;", "", "<init>", "()V", "DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE", "getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE() {
            return DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE;
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE() {
            return DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0087@\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u00020\fH\u00d6\u0081\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\u0003H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$DeclarationKeyForScope;", "", "name", "", "constructor-impl", "(Ljava/lang/String;)Ljava/lang/String;", "equals", "", "other", "equals-impl", "(Ljava/lang/String;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/String;)I", "toString", "toString-impl", "Companion", "ir.backend.common"})
    public static final class DeclarationKeyForScope {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;

        public static String toString-impl(String arg0) {
            return "DeclarationKeyForScope(name=" + arg0 + ')';
        }

        public String toString() {
            return DeclarationKeyForScope.toString-impl(this.name);
        }

        public static int hashCode-impl(String arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return DeclarationKeyForScope.hashCode-impl(this.name);
        }

        public static boolean equals-impl(String arg0, Object other) {
            if (!(other instanceof DeclarationKeyForScope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((DeclarationKeyForScope)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return DeclarationKeyForScope.equals-impl(this.name, other);
        }

        private /* synthetic */ DeclarationKeyForScope(String name2) {
            this.name = name2;
        }

        private static String constructor-impl(String name2) {
            return name2;
        }

        public static final /* synthetic */ DeclarationKeyForScope box-impl(String v) {
            return new DeclarationKeyForScope(v);
        }

        public final /* synthetic */ String unbox-impl() {
            return this.name;
        }

        public static final boolean equals-impl0(String p1, String p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$DeclarationKeyForScope$Companion;", "", "<init>", "()V", "createDeclarationKeyForScopeBySanitizedName", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$DeclarationKeyForScope;", "name", "Lorg/jetbrains/kotlin/name/Name;", "nameSanitizer", "Lkotlin/Function1;", "", "createDeclarationKeyForScopeBySanitizedName-hBm_5nc", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "ir.backend.common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String createDeclarationKeyForScopeBySanitizedName-hBm_5nc(@NotNull Name name2, @NotNull Function1<? super String, String> nameSanitizer) {
                String string;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter(nameSanitizer, (String)"nameSanitizer");
                if (name2.isSpecial()) {
                    string = name2.asString();
                } else {
                    String string2 = name2.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    string = (String)nameSanitizer.invoke((Object)string2);
                }
                String string3 = string;
                Intrinsics.checkNotNull((Object)string3);
                return DeclarationKeyForScope.constructor-impl(string3);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassConstructorContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "inInlineFunctionScope", "", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;ZLorg/jetbrains/kotlin/ir/IrFileEntry;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getInInlineFunctionScope", "()Z", "transformedDeclaration", "getTransformedDeclaration", "setTransformedDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "ir.backend.common"})
    private static final class LocalClassConstructorContext
    extends LocalContextWithClosureAsParameters {
        @NotNull
        private final IrConstructor declaration;
        private final boolean inInlineFunctionScope;
        public IrConstructor transformedDeclaration;

        public LocalClassConstructorContext(@NotNull IrConstructor declaration, boolean inInlineFunctionScope, @Nullable IrFileEntry sourceFileWhenInlined) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            super(sourceFileWhenInlined);
            this.declaration = declaration;
            this.inInlineFunctionScope = inInlineFunctionScope;
        }

        @Override
        @NotNull
        public IrConstructor getDeclaration() {
            return this.declaration;
        }

        public final boolean getInInlineFunctionScope() {
            return this.inInlineFunctionScope;
        }

        @Override
        @NotNull
        public IrConstructor getTransformedDeclaration() {
            IrConstructor irConstructor = this.transformedDeclaration;
            if (irConstructor != null) {
                return irConstructor;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"transformedDeclaration");
            return null;
        }

        public void setTransformedDeclaration(@NotNull IrConstructor irConstructor) {
            Intrinsics.checkNotNullParameter((Object)irConstructor, (String)"<set-?>");
            this.transformedDeclaration = irConstructor;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u001fH\u0016J\f\u0010(\u001a\u00020\u0005*\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "inInlineFunctionScope", "", "constructorContext", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;ZLorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;Lorg/jetbrains/kotlin/ir/IrFileEntry;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInInlineFunctionScope", "()Z", "getConstructorContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "getSourceFileWhenInlined", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "numberOfOwnTypeParameters", "", "getNumberOfOwnTypeParameters", "()I", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/lower/Closure;)V", "capturedValueToField", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$PotentiallyUnusedField;", "getCapturedValueToField", "()Ljava/util/Map;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "endOffset", "valueDeclaration", "isInlineDeclaration", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1203:1\n1#2:1204\n*E\n"})
    private final class LocalClassContext
    extends LocalContext {
        @NotNull
        private final IrClass declaration;
        private final boolean inInlineFunctionScope;
        @Nullable
        private final LocalContext constructorContext;
        @Nullable
        private final IrFileEntry sourceFileWhenInlined;
        private final int numberOfOwnTypeParameters;
        public Closure closure;
        @NotNull
        private final Map<IrValueDeclaration, PotentiallyUnusedField> capturedValueToField;

        public LocalClassContext(IrClass declaration, @Nullable boolean inInlineFunctionScope, @Nullable LocalContext constructorContext, IrFileEntry sourceFileWhenInlined) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.declaration = declaration;
            this.inInlineFunctionScope = inInlineFunctionScope;
            this.constructorContext = constructorContext;
            this.sourceFileWhenInlined = sourceFileWhenInlined;
            this.numberOfOwnTypeParameters = this.declaration.getTypeParameters().size();
            this.capturedValueToField = new LinkedHashMap();
        }

        @NotNull
        public final IrClass getDeclaration() {
            return this.declaration;
        }

        public final boolean getInInlineFunctionScope() {
            return this.inInlineFunctionScope;
        }

        @Nullable
        public final LocalContext getConstructorContext() {
            return this.constructorContext;
        }

        @Override
        @Nullable
        public IrFileEntry getSourceFileWhenInlined() {
            return this.sourceFileWhenInlined;
        }

        public final int getNumberOfOwnTypeParameters() {
            return this.numberOfOwnTypeParameters;
        }

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure != null) {
                return closure;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"closure");
            return null;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"<set-?>");
            this.closure = closure;
        }

        @NotNull
        public final Map<IrValueDeclaration, PotentiallyUnusedField> getCapturedValueToField() {
            return this.capturedValueToField;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            IrExpression irExpression;
            LocalContext localContext;
            Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
            if (!(LocalDeclarationsLowering.this.getForceFieldsForInlineCaptures() && this.isInlineDeclaration(valueDeclaration) || (localContext = this.constructorContext) == null || (irExpression = localContext.irGet(startOffset, endOffset, valueDeclaration)) == null)) {
                IrExpression it = irExpression;
                boolean bl = false;
                return it;
            }
            PotentiallyUnusedField potentiallyUnusedField = this.capturedValueToField.get(valueDeclaration);
            if (potentiallyUnusedField == null) {
                return null;
            }
            PotentiallyUnusedField field = potentiallyUnusedField;
            IrValueParameter irValueParameter = this.declaration.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrValueParameter receiver = irValueParameter;
            return BuildersKt.IrGetFieldImpl$default(startOffset, endOffset, field.getSymbol(), valueDeclaration.getType(), BuildersKt.IrGetValueImpl$default(startOffset, endOffset, receiver.getType(), receiver.getSymbol(), null, 16, null), null, null, 96, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInlineDeclaration(IrValueDeclaration $this$isInlineDeclaration) {
            if (!($this$isInlineDeclaration instanceof IrValueParameter)) return false;
            IrDeclarationParent it = ((IrValueParameter)$this$isInlineDeclaration).getParent();
            boolean bl = false;
            if (!(it instanceof IrFunction)) return false;
            if (!((IrFunction)it).isInline()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            if (!IrInlineUtilsKt.isInlineParameter((IrValueParameter)$this$isInlineDeclaration)) return false;
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassMemberContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "member", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "classContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;)V", "getMember", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getClassContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "getSourceFileWhenInlined", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "ir.backend.common"})
    private static final class LocalClassMemberContext
    extends LocalContext {
        @NotNull
        private final IrDeclaration member;
        @NotNull
        private final LocalClassContext classContext;

        public LocalClassMemberContext(@NotNull IrDeclaration member, @NotNull LocalClassContext classContext) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            Intrinsics.checkNotNullParameter((Object)classContext, (String)"classContext");
            this.member = member;
            this.classContext = classContext;
        }

        @NotNull
        public final IrDeclaration getMember() {
            return this.member;
        }

        @NotNull
        public final LocalClassContext getClassContext() {
            return this.classContext;
        }

        @Override
        @Nullable
        public IrFileEntry getSourceFileWhenInlined() {
            return this.classContext.getSourceFileWhenInlined();
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
            PotentiallyUnusedField potentiallyUnusedField = this.classContext.getCapturedValueToField().get(valueDeclaration);
            if (potentiallyUnusedField == null) {
                return null;
            }
            PotentiallyUnusedField field = potentiallyUnusedField;
            IrValueParameter irValueParameter = this.member instanceof IrFunction ? ((IrFunction)this.member).getDispatchReceiverParameter() : this.classContext.getDeclaration().getThisReceiver();
            if (irValueParameter == null) {
                throw new IllegalStateException(("No dispatch receiver parameter for " + RenderIrElementKt.render$default(this.member, null, 1, null)).toString());
            }
            IrValueParameter receiver = irValueParameter;
            return BuildersKt.IrGetFieldImpl$default(startOffset, endOffset, field.getSymbol(), valueDeclaration.getType(), BuildersKt.IrGetValueImpl$default(startOffset, endOffset, receiver.getType(), receiver.getSymbol(), null, 16, null), null, null, 96, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH&R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "", "<init>", "()V", "capturedTypeParameterToTypeParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "getCapturedTypeParameterToTypeParameter", "()Ljava/util/Map;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper;", "getTypeRemapper", "()Lorg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper;", "ownTypeParameterMap", "getOwnTypeParameterMap", "ownTypeParameterRemapper", "getOwnTypeParameterRemapper", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "getSourceFileWhenInlined", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "ir.backend.common"})
    public static abstract class LocalContext {
        @NotNull
        private final Map<IrTypeParameter, IrTypeParameter> capturedTypeParameterToTypeParameter = new LinkedHashMap();
        @NotNull
        private final IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(this.capturedTypeParameterToTypeParameter);
        @NotNull
        private final Map<IrTypeParameter, IrTypeParameter> ownTypeParameterMap = new LinkedHashMap();
        @NotNull
        private final IrTypeParameterRemapper ownTypeParameterRemapper = new IrTypeParameterRemapper(this.ownTypeParameterMap);

        @NotNull
        public final Map<IrTypeParameter, IrTypeParameter> getCapturedTypeParameterToTypeParameter() {
            return this.capturedTypeParameterToTypeParameter;
        }

        @NotNull
        public final IrTypeParameterRemapper getTypeRemapper() {
            return this.typeRemapper;
        }

        @NotNull
        public final Map<IrTypeParameter, IrTypeParameter> getOwnTypeParameterMap() {
            return this.ownTypeParameterMap;
        }

        @NotNull
        public final IrTypeParameterRemapper getOwnTypeParameterRemapper() {
            return this.ownTypeParameterRemapper;
        }

        @Nullable
        public abstract IrFileEntry getSourceFileWhenInlined();

        @Nullable
        public abstract IrExpression irGet(int var1, int var2, @NotNull IrValueDeclaration var3);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0010H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrFileEntry;)V", "getSourceFileWhenInlined", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "transformedDeclaration", "getTransformedDeclaration", "capturedValueToParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getCapturedValueToParameter", "()Ljava/util/Map;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "ir.backend.common"})
    public static abstract class LocalContextWithClosureAsParameters
    extends LocalContext {
        @Nullable
        private final IrFileEntry sourceFileWhenInlined;
        @NotNull
        private final Map<IrValueDeclaration, IrValueParameter> capturedValueToParameter;

        public LocalContextWithClosureAsParameters(@Nullable IrFileEntry sourceFileWhenInlined) {
            this.sourceFileWhenInlined = sourceFileWhenInlined;
            this.capturedValueToParameter = new LinkedHashMap();
        }

        @Override
        @Nullable
        public IrFileEntry getSourceFileWhenInlined() {
            return this.sourceFileWhenInlined;
        }

        @NotNull
        public abstract IrFunction getDeclaration();

        @NotNull
        public abstract IrFunction getTransformedDeclaration();

        @NotNull
        public final Map<IrValueDeclaration, IrValueParameter> getCapturedValueToParameter() {
            return this.capturedValueToParameter;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
            IrValueParameter irValueParameter = this.capturedValueToParameter.get(valueDeclaration);
            if (irValueParameter == null) {
                return null;
            }
            IrValueParameter parameter = irValueParameter;
            return BuildersKt.IrGetValueImpl$default(startOffset, endOffset, parameter.getType(), parameter.getSymbol(), null, 16, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002rsB}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u00101\u001a\u000202J\u001a\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u00032\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u001c\u00107\u001a\u0002022\u0006\u00108\u001a\u00020&2\n\u00109\u001a\u00060'R\u00020(H\u0002J\b\u0010:\u001a\u000202H\u0002J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u000202*\u0006\u0012\u0002\b\u00030B2\u0006\u0010C\u001a\u00020\"H\u0002J\b\u0010D\u001a\u000202H\u0002J\u0010\u0010E\u001a\u0002022\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020#H\u0002J>\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000b0K2\u0006\u0010I\u001a\u0002062\u0006\u0010M\u001a\u00020\"2\u0006\u0010N\u001a\u00020\"2\b\b\u0002\u0010O\u001a\u00020\u0011H\u0002J\u0014\u0010P\u001a\u000202*\u00020\"2\u0006\u00105\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u0002022\u0006\u0010S\u001a\u00020,H\u0002J\u001a\u0010T\u001a\b\u0012\u0004\u0012\u00020U0K2\n\u00109\u001a\u00060'R\u00020(H\u0002J9\u0010V\u001a\u000202\"\u0004\b\u0000\u0010W\"\u0004\b\u0001\u0010X*\u000e\u0012\u0004\u0012\u0002HW\u0012\u0004\u0012\u0002HX0\u00072\u0006\u0010Y\u001a\u0002HW2\u0006\u0010Z\u001a\u0002HXH\u0002\u00a2\u0006\u0002\u0010[J(\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a2\b\b\u0002\u0010O\u001a\u00020\u0011H\u0002J3\u0010c\u001a\u00020]2\u0006\u0010d\u001a\u00020b2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020b0fH\u0082\bJ\f\u0010i\u001a\u00020\u0011*\u00020\nH\u0002J\u001d\u0010m\u001a\u0002022\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020o0fH\u0082\bJ\b\u0010p\u001a\u000202H\u0002J\b\u0010q\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0019R!\u0010%\u001a\u0012\u0012\u0004\u0012\u00020&\u0012\b\u0012\u00060'R\u00020(0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0019R\u0017\u0010.\u001a\u0004\u0018\u00010\"*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u0010h\u001a\u00020bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010j\u001a\u00020b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bk\u0010l\u00a8\u0006t"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "newParameterToCaptured", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "newParameterToOld", "oldParameterToNew", "closestParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "dontCaptureOutsideOfContainer", "", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Z)V", "getIrElement", "()Lorg/jetbrains/kotlin/ir/IrElement;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getTransformedDeclarations", "()Ljava/util/Map;", "getNewParameterToCaptured", "getNewParameterToOld", "getOldParameterToNew", "getClosestParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getDontCaptureOutsideOfContainer", "()Z", "localFunctions", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "getLocalFunctions", "localClasses", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "getLocalClasses", "localClassConstructors", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassConstructorContext;", "getLocalClassConstructors", "transformed", "getTransformed", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lowerLocalDeclarations", "", "rewriteFunctionBody", "irDeclaration", "localContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "rewriteClassMembers", "irClass", "localClassContext", "rewriteDeclarations", "createNewCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "oldCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "newCallee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "setLocalTypeArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "callee", "transformDeclarations", "cleanUpLocalFunctionsForUnboundSymbols", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createTransformedSimpleFunction", "localFunctionContext", "createTransformedValueParameters", "", "capturedValues", "oldDeclaration", "newDeclaration", "isExplicitLocalFunction", "recordTransformedValueParameters", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "createTransformedConstructorDeclaration", "constructorContext", "createFieldsForCapturedValues", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "putAbsentOrSame", "K", "V", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "suggestNameForCapturedValue", "Lorg/jetbrains/kotlin/name/Name;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "usedNames", "", "", "findFirstUnusedName", "initialName", "nextName", "Lkotlin/Function1;", "", "CAPTURED_RECEIVER_PREFIX", "isCapturedReceiver", "parentNameSuffixForExtensionReceiver", "getParentNameSuffixForExtensionReceiver", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;)Ljava/lang/String;", "setClosures", "block", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "collectClosureForLocalDeclarations", "collectLocalDeclarations", "FunctionBodiesRewriter", "LocalClassTypeParameterRemapper", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 8 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,1203:1\n1044#1,5:1353\n1044#1,5:1358\n1044#1,5:1363\n1044#1,5:1368\n1044#1,5:1373\n1070#1:1382\n1071#1,2:1384\n1074#1,4:1387\n1070#1:1391\n1071#1,2:1393\n1074#1:1396\n1075#1,2:1398\n1077#1:1401\n812#2,12:1204\n1915#2,2:1244\n1915#2:1246\n812#2,12:1247\n1915#2,2:1259\n1916#2:1261\n1915#2,2:1262\n1807#2,3:1264\n1915#2,2:1267\n1915#2:1270\n1282#2,4:1271\n1916#2:1275\n1915#2,2:1276\n672#2,11:1278\n1915#2:1293\n1661#2,3:1295\n1916#2:1298\n1586#2:1299\n1661#2,3:1300\n1586#2:1303\n1661#2,2:1304\n1663#2:1310\n363#2,7:1311\n1915#2,2:1318\n1915#2,2:1320\n1915#2,2:1322\n1915#2,2:1324\n296#2,2:1330\n1011#3:1216\n1041#3,3:1217\n1044#3,3:1227\n383#4,7:1220\n383#4,7:1346\n139#5,10:1230\n221#5:1240\n222#5:1242\n149#5:1243\n139#5,10:1332\n221#5:1342\n222#5:1344\n149#5:1345\n221#5,2:1378\n221#5,2:1380\n221#5:1383\n222#5:1386\n221#5:1392\n222#5:1395\n221#5:1397\n222#5:1400\n1#6:1241\n1#6:1269\n1#6:1343\n269#7,4:1289\n363#7,4:1306\n315#7,4:1326\n16#8:1294\n*S KotlinDebug\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer\n*L\n1010#1:1353,5\n1015#1:1358,5\n1020#1:1363,5\n1033#1:1368,5\n1037#1:1373,5\n1086#1:1382\n1086#1:1384,2\n1086#1:1387,4\n1095#1:1391\n1095#1:1393,2\n1095#1:1396\n1095#1:1398,2\n1095#1:1401\n620#1:1204,12\n665#1:1244,2\n669#1:1246\n675#1:1247,12\n676#1:1259,2\n669#1:1261\n679#1:1262,2\n683#1:1264,3\n738#1:1267,2\n746#1:1270\n749#1:1271,4\n746#1:1275\n760#1:1276,2\n773#1:1278,11\n813#1:1293\n814#1:1295,3\n813#1:1298\n859#1:1299\n859#1:1300,3\n873#1:1303\n873#1:1304,2\n873#1:1310\n895#1:1311,7\n905#1:1318,2\n912#1:1320,2\n931#1:1322,2\n934#1:1324,2\n953#1:1330,2\n629#1:1216\n629#1:1217,3\n629#1:1227,3\n629#1:1220,7\n996#1:1346,7\n650#1:1230,10\n650#1:1240\n650#1:1242\n650#1:1243\n972#1:1332,10\n972#1:1342\n972#1:1344\n972#1:1345\n1070#1:1378,2\n1074#1:1380,2\n1086#1:1383\n1086#1:1386\n1095#1:1392\n1095#1:1395\n1095#1:1397\n1095#1:1400\n650#1:1241\n972#1:1343\n791#1:1289,4\n875#1:1306,4\n941#1:1326,4\n814#1:1294\n*E\n"})
    private final class LocalDeclarationsTransformer {
        @NotNull
        private final IrElement irElement;
        @NotNull
        private final IrDeclaration container;
        @NotNull
        private final Map<IrSymbolOwner, IrDeclaration> transformedDeclarations;
        @NotNull
        private final Map<IrValueParameter, IrValueSymbol> newParameterToCaptured;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> newParameterToOld;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> oldParameterToNew;
        @Nullable
        private final IrDeclarationParent closestParent;
        private final boolean dontCaptureOutsideOfContainer;
        @NotNull
        private final Map<IrFunction, LocalFunctionContext> localFunctions;
        @NotNull
        private final Map<IrClass, LocalClassContext> localClasses;
        @NotNull
        private final Map<IrConstructor, LocalClassConstructorContext> localClassConstructors;
        @NotNull
        private final String CAPTURED_RECEIVER_PREFIX;
        final /* synthetic */ LocalDeclarationsLowering this$0;

        public LocalDeclarationsTransformer(@NotNull LocalDeclarationsLowering this$0, @NotNull IrElement irElement, @NotNull IrDeclaration container, @NotNull Map<IrSymbolOwner, IrDeclaration> transformedDeclarations, @NotNull Map<IrValueParameter, IrValueSymbol> newParameterToCaptured, @NotNull Map<IrValueParameter, IrValueParameter> newParameterToOld, @Nullable Map<IrValueParameter, IrValueParameter> oldParameterToNew, IrDeclarationParent closestParent, boolean dontCaptureOutsideOfContainer) {
            Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter(transformedDeclarations, (String)"transformedDeclarations");
            Intrinsics.checkNotNullParameter(newParameterToCaptured, (String)"newParameterToCaptured");
            Intrinsics.checkNotNullParameter(newParameterToOld, (String)"newParameterToOld");
            Intrinsics.checkNotNullParameter(oldParameterToNew, (String)"oldParameterToNew");
            this.this$0 = this$0;
            this.irElement = irElement;
            this.container = container;
            this.transformedDeclarations = transformedDeclarations;
            this.newParameterToCaptured = newParameterToCaptured;
            this.newParameterToOld = newParameterToOld;
            this.oldParameterToNew = oldParameterToNew;
            this.closestParent = closestParent;
            this.dontCaptureOutsideOfContainer = dontCaptureOutsideOfContainer;
            this.localFunctions = new LinkedHashMap();
            this.localClasses = new LinkedHashMap();
            this.localClassConstructors = new LinkedHashMap();
            this.CAPTURED_RECEIVER_PREFIX = "$this$";
        }

        public /* synthetic */ LocalDeclarationsTransformer(LocalDeclarationsLowering localDeclarationsLowering, IrElement irElement, IrDeclaration irDeclaration, Map map, Map map2, Map map3, Map map4, IrDeclarationParent irDeclarationParent, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x40) != 0) {
                irDeclarationParent = null;
            }
            if ((n & 0x80) != 0) {
                bl = false;
            }
            this(localDeclarationsLowering, irElement, irDeclaration, map, map2, map3, map4, irDeclarationParent, bl);
        }

        @NotNull
        public final IrElement getIrElement() {
            return this.irElement;
        }

        @NotNull
        public final IrDeclaration getContainer() {
            return this.container;
        }

        @NotNull
        public final Map<IrSymbolOwner, IrDeclaration> getTransformedDeclarations() {
            return this.transformedDeclarations;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueSymbol> getNewParameterToCaptured() {
            return this.newParameterToCaptured;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getNewParameterToOld() {
            return this.newParameterToOld;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getOldParameterToNew() {
            return this.oldParameterToNew;
        }

        @Nullable
        public final IrDeclarationParent getClosestParent() {
            return this.closestParent;
        }

        public final boolean getDontCaptureOutsideOfContainer() {
            return this.dontCaptureOutsideOfContainer;
        }

        @NotNull
        public final Map<IrFunction, LocalFunctionContext> getLocalFunctions() {
            return this.localFunctions;
        }

        @NotNull
        public final Map<IrClass, LocalClassContext> getLocalClasses() {
            return this.localClasses;
        }

        @NotNull
        public final Map<IrConstructor, LocalClassConstructorContext> getLocalClassConstructors() {
            return this.localClassConstructors;
        }

        @Nullable
        public final IrFunction getTransformed(@NotNull IrFunction $this$transformed) {
            Intrinsics.checkNotNullParameter((Object)$this$transformed, (String)"<this>");
            return (IrFunction)this.transformedDeclarations.get($this$transformed);
        }

        public final void lowerLocalDeclarations() {
            this.collectLocalDeclarations();
            if (this.localFunctions.isEmpty() && this.localClasses.isEmpty() && this.transformedDeclarations.isEmpty()) {
                return;
            }
            this.collectClosureForLocalDeclarations();
            this.transformDeclarations();
            this.rewriteDeclarations();
        }

        private final void rewriteFunctionBody(IrElement irDeclaration, LocalContext localContext) {
            IrElementTransformerVoidKt.transformChildrenVoid(irDeclaration, new FunctionBodiesRewriter(localContext));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteClassMembers(IrClass irClass, LocalClassContext localClassContext) {
            List constructorsCallingSuper;
            LocalClassConstructorContext it;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            LocalDeclarationsLowering $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo22 = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof IrConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constructors2 = (List)destination$iv$iv;
            IrElementTransformerVoidKt.transformChildrenVoid(irClass, new FunctionBodiesRewriter(localClassContext));
            Sequence $i$f$filterIsInstance22 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)constructors2), arg_0 -> LocalDeclarationsTransformer.rewriteClassMembers$lambda$0(this, arg_0));
            $this$filterIsInstanceTo$iv$iv = this.this$0;
            boolean $i$f$groupBy = false;
            void $i$f$filterIsInstanceTo22 = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                it = (LocalClassConstructorContext)element$iv$iv;
                boolean bl = false;
                ConstructorDelegationKind key$iv$iv = LowerUtilsKt.delegationKind(it.getDeclaration(), $this$filterIsInstanceTo$iv$iv.getContext());
                Map map = destination$iv$iv2;
                ConstructorDelegationKind key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map constructorsByDelegationKinds = destination$iv$iv2;
            List list = (List)constructorsByDelegationKinds.get((Object)ConstructorDelegationKind.CALLS_SUPER);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            boolean bl = $this$filterIsInstanceTo$iv$iv = !((Collection)(constructorsCallingSuper = list)).isEmpty() || constructorsByDelegationKinds.get((Object)ConstructorDelegationKind.PARTIAL_LINKAGE_ERROR) != null;
            if (_Assertions.ENABLED && !$this$filterIsInstanceTo$iv$iv) {
                boolean bl3 = false;
                String string = "Expected at least one constructor calling super; class: " + irClass;
                throw new AssertionError((Object)string);
            }
            List<IrField> usedCaptureFields = this.createFieldsForCapturedValues(localClassContext);
            CollectionsKt.addAll((Collection)irClass.getDeclarations(), (Iterable)usedCaptureFields);
            Collection collection = CommonIrAttributesKt.getCapturedFields(irClass);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            CommonIrAttributesKt.setCapturedFields(irClass, CollectionsKt.plus((Collection)collection, (Iterable)usedCaptureFields));
            for (LocalClassConstructorContext constructorContext : constructorsCallingSuper) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                IrBlockBody blockBody;
                Object object = constructorContext.getDeclaration().getBody();
                if ((object instanceof IrBlockBody ? (IrBlockBody)object : null) == null) {
                    throw new AssertionError((Object)("Unexpected constructor body: " + constructorContext.getDeclaration().getBody()));
                }
                blockBody = blockBody;
                Map<IrValueDeclaration, PotentiallyUnusedField> $i$f$groupByTo2 = localClassContext.getCapturedValueToField();
                object = this.this$0;
                int n = 0;
                List<IrStatement> list2 = blockBody.getStatements();
                boolean $i$f$mapNotNull = false;
                it = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    IrSetFieldImpl irSetFieldImpl;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    Map.Entry entry = element$iv$iv;
                    boolean bl5 = false;
                    IrValueDeclaration capturedValue = (IrValueDeclaration)entry.getKey();
                    PotentiallyUnusedField field = (PotentiallyUnusedField)entry.getValue();
                    if (field.getSymbolIfUsed() == null) {
                        irSetFieldImpl = null;
                    } else {
                        IrFieldSymbol symbol;
                        IrValueParameter irValueParameter = irClass.getThisReceiver();
                        Intrinsics.checkNotNull((Object)irValueParameter);
                        IrExpression irExpression = BuildersKt.IrGetValueImpl$default(-1, -1, irValueParameter.getSymbol(), null, 8, null);
                        IrExpression irExpression2 = constructorContext.irGet(-1, -1, capturedValue);
                        Intrinsics.checkNotNull((Object)irExpression2);
                        irSetFieldImpl = BuildersKt.IrSetFieldImpl$default(-1, -1, symbol, irExpression, irExpression2, ((LocalDeclarationsLowering)object).getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getSTATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE(), null, 128, null);
                    }
                    if (irSetFieldImpl == null) continue;
                    IrSetFieldImpl it$iv$iv = irSetFieldImpl;
                    boolean bl6 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv3;
                list2.addAll(n, list3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteDeclarations() {
            LocalContext it;
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                this.rewriteFunctionBody(((LocalFunctionContext)it).getDeclaration(), it);
            }
            $this$forEach$iv = this.localClassConstructors.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                LocalClassConstructorContext constructorContext = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.rewriteFunctionBody(constructorContext.getDeclaration(), constructorContext);
                if (!constructorContext.getDeclaration().isPrimary()) continue;
                Iterable iterable = AdditionalIrUtilsKt.getConstructedClass(constructorContext.getDeclaration()).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterator iterator2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IrAnonymousInitializer it2 = (IrAnonymousInitializer)element$iv2;
                    boolean bl2 = false;
                    this.rewriteFunctionBody(it2, constructorContext);
                }
            }
            $this$forEach$iv = this.localClasses.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassContext)element$iv;
                boolean bl = false;
                this.rewriteClassMembers(((LocalClassContext)it).getDeclaration(), (LocalClassContext)it);
            }
            if (this.this$0.getRemapCapturedTypesInExtractedLocalDeclarations()) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.localClasses.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (LocalClassContext)element$iv;
                            boolean bl3 = false;
                            boolean bl4 = !((Collection)((LocalClassContext)it).getClosure().getCapturedTypeParameters()).isEmpty();
                            if (!bl4) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.irElement.accept((IrVisitor)new IrTypeTransformer<Unit, LocalClassContext>(this){
                        final /* synthetic */ LocalDeclarationsTransformer this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void visitElement(IrElement element, LocalClassContext currentLocalClass) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            element.acceptChildren(this, currentLocalClass);
                        }

                        public void visitClass(IrClass declaration, LocalClassContext currentLocalClass) {
                            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                            LocalClassContext newLocalClassContext = this.this$0.getLocalClasses().get(declaration);
                            if (newLocalClassContext == null && LocalDeclarationsLoweringKt.isLocalNotInner(declaration)) {
                                CompilationExceptionKt.compilationException("Encountered a local class not previously collected", declaration);
                                throw new KotlinNothingValueException();
                            }
                            LocalClassContext localClassContext = newLocalClassContext;
                            if (localClassContext == null) {
                                localClassContext = currentLocalClass;
                            }
                            super.visitClass(declaration, localClassContext);
                        }

                        public <Type extends IrType> Type transformTypeRecursively(IrElement container, Type type, LocalClassContext currentLocalClass) {
                            IrType irType;
                            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                            Type Type2 = type;
                            if (Type2 != null) {
                                Type Type3 = Type2;
                                LocalDeclarationsTransformer localDeclarationsTransformer = this.this$0;
                                Type it = Type3;
                                boolean bl = false;
                                irType = localDeclarationsTransformer.new LocalClassTypeParameterRemapper(currentLocalClass).remapType(it);
                            } else {
                                irType = null;
                            }
                            return (Type)irType;
                        }
                    }, null);
                }
            }
            this.rewriteFunctionBody(this.irElement, null);
        }

        private final IrCallImpl createNewCall(IrCall oldCall, IrSimpleFunction newCallee) {
            IrCallImpl irCallImpl;
            IrCallImpl it = irCallImpl = BuildersKt.IrCallImpl(oldCall.getStartOffset(), oldCall.getEndOffset(), oldCall.getType(), newCallee.getSymbol(), newCallee.getTypeParameters().size(), oldCall.getOrigin(), oldCall.getSuperQualifierSymbol());
            boolean bl = false;
            this.setLocalTypeArguments(it, (IrFunction)oldCall.getSymbol().getOwner());
            IrExpressionsKt.copyTypeArgumentsFrom(it, oldCall, newCallee.getTypeParameters().size() - oldCall.getTypeArguments().size());
            return irCallImpl;
        }

        private final void setLocalTypeArguments(IrMemberAccessExpression<?> $this$setLocalTypeArguments, IrFunction callee) {
            LocalFunctionContext localFunctionContext = this.localFunctions.get(callee);
            if (localFunctionContext == null) {
                return;
            }
            LocalFunctionContext context2 = localFunctionContext;
            for (Map.Entry<IrTypeParameter, IrTypeParameter> entry : context2.getCapturedTypeParameterToTypeParameter().entrySet()) {
                IrTypeParameter outerTypeParameter = entry.getKey();
                IrTypeParameter innerTypeParameter = entry.getValue();
                $this$setLocalTypeArguments.getTypeArguments().set(innerTypeParameter.getIndex(), IrTypesKt.getDefaultType(outerTypeParameter));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void transformDeclarations() {
            LocalContextWithClosureAsParameters it;
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                this.createTransformedSimpleFunction((LocalFunctionContext)it);
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(this.container);
            if (irFile != null) {
                IrFile it2 = irFile;
                boolean bl = false;
                this.cleanUpLocalFunctionsForUnboundSymbols(it2);
            }
            $this$forEach$iv = this.localClasses.values();
            LocalDeclarationsLowering $i$f$forEach22 = this.this$0;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$associateTo$iv;
                LocalClassContext it3 = (LocalClassContext)element$iv;
                boolean bl = false;
                AdditionalIrUtilsKt.setOriginallyLocalDeclaration(it3.getDeclaration(), true);
                it3.getDeclaration().setVisibility($i$f$forEach22.getVisibilityPolicy().forClass(it3.getDeclaration(), it3.getInInlineFunctionScope()));
                Iterable iterable = it3.getClosure().getCapturedValues();
                Map<IrValueDeclaration, PotentiallyUnusedField> destination$iv = it3.getCapturedValueToField();
                boolean $i$f$associateTo = false;
                for (Object element$iv2 : $this$associateTo$iv) {
                    Map<IrValueDeclaration, PotentiallyUnusedField> map = destination$iv;
                    IrValueSymbol capturedValue = (IrValueSymbol)element$iv2;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)capturedValue.getOwner(), (Object)new PotentiallyUnusedField());
                    map.put((IrValueDeclaration)pair.getFirst(), (PotentiallyUnusedField)pair.getSecond());
                }
                IrInlineUtilsKt.setSourceFileWhenInlined(it3.getDeclaration(), it3.getSourceFileWhenInlined());
                if (!$i$f$forEach22.getRemapCapturedTypesInExtractedLocalDeclarations()) continue;
                List<IrTypeParameter> capturedTypeParameters = it3.getClosure().getCapturedTypeParameters();
                List newTypeParameters = IrUtilsKt.copyTypeParameters$default(it3.getDeclaration(), capturedTypeParameters, null, null, 6, null);
                MapsKt.putAll(it3.getCapturedTypeParameterToTypeParameter(), (Iterable)CollectionsKt.zip((Iterable)capturedTypeParameters, (Iterable)newTypeParameters));
            }
            $this$forEach$iv = this.localClassConstructors.values();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.createTransformedConstructorDeclaration((LocalClassConstructorContext)it);
            }
        }

        private final void cleanUpLocalFunctionsForUnboundSymbols(IrFile irFile) {
            Object v0;
            block3: {
                Iterable $this$singleOrNull$iv = irFile.getDeclarations();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrClass && IrUtilsKt.isFacadeClass((IrDeclarationParent)((Object)it)))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            Object var3_10 = v0;
            IrClass irClass = var3_10 instanceof IrClass ? (IrClass)var3_10 : null;
            if (irClass == null) {
                return;
            }
            IrClass fileClass = irClass;
            CollectionsKt.removeAll(fileClass.getDeclarations(), LocalDeclarationsTransformer::cleanUpLocalFunctionsForUnboundSymbols$lambda$1);
        }

        /*
         * WARNING - void declaration
         */
        private final void createTransformedSimpleFunction(LocalFunctionContext localFunctionContext) {
            Object it;
            void $this$forEach$iv;
            void $this$buildFun$iv;
            IrSimpleFunction oldDeclaration = localFunctionContext.getDeclaration();
            if (oldDeclaration.getDispatchReceiverParameter() != null) {
                throw new AssertionError((Object)"local functions must not have dispatch receiver");
            }
            Closure closure = localFunctionContext.getClosure();
            List<IrValueSymbol> capturedValues = closure.component1();
            List<IrTypeParameter> capturedTypeParameters = closure.component2();
            IrFactory irFactory = this.this$0.getContext().getIrFactory();
            LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
            boolean $i$f$buildFun22 = false;
            Object $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$createTransformedSimpleFunction_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
            boolean bl2 = false;
            ((IrFunctionBuilder)$this$createTransformedSimpleFunction_u24lambda_u240).updateFrom(oldDeclaration);
            Name name2 = InventNamesForLocalFunctionsKt.getInventedNameForLocalFunction(oldDeclaration);
            if (name2 == null) {
                name2 = oldDeclaration.getName();
            }
            ((IrDeclarationBuilder)$this$createTransformedSimpleFunction_u24lambda_u240).setName(name2);
            ((IrDeclarationBuilder)$this$createTransformedSimpleFunction_u24lambda_u240).setVisibility(localDeclarationsLowering.getVisibilityPolicy().forSimpleFunction(oldDeclaration));
            ((IrFunctionBuilder)$this$createTransformedSimpleFunction_u24lambda_u240).setModality(Modality.FINAL);
            IrSimpleFunction newDeclaration = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv);
            localFunctionContext.setTransformedDeclaration(newDeclaration);
            List newTypeParameters = Intrinsics.areEqual((Object)oldDeclaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINLINE_LAMBDA()) ? CollectionsKt.emptyList() : IrUtilsKt.copyTypeParameters$default(newDeclaration, capturedTypeParameters, null, null, 6, null);
            MapsKt.putAll(localFunctionContext.getCapturedTypeParameterToTypeParameter(), (Iterable)CollectionsKt.zip((Iterable)capturedTypeParameters, (Iterable)newTypeParameters));
            IrUtilsKt.copyTypeParametersFrom$default(newDeclaration, oldDeclaration, null, localFunctionContext.getCapturedTypeParameterToTypeParameter(), 2, null);
            Map ownTypeParameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)oldDeclaration.getTypeParameters(), (Iterable)CollectionsKt.drop((Iterable)newDeclaration.getTypeParameters(), (int)newTypeParameters.size())));
            localFunctionContext.getOwnTypeParameterMap().putAll(ownTypeParameterMap);
            localFunctionContext.getCapturedTypeParameterToTypeParameter().putAll(ownTypeParameterMap);
            Iterable $i$f$buildFun22 = CollectionsKt.drop((Iterable)newDeclaration.getTypeParameters(), (int)newTypeParameters.size());
            $this$buildFun_u24lambda_u240$iv = this.this$0;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                IrTypeParameter tp = (IrTypeParameter)element$iv;
                boolean bl3 = false;
                Collection collection = tp.getSuperTypes();
                IrTypeParameter irTypeParameter = tp;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    IrType irType = (IrType)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    collection2.add(((LocalDeclarationsLowering)$this$buildFun_u24lambda_u240$iv).remapType(localFunctionContext, (IrType)it2));
                }
                irTypeParameter.setSuperTypes(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            }
            newDeclaration.setParent(oldDeclaration.getParent());
            newDeclaration.setReturnType(this.this$0.remapType(localFunctionContext, oldDeclaration.getReturnType()));
            IrDeclarationsKt.copyAttributes$default(newDeclaration, oldDeclaration, false, 2, null);
            AdditionalIrUtilsKt.setOriginallyLocalDeclaration(newDeclaration, true);
            newDeclaration.setParameters(this.createTransformedValueParameters(capturedValues, localFunctionContext, oldDeclaration, newDeclaration, Intrinsics.areEqual((Object)oldDeclaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION())));
            this.recordTransformedValueParameters(newDeclaration, localFunctionContext);
            newDeclaration.setAnnotations(oldDeclaration.getAnnotations());
            IrInlineUtilsKt.setSourceFileWhenInlined(newDeclaration, localFunctionContext.getSourceFileWhenInlined());
            CommonIrAttributesKt.setCustomNameInReflection(newDeclaration, oldDeclaration.getName());
            newDeclaration.setBody(oldDeclaration.getBody());
            if (this.this$0.getRemapCapturedTypesInExtractedLocalDeclarations()) {
                IrBody irBody = newDeclaration.getBody();
                if (irBody != null) {
                    $this$buildFun_u24lambda_u240$iv = irBody;
                    LocalDeclarationsLowering $i$f$forEach2 = this.this$0;
                    it = $this$buildFun_u24lambda_u240$iv;
                    boolean bl5 = false;
                    $i$f$forEach2.remapAllTypes(localFunctionContext, (IrBody)it);
                }
            } else {
                IrBody irBody = newDeclaration.getBody();
                if (irBody != null) {
                    $this$buildFun_u24lambda_u240$iv = irBody;
                    LocalDeclarationsLowering $i$f$forEach2 = this.this$0;
                    it = $this$buildFun_u24lambda_u240$iv;
                    boolean bl6 = false;
                    $i$f$forEach2.remapOnlyOwnTypeParameters(localFunctionContext, (IrBody)it);
                }
            }
            for (IrValueParameter argument : oldDeclaration.getParameters()) {
                IrExpressionBody body;
                if (argument.getDefaultValue() == null) continue;
                if (this.this$0.getRemapCapturedTypesInExtractedLocalDeclarations()) {
                    this.this$0.remapAllTypes(localFunctionContext, body);
                } else {
                    this.this$0.remapOnlyOwnTypeParameters(localFunctionContext, body);
                }
                IrValueParameter irValueParameter = this.oldParameterToNew.get(argument);
                Intrinsics.checkNotNull((Object)irValueParameter);
                irValueParameter.setDefaultValue(body);
            }
            this.transformedDeclarations.put(oldDeclaration, newDeclaration);
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrValueParameter> createTransformedValueParameters(List<? extends IrValueSymbol> capturedValues, LocalContext localFunctionContext, IrFunction oldDeclaration, IrFunction newDeclaration, boolean isExplicitLocalFunction) {
            int n;
            Object $this$indexOfFirst$iv;
            List parametersForCapturedValues;
            Object object;
            List transformedParameters;
            block6: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                IrParameterKind[] irParameterKindArray;
                Object object2;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable = oldDeclaration.getParameters();
                LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    IrValueParameter irValueParameter;
                    IrParameterKind[] irParameterKindArray2;
                    void param;
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v0 = param;
                    IrFunction irFunction = newDeclaration;
                    IrDeclarationOrigin irDeclarationOrigin = null;
                    int n2 = 0;
                    int n3 = 0;
                    Name name2 = null;
                    Map map = null;
                    IrType irType = localDeclarationsLowering.remapType(localFunctionContext, param.getType());
                    if (param.getVarargElementType() != null) {
                        void it;
                        object2 = irType;
                        Map map2 = map;
                        Name name3 = name2;
                        int n4 = n3;
                        int n5 = n2;
                        IrDeclarationOrigin irDeclarationOrigin2 = irDeclarationOrigin;
                        IrFunction irFunction2 = irFunction;
                        void var25_43 = v0;
                        boolean bl2 = false;
                        irParameterKindArray = localDeclarationsLowering.remapType(localFunctionContext, (IrType)it);
                        v0 = var25_43;
                        irFunction = irFunction2;
                        irDeclarationOrigin = irDeclarationOrigin2;
                        n2 = n5;
                        n3 = n4;
                        name2 = name3;
                        map = map2;
                        irType = object2;
                        irParameterKindArray2 = irParameterKindArray;
                    } else {
                        irParameterKindArray2 = null;
                    }
                    IrValueParameter it = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)v0, irFunction, irDeclarationOrigin, n2, n3, name2, map, irType, irParameterKindArray2, null, false, false, false, null, null, 16190, null);
                    boolean bl3 = false;
                    this.putAbsentOrSame(this.newParameterToOld, it, param);
                    collection.add(irValueParameter);
                }
                transformedParameters = (List)destination$iv$iv;
                Map parametersMapping = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)oldDeclaration.getParameters(), (Iterable)transformedParameters));
                this.this$0.getContext().remapMultiFieldValueClassStructure(oldDeclaration, newDeclaration, parametersMapping);
                Set generatedNames = new LinkedHashSet();
                $this$mapTo$iv$iv2 = capturedValues;
                object = this.this$0;
                boolean $i$f$map2 = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IrValueParameter irValueParameter;
                    void capturedValue;
                    object2 = (IrValueSymbol)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    IrValueDeclaration p = capturedValue.getOwner();
                    IrDeclaration declaration$iv = newDeclaration;
                    boolean $i$f$buildValueParameter = false;
                    IrValueParameterBuilder $this$buildValueParameter_u24lambda_u241$iv = new IrValueParameterBuilder();
                    boolean bl4 = false;
                    IrValueParameterBuilder $this$createTransformedValueParameters_u24lambda_u241_u240 = $this$buildValueParameter_u24lambda_u241$iv;
                    boolean bl5 = false;
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setStartOffset(p.getStartOffset());
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setEndOffset(p.getEndOffset());
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setOrigin(p instanceof IrValueParameter && CollectionsKt.listOf((Object[])(irParameterKindArray = new IrParameterKind[]{IrParameterKind.DispatchReceiver, IrParameterKind.ExtensionReceiver})).contains((Object)((IrValueParameter)p).getKind()) && newDeclaration instanceof IrConstructor ? LocalDeclarationsLoweringKt.getBOUND_RECEIVER_PARAMETER() : LocalDeclarationsLoweringKt.getBOUND_VALUE_PARAMETER());
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setName(this.suggestNameForCapturedValue(p, generatedNames, isExplicitLocalFunction));
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setKind(IrParameterKind.Regular);
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setType(((LocalDeclarationsLowering)object).remapType(localFunctionContext, p.getType()));
                    Object object3 = capturedValue instanceof IrValueParameterSymbol ? (IrValueParameterSymbol)capturedValue : null;
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setCrossInline(object3 != null && (object3 = (IrValueParameter)object3.getOwner()) != null ? ((IrValueParameter)object3).isCrossinline() : false);
                    Object object4 = capturedValue instanceof IrValueParameterSymbol ? (IrValueParameterSymbol)capturedValue : null;
                    $this$createTransformedValueParameters_u24lambda_u241_u240.setNoinline(object4 != null && (object4 = (IrValueParameter)object4.getOwner()) != null ? ((IrValueParameter)object4).isNoinline() : false);
                    IrValueParameter it = irValueParameter = DeclarationBuildersKt.buildValueParameter(declaration$iv.getFactory(), $this$buildValueParameter_u24lambda_u241$iv, (IrDeclarationParent)((Object)declaration$iv));
                    boolean bl6 = false;
                    this.newParameterToCaptured.put(it, (IrValueSymbol)capturedValue);
                    collection.add(irValueParameter);
                }
                parametersForCapturedValues = (List)destination$iv$iv2;
                $this$indexOfFirst$iv = transformedParameters;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator iterator3 = $this$indexOfFirst$iv.iterator();
                while (iterator3.hasNext()) {
                    Object item$iv = iterator3.next();
                    IrValueParameter it = (IrValueParameter)item$iv;
                    boolean bl = false;
                    if (it.getKind() == IrParameterKind.Regular) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            $this$indexOfFirst$iv = n;
            int it = ((Number)$this$indexOfFirst$iv).intValue();
            boolean bl = false;
            Object object5 = it != -1 ? $this$indexOfFirst$iv : null;
            int capturedValuesStartIndex = object5 != null ? ((Integer)object5).intValue() : transformedParameters.size();
            Object $this$createTransformedValueParameters_u24lambda_u244 = object = CollectionsKt.createListBuilder();
            boolean bl7 = false;
            $this$createTransformedValueParameters_u24lambda_u244.addAll(transformedParameters);
            $this$createTransformedValueParameters_u24lambda_u244.addAll(capturedValuesStartIndex, parametersForCapturedValues);
            return CollectionsKt.build((List)object);
        }

        static /* synthetic */ List createTransformedValueParameters$default(LocalDeclarationsTransformer localDeclarationsTransformer, List list, LocalContext localContext, IrFunction irFunction, IrFunction irFunction2, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return localDeclarationsTransformer.createTransformedValueParameters(list, localContext, irFunction, irFunction2, bl);
        }

        private final void recordTransformedValueParameters(IrFunction $this$recordTransformedValueParameters, LocalContextWithClosureAsParameters localContext) {
            IrValueParameter it;
            Iterable $this$forEach$iv = $this$recordTransformedValueParameters.getParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrValueParameter)element$iv;
                boolean bl = false;
                IrValueSymbol capturedValue = this.newParameterToCaptured.get(it);
                if (capturedValue == null) continue;
                localContext.getCapturedValueToParameter().put(capturedValue.getOwner(), it);
            }
            $this$forEach$iv = $this$recordTransformedValueParameters.getParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrValueParameter)element$iv;
                boolean bl = false;
                IrValueParameter oldParameter = this.newParameterToOld.get(it);
                if (oldParameter == null) continue;
                this.putAbsentOrSame(this.oldParameterToNew, oldParameter, it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void createTransformedConstructorDeclaration(LocalClassConstructorContext constructorContext) {
            Object v1;
            IrConstructor newDeclaration;
            Object object;
            List<IrValueSymbol> capturedValues;
            LocalClassContext localClassContext;
            IrConstructor oldDeclaration;
            block5: {
                void $this$firstOrNull$iv;
                void $this$buildConstructor$iv;
                oldDeclaration = constructorContext.getDeclaration();
                LocalClassContext localClassContext2 = this.localClasses.get(oldDeclaration.getParent());
                Intrinsics.checkNotNull((Object)localClassContext2);
                localClassContext = localClassContext2;
                capturedValues = localClassContext.getClosure().getCapturedValues();
                IrConstructor irConstructor = CommonIrAttributesKt.getCapturedConstructor(oldDeclaration);
                if (irConstructor != null) {
                    Pair pair;
                    IrConstructor newDeclaration2 = irConstructor;
                    boolean bl = false;
                    this.transformedDeclarations.put(oldDeclaration, newDeclaration2);
                    constructorContext.setTransformedDeclaration(newDeclaration2);
                    Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)newDeclaration2.getParameters(), (Iterable)capturedValues);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        pair = (Pair)element$iv;
                        boolean bl2 = false;
                        IrValueParameter it = (IrValueParameter)pair.component1();
                        IrValueSymbol capturedValue = (IrValueSymbol)pair.component2();
                        this.newParameterToCaptured.put(it, capturedValue);
                    }
                    $this$forEach$iv = CollectionsKt.zip((Iterable)oldDeclaration.getParameters(), (Iterable)newDeclaration2.getParameters());
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        pair = (Pair)element$iv;
                        boolean bl3 = false;
                        IrValueParameter v = (IrValueParameter)pair.component1();
                        IrValueParameter it = (IrValueParameter)pair.component2();
                        this.putAbsentOrSame(this.newParameterToOld, it, v);
                    }
                    this.recordTransformedValueParameters(newDeclaration2, constructorContext);
                    return;
                }
                object = this.this$0.getContext().getIrFactory();
                Object newDeclaration2 = this.this$0;
                boolean $i$f$buildConstructor = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$createTransformedConstructorDeclaration_u24lambda_u241 = $this$buildConstructor_u24lambda_u241$iv;
                boolean bl4 = false;
                $this$createTransformedConstructorDeclaration_u24lambda_u241.updateFrom(oldDeclaration);
                $this$createTransformedConstructorDeclaration_u24lambda_u241.setVisibility(((LocalDeclarationsLowering)newDeclaration2).getVisibilityPolicy().forConstructor(oldDeclaration, constructorContext.getInInlineFunctionScope()));
                $this$createTransformedConstructorDeclaration_u24lambda_u241.setReturnType(oldDeclaration.getReturnType());
                newDeclaration = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, $this$buildConstructor_u24lambda_u241$iv);
                constructorContext.setTransformedDeclaration(newDeclaration);
                newDeclaration.setParent(localClassContext.getDeclaration());
                IrUtilsKt.copyTypeParametersFrom$default(newDeclaration, oldDeclaration, null, null, 6, null);
                newDeclaration2 = oldDeclaration.getParameters();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl5 = false;
                    if (!(it.getKind() == IrParameterKind.DispatchReceiver || it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            object = v1;
            if (object != null) {
                Object $this$createTransformedConstructorDeclaration_u24lambda_u243 = object;
                boolean bl = false;
                throw new AssertionError((Object)("Local class constructor can't have " + (Object)((Object)((IrValueParameter)$this$createTransformedConstructorDeclaration_u24lambda_u243).getKind()) + ": " + IrUtilsKt.ir2string(oldDeclaration)));
            }
            newDeclaration.setParameters(LocalDeclarationsTransformer.createTransformedValueParameters$default(this, capturedValues, localClassContext, oldDeclaration, newDeclaration, false, 16, null));
            this.recordTransformedValueParameters(newDeclaration, constructorContext);
            newDeclaration.setAnnotations(oldDeclaration.getAnnotations());
            newDeclaration.setMetadata(oldDeclaration.getMetadata());
            this.transformedDeclarations.put(oldDeclaration, newDeclaration);
            CommonIrAttributesKt.setCapturedConstructor(oldDeclaration, newDeclaration);
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrField> createFieldsForCapturedValues(LocalClassContext localClassContext) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            IrClass classDeclaration = localClassContext.getDeclaration();
            Set generatedNames = new LinkedHashSet();
            Map<IrValueDeclaration, PotentiallyUnusedField> map = localClassContext.getCapturedValueToField();
            LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                IrField irField;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                IrValueDeclaration capturedValue = (IrValueDeclaration)entry.getKey();
                PotentiallyUnusedField field = (PotentiallyUnusedField)entry.getValue();
                if (field.getSymbolIfUsed() == null) {
                    irField = null;
                } else {
                    IrFieldSymbol symbol;
                    IrField irField2;
                    IrDeclarationOriginImpl origin = capturedValue instanceof IrValueParameter && ((IrValueParameter)capturedValue).isCrossinline() ? Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE() : Companion.getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE();
                    IrField it = irField2 = localDeclarationsLowering.getContext().getIrFactory().createField(classDeclaration.getStartOffset(), classDeclaration.getEndOffset(), origin, LocalDeclarationsTransformer.suggestNameForCapturedValue$default(this, capturedValue, generatedNames, false, 4, null), localDeclarationsLowering.getVisibilityPolicy().forCapturedField(capturedValue.getSymbol()), symbol, capturedValue.getType(), true, false, false);
                    boolean bl3 = false;
                    it.setParent(classDeclaration);
                    irField = irField2;
                }
                if (irField == null) continue;
                IrField it$iv$iv = irField;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final <K, V> void putAbsentOrSame(Map<K, V> $this$putAbsentOrSame, K key, V value2) {
            Object current;
            Object v;
            void $this$getOrPut$iv;
            Map<K, V> map = $this$putAbsentOrSame;
            K key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                V answer$iv = value2;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                v = answer$iv;
            } else {
                v = value$iv;
            }
            if (!Intrinsics.areEqual(current = v, value2)) {
                throw new IllegalStateException((current + " != " + value2).toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Name suggestNameForCapturedValue(IrValueDeclaration declaration, Set<String> usedNames, boolean isExplicitLocalFunction) {
            Name name2;
            if (declaration instanceof IrValueParameter) {
                if (Intrinsics.areEqual((Object)declaration.getName().asString(), (Object)"<this>") && ((IrValueParameter)declaration).getKind() == IrParameterKind.DispatchReceiver) {
                    void initialName$iv2;
                    LocalDeclarationsTransformer localDeclarationsTransformer = this;
                    String string = "this$0";
                    Set<String> usedNames$iv = usedNames;
                    boolean $i$f$findFirstUnusedName = false;
                    String chosen$iv = initialName$iv2;
                    int suffix$iv = 0;
                    while (!usedNames$iv.add(chosen$iv)) {
                        int it = ++suffix$iv;
                        boolean bl = false;
                        chosen$iv = "this$" + it;
                    }
                    Name name3 = Name.identifier(chosen$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                    return name3;
                }
                if (Intrinsics.areEqual((Object)declaration.getName().asString(), (Object)"<this>") && ((IrValueParameter)declaration).getKind() == IrParameterKind.ExtensionReceiver) {
                    void initialName$iv;
                    String parentNameSuffix = this.getParentNameSuffixForExtensionReceiver((IrValueParameter)declaration);
                    LocalDeclarationsTransformer initialName$iv2 = this;
                    String usedNames$iv = "$this_" + parentNameSuffix;
                    Set<String> usedNames$iv2 = usedNames;
                    boolean $i$f$findFirstUnusedName = false;
                    String chosen$iv = initialName$iv;
                    int suffix$iv = 0;
                    while (!usedNames$iv2.add(chosen$iv)) {
                        int it = ++suffix$iv;
                        boolean bl = false;
                        chosen$iv = "$this_" + parentNameSuffix + '$' + it;
                    }
                    Name name4 = Name.identifier(chosen$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
                    return name4;
                }
                if (this.isCapturedReceiver((IrValueParameter)declaration)) {
                    String string = declaration.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    String baseName = StringsKt.removePrefix((String)string, (CharSequence)this.CAPTURED_RECEIVER_PREFIX);
                    LocalDeclarationsTransformer this_$iv = this;
                    String initialName$iv = "$this_" + baseName;
                    Set<String> usedNames$iv = usedNames;
                    boolean $i$f$findFirstUnusedName = false;
                    String chosen$iv = initialName$iv;
                    int suffix$iv = 0;
                    while (!usedNames$iv.add(chosen$iv)) {
                        int it = ++suffix$iv;
                        boolean bl = false;
                        chosen$iv = "$this_" + baseName + '$' + it;
                    }
                    Name name5 = Name.identifier(chosen$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
                    return name5;
                }
            }
            Object this_$iv = declaration.getName().isSpecial() ? declaration.getName().asStringStripSpecialMarkers() : declaration.getName().asString();
            Intrinsics.checkNotNull((Object)this_$iv);
            String base = this_$iv;
            if (isExplicitLocalFunction && declaration instanceof IrVariable) {
                this_$iv = this;
                String initialName$iv = base;
                Set<String> usedNames$iv = usedNames;
                boolean $i$f$findFirstUnusedName = false;
                String chosen$iv = initialName$iv;
                int suffix$iv = 0;
                while (!usedNames$iv.add(chosen$iv)) {
                    int it = ++suffix$iv;
                    boolean bl = false;
                    chosen$iv = base + '$' + it;
                }
                Name name6 = Name.identifier(chosen$iv);
                name2 = name6;
                Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(...)");
            } else {
                this_$iv = this;
                String initialName$iv = DescriptorUtilsKt.getSynthesizedString(base);
                Set<String> usedNames$iv = usedNames;
                boolean $i$f$findFirstUnusedName = false;
                String chosen$iv = initialName$iv;
                int suffix$iv = 0;
                while (!usedNames$iv.add(chosen$iv)) {
                    int it = ++suffix$iv;
                    boolean bl = false;
                    chosen$iv = DescriptorUtilsKt.getSynthesizedString(base + '$' + it);
                }
                Name name7 = Name.identifier(chosen$iv);
                name2 = name7;
                Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
            }
            return name2;
        }

        static /* synthetic */ Name suggestNameForCapturedValue$default(LocalDeclarationsTransformer localDeclarationsTransformer, IrValueDeclaration irValueDeclaration, Set set, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return localDeclarationsTransformer.suggestNameForCapturedValue(irValueDeclaration, set, bl);
        }

        private final boolean isCapturedReceiver(IrValueParameter $this$isCapturedReceiver) {
            String string = $this$isCapturedReceiver.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return StringsKt.startsWith$default((String)string, (String)this.CAPTURED_RECEIVER_PREFIX, (boolean)false, (int)2, null);
        }

        private final String getParentNameSuffixForExtensionReceiver(IrValueParameter $this$parentNameSuffixForExtensionReceiver) {
            String string;
            IrDeclarationParent irDeclarationParent = $this$parentNameSuffixForExtensionReceiver.getParent();
            IrSimpleFunction irSimpleFunction = irDeclarationParent instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclarationParent : null;
            if (irSimpleFunction == null) {
                throw new AssertionError((Object)("Extension receiver parent is not a simple function: " + RenderIrElementKt.render$default($this$parentNameSuffixForExtensionReceiver.getParent(), null, 1, null)));
            }
            IrSimpleFunction parentFun = irSimpleFunction;
            IrPropertySymbol irPropertySymbol = parentFun.getCorrespondingPropertySymbol();
            IrProperty correspondingProperty = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (correspondingProperty != null) {
                String string2 = correspondingProperty.getName().asStringStripSpecialMarkers();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringStripSpecialMarkers(...)");
            } else {
                String string3 = parentFun.getName().asStringStripSpecialMarkers();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringStripSpecialMarkers(...)");
            }
            return string;
        }

        private final void collectClosureForLocalDeclarations() {
            if (this.dontCaptureOutsideOfContainer) {
                Closure closure;
                IrDeclaration it;
                boolean bl;
                LocalFunctionContext localFunctionContext;
                LocalContext context$iv;
                IrDeclarationBase declaration$iv;
                Map.Entry<IrFunction, LocalFunctionContext> entry;
                Map.Entry<IrDeclarationBase, LocalContext> element$iv$iv;
                IrDeclarationParent irDeclarationParent;
                ClosureAnnotator annotator = new ClosureAnnotator(this.irElement, this.this$0.getClosureBuilders(), (irDeclarationParent = this.closestParent) instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null);
                Set rootCapturedValues = CollectionsKt.toSet((Iterable)annotator.getRootClosure().getCapturedValues());
                Set rootCapturedTypeParameters = CollectionsKt.toSet((Iterable)annotator.getRootClosure().getCapturedTypeParameters());
                LocalDeclarationsTransformer this_$iv = this;
                boolean $i$f$setClosures = false;
                Map<IrDeclarationBase, LocalContext> $this$forEach$iv$iv = this_$iv.localFunctions;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<IrDeclarationBase, LocalContext>> iterator2 = $this$forEach$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = element$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    declaration$iv = entry.getKey();
                    context$iv = entry.getValue();
                    IrDeclaration irDeclaration = declaration$iv;
                    localFunctionContext = context$iv;
                    bl = false;
                    closure = annotator.getClosure(it);
                    localFunctionContext.setClosure(new Closure(CollectionsKt.minus((Iterable)closure.getCapturedValues(), (Iterable)rootCapturedValues), CollectionsKt.minus((Iterable)closure.getCapturedTypeParameters(), (Iterable)rootCapturedTypeParameters)));
                }
                $this$forEach$iv$iv = this_$iv.localClasses;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = element$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    declaration$iv = (IrClass)((Object)entry.getKey());
                    context$iv = (LocalClassContext)((Object)entry.getValue());
                    it = declaration$iv;
                    localFunctionContext = context$iv;
                    bl = false;
                    closure = annotator.getClosure(it);
                    ((LocalClassContext)((Object)localFunctionContext)).setClosure(new Closure(CollectionsKt.minus((Iterable)closure.getCapturedValues(), (Iterable)rootCapturedValues), CollectionsKt.minus((Iterable)closure.getCapturedTypeParameters(), (Iterable)rootCapturedTypeParameters)));
                }
            } else {
                IrDeclaration it;
                boolean bl;
                LocalFunctionContext localFunctionContext;
                LocalContext context$iv;
                IrDeclarationBase declaration$iv;
                Map.Entry<IrFunction, LocalFunctionContext> entry;
                Map.Entry<IrDeclarationBase, LocalContext> element$iv$iv;
                ClosureAnnotator annotator = new ClosureAnnotator(this.irElement, this.container, this.this$0.getClosureBuilders(), false, 8, null);
                LocalDeclarationsTransformer this_$iv = this;
                boolean $i$f$setClosures = false;
                Map<IrDeclarationBase, LocalContext> $this$forEach$iv$iv = this_$iv.localFunctions;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<IrDeclarationBase, LocalContext>> iterator3 = $this$forEach$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    entry = element$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    declaration$iv = entry.getKey();
                    context$iv = entry.getValue();
                    IrDeclaration declaration$iv2 = declaration$iv;
                    localFunctionContext = context$iv;
                    bl = false;
                    localFunctionContext.setClosure(annotator.getClosure(it));
                }
                $this$forEach$iv$iv = this_$iv.localClasses;
                $i$f$forEach = false;
                iterator3 = $this$forEach$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    entry = element$iv$iv = iterator3.next();
                    boolean bl5 = false;
                    declaration$iv = (IrClass)((Object)entry.getKey());
                    context$iv = (LocalClassContext)((Object)entry.getValue());
                    it = declaration$iv;
                    localFunctionContext = context$iv;
                    bl = false;
                    ((LocalClassContext)((Object)localFunctionContext)).setClosure(annotator.getClosure(it));
                }
            }
        }

        private final void collectLocalDeclarations() {
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"org/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$collectLocalDeclarations$Data", "", "isInInlineFunction", "", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(ZLorg/jetbrains/kotlin/ir/IrFileEntry;)V", "()Z", "getSourceFileWhenInlined", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "ir.backend.common"})
            public final class Data {
                private final boolean isInInlineFunction;
                private final IrFileEntry sourceFileWhenInlined;

                public Data(boolean isInInlineFunction, IrFileEntry sourceFileWhenInlined) {
                    this.isInInlineFunction = isInInlineFunction;
                    this.sourceFileWhenInlined = sourceFileWhenInlined;
                }

                public /* synthetic */ Data(boolean bl, IrFileEntry irFileEntry, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        irFileEntry = null;
                    }
                    this(bl, irFileEntry);
                }

                public final boolean isInInlineFunction() {
                    return this.isInInlineFunction;
                }

                public final IrFileEntry getSourceFileWhenInlined() {
                    return this.sourceFileWhenInlined;
                }
            }
            this.irElement.accept((IrVisitor)new IrVisitor<Unit, Data>(this.this$0, this){
                final /* synthetic */ LocalDeclarationsLowering this$0;
                final /* synthetic */ LocalDeclarationsTransformer this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void visitElement(IrElement element, Data data) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    element.acceptChildren(this, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Data data) {
                    Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    super.visitInlinedFunctionBlock(inlinedBlock, new Data(IrInlineUtilsKt.isFunctionInlining(inlinedBlock), inlinedBlock.getInlinedFunctionFileEntry()));
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, Data data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    expression2.getFunction().acceptChildren(this, data);
                }

                public void visitRichFunctionReference(IrRichFunctionReference expression2, Data data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    if (this.this$0.getConsiderRichFunctionReferenceInvokeFunctionsAsLocal()) {
                        super.visitRichFunctionReference(expression2, data);
                    } else {
                        Iterable $this$forEach$iv = expression2.getBoundValues();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IrExpression it = (IrExpression)element$iv;
                            boolean bl = false;
                            it.accept(this, data);
                        }
                        expression2.getInvokeFunction().acceptChildren(this, data);
                    }
                }

                public void visitRichPropertyReference(IrRichPropertyReference expression2, Data data) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        Iterable $this$forEach$iv = expression2.getBoundValues();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IrExpression it = (IrExpression)element$iv;
                            boolean bl = false;
                            it.accept(this, data);
                        }
                        expression2.getGetterFunction().acceptChildren(this, data);
                        IrSimpleFunction irSimpleFunction = expression2.getSetterFunction();
                        if (irSimpleFunction == null) break block1;
                        irSimpleFunction.acceptChildren(this, data);
                    }
                }

                public void visitSimpleFunction(IrSimpleFunction declaration, Data data) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    if (Intrinsics.areEqual((Object)declaration.getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                        this.this$1.getLocalFunctions().put(declaration, new LocalFunctionContext(declaration, data.getSourceFileWhenInlined()));
                    }
                    Data newData = new Data(declaration.isInline(), data.getSourceFileWhenInlined());
                    super.visitSimpleFunction(declaration, newData);
                }

                public void visitConstructor(IrConstructor declaration, Data data) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    super.visitConstructor(declaration, data);
                    if (!LocalDeclarationsLoweringKt.isLocalNotInner(AdditionalIrUtilsKt.getConstructedClass(declaration))) {
                        return;
                    }
                    this.this$1.getLocalClassConstructors().put(declaration, new LocalClassConstructorContext(declaration, this.getInInlineFunctionScope(data), data.getSourceFileWhenInlined()));
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitClass(IrClass declaration, Data data) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    super.visitClass(declaration, data);
                    if (!LocalDeclarationsLoweringKt.isLocalNotInner(declaration)) {
                        return;
                    }
                    Iterable<IrConstructor> iterable = this.this$0.getConstructorsThatCouldCaptureParamsWithoutFieldCreating(declaration);
                    LocalDeclarationsTransformer localDeclarationsTransformer = this.this$1;
                    boolean $i$f$mapNotNull = false;
                    void var7_6 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        LocalClassConstructorContext it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        IrConstructor it = (IrConstructor)element$iv$iv;
                        boolean bl2 = false;
                        if (localDeclarationsTransformer.getLocalClassConstructors().get(it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    LocalClassConstructorContext constructorContext = (LocalClassConstructorContext)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                    this.this$1.getLocalClasses().put(declaration, this.this$0.new LocalClassContext(declaration, this.getInInlineFunctionScope(data), constructorContext, data.getSourceFileWhenInlined()));
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private final boolean getInInlineFunctionScope(Data $this$inInlineFunctionScope) {
                    boolean bl;
                    if ($this$inInlineFunctionScope.isInInlineFunction()) return true;
                    Sequence $this$any$iv = SequencesKt.generateSequence((Object)this.this$1.getContainer(), collectLocalDeclarations.1::_get_inInlineFunctionScope_$lambda$3);
                    boolean $i$f$any = false;
                    Iterator iterator2 = $this$any$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return false;
                        E element$iv = iterator2.next();
                        IrDeclaration it = (IrDeclaration)element$iv;
                        boolean bl2 = false;
                        if (it instanceof IrFunction && ((IrFunction)it).isInline()) {
                            return true;
                        }
                        bl = false;
                    } while (!bl);
                    return true;
                }

                private static final IrDeclaration _get_inInlineFunctionScope_$lambda$3(IrDeclaration it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IrDeclarationParent irDeclarationParent = it.getParent();
                    return irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
                }
            }, new Data(false, null));
        }

        private static final LocalClassConstructorContext rewriteClassMembers$lambda$0(LocalDeclarationsTransformer this$0, IrConstructor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LocalClassConstructorContext localClassConstructorContext = this$0.localClassConstructors.get(it);
            Intrinsics.checkNotNull((Object)localClassConstructorContext);
            return localClassConstructorContext;
        }

        private static final boolean cleanUpLocalFunctionsForUnboundSymbols$lambda$1(IrDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return declaration instanceof IrFunction && Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFILLED_FOR_UNBOUND_SYMBOL()) && Intrinsics.areEqual((Object)((IrFunction)declaration).getVisibility(), (Object)DescriptorVisibilities.LOCAL);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\"H\u0016J3\u0010#\u001a\u0002H$\"\f\b\u0000\u0010$*\u0006\u0012\u0002\b\u00030%*\u0002H$2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010'\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010(J \u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\t2\u0006\u0010\n\u001a\u00020:H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "localContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;)V", "getLocalContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitMember", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitWithTheSingleConstructorContext", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "fillArguments2", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "oldExpression", "newTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "replacedCapturedValue", "startOffset", "", "endOffset", "capturedValueSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "ir.backend.common"})
        @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1203:1\n1#2:1204\n1#2:1225\n777#3:1205\n873#3,2:1206\n1915#3,2:1208\n1586#3:1210\n1661#3,3:1211\n1642#3,10:1214\n1915#3:1224\n1916#3:1226\n1652#3:1227\n1586#3:1228\n1661#3,3:1229\n*S KotlinDebug\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter\n*L\n535#1:1225\n376#1:1205\n376#1:1206,2\n376#1:1208,2\n470#1:1210\n470#1:1211,3\n535#1:1214,10\n535#1:1224\n535#1:1226\n535#1:1227\n536#1:1228\n536#1:1229,3\n*E\n"})
        private final class FunctionBodiesRewriter
        extends IrElementTransformerVoid {
            @Nullable
            private final LocalContext localContext;

            public FunctionBodiesRewriter(LocalContext localContext) {
                this.localContext = localContext;
            }

            @Nullable
            public final LocalContext getLocalContext() {
                return this.localContext;
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Object object = LocalDeclarationsTransformer.this.getLocalClasses().get(declaration);
                if (object != null && (object = ((LocalClassContext)object).getDeclaration()) != null) {
                    irStatement = (IrStatement)object;
                } else {
                    irStatement = this.visitMember(declaration);
                    if (irStatement == null) {
                        irStatement = super.visitClass(declaration);
                    }
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (LocalDeclarationsTransformer.this.getLocalFunctions().containsKey(declaration)) {
                    IrFunction irFunction;
                    IrFunction irFunction2 = LocalDeclarationsTransformer.this.getTransformed(declaration);
                    if (irFunction2 == null) {
                        throw new IllegalStateException("No transformed function for local function".toString());
                    }
                    IrFunction $this$visitFunction_u24lambda_u240 = irFunction = irFunction2;
                    boolean bl = false;
                    $this$visitFunction_u24lambda_u240.acceptChildren(SetDeclarationsParentVisitor.INSTANCE, $this$visitFunction_u24lambda_u240);
                    irStatement = irFunction;
                } else {
                    irStatement = this.visitMember(declaration);
                    if (irStatement == null) {
                        irStatement = super.visitFunction(declaration);
                    }
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrStatement irStatement = this.visitWithTheSingleConstructorContext(declaration);
                if (irStatement == null && (irStatement = this.visitMember(declaration)) == null) {
                    irStatement = super.visitAnonymousInitializer(declaration);
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitField(@NotNull IrField declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrStatement irStatement = this.visitWithTheSingleConstructorContext(declaration);
                if (irStatement == null && (irStatement = this.visitMember(declaration)) == null) {
                    irStatement = super.visitField(declaration);
                }
                return irStatement;
            }

            private final IrStatement visitMember(IrDeclaration declaration) {
                IrStatement irStatement;
                if (this.localContext instanceof LocalClassContext && Intrinsics.areEqual((Object)declaration.getParent(), (Object)((LocalClassContext)this.localContext).getDeclaration())) {
                    LocalClassMemberContext classMemberLocalContext = new LocalClassMemberContext(declaration, (LocalClassContext)this.localContext);
                    IrDeclaration irDeclaration = declaration;
                    LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                    IrDeclaration $this$visitMember_u24lambda_u240 = irDeclaration;
                    boolean bl = false;
                    IrElementTransformerVoidKt.transformChildrenVoid($this$visitMember_u24lambda_u240, localDeclarationsTransformer.new FunctionBodiesRewriter(classMemberLocalContext));
                    irStatement = irDeclaration;
                } else {
                    irStatement = null;
                }
                return irStatement;
            }

            private final IrStatement visitWithTheSingleConstructorContext(IrDeclaration declaration) {
                IrStatement irStatement;
                if (this.localContext instanceof LocalClassContext && Intrinsics.areEqual((Object)declaration.getParent(), (Object)((LocalClassContext)this.localContext).getDeclaration())) {
                    LocalContext localContext = ((LocalClassContext)this.localContext).getConstructorContext();
                    if (localContext == null) {
                        return null;
                    }
                    LocalContext constructorContext = localContext;
                    IrDeclaration irDeclaration = declaration;
                    LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                    IrDeclaration $this$visitWithTheSingleConstructorContext_u24lambda_u240 = irDeclaration;
                    boolean bl = false;
                    IrElementTransformerVoidKt.transformChildrenVoid($this$visitWithTheSingleConstructorContext_u24lambda_u240, localDeclarationsTransformer.new FunctionBodiesRewriter(constructorContext));
                    irStatement = irDeclaration;
                } else {
                    irStatement = null;
                }
                return irStatement;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                LocalClassConstructorContext localClassConstructorContext = LocalDeclarationsTransformer.this.getLocalClassConstructors().get(declaration);
                if (localClassConstructorContext == null) {
                    return super.visitConstructor(declaration);
                }
                LocalClassConstructorContext constructorContext = localClassConstructorContext;
                IrConstructor irConstructor = constructorContext.getTransformedDeclaration();
                LocalDeclarationsLowering localDeclarationsLowering = LocalDeclarationsTransformer.this.this$0;
                LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u240 = irConstructor;
                boolean bl = false;
                if (!CommonConfigurationKeysKt.getLanguageVersionSettings(localDeclarationsLowering.getContext().getConfiguration()).getFlag(AnalysisFlags.INSTANCE.getHeaderMode()).booleanValue() && declaration.getBody() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                $this$visitConstructor_u24lambda_u240.setBody(declaration.getBody());
                Iterable $this$filter$iv = declaration.getParameters();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getDefaultValue() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter argument = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    IrValueParameter irValueParameter = localDeclarationsTransformer.getOldParameterToNew().get(argument);
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    irValueParameter.setDefaultValue(argument.getDefaultValue());
                }
                $this$visitConstructor_u24lambda_u240.acceptChildren(SetDeclarationsParentVisitor.INSTANCE, $this$visitConstructor_u24lambda_u240);
                return irConstructor;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueDeclaration declaration = expression2.getSymbol().getOwner();
                Object object = this.localContext;
                if (object != null && (object = ((LocalContext)object).irGet(expression2.getStartOffset(), expression2.getEndOffset(), declaration)) != null) {
                    Object it = object;
                    boolean bl = false;
                    return it;
                }
                IrValueParameter irValueParameter = LocalDeclarationsTransformer.this.getOldParameterToNew().get(declaration);
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    return BuildersKt.IrGetValueImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), null, 16, null);
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrValueDeclaration declaration = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = LocalDeclarationsTransformer.this.getOldParameterToNew().get(declaration);
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    return BuildersKt.IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrSimpleFunction oldCallee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                IrSimpleFunction newCallee = (IrSimpleFunction)irFunction;
                return this.fillArguments2((IrMemberAccessExpression)LocalDeclarationsTransformer.this.createNewCall(expression2, newCallee), expression2, newCallee);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                void it;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor oldCallee = (IrConstructor)expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                IrConstructor newCallee = (IrConstructor)irFunction;
                IrConstructorCallImpl irConstructorCallImpl = BuildersKt.fromSymbolOwner(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee.getSymbol(), IrUtilsKt.getParentAsClass(newCallee).getTypeParameters().size(), expression2.getOrigin());
                LocalDeclarationsLowering localDeclarationsLowering = LocalDeclarationsTransformer.this.this$0;
                LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                IrConstructorCallImpl irConstructorCallImpl2 = irConstructorCallImpl;
                FunctionBodiesRewriter functionBodiesRewriter = this;
                boolean bl = false;
                int tpIndex = 0;
                for (IrType typeArgument : expression2.getTypeArguments()) {
                    it.getTypeArguments().set(tpIndex++, typeArgument);
                }
                if (localDeclarationsLowering.getRemapCapturedTypesInExtractedLocalDeclarations()) {
                    Object object = localDeclarationsTransformer.getLocalClasses().get(AdditionalIrUtilsKt.getConstructedClass(oldCallee));
                    if (object == null || (object = ((LocalClassContext)object).getClosure()) == null || (object = ((Closure)object).getCapturedTypeParameters()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    List<IrTypeParameter> contextTypeParameters = object;
                    for (IrTypeParameter contextTP : contextTypeParameters) {
                        it.getTypeArguments().set(tpIndex++, IrTypesKt.getDefaultType(contextTP));
                    }
                }
                return functionBodiesRewriter.fillArguments2((IrMemberAccessExpression)irConstructorCallImpl, expression2, newCallee);
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor oldCallee = (IrConstructor)expression2.getSymbol().getOwner();
                IrConstructor irConstructor = (IrConstructor)LocalDeclarationsTransformer.this.getTransformedDeclarations().get(oldCallee);
                if (irConstructor == null) {
                    return expression2;
                }
                IrConstructor newCallee = irConstructor;
                IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl = BuildersKt.IrDelegatingConstructorCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), LocalDeclarationsTransformer.this.this$0.getContext().getIrBuiltIns().getUnitType(), newCallee.getSymbol(), expression2.getTypeArguments().size(), null, 32, null);
                boolean bl = false;
                this.fillArguments2((IrMemberAccessExpression)it, expression2, newCallee);
                IrExpressionsKt.copyTypeArgumentsFrom$default(it, expression2, 0, 2, null);
                return irDelegatingConstructorCallImpl;
            }

            /*
             * WARNING - void declaration
             */
            private final <T extends IrMemberAccessExpression<?>> T fillArguments2(T $this$fillArguments2, IrMemberAccessExpression<?> oldExpression, IrFunction newTarget) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = newTarget.getParameters();
                LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                boolean $i$f$map = false;
                void var8_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IrExpression irExpression;
                    void newValueParameterDeclaration;
                    IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrValueParameter oldParameter = localDeclarationsTransformer.getNewParameterToOld().get(newValueParameterDeclaration);
                    if (oldParameter != null) {
                        irExpression = (IrExpression)oldExpression.getArguments().get(oldParameter.getIndexInParameters());
                    } else {
                        IrValueSymbol capturedValueSymbol;
                        if (localDeclarationsTransformer.getNewParameterToCaptured().get(newValueParameterDeclaration) == null) {
                            throw new AssertionError((Object)("Non-mapped parameter " + newValueParameterDeclaration));
                        }
                        irExpression = this.replacedCapturedValue(oldExpression.getStartOffset(), oldExpression.getEndOffset(), capturedValueSymbol);
                    }
                    collection.add(irExpression);
                }
                List transformedNewTargetParameters = (List)destination$iv$iv;
                AddToStdlibKt.assignFrom($this$fillArguments2.getArguments(), transformedNewTargetParameters);
                return $this$fillArguments2;
            }

            private final IrExpression replacedCapturedValue(int startOffset, int endOffset, IrValueSymbol capturedValueSymbol) {
                Object object;
                IrValueDeclaration capturedValue = capturedValueSymbol.getOwner();
                Object object2 = this.localContext;
                if (object2 != null && (object2 = ((LocalContext)object2).irGet(startOffset, endOffset, capturedValue)) != null) {
                    Object it = object2;
                    boolean bl = false;
                    return it;
                }
                IrValueSymbol replacementSymbol = LocalDeclarationsTransformer.this.this$0.getReplacementSymbolForCaptured(LocalDeclarationsTransformer.this.getContainer(), (object = LocalDeclarationsTransformer.this.getOldParameterToNew().get(capturedValue)) != null && (object = ((IrValueParameter)object).getSymbol()) != null ? (IrValueSymbol)object : capturedValueSymbol);
                return BuildersKt.IrGetValueImpl$default(startOffset, endOffset, replacementSymbol, null, 8, null);
            }

            @Override
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrFunction irFunction;
                LocalDeclarationsTransformer localDeclarationsTransformer;
                Object object;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunction oldCallee = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
                IrFunction irFunction2 = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction2 == null) {
                    return expression2;
                }
                IrFunction newCallee = irFunction2;
                IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
                if (irFunctionSymbol != null) {
                    object = irFunctionSymbol;
                    localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                    IrFunctionSymbol $this$visitFunctionReference_u24lambda_u240 = object;
                    boolean bl = false;
                    irFunction = localDeclarationsTransformer.getTransformed($this$visitFunctionReference_u24lambda_u240.getOwner());
                    if (irFunction == null) {
                        irFunction = $this$visitFunctionReference_u24lambda_u240.getOwner();
                    }
                } else {
                    irFunction = null;
                }
                IrFunction newReflectionTarget = irFunction;
                List<IrTypeParameter> typeParameters2 = newCallee instanceof IrConstructor ? IrUtilsKt.getParentAsClass(newCallee).getTypeParameters() : newCallee.getTypeParameters();
                IrFunction irFunction3 = newReflectionTarget;
                object = BuildersKt.IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee.getSymbol(), typeParameters2.size(), irFunction3 != null ? irFunction3.getSymbol() : null, expression2.getOrigin());
                localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                Object it = object;
                boolean bl = false;
                this.fillArguments2((IrMemberAccessExpression)it, expression2, newCallee);
                localDeclarationsTransformer.setLocalTypeArguments((IrMemberAccessExpression)it, oldCallee);
                IrExpressionsKt.copyTypeArgumentsFrom((IrMemberAccessExpression)it, expression2, typeParameters2.size() - expression2.getTypeArguments().size());
                IrDeclarationsKt.copyAttributes$default((IrElement)it, expression2, false, 2, null);
                return (IrExpression)object;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            @NotNull
            public IrExpression visitRichFunctionReference(@NotNull IrRichFunctionReference expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                oldInvokeFunction = expression.getInvokeFunction();
                IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
                v0 = expression;
                v1 = (IrFunctionSymbol)expression.getReflectionTargetSymbol();
                if (v1 == null) ** GOTO lbl-1000
                var5_3 = v1;
                var6_4 = LocalDeclarationsTransformer.this;
                var7_5 = var5_3;
                var22_6 = v0;
                $i$a$-run-LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter$visitRichFunctionReference$1 = false;
                v2 = var6_4.getTransformed($this$visitRichFunctionReference_u24lambda_u240.getOwner());
                if (v2 == null) {
                    v2 = $this$visitRichFunctionReference_u24lambda_u240.getOwner();
                }
                v0 = var22_6;
                v1 = v2;
                if (v2 != null) {
                    v3 = v1.getSymbol();
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
                v0.setReflectionTargetSymbol((IrSymbol)v3);
                newInvokeFunction = (IrSimpleFunction)LocalDeclarationsTransformer.this.getTransformed(oldInvokeFunction);
                if (newInvokeFunction != null) {
                    expression.setInvokeFunction(newInvokeFunction);
                    parent = newInvokeFunction.getParent();
                    var5_3 = parent instanceof IrFunction != false ? (IrFunction)parent : null;
                    newInvokeFunction.setParent(var5_3 != null && (var6_4 = LocalDeclarationsTransformer.this.getTransformed((IrFunction)var5_3)) != null ? (IrDeclarationParent)var6_4 : parent);
                    var6_4 = newInvokeFunction.getParameters();
                    $this$visitRichFunctionReference_u24lambda_u240 = LocalDeclarationsTransformer.this;
                    $i$f$mapNotNull = false;
                    var9_10 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var14_16 = $this$forEach$iv$iv$iv.iterator();
                    while (var14_16.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var14_16.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (IrValueParameter)element$iv$iv;
                        $i$a$-mapNotNull-LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter$visitRichFunctionReference$capturedValues$1 = false;
                        if ($this$visitRichFunctionReference_u24lambda_u240.getNewParameterToCaptured().get(it) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    capturedValues = (List)destination$iv$iv;
                    $this$map$iv = capturedValues;
                    $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_16 = (IrValueSymbol)item$iv$iv;
                        var22_6 = destination$iv$iv;
                        $i$a$-map-LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter$visitRichFunctionReference$capturedValueExpressions$1 = false;
                        var22_6.add(this.replacedCapturedValue(-1, -1, (IrValueSymbol)capturedValueSymbol));
                    }
                    capturedValueExpressions = (List)destination$iv$iv;
                    expression.getBoundValues().addAll(0, capturedValueExpressions);
                }
                return expression;
            }

            @Override
            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrReturnTarget irReturnTarget = expression2.getReturnTargetSymbol().getOwner();
                IrFunction irFunction = irReturnTarget instanceof IrFunction ? (IrFunction)irReturnTarget : null;
                if (irFunction == null) {
                    return expression2;
                }
                IrFunction oldReturnTarget = irFunction;
                IrFunction irFunction2 = LocalDeclarationsTransformer.this.getTransformed(oldReturnTarget);
                if (irFunction2 == null) {
                    return expression2;
                }
                IrFunction newReturnTarget = irFunction2;
                return new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), LocalDeclarationsTransformer.this.this$0.getContext().getIrBuiltIns().getNothingType(), newReturnTarget.getSymbol(), expression2.getValue());
            }

            @Override
            @NotNull
            public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunction oldFunction = expression2.getSymbol().getOwner();
                IrFunction newFunction = LocalDeclarationsTransformer.this.getTransformed(oldFunction);
                if (newFunction != null) {
                    expression2.setSymbol(newFunction.getSymbol());
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (LocalDeclarationsTransformer.this.getTransformedDeclarations().containsKey(expression2.getSymbol().getOwner())) {
                    String string = "Unsupported reference type " + Reflection.getOrCreateKotlinClass(expression2.getClass()) + " for local declaration";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                return super.visitDeclarationReference(expression2);
            }

            @Override
            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (LocalDeclarationsTransformer.this.getTransformedDeclarations().containsKey(declaration)) {
                    throw new NotImplementedError(null, 1, null);
                }
                return super.visitDeclaration(declaration);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$LocalClassTypeParameterRemapper;", "Lorg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper;", "currentLocalClass", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;)V", "remapTypeOrNull", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "ir.backend.common"})
        @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$LocalClassTypeParameterRemapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1203:1\n1586#2:1204\n1661#2,3:1205\n*S KotlinDebug\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$LocalClassTypeParameterRemapper\n*L\n604#1:1204\n604#1:1205,3\n*E\n"})
        private final class LocalClassTypeParameterRemapper
        extends IrTypeParameterRemapper {
            public LocalClassTypeParameterRemapper(LocalClassContext currentLocalClass) {
                Object object = currentLocalClass;
                if (object == null || (object = ((LocalContext)object).getCapturedTypeParameterToTypeParameter()) == null) {
                    object = MapsKt.emptyMap();
                }
                super((Map<IrTypeParameter, ? extends IrTypeParameter>)object);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            protected IrType remapTypeOrNull(@NotNull IrType type) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (!(type instanceof IrSimpleType)) {
                    return super.remapTypeOrNull(type);
                }
                LocalClassContext localClassContext = LocalDeclarationsTransformer.this.getLocalClasses().get(((IrSimpleType)type).getClassifier().getOwner());
                if (localClassContext == null) {
                    return super.remapTypeOrNull(type);
                }
                LocalClassContext referencedLocalClass = localClassContext;
                List<IrTypeParameter> capturedTypeParameters = referencedLocalClass.getClosure().getCapturedTypeParameters();
                Iterable iterable = capturedTypeParameters;
                Collection collection = CollectionsKt.take((Iterable)((IrSimpleType)type).getArguments(), (int)referencedLocalClass.getNumberOfOwnTypeParameters());
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(IrTypesKt.getDefaultType((IrTypeParameter)it));
                }
                List newTypeArguments = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                IrSimpleType correctedType = IrSimpleTypeImplKt.IrSimpleTypeImpl$default(((IrSimpleType)type).getClassifier(), ((IrSimpleType)type).getNullability(), newTypeArguments, type.getAnnotations(), null, 16, null);
                return super.remapTypeOrNull(correctedType);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "sourceFileWhenInlined", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/IrFileEntry;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/lower/Closure;)V", "transformedDeclaration", "getTransformedDeclaration", "setTransformedDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "ir.backend.common"})
    public static final class LocalFunctionContext
    extends LocalContextWithClosureAsParameters {
        @NotNull
        private final IrSimpleFunction declaration;
        public Closure closure;
        public IrSimpleFunction transformedDeclaration;

        public LocalFunctionContext(@NotNull IrSimpleFunction declaration, @Nullable IrFileEntry sourceFileWhenInlined) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            super(sourceFileWhenInlined);
            this.declaration = declaration;
        }

        @Override
        @NotNull
        public IrSimpleFunction getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure != null) {
                return closure;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"closure");
            return null;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"<set-?>");
            this.closure = closure;
        }

        @Override
        @NotNull
        public IrSimpleFunction getTransformedDeclaration() {
            IrSimpleFunction irSimpleFunction = this.transformedDeclaration;
            if (irSimpleFunction != null) {
                return irSimpleFunction;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"transformedDeclaration");
            return null;
        }

        public void setTransformedDeclaration(@NotNull IrSimpleFunction irSimpleFunction) {
            Intrinsics.checkNotNullParameter((Object)irSimpleFunction, (String)"<set-?>");
            this.transformedDeclaration = irSimpleFunction;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$PotentiallyUnusedField;", "", "<init>", "()V", "value", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "symbolIfUsed", "getSymbolIfUsed", "()Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "symbol", "getSymbol", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$PotentiallyUnusedField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1203:1\n1#2:1204\n*E\n"})
    private static final class PotentiallyUnusedField {
        @Nullable
        private IrFieldSymbol symbolIfUsed;

        @Nullable
        public final IrFieldSymbol getSymbolIfUsed() {
            return this.symbolIfUsed;
        }

        @NotNull
        public final IrFieldSymbol getSymbol() {
            IrFieldSymbol irFieldSymbol = this.symbolIfUsed;
            if (irFieldSymbol == null) {
                IrFieldSymbolImpl irFieldSymbolImpl;
                IrFieldSymbolImpl it = irFieldSymbolImpl = new IrFieldSymbolImpl(null, null, 3, null);
                boolean bl = false;
                this.symbolIfUsed = it;
                irFieldSymbol = irFieldSymbolImpl;
            }
            return irFieldSymbol;
        }
    }
}

