/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FunctionHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ModuleReferencedDeclarations;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.Synthetics;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmServiceImportExportKind;
import org.jetbrains.kotlin.ir.declarations.IdSignatureRetriever;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u001a\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContextWithImport;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmFileFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;", "idSignatureRetriever", "Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;", "moduleName", "", "moduleReferencedDeclarations", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ModuleReferencedDeclarations;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;Ljava/lang/String;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ModuleReferencedDeclarations;)V", "handleFunctionWithImport", "", "declaration", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "handleVTableWithImport", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "handleClassITableWithImport", "handleRTTIWithImport", "superType", "backend.wasm"})
public final class WasmFileCodegenContextWithImport
extends WasmFileCodegenContext {
    @NotNull
    private final String moduleName;
    @NotNull
    private final ModuleReferencedDeclarations moduleReferencedDeclarations;

    public WasmFileCodegenContextWithImport(@NotNull WasmCompiledFileFragment wasmFileFragment, @NotNull IdSignatureRetriever idSignatureRetriever, @NotNull String moduleName2, @NotNull ModuleReferencedDeclarations moduleReferencedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)wasmFileFragment, (String)"wasmFileFragment");
        Intrinsics.checkNotNullParameter((Object)idSignatureRetriever, (String)"idSignatureRetriever");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)moduleReferencedDeclarations, (String)"moduleReferencedDeclarations");
        super(wasmFileFragment, idSignatureRetriever);
        this.moduleName = moduleName2;
        this.moduleReferencedDeclarations = moduleReferencedDeclarations;
    }

    @Override
    public boolean handleFunctionWithImport(@NotNull IrFunctionSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature(declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedFunction(), (Object)signature)) {
            return true;
        }
        FunctionHeapTypeSymbol functionTypeSymbol = this.referenceFunctionHeapType(declaration);
        this.defineFunction(declaration, new WasmFunction.Imported(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration.getOwner())), (WasmHeapType.Type.FunctionType)functionTypeSymbol, new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.FUNC.getPrefix() + signature))));
        return true;
    }

    @Override
    public boolean handleVTableWithImport(@NotNull IrClassSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedGlobalVTable(), (Object)signature)) {
            return true;
        }
        WasmGlobal global = new WasmGlobal("<classVTable>", new WasmRefType(new VTableHeapTypeSymbol(this.getReferenceKey(declaration))), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.VTABLE.getPrefix() + signature)));
        this.defineGlobalVTable(declaration, global);
        return true;
    }

    @Override
    public boolean handleClassITableWithImport(@NotNull IrClassSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedGlobalClassITable(), (Object)signature)) {
            return true;
        }
        WasmGlobal global = new WasmGlobal("<classITable>", new WasmRefType(Synthetics.HeapTypes.INSTANCE.getWasmAnyArrayType()), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.ITABLE.getPrefix() + signature)));
        this.defineGlobalClassITable(declaration, global);
        return true;
    }

    @Override
    public boolean handleRTTIWithImport(@NotNull IrClassSymbol declaration, @Nullable IrClassSymbol superType) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.moduleReferencedDeclarations.getReferencedRttiGlobal(), (Object)signature)) {
            return true;
        }
        WasmGlobal rttiGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration.getOwner()) + "_rtti", new WasmRefType(Synthetics.HeapTypes.INSTANCE.getRttiType()), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.RTTI.getPrefix() + signature)));
        this.defineRttiGlobal(rttiGlobal, declaration, superType);
        return true;
    }
}

