/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PerformanceNotifications;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataFrontendPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataInMemorySerializationArtifact;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.pipeline.SingleModuleFrontendOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirKLibSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.FirKlibSerializationKt;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.util.KlibMetadataHelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibInMemorySerializerPhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataFrontendPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataInMemorySerializationArtifact;", "<init>", "()V", "executePhase", "input", "cli"})
@SourceDebugExtension(value={"SMAP\nMetadataKlibSerializerPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataKlibSerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibInMemorySerializerPhase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n383#2,7:95\n1068#3:102\n*S KotlinDebug\n*F\n+ 1 MetadataKlibSerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibInMemorySerializerPhase\n*L\n52#1:95,7\n66#1:102\n*E\n"})
public final class MetadataKlibInMemorySerializerPhase
extends PipelinePhase<MetadataFrontendPipelineArtifact, MetadataInMemorySerializationArtifact> {
    @NotNull
    public static final MetadataKlibInMemorySerializerPhase INSTANCE = new MetadataKlibInMemorySerializerPhase();

    private MetadataKlibInMemorySerializerPhase() {
        Object[] objectArray = new Function3[]{PerformanceNotifications.KlibWritingFinished.INSTANCE, CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE};
        super("MetadataKlibInMemorySerializerPhase", SetsKt.setOf((Object)PerformanceNotifications.KlibWritingStarted.INSTANCE), SetsKt.setOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MetadataInMemorySerializationArtifact executePhase(@NotNull MetadataFrontendPipelineArtifact input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List<? extends SingleModuleFrontendOutput> firResult = input.component1-QYgrGdg();
        CompilerConfiguration configuration = input.component2();
        MetadataVersion metadataVersion = KlibMetadataHelpersKt.klibMetadataVersionOrDefault$default(configuration, null, 1, null);
        Map fragments = new LinkedHashMap();
        List<? extends SingleModuleFrontendOutput> analysisResult = firResult;
        for (SingleModuleFrontendOutput singleModuleFrontendOutput : analysisResult) {
            FirSession session = singleModuleFrontendOutput.component1();
            ScopeSession scopeSession = singleModuleFrontendOutput.component2();
            List<FirFile> fir = singleModuleFrontendOutput.component3();
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration);
            for (FirFile firFile : fir) {
                Object object;
                void $this$getOrPut$iv;
                ProtoBuf.PackageFragment packageFragment = FirKlibSerializationKt.serializeSingleFirFile$default(firFile, session, scopeSession, null, new FirKLibSerializerExtension(session, scopeSession, FirProviderKt.getFirProvider(session), metadataVersion, null, false, null), languageVersionSettings, false, 64, null);
                Map map = fragments;
                String key$iv = UtilsKt.getPackageFqName(firFile).asString();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List list = (List)object;
                byte[] byArray = packageFragment.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                list.add(byArray);
            }
        }
        KlibMetadataProtoBuf.Header.Builder header = KlibMetadataProtoBuf.Header.newBuilder();
        header.setModuleName(FirModuleDataKt.getModuleData(((SingleModuleFrontendOutput)CollectionsKt.last(analysisResult)).getSession()).getName().asString());
        if (CommonConfigurationKeysKt.getLanguageVersionSettings(configuration).isPreRelease()) {
            header.setFlags(2);
        }
        List list = new ArrayList();
        List fragmentParts = new ArrayList();
        Object $this$sortedBy$iv22 = fragments.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv22 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv22, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        })) {
            String fqName = (String)$this$sortedBy$iv22.getKey();
            List fragment = (List)$this$sortedBy$iv22.getValue();
            ((Collection)list).add(fqName);
            ((Collection)fragmentParts).add(fragment);
            header.addPackageFragmentName(fqName);
        }
        byte[] module2 = header.build().toByteArray();
        Intrinsics.checkNotNull((Object)module2);
        SerializedMetadata serializedMetadata = new SerializedMetadata(module2, fragmentParts, list, metadataVersion.toArray());
        return new MetadataInMemorySerializationArtifact(serializedMetadata, configuration);
    }
}

