/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.internal.intellij.IntellijCoroutines;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.concurrency.InstalledThreadContext;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.concurrency.Propagation;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u001a#\u0010\b\u001a\u0004\u0018\u00010\t2\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0082\b\u001a\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0007\u001a\n\u0010\r\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0006\u0010\u000e\u001a\u00020\t\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0010H\u0000\u001a\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\u0014\u001a\n\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\tH\u0007\u001a?\u0010\u001f\u001a\u00020\u0018\"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00072!\u0010\"\u001a\u001d\u0012\u0013\u0012\u0011H \u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(%\u0012\u0004\u0012\u0002H 0\u000bH\u0007\u001a\u0018\u0010&\u001a\u00060'j\u0002`(2\n\u0010)\u001a\u00060'j\u0002`(H\u0007\u001a\"\u0010&\u001a\b\u0012\u0004\u0012\u0002H 0*\"\u0004\b\u0000\u0010 2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H 0*H\u0007\u001a\"\u0010&\u001a\b\u0012\u0004\u0012\u0002H 0,\"\u0004\b\u0000\u0010 2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H 0,H\u0007\u001a4\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H/0.\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H/0.H\u0007\u001a\"\u0010&\u001a\b\u0012\u0004\u0012\u0002H 01\"\u0004\b\u0000\u0010 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H 01H\u0007\u001a\"\u00103\u001a\b\u0012\u0004\u0012\u0002H 04\"\u0004\b\u0000\u0010 2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H 04H\u0007\u001a\u0016\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0006\u00109\u001a\u00020\tH\u0007\u001a\"\u0010&\u001a\b\u0012\u0004\u0012\u0002H;0:\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0:H\u0007\u001a\b\u0010=\u001a\u00020\u0014H\u0002\u001a\b\u0010>\u001a\u00020?H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"category", "", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "INITIAL_THREAD_CONTEXT", "Lorg/jetbrains/kotlin/com/intellij/concurrency/InstalledThreadContext;", "tlCoroutineContext", "Ljava/lang/ThreadLocal;", "currentThreadContextOrFallback", "Lkotlin/coroutines/CoroutineContext;", "getter", "Lkotlin/Function1;", "currentThreadOverriddenContextOrNull", "currentThreadContextOrNull", "currentThreadContext", "checkContextInstalled", "", "VIOLATORS", "", "isKnownViolator", "", "shouldWarnAccidentalCancellation", "warnAccidentalCancellation", "resetThreadContext", "Lorg/jetbrains/kotlin/com/intellij/openapi/application/AccessToken;", "installThreadContext", "coroutineContext", "replace", "tlTemporaryContext", "currentTemporaryThreadContextOrNull", "installTemporaryThreadContext", "withThreadLocal", "T", "variable", "update", "Lkotlin/ParameterName;", "name", "value", "captureThreadContext", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "runnable", "Ljava/util/function/Supplier;", "s", "Ljava/util/function/Consumer;", "c", "Ljava/util/function/Function;", "U", "f", "Lkotlin/Function0;", "action", "captureThreadContextProcessor", "Lorg/jetbrains/kotlin/com/intellij/util/Processor;", "processor", "getContextSkeleton", "", "Lkotlin/coroutines/CoroutineContext$Element;", "context", "Ljava/util/concurrent/Callable;", "V", "callable", "isStacktraceLoggingEnabled", "tracingHint", "", "intellij.platform.util"})
@JvmName(name="ThreadContext")
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nthreadContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,484:1\n93#1,11:485\n93#1,11:496\n11158#2:507\n11493#2,3:508\n1755#3,3:511\n*S KotlinDebug\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n*L\n114#1:485,11\n128#1:496,11\n220#1:507\n220#1:508,3\n221#1:511,3\n*E\n"})
public final class ThreadContext {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final InstalledThreadContext INITIAL_THREAD_CONTEXT;
    @NotNull
    private static final ThreadLocal<InstalledThreadContext> tlCoroutineContext;
    @NotNull
    private static final List<String> VIOLATORS;
    private static final boolean shouldWarnAccidentalCancellation;
    @NotNull
    private static final ThreadLocal<CoroutineContext> tlTemporaryContext;

    @ApiStatus.Internal
    @Nullable
    public static final CoroutineContext currentThreadContextOrNull() {
        Object object;
        boolean $i$f$currentThreadContextOrFallback = false;
        if (!Propagation.getUseImplicitBlockingContext()) {
            object = tlCoroutineContext.get().getContext();
        } else {
            CoroutineContext suspendingContext$iv = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
            InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
            CoroutineContext snapshot$iv = installedThreadContext.component1();
            CoroutineContext overridingContext$iv = installedThreadContext.component2();
            if (suspendingContext$iv == snapshot$iv) {
                object = overridingContext$iv;
            } else {
                CoroutineContext it = suspendingContext$iv;
                boolean bl = false;
                CoroutineContext coroutineContext = it;
                object = coroutineContext != null ? coroutineContext.minusKey((CoroutineContext.Key)ContinuationInterceptor.Key) : null;
            }
        }
        return object;
    }

    @NotNull
    public static final CoroutineContext currentThreadContext() {
        ThreadContext.checkContextInstalled();
        CoroutineContext coroutineContext = ThreadContext.currentThreadContextOrNull();
        if (coroutineContext == null) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    private static final void checkContextInstalled() {
        if (Propagation.isCheckContextAssertions() && LoadingState.APP_STARTED.isOccurred()) {
            CoroutineContext coroutineContext;
            boolean $i$f$currentThreadContextOrFallback = false;
            if (!Propagation.getUseImplicitBlockingContext()) {
                coroutineContext = tlCoroutineContext.get().getContext();
            } else {
                CoroutineContext suspendingContext$iv = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
                InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
                CoroutineContext snapshot$iv = installedThreadContext.component1();
                CoroutineContext overridingContext$iv = installedThreadContext.component2();
                if (suspendingContext$iv == snapshot$iv) {
                    coroutineContext = overridingContext$iv;
                } else {
                    CoroutineContext it = suspendingContext$iv;
                    boolean bl = false;
                    coroutineContext = it;
                }
            }
            if (coroutineContext == null && !ThreadContext.isKnownViolator()) {
                LOG.warn("Missing thread context", new Throwable());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isKnownViolator() {
        boolean bl;
        block8: {
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getClassName() + '.' + it.getMethodName());
            }
            List stackTrace = (List)destination$iv$iv;
            Iterable $this$any$iv = VIOLATORS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        String badTrace = (String)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = stackTrace;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl5 = false;
                                if (!StringsKt.startsWith$default((String)it, (String)badTrace, (boolean)false, (int)2, null)) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final AccessToken resetThreadContext() {
        return ThreadContext.withThreadLocal(tlCoroutineContext, ThreadContext::resetThreadContext$lambda$6);
    }

    @NotNull
    public static final AccessToken installThreadContext(@NotNull CoroutineContext coroutineContext, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.withThreadLocal(tlCoroutineContext, arg_0 -> ThreadContext.installThreadContext$lambda$8(replace, coroutineContext, arg_0));
    }

    public static /* synthetic */ AccessToken installThreadContext$default(CoroutineContext coroutineContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ThreadContext.installThreadContext(coroutineContext, bl);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> AccessToken withThreadLocal(@NotNull ThreadLocal<T> variable, @NotNull Function1<? super T, ? extends T> update2) {
        Intrinsics.checkNotNullParameter(variable, (String)"variable");
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        T previousValue = variable.get();
        Object newValue = update2.invoke(previousValue);
        if (newValue == previousValue) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        variable.set(newValue);
        return new AccessToken(variable, previousValue, newValue){
            final /* synthetic */ ThreadLocal<T> $variable;
            final /* synthetic */ T $previousValue;
            final /* synthetic */ T $newValue;
            {
                this.$variable = $variable;
                this.$previousValue = $previousValue;
                this.$newValue = $newValue;
            }

            public void finish() {
                T currentValue = this.$variable.get();
                this.$variable.set(this.$previousValue);
                boolean bl = currentValue == this.$newValue;
                T t = this.$newValue;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Value was not reset correctly. Expected: " + t + ", actual: " + currentValue;
                    throw new IllegalStateException(string.toString());
                }
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static final Runnable captureThreadContext(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return Propagation.captureRunnableThreadContext(runnable);
    }

    private static final boolean isStacktraceLoggingEnabled() {
        return LOG.isTraceEnabled();
    }

    private static final Throwable tracingHint() {
        return new Throwable("To enable stack trace recording set log category '#com.intellij.concurrency' to 'trace'");
    }

    private static final InstalledThreadContext tlCoroutineContext$lambda$0() {
        return INITIAL_THREAD_CONTEXT;
    }

    private static final InstalledThreadContext resetThreadContext$lambda$6(InstalledThreadContext installedThreadContext) {
        Intrinsics.checkNotNullParameter((Object)installedThreadContext, (String)"<unused var>");
        CoroutineContext currentSnapshot = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
        return new InstalledThreadContext(currentSnapshot, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final InstalledThreadContext installThreadContext$lambda$8(boolean $replace, CoroutineContext $coroutineContext, InstalledThreadContext previousContext) {
        Intrinsics.checkNotNullParameter((Object)previousContext, (String)"previousContext");
        CoroutineContext currentSnapshot = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
        if (!$replace && previousContext.getSnapshot() == currentSnapshot && previousContext.getContext() != null) {
            void $this$installThreadContext_u24lambda_u248_u24lambda_u247;
            Throwable throwable;
            Throwable throwable2 = throwable = new Throwable("Thread context was already set: " + previousContext + ". \n Most likely, you are using 'runBlocking' instead of 'runBlockingCancellable' somewhere in the asynchronous stack. \nAlso, if you have any kind of manual event queue draining/pumping/flushing/etc \nyou have to wrap the loop with `resetThreadContext().use { // your queue draining code }`. \nSee usages of resetThreadContext().");
            Logger logger = LOG;
            boolean bl = false;
            Throwable throwable3 = previousContext.getCreationTrace();
            if (throwable3 == null) {
                throwable3 = ThreadContext.tracingHint();
            }
            ExceptionsKt.addSuppressed((Throwable)$this$installThreadContext_u24lambda_u248_u24lambda_u247, (Throwable)throwable3);
            logger.error(throwable);
        }
        return new InstalledThreadContext(currentSnapshot, $coroutineContext);
    }

    public static final /* synthetic */ boolean access$isStacktraceLoggingEnabled() {
        return ThreadContext.isStacktraceLoggingEnabled();
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.concurrency");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        INITIAL_THREAD_CONTEXT = new InstalledThreadContext(null, null);
        ThreadLocal<InstalledThreadContext> threadLocal = ThreadLocal.withInitial(ThreadContext::tlCoroutineContext$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        tlCoroutineContext = threadLocal;
        Object[] objectArray = new String[]{"org.jetbrains.kotlin.com.intellij.diagnostic", "org.jetbrains.kotlin.com.intellij.openapi.wm.impl", "org.jetbrains.kotlin.com.intellij.model.SideEffectGuard", "org.jetbrains.kotlin.com.intellij.openapi.editor.impl", "org.jetbrains.kotlin.com.intellij.ui.components", "org.jetbrains.kotlin.com.intellij.openapi.progress.util", "org.jetbrains.kotlin.com.intellij.openapi.application.impl.NonBlockingReadActionImpl$Submission.reschedule", "org.jetbrains.kotlin.com.intellij.openapi.keymap.impl.SystemShortcuts", "org.jetbrains.kotlin.com.intellij.ide.IdeKeyboardFocusManager", "org.jetbrains.kotlin.com.intellij.execution.process.ProcessIOExecutorService", "org.jetbrains.kotlin.com.intellij.util.animation", "org.jetbrains.kotlin.com.intellij.util.ui", "org.jetbrains.kotlin.com.intellij.ide.ui.popup", "org.jetbrains.kotlin.com.intellij.ui", "org.jetbrains.io", "org.jetbrains.kotlin.com.intellij.javascript.webSymbols.nodejs.WebTypesNpmLoader", "org.jetbrains.kotlin.com.intellij.tasks", "org.jetbrains.kotlin.com.intellij.util.concurrency.Invoker", "org.jetbrains.kotlin.com.intellij.openapi.application.constraints", "org.jetbrains.kotlin.com.intellij.openapi.actionSystem", "org.jetbrains.idea.maven.server", "org.jetbrains.kotlin.com.intellij.internal.statistic", "org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger", "org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensionList", "org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensions", "org.jetbrains.kotlin.com.intellij.serviceContainer.LazyExtensionInstance.createInstance", "org.jetbrains.kotlin.com.intellij.ui.icons", "org.jetbrains.kotlin.com.intellij.ui.tree", "org.jetbrains.kotlin.com.intellij.openapi.project.SmartModeScheduler.onStateChanged", "javax.swing.JComponent.paint", "org.jetbrains.kotlin.com.intellij.openapi.application.impl.LaterInvocator.leaveModal", "org.jetbrains.kotlin.com.intellij.openapi.application.impl.LaterInvocator.invokeAndWait", "org.jetbrains.kotlin.com.intellij.util.animation.JBAnimator.animate", "org.jetbrains.kotlin.com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl.disconnect", "org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.scheduleUpdateRunnable", "org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.stopProcess", "org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl", "org.jetbrains.kotlin.com.intellij.openapi.wm.impl.WindowCloseListener.windowClosing", "org.jetbrains.kotlin.com.intellij.ide.ApplicationActivationStateManager.updateState", "org.jetbrains.kotlin.com.intellij.openapi.util.io.GentleFlusherBase"};
        VIOLATORS = CollectionsKt.listOf((Object[])objectArray);
        shouldWarnAccidentalCancellation = SystemProperties.getBooleanProperty("ide.warn.accidental.cancellation", false);
        tlTemporaryContext = new ThreadLocal();
    }
}

