/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginEnabler;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0014\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u001a\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0000\u001a\"\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0007\u001a.\u0010\u0017\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\b\u0010\u0018\u001a\u00020\u0015H\u0007\u001a\u001a\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0002\u001a$\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\"\u001a\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"(\u0010\t\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "()V", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getUpdatedBrokenPluginFile", "Ljava/nio/file/Path;", "configDir", "brokenPluginVersions", "Ljava/lang/ref/Reference;", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId;", "", "", "isBrokenPlugin", "", "descriptor", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptor;", "getBrokenPluginVersions", "updateBrokenPlugins", "", "brokenPlugins", "writeBrokenPlugins", "dropInMemoryBrokenPluginsCache", "readBrokenPluginFile", "tryReadBrokenPluginsFile", "brokenPluginsStorage", "intellij.platform.core.impl"})
public final class BrokenPluginFileKt {
    @Nullable
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public static final Path getUpdatedBrokenPluginFile(@Nullable Path configDir) {
        Object object = configDir;
        if (object == null || (object = object.toString()) == null) {
            String string = PathManager.getConfigPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigPath(...)");
        }
        String[] stringArray = new String[]{"updatedBrokenPlugins.db"};
        Path path = Paths.get((String)object, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public static /* synthetic */ Path getUpdatedBrokenPluginFile$default(Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        return BrokenPluginFileKt.getUpdatedBrokenPluginFile(path);
    }

    @NotNull
    public static final Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (PluginEnabler.HEADLESS.isIgnoredDisabledPlugins()) {
            return MapsKt.emptyMap();
        }
        Reference<Map<PluginId, Set<String>>> reference2 = brokenPluginVersions;
        Map<PluginId, Set<String>> map = result2 = reference2 != null ? reference2.get() : null;
        if (result2 == null) {
            result2 = BrokenPluginFileKt.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        return result2;
    }

    private static final Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> map;
        Map<PluginId, Set<String>> result2 = null;
        Path updatedBrokenPluginFile = BrokenPluginFileKt.getUpdatedBrokenPluginFile$default(null, 1, null);
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result2 = BrokenPluginFileKt.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            BrokenPluginFileKt.getLOG().info("Using cached broken plugins file");
        }
        if (result2 == null) {
            String[] stringArray = new String[]{"brokenPlugins.db"};
            Path path = Paths.get(PathManager.getBinPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            result2 = BrokenPluginFileKt.tryReadBrokenPluginsFile(path);
            if (result2 != null) {
                BrokenPluginFileKt.getLOG().info("Using broken plugins file from IDE distribution");
            }
        }
        if ((map = result2) == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try {
            Closeable closeable = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));
            Throwable throwable = null;
            try {
                DataInputStream stream = (DataInputStream)closeable;
                boolean bl = false;
                int version2 = stream.readUnsignedByte();
                if (version2 != 2) {
                    BrokenPluginFileKt.getLOG().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version2 + ", supportedVersion=2)");
                    Map<PluginId, Set<String>> map = null;
                    return map;
                }
                String buildNumber = stream.readUTF();
                if (!Intrinsics.areEqual((Object)buildNumber, (Object)PluginManagerCore.getBuildNumber().toString())) {
                    BrokenPluginFileKt.getLOG().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ')');
                    Map<PluginId, Set<String>> map = null;
                    return map;
                }
                int count = stream.readInt();
                HashMap result2 = new HashMap(count);
                for (int i = 0; i < count; ++i) {
                    PluginId pluginId;
                    HashSet hashSet;
                    Intrinsics.checkNotNullExpressionValue((Object)PluginId.getId(stream.readUTF()), (String)"getId(...)");
                    HashSet hashSet2 = hashSet = new HashSet();
                    PluginId pluginId2 = pluginId;
                    HashMap hashMap = result2;
                    boolean bl2 = false;
                    int n = stream.readUnsignedShort();
                    int n2 = 0;
                    while (n2 < n) {
                        void r;
                        int it = n2++;
                        boolean bl3 = false;
                        r.add(stream.readUTF());
                    }
                    Unit unit = Unit.INSTANCE;
                    hashMap.put(pluginId2, hashSet);
                }
                Map map = result2;
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (Exception e) {
            BrokenPluginFileKt.getLOG().warn("Failed to read " + brokenPluginsStorage, e);
        }
        return null;
    }
}

