/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDependency;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginOsRequirement;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginLoadingError;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.NioFiles;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.HtmlChunk;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010'\u001a\u00020\u0018H\u0007J\b\u0010=\u001a\u00020\u001bH\u0007J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\"0?H\u0007J\b\u0010D\u001a\u00020\u0018H\u0007J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u001bH\u0007J\u0010\u0010H\u001a\u00020\u00182\u0006\u0010I\u001a\u00020\u0011H\u0007J\u0010\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00020\u0011H\u0007J\u0010\u0010L\u001a\u00020\u00182\u0006\u0010K\u001a\u00020\u0011H\u0007J\u0010\u0010M\u001a\u00020\u00182\u0006\u0010N\u001a\u00020\u0011H\u0007J\u0012\u0010O\u001a\u0004\u0018\u00010\u00112\u0006\u0010P\u001a\u00020\u0005H\u0007J\u0010\u0010Q\u001a\u00020\u00182\u0006\u0010R\u001a\u00020\u0005H\u0007J\u0012\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010P\u001a\u00020\u0005H\u0007J\u0016\u0010U\u001a\u0004\u0018\u00010T2\n\u0010V\u001a\u0006\u0012\u0002\b\u00030WH\u0007J\u0010\u0010X\u001a\u00020\u00182\u0006\u0010Y\u001a\u00020\u0005H\u0002J\u0010\u0010Z\u001a\u00020\u00182\u0006\u0010[\u001a\u00020\u0005H\u0007J\u0010\u0010Z\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020TH\u0007J\u0010\u0010]\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020TH\u0007J\u0012\u0010]\u001a\u00020\u00182\b\u0010^\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010_\u001a\u00020\u00182\u0006\u0010Y\u001a\u00020\u0005H\u0007J\b\u0010`\u001a\u00020FH\u0007J(\u0010a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0?2\u0012\u0010b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050!0?H\u0002J\u0010\u0010c\u001a\u0004\u0018\u00010\u001e2\u0006\u0010I\u001a\u00020\u0011J\u0010\u0010d\u001a\u00020\u00182\u0006\u0010e\u001a\u00020\u0018H\u0007J\u0010\u0010f\u001a\u00020F2\u0006\u0010g\u001a\u00020hH\u0007JD\u0010f\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\u0006\u0010g\u001a\u00020h2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020j0.2\u000e\u0010k\u001a\n\u0012\u0004\u0012\u00020l\u0018\u00010.2\u000e\u0010m\u001a\n\u0012\u0004\u0012\u00020n\u0018\u00010.H\u0007J\u0014\u0010o\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020q0?0pH\u0007J>\u0010y\u001a\u00020F2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020q0{2\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001d2\u0012\u0010}\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0~H\u0002J\u0011\u0010\u007f\u001a\u00020\u00182\u0007\u0010\u0080\u0001\u001a\u000209H\u0007J\u0019\u0010\u007f\u001a\u00020\u00182\u0007\u0010\u0080\u0001\u001a\u0002092\b\u0010u\u001a\u0004\u0018\u000100J\u0012\u0010\u0081\u0001\u001a\u00020\u00182\u0007\u0010\u0080\u0001\u001a\u000209H\u0007J\u001c\u0010\u0081\u0001\u001a\u00020\u00182\u0007\u0010\u0080\u0001\u001a\u0002092\b\u0010u\u001a\u0004\u0018\u000100H\u0007J\u0013\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u00012\u0007\u0010\u0080\u0001\u001a\u000209J\u001d\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u001e2\u0007\u0010\u0080\u0001\u001a\u0002092\u0007\u0010\u0085\u0001\u001a\u000200H\u0007J\u001d\u0010\u0086\u0001\u001a\u00020F2\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001dH\u0002J:\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020l2\u0007\u0010\u0094\u0001\u001a\u00020\u00182\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u0001J)\u0010\u0097\u0001\u001a\u00020F2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u00012\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001dH\u0002J\u0018\u0010\u0097\u0001\u001a\u00020F2\r\u0010\u0098\u0001\u001a\b\u0012\u0004\u0012\u00020q0?H\u0002J\u0018\u0010\u0099\u0001\u001a\u00020F2\r\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110$H\u0007J\u0011\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0003\u0010\u009c\u0001J\u0018\u0010\u009d\u0001\u001a\u00020F2\r\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110{H\u0007J\u000f\u0010\u009f\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110$H\u0002JE\u0010\u00a0\u0001\u001a\u00020\u00182\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\r\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110$2\u0007\u0010\u00a3\u0001\u001a\u00020n2\u0012\b\u0002\u0010\u00a4\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00a5\u0001\u0018\u000108H\u0007\u00a2\u0006\u0003\u0010\u00a6\u0001J=\u0010\u00a7\u0001\u001a\u00020F2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\u000e\u0010\u009e\u0001\u001a\t\u0012\u0004\u0012\u00020\u00110\u00a8\u00012\u0012\b\u0002\u0010\u00a4\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00a5\u0001\u0018\u000108H\u0007\u00a2\u0006\u0003\u0010\u00a9\u0001J<\u0010\u00a7\u0001\u001a\u00020F2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\r\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050{2\u0012\b\u0002\u0010\u00a4\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00a5\u0001\u0018\u000108H\u0007\u00a2\u0006\u0003\u0010\u00aa\u0001J\u001e\u0010\u00ab\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110$2\r\u0010\u00ac\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050{H\u0007J\u0017\u0010\u00ad\u0001\u001a\u00020\u00182\f\u0010z\u001a\b\u0012\u0004\u0012\u00020q0?H\u0002J\u0018\u0010\u00ae\u0001\u001a\b0\u0005\u00a2\u0006\u0003\b\u00af\u00012\u0007\u0010\u0080\u0001\u001a\u000209H\u0007J'\u0010\u00b0\u0001\u001a\u00020\u001b2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0080@\u00a2\u0006\u0006\b\u00b1\u0001\u0010\u00b2\u0001J\u0015\u0010\u00b6\u0001\u001a\u0004\u0018\u0001092\b\u0010K\u001a\u0004\u0018\u00010\u0011H\u0007J\u0013\u0010\u00b7\u0001\u001a\u0004\u0018\u00010q2\u0006\u0010K\u001a\u00020\u0011H\u0007J\u0013\u0010\u00b8\u0001\u001a\u0004\u0018\u00010q2\u0006\u0010K\u001a\u00020\u0011H\u0007J\u0011\u0010\u00b9\u0001\u001a\u00020\u00182\u0006\u0010K\u001a\u00020\u0011H\u0007J\u0015\u0010\u00ba\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001dH\u0007J>\u0010\u00bb\u0001\u001a\u00020F2\u0007\u0010\u00bc\u0001\u001a\u00020q2\u0013\u0010\u00bd\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001d2\u0015\u0010\u00be\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0005\u0012\u00030\u00c0\u00010\u00bf\u0001H\u0007J>\u0010\u00c1\u0001\u001a\u00020\u00182\u0007\u0010\u00bc\u0001\u001a\u00020q2\u0013\u0010\u00bd\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001d2\u0015\u0010\u00be\u0001\u001a\u0010\u0012\u0004\u0012\u00020q\u0012\u0005\u0012\u00030\u00c0\u00010\u00bf\u0001H\u0007JX\u0010\u00c1\u0001\u001a\u00020\u00182\u0007\u0010\u00bc\u0001\u001a\u00020q2\u0010\u0010\u00c2\u0001\u001a\u000b\u0012\u0006\b\u0000\u0012\u00020q0\u00c3\u00012\u0013\u0010\u00bd\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020q0\u001d2\u001d\u0010\u00be\u0001\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010q\u0012\u0005\u0012\u00030\u00c0\u00010\u00c4\u0001H\u0002J\u0018\u0010\u00c5\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110$2\u0007\u0010\u0080\u0001\u001a\u00020qH\u0007J\u0011\u0010\u00c6\u0001\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020TH\u0007JQ\u0010\u00c7\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u00050!\u00a2\u0006\u0003\b\u00af\u00012\u001b\u0010\u00c8\u0001\u001a\u0016\u0018\u00010\u0005\u00a2\u0006\u000f\b\u00c9\u0001\u0012\n\b\u00ca\u0001\u0012\u0005\b\b(\u00cb\u00012\u0017\u0010\u00cc\u0001\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000108\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0003\u0010\u00cd\u0001J3\u0010\u00ce\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0?2\r\u0010\u00cf\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050{2\r\u0010\u00d0\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050{H\u0002J\u001c\u0010\u00d1\u0001\u001a\u0004\u0018\u00010q2\u0006\u0010P\u001a\u00020\u00052\u0007\u0010\u00d2\u0001\u001a\u00020\u001bH\u0002J\u0010\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00020\u0005H\u0007J\u0010\u0010L\u001a\u00020\u00182\u0006\u0010K\u001a\u00020\u0005H\u0007J\u0013\u0010\u00d3\u0001\u001a\u00020F2\b\u0010\u00d4\u0001\u001a\u00030\u00d5\u0001H\u0007J\u0014\u0010\u00d6\u0001\u001a\u00020\u00182\t\u0010\u00d7\u0001\u001a\u0004\u0018\u000109H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R\u0014\u0010)\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010\u0003R\u000e\u0010+\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R\u0016\u0010-\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b3\u00104R \u00107\u001a\b\u0012\u0004\u0012\u000209088FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010\u0003\u001a\u0004\b;\u0010<R \u0010>\u001a\b\u0012\u0004\u0012\u0002090?8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b@\u0010\u0003\u001a\u0004\bA\u0010BR\u0017\u0010r\u001a\b\u0012\u0004\u0012\u00020\u001b0.8G\u00a2\u0006\u0006\u001a\u0004\bs\u0010tR\u001a\u0010u\u001a\u0002008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bv\u0010\u0003\u001a\u0004\bw\u0010xR&\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\"\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001e\u0010\u00a3\u0001\u001a\u00020n8GX\u0087\u0004\u00a2\u0006\u000f\u0012\u0005\b\u00b3\u0001\u0010\u0003\u001a\u0006\b\u00b4\u0001\u0010\u00b5\u0001\u00a8\u0006\u00d8\u0001"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore;", "", "<init>", "()V", "META_INF", "", "CORE_PLUGIN_ID", "PLUGIN_XML", "PLUGIN_XML_PATH", "VENDOR_JETBRAINS", "VENDOR_JETBRAINS_SRO", "DISABLE", "ENABLE", "EDIT", "MODULE_DEPENDENCY_PREFIX", "THIRD_PARTY_PLUGINS_FILE", "CORE_ID", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId;", "JAVA_PLUGIN_ID", "JAVA_MODULE_ID", "ALL_MODULES_MARKER", "SPECIAL_IDEA_PLUGIN_ID", "ULTIMATE_PLUGIN_ID", "isIgnoreCompatibility", "", "isUnitTestMode", "nullablePluginSet", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginSet;", "pluginLoadingErrors", "", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginLoadingError;", "pluginErrors", "Ljava/util/ArrayList;", "Ljava/util/function/Supplier;", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk;", "pluginsToDisable", "", "pluginsToEnable", "shadowedBundledPlugins", "isRunningFromSources", "Ljava/lang/Boolean;", "QODANA_PLUGINS_THIRD_PARTY_ACCEPT", "getQODANA_PLUGINS_THIRD_PARTY_ACCEPT$annotations", "FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT", "thirdPartyPluginsNoteAccepted", "initFuture", "Lkotlinx/coroutines/Deferred;", "ourBuildNumber", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/BuildNumber;", "findLoadedClassHandle", "Ljava/lang/invoke/MethodHandle;", "getFindLoadedClassHandle", "()Ljava/lang/invoke/MethodHandle;", "findLoadedClassHandle$delegate", "Lkotlin/Lazy;", "plugins", "", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptor;", "getPlugins$annotations", "getPlugins", "()[Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getPluginSet", "loadedPlugins", "", "getLoadedPlugins$annotations", "getLoadedPlugins", "()Ljava/util/List;", "getAndClearPluginLoadingErrors", "arePluginsInitialized", "setPluginSet", "", "value", "isDisabled", "pluginId", "disablePlugin", "id", "enablePlugin", "isModuleDependency", "dependentPluginId", "getPluginByClassName", "className", "isPlatformClass", "fqn", "getPluginDescriptorOrPlatformByClassName", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginDescriptor;", "getPluginDescriptorIfIdeaClassLoaderIsUsed", "aClass", "Ljava/lang/Class;", "isVendorItemTrusted", "vendorItem", "isVendorTrusted", "vendor", "plugin", "isDevelopedByJetBrains", "vendorString", "isVendorJetBrains", "invalidatePlugins", "preparePluginErrors", "globalErrorsSuppliers", "getLoadingError", "onEnable", "enabled", "scheduleDescriptorLoading", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "zipFilePoolDeferred", "Lorg/jetbrains/kotlin/com/intellij/util/lang/ZipFilePool;", "mainClassLoaderDeferred", "Ljava/lang/ClassLoader;", "logDeferred", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "getEnabledPluginRawList", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "initPluginFuture", "getInitPluginFuture", "()Lkotlinx/coroutines/Deferred;", "buildNumber", "getBuildNumber$annotations", "getBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "disableIncompatiblePlugins", "descriptors", "", "idMap", "errors", "", "isCompatible", "descriptor", "isIncompatible", "getIncompatibleOs", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginOsRequirement;", "checkBuildNumberCompatibility", "ideBuildNumber", "checkEssentialPluginsAreAvailable", "pluginDescriptorDebugData", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginDescriptorsDebugData;", "getPluginDescriptorDebugData", "()Lcom/intellij/ide/plugins/PluginDescriptorsDebugData;", "setPluginDescriptorDebugData", "(Lcom/intellij/ide/plugins/PluginDescriptorsDebugData;)V", "initializePlugins", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerState;", "context", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/DescriptorListLoadingContext;", "loadingResult", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginLoadingResult;", "coreLoader", "checkEssentialPlugins", "parentActivity", "Lorg/jetbrains/kotlin/com/intellij/diagnostic/Activity;", "checkThirdPartyPluginsPrivacyConsent", "aliens", "giveConsentToSpecificThirdPartyPlugins", "acceptedPlugins", "isThirdPartyPluginsNoteAccepted", "()Ljava/lang/Boolean;", "writeThirdPartyPluginsIds", "pluginIds", "readThirdPartyPluginIdsOnce", "tryWritePluginIdsToFile", "path", "Ljava/nio/file/Path;", "logger", "openOptions", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;Ljava/util/Set;Lcom/intellij/openapi/diagnostic/Logger;[Ljava/nio/file/OpenOption;)Z", "writePluginIdsToFile", "Lkotlin/sequences/Sequence;", "(Ljava/nio/file/Path;Lkotlin/sequences/Sequence;[Ljava/nio/file/OpenOption;)V", "(Ljava/nio/file/Path;Ljava/util/Collection;[Ljava/nio/file/OpenOption;)V", "toPluginIds", "pluginIdStrings", "askThirdPartyPluginsPrivacyConsent", "getPluginNameAndVendor", "Lorg/jetbrains/annotations/Nls;", "initializeAndSetPlugins", "initializeAndSetPlugins$intellij_platform_core_impl", "(Lcom/intellij/ide/plugins/DescriptorListLoadingContext;Lcom/intellij/ide/plugins/PluginLoadingResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getPlugin", "findPlugin", "findPluginByModuleDependency", "isPluginInstalled", "buildPluginIdMap", "processAllNonOptionalDependencyIds", "rootDescriptor", "pluginIdMap", "consumer", "Lkotlin/Function1;", "Ljava/nio/file/FileVisitResult;", "processAllNonOptionalDependencies", "depProcessed", "", "Lkotlin/Function2;", "getNonOptionalDependenciesIds", "isUpdatedBundledPlugin", "message", "key", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.CoreBundle", "params", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/function/Supplier;", "prepareActions", "pluginNamesToDisable", "pluginNamesToEnable", "findClassInPluginThatUsesCoreClassloader", "pluginSet", "addDisablePluginListener", "listener", "Ljava/lang/Runnable;", "dependsOnUltimateOptionally", "pluginDescriptor", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nPluginManagerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCore\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1114:1\n37#2:1115\n36#2,3:1116\n1557#3:1119\n1628#3,3:1120\n1557#3:1127\n1628#3,3:1128\n1557#3:1136\n1628#3,3:1137\n1557#3:1143\n1628#3,3:1144\n295#3,2:1147\n1755#3,3:1153\n1251#4,2:1123\n1251#4,2:1125\n183#4,2:1131\n743#4,4:1149\n77#5:1133\n97#5,2:1134\n99#5,3:1140\n*S KotlinDebug\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCore\n*L\n141#1:1115\n141#1:1116,3\n162#1:1119\n162#1:1120,3\n316#1:1127\n316#1:1128,3\n623#1:1136\n623#1:1137,3\n719#1:1143\n719#1:1144,3\n871#1:1147,2\n1033#1:1153,3\n271#1:1123,2\n289#1:1125,2\n521#1:1131,2\n897#1:1149,4\n622#1:1133\n622#1:1134,2\n622#1:1140,3\n*E\n"})
public final class PluginManagerCore {
    @NotNull
    public static final PluginManagerCore INSTANCE = new PluginManagerCore();
    @JvmField
    @NotNull
    public static final PluginId CORE_ID;
    @JvmField
    @NotNull
    public static final PluginId JAVA_PLUGIN_ID;
    @JvmField
    @NotNull
    public static final PluginId JAVA_MODULE_ID;
    @JvmField
    @NotNull
    public static final PluginId ALL_MODULES_MARKER;
    @JvmField
    @NotNull
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final PluginId ULTIMATE_PLUGIN_ID;
    @VisibleForTesting
    @JvmField
    public static volatile boolean isIgnoreCompatibility;
    @VisibleForTesting
    @JvmField
    public static volatile boolean isUnitTestMode;
    @NotNull
    private static final ArrayList<Supplier<HtmlChunk>> pluginErrors;
    @NotNull
    private static Set<PluginId> shadowedBundledPlugins;
    private static final boolean QODANA_PLUGINS_THIRD_PARTY_ACCEPT;
    private static final boolean FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT;
    @Nullable
    private static BuildNumber ourBuildNumber;
    @NotNull
    private static final Lazy findLoadedClassHandle$delegate;

    private PluginManagerCore() {
    }

    @NotNull
    public static final BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromPluginCompatibleBuild();
            if (INSTANCE.getLogger().isDebugEnabled()) {
                Logger logger = INSTANCE.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("getBuildNumber: fromPluginsCompatibleBuild=");
                Object object = result2;
                if (object == null || (object = ((BuildNumber)object).asString()) == null) {
                    object = "null";
                }
                logger.debug(stringBuilder.append((String)object).toString());
            }
            if (result2 == null) {
                BuildNumber buildNumber;
                if (isUnitTestMode) {
                    buildNumber = BuildNumber.currentVersion();
                } else {
                    BuildNumber buildNumber2;
                    try {
                        buildNumber2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException runtimeException) {
                        buildNumber2 = BuildNumber.currentVersion();
                    }
                    buildNumber = buildNumber2;
                }
                result2 = buildNumber;
            }
            ourBuildNumber = result2;
        }
        return result2;
    }

    @Nullable
    public final IdeaPluginOsRequirement getIncompatibleOs(@NotNull IdeaPluginDescriptor descriptor) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            List<IdeaPluginDependency> list = descriptor.getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), PluginManagerCore::getIncompatibleOs$lambda$13);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeaPluginOsRequirement p = (IdeaPluginOsRequirement)((Object)element$iv);
                boolean bl = false;
                if (!(p != null && !p.isHostOs())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @JvmStatic
    @Nullable
    public static final PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor, @NotNull BuildNumber ideBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)ideBuildNumber, (String)"ideBuildNumber");
        IdeaPluginOsRequirement incompatibleOs = INSTANCE.getIncompatibleOs(descriptor);
        if (incompatibleOs != null) {
            Object[] objectArray = new Object[]{descriptor.getName(), descriptor.getVersion(), incompatibleOs, SystemInfo.getOsName()};
            Supplier<String> supplier = INSTANCE.message("plugin.loading.error.long.incompatible.with.platform", objectArray);
            objectArray = new Object[]{incompatibleOs};
            return new PluginLoadingError(descriptor, supplier, INSTANCE.message("plugin.loading.error.short.incompatible.with.platform", objectArray));
        }
        if (isIgnoreCompatibility) {
            return null;
        }
        try {
            String pluginName;
            BuildNumber untilBuildNumber;
            String untilBuild;
            String sinceBuild = descriptor.getSinceBuild();
            if (sinceBuild != null) {
                Object[] objectArray;
                String pluginName2 = descriptor.getName();
                try {
                    objectArray = BuildNumber.fromString(sinceBuild, pluginName2, null);
                }
                catch (RuntimeException e) {
                    INSTANCE.getLogger().error(e);
                    objectArray = null;
                }
                Object[] sinceBuildNumber = objectArray;
                if (sinceBuildNumber != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                    objectArray = new Object[]{pluginName2, descriptor.getVersion(), sinceBuild, ideBuildNumber};
                    Supplier<String> supplier = INSTANCE.message("plugin.loading.error.long.incompatible.since.build", objectArray);
                    objectArray = new Object[]{sinceBuild};
                    return new PluginLoadingError(descriptor, supplier, INSTANCE.message("plugin.loading.error.short.incompatible.since.build", objectArray));
                }
            }
            if ((untilBuild = descriptor.getUntilBuild()) != null && (untilBuildNumber = BuildNumber.fromString(untilBuild, pluginName = descriptor.getName(), null)) != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                Object[] objectArray = new Object[]{pluginName, descriptor.getVersion(), untilBuild, ideBuildNumber};
                Supplier<String> supplier = INSTANCE.message("plugin.loading.error.long.incompatible.until.build", objectArray);
                objectArray = new Object[]{untilBuild};
                return new PluginLoadingError(descriptor, supplier, INSTANCE.message("plugin.loading.error.short.incompatible.until.build", objectArray));
            }
        }
        catch (Exception e) {
            INSTANCE.getLogger().error(e);
            Object[] objectArray = new Object[]{descriptor.getName()};
            return new PluginLoadingError(descriptor, INSTANCE.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", objectArray), INSTANCE.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
        return null;
    }

    @ApiStatus.Internal
    public final boolean tryWritePluginIdsToFile(@NotNull Path path, @NotNull Set<PluginId> pluginIds, @NotNull Logger logger, @Nullable OpenOption[] openOptions) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            this.writePluginIdsToFile(path, (Sequence<PluginId>)CollectionsKt.asSequence((Iterable)pluginIds), openOptions);
            bl = true;
        }
        catch (IOException e) {
            logger.warn("Unable to write plugin ID list to " + path, e);
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean tryWritePluginIdsToFile$default(PluginManagerCore pluginManagerCore, Path path, Set set, Logger logger, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 8) != 0) {
            openOptionArray = null;
        }
        return pluginManagerCore.tryWritePluginIdsToFile(path, set, logger, openOptionArray);
    }

    @ApiStatus.Internal
    public final void writePluginIdsToFile(@NotNull Path path, @NotNull Sequence<PluginId> pluginIds, @Nullable OpenOption[] openOptions) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        this.writePluginIdsToFile(path, SequencesKt.toList((Sequence)SequencesKt.map(pluginIds, PluginManagerCore::writePluginIdsToFile$lambda$23)), openOptions);
    }

    @VisibleForTesting
    public final synchronized void writePluginIdsToFile(@NotNull Path path, @NotNull Collection<String> pluginIds, @Nullable OpenOption[] openOptions) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        NioFiles.createDirectories(path.getParent());
        Iterable iterable = new TreeSet<String>(pluginIds);
        OpenOption[] openOptionArray = openOptions;
        if (openOptions == null) {
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] openOptionArray2 = openOptionArray;
        Files.write(path, (Iterable<? extends CharSequence>)iterable, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final Set<PluginId> toPluginIds(@NotNull Collection<String> pluginIdStrings) {
        Intrinsics.checkNotNullParameter(pluginIdStrings, (String)"pluginIdStrings");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)pluginIdStrings), PluginManagerCore::toPluginIds$lambda$24), PluginManagerCore::toPluginIds$lambda$25), PluginManagerCore::toPluginIds$lambda$26));
    }

    @ApiStatus.Internal
    @NotNull
    public static final Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private final Supplier<String> message(String key, Object ... params) {
        return () -> PluginManagerCore.message$lambda$39(key, params);
    }

    private static final MethodHandle findLoadedClassHandle_delegate$lambda$0() {
        Class[] classArray = new Class[]{String.class};
        Method method = ClassLoader.class.getDeclaredMethod("findLoadedClass", classArray);
        method.setAccessible(true);
        return MethodHandles.lookup().unreflect(method);
    }

    private static final IdeaPluginOsRequirement getIncompatibleOs$lambda$13(IdeaPluginDependency it) {
        return IdeaPluginOsRequirement.Companion.fromModuleId(it.getPluginId());
    }

    private static final String writePluginIdsToFile$lambda$23(PluginId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdString();
    }

    private static final String toPluginIds$lambda$24(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean toPluginIds$lambda$25(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() == 0;
    }

    private static final PluginId toPluginIds$lambda$26(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PluginId.getId(it);
    }

    private static final String message$lambda$39(String $key, Object[] $params) {
        String string = $key;
        Intrinsics.checkNotNull((Object)string);
        return CoreBundle.message(string, Arrays.copyOf($params, $params.length));
    }

    static {
        PluginId pluginId = PluginId.getId("org.jetbrains.kotlin.com.intellij");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        CORE_ID = pluginId;
        PluginId pluginId2 = PluginId.getId("org.jetbrains.kotlin.com.intellij.java");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getId(...)");
        JAVA_PLUGIN_ID = pluginId2;
        PluginId pluginId3 = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.java");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId3, (String)"getId(...)");
        JAVA_MODULE_ID = pluginId3;
        PluginId pluginId4 = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.all");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId4, (String)"getId(...)");
        ALL_MODULES_MARKER = pluginId4;
        PluginId pluginId5 = PluginId.getId("IDEA CORE");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId5, (String)"getId(...)");
        SPECIAL_IDEA_PLUGIN_ID = pluginId5;
        PluginId pluginId6 = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.ultimate");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId6, (String)"getId(...)");
        ULTIMATE_PLUGIN_ID = pluginId6;
        isIgnoreCompatibility = Boolean.getBoolean("idea.ignore.plugin.compatibility");
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList();
        Set set = Collections.emptySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"emptySet(...)");
        shadowedBundledPlugins = set;
        QODANA_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("idea.qodana.thirdpartyplugins.accept");
        FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("fleet.backend.third-party.plugins.accept");
        findLoadedClassHandle$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, PluginManagerCore::findLoadedClassHandle_delegate$lambda$0);
    }
}

