/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.AbstractBundle;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.SyntaxTreeBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicDeclarationParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class BasicFileParser {
    protected final TokenSet IMPORT_LIST_STOPPER_SET;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final TokenSet IMPLICIT_CLASS_INDICATORS;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicFileParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicFileParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.IMPORT_LIST_STOPPER_SET = TokenSet.orSet(BasicElementTypes.BASIC_MODIFIER_BIT_SET, TokenSet.create(JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT));
        this.IMPLICIT_CLASS_INDICATORS = TokenSet.create(this.myJavaElementTypeContainer.METHOD, this.myJavaElementTypeContainer.FIELD, this.myJavaElementTypeContainer.CLASS_INITIALIZER);
    }

    public void parse(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            BasicFileParser.$$$reportNull$$$0(1);
        }
        this.parseFile(builder2, this::stopImportListParsing, JavaPsiBundle.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder2, @NotNull Predicate<? super PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder2 == null) {
            BasicFileParser.$$$reportNull$$$0(2);
        }
        if (importListStopper == null) {
            BasicFileParser.$$$reportNull$$$0(3);
        }
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(4);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(5);
        }
        this.parsePackageStatement(builder2);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder2, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        SyntaxTreeBuilder.Marker invalidElements = null;
        boolean isImplicitClass = false;
        while (!builder2.eof()) {
            if (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.myParser.getModuleParser().parse(builder2);
            if (declaration == null) {
                declaration = this.parseInitial(builder2);
            }
            if (declaration != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(BasicFileParser.error(bundle, errorMessageKey), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk == null) {
                    firstDeclarationOk = BasicJavaParserUtil.exprType(declaration) != this.myJavaElementTypeContainer.MODIFIER_LIST;
                }
                if (firstDeclaration == null) {
                    firstDeclaration = declaration;
                }
                if (isImplicitClass || !this.IMPLICIT_CLASS_INDICATORS.contains(BasicJavaParserUtil.exprType(declaration))) continue;
                isImplicitClass = true;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder2.mark();
            }
            builder2.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(BasicFileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getPrecedingCommentBinder(BasicJavaParserUtil.getLanguageLevel(builder2)), null);
            firstDeclaration.setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getSpecialPrecedingCommentBinder(BasicJavaParserUtil.getLanguageLevel(builder2)), null);
        }
        if (isImplicitClass) {
            PsiBuilder.Marker beforeFirst = firstDeclaration.precede();
            BasicJavaParserUtil.done(beforeFirst, this.myJavaElementTypeContainer.IMPLICIT_CLASS, builder2, this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private boolean stopImportListParsing(PsiBuilder b) {
        String text;
        IElementType type = b.getTokenType();
        if (this.IMPORT_LIST_STOPPER_SET.contains(type) || BasicDeclarationParser.isRecordToken(b, type)) {
            return true;
        }
        return type == JavaTokenType.IDENTIFIER && ("open".equals(text = b.getTokenText()) || "module".equals(text));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder2) {
        return this.myParser.getDeclarationParser().parse(builder2, BasicDeclarationParser.BaseContext.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder2) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement = builder2.mark();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder2.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder2);
            BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, builder2, this.myWhiteSpaceAndCommentSetHolder);
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.PACKAGE_KEYWORD)) {
                statement.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, false, false, false)) == null) {
            statement.error(JavaPsiBundle.message("expected.class.or.interface", new Object[0]));
            return;
        }
        BasicJavaParserUtil.semicolon(builder2);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.PACKAGE_STATEMENT, builder2, this.myWhiteSpaceAndCommentSetHolder);
    }

    @NotNull
    protected Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder2, Predicate<? super PsiBuilder> stopper) {
        PsiBuilder.Marker list = builder2.mark();
        boolean isEmpty = true;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while (!builder2.eof() && !stopper.test(builder2)) {
            if (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseImportStatement(builder2);
            if (statement != null) {
                isEmpty = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), statement);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder2.mark();
            }
            builder2.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.rollbackTo();
        }
        if (isEmpty) {
            PsiBuilder.Marker precede = list.precede();
            list.rollbackTo();
            list = precede;
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.IMPORT_LIST, builder2, this.myWhiteSpaceAndCommentSetHolder);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(list, isEmpty);
        if (pair == null) {
            BasicFileParser.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nullable
    protected PsiBuilder.Marker parseImportStatement(PsiBuilder builder2) {
        boolean isModule;
        if (builder2.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        String identifierText = builder2.getTokenText();
        IElementType type = this.getImportType(builder2);
        boolean isStatic = type == this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT;
        boolean bl = isModule = type == this.myJavaElementTypeContainer.IMPORT_MODULE_STATEMENT;
        boolean isOk = isModule ? this.myParser.getModuleParser().parseName(builder2) != null : this.myParser.getReferenceParser().parseImportCodeReference(builder2, isStatic);
        if (isOk && !isModule && !isStatic && builder2.getTokenType() != JavaTokenType.SEMICOLON && "module".equals(identifierText)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier.or.semicolon", new Object[0]));
        } else if (isOk) {
            BasicJavaParserUtil.semicolon(builder2);
        }
        BasicJavaParserUtil.done(statement, type, builder2, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private IElementType getImportType(@NotNull PsiBuilder builder2) {
        IElementType type;
        if (builder2 == null) {
            BasicFileParser.$$$reportNull$$$0(7);
        }
        if ((type = builder2.getTokenType()) == JavaTokenType.STATIC_KEYWORD) {
            builder2.advanceLexer();
            IElementType iElementType = this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT;
            if (iElementType == null) {
                BasicFileParser.$$$reportNull$$$0(8);
            }
            return iElementType;
        }
        if (type == JavaTokenType.IDENTIFIER && "module".equals(builder2.getTokenText()) && builder2.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            builder2.remapCurrentToken(JavaTokenType.MODULE_KEYWORD);
            builder2.advanceLexer();
            IElementType iElementType = this.myJavaElementTypeContainer.IMPORT_MODULE_STATEMENT;
            if (iElementType == null) {
                BasicFileParser.$$$reportNull$$$0(9);
            }
            return iElementType;
        }
        IElementType iElementType = this.myJavaElementTypeContainer.IMPORT_STATEMENT;
        if (iElementType == null) {
            BasicFileParser.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(11);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(12);
        }
        String string = bundle.getMessage(errorMessageKey, new Object[0]);
        if (string == null) {
            BasicFileParser.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importListStopper";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportList";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

