/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.fileTypes;

import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DynamicPluginListener;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.EmptyFileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public abstract class FileTypeRegistry {
    private static volatile FileTypeRegistry instance;

    @ApiStatus.Internal
    public static void setInstanceSupplier(@NotNull Supplier<? extends FileTypeRegistry> supplier, @NotNull Disposable parentDisposable) {
        if (supplier == null) {
            FileTypeRegistry.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            FileTypeRegistry.$$$reportNull$$$0(1);
        }
        FileTypeRegistry oldInstance = instance;
        instance = supplier.get();
        Disposer.register(parentDisposable, () -> {
            instance = oldInstance;
        });
    }

    public FileTypeRegistry() {
        MessageBus messageBus;
        Application application = ApplicationManager.getApplication();
        if (application != null && !application.isDisposed() && !(messageBus = application.getMessageBus()).isDisposed()) {
            messageBus.simpleConnect().subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){});
        }
    }

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        if (file == null) {
            FileTypeRegistry.$$$reportNull$$$0(2);
        }
        if (type == null) {
            FileTypeRegistry.$$$reportNull$$$0(3);
        }
        return file.getFileType() == type;
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        if (language == null) {
            FileTypeRegistry.$$$reportNull$$$0(4);
        }
        return language.findMyFileType(this.getRegisteredFileTypes());
    }

    public static FileTypeRegistry getInstance() {
        FileTypeRegistry cached = instance;
        if (cached == null) {
            Application application = ApplicationManager.getApplication();
            Class<?> aClass = null;
            try {
                aClass = Class.forName("org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            cached = application == null || aClass == null || !application.hasComponent(aClass) ? new EmptyFileTypeRegistry() : (FileTypeRegistry)application.getService(aClass);
            instance = cached;
        }
        return cached;
    }

    public abstract FileType @NotNull [] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file, byte @Nullable [] content) {
        if (file == null) {
            FileTypeRegistry.$$$reportNull$$$0(5);
        }
        FileType fileType = this.getFileTypeByFile(file);
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(6);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileNameSeq) {
        if (fileNameSeq == null) {
            FileTypeRegistry.$$$reportNull$$$0(7);
        }
        FileType fileType = this.getFileTypeByFileName(fileNameSeq.toString());
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull String var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NotNull String var1);

    public abstract FileType findFileTypeByName(@NotNull String var1);

    static {
        ApplicationManager.registerCleaner(() -> {
            instance = null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSeq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInstanceSupplier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFileOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

