/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.util.MathUtil;

@ApiStatus.Internal
public final class TextRangeScalarUtil {
    public static long toScalarRange(@NotNull Segment range) {
        if (range == null) {
            TextRangeScalarUtil.$$$reportNull$$$0(0);
        }
        return TextRangeScalarUtil.toScalarRange(range.getStartOffset(), range.getEndOffset());
    }

    public static long toScalarRange(int start, int end) {
        if (start > end || start < 0) {
            throw new IllegalArgumentException("Incorrect offsets: start=" + start + "; end=" + end);
        }
        return (long)end << 32 | (long)start;
    }

    public static long shift(long range, int deltaStart, int deltaEnd) {
        int newEnd = Math.max(TextRangeScalarUtil.endOffset(range) + deltaEnd, 0);
        int newStart = MathUtil.clamp(TextRangeScalarUtil.startOffset(range) + deltaStart, 0, newEnd);
        return TextRangeScalarUtil.toScalarRange(newStart, newEnd);
    }

    public static int startOffset(long range) {
        return (int)range & Integer.MAX_VALUE;
    }

    public static int endOffset(long range) {
        return (int)(range >>> 32);
    }

    @NotNull
    public static TextRange create(long range) {
        TextRange textRange = TextRange.create(TextRangeScalarUtil.startOffset(range), TextRangeScalarUtil.endOffset(range));
        if (textRange == null) {
            TextRangeScalarUtil.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/TextRangeScalarUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/TextRangeScalarUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toScalarRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

