/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.EnvironmentUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SynchronizedClearableLazy;

@ApiStatus.Internal
public final class PathExecLazyValue {
    @NotNull
    public static Supplier<Boolean> create(@NotNull String name2) {
        if (name2 == null) {
            PathExecLazyValue.$$$reportNull$$$0(0);
        }
        if (Strings.containsAnyChar(name2, "/\\")) {
            throw new IllegalArgumentException(name2);
        }
        return new SynchronizedClearableLazy<Boolean>(() -> {
            String path = EnvironmentUtil.getValue("PATH");
            if (path != null) {
                for (String dir2 : StringUtil.tokenize(path, File.pathSeparator)) {
                    if (!new File(dir2, name2).canExecute()) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/io/PathExecLazyValue", "create"));
    }
}

