/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.GenericZipFile;
import org.jetbrains.kotlin.com.intellij.util.io.zip.JBZipEntry;
import org.jetbrains.kotlin.com.intellij.util.io.zip.JBZipFile;

@ApiStatus.Internal
public final class JBZipFileWrapper
implements GenericZipFile {
    private final JBZipFile myZipFile;

    public JBZipFileWrapper(File file) throws IOException {
        this.myZipFile = new JBZipFile(file, true);
    }

    @Override
    @Nullable
    public GenericZipFile.GenericZipEntry getEntry(@NotNull String entryName) throws IOException {
        JBZipEntry entry;
        if (entryName == null) {
            JBZipFileWrapper.$$$reportNull$$$0(0);
        }
        return (entry = this.myZipFile.getEntry(entryName)) != null ? new EntryWrapper(entry) : null;
    }

    @Override
    @NotNull
    public List<? extends GenericZipFile.GenericZipEntry> getEntries() {
        List<JBZipEntry> entries = this.myZipFile.getEntries();
        ArrayList<EntryWrapper> list = new ArrayList<EntryWrapper>(entries.size());
        for (JBZipEntry entry : entries) {
            list.add(new EntryWrapper(entry));
        }
        ArrayList<EntryWrapper> arrayList = list;
        if (arrayList == null) {
            JBZipFileWrapper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public void close() throws IOException {
        this.myZipFile.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/JBZipFileWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/JBZipFileWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EntryWrapper
    implements GenericZipFile.GenericZipEntry {
        private final JBZipEntry myEntry;

        EntryWrapper(JBZipEntry entry) {
            this.myEntry = entry;
        }

        @Override
        public long getSize() {
            return this.myEntry.getSize();
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myEntry.getName();
            if (string == null) {
                EntryWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public long getCrc() {
            return this.myEntry.getCrc();
        }

        @Override
        public boolean isDirectory() {
            return this.myEntry.isDirectory();
        }

        @Override
        @Nullable
        public InputStream getInputStream() throws IOException {
            return this.myEntry.getInputStream();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/JBZipFileWrapper$EntryWrapper", "getName"));
        }
    }
}

