/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileTooBigException;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.StreamUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ArchiveHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.GenericZipFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.JBZipFileWrapper;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.JavaZipFileWrapper;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipEntryMap;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.limits.FileSizeLimit;
import org.jetbrains.kotlin.com.intellij.util.io.ResourceHandle;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    private static final Logger LOG = Logger.getInstance(ZipHandlerBase.class);

    @ApiStatus.Internal
    public static boolean getUseCrcInsteadOfTimestampPropertyValue() {
        return Boolean.getBoolean("zip.handler.uses.crc.instead.of.timestamp");
    }

    @ApiStatus.Internal
    @NotNull
    public static GenericZipFile getZipFileWrapper(@NotNull Path file) throws IOException {
        GenericZipFile wrapper;
        if (file == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        GenericZipFile genericZipFile = wrapper = ZipHandlerBase.isFileLocal(file) ? new JavaZipFileWrapper(file.toFile()) : new JBZipFileWrapper(file.toFile());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using " + wrapper.getClass().getName() + " to open " + file);
        }
        GenericZipFile genericZipFile2 = wrapper;
        if (genericZipFile2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        return genericZipFile2;
    }

    private static boolean isFileLocal(Path file) {
        FileSystem fileFs = file.getFileSystem();
        if (fileFs.equals(FileSystems.getDefault())) {
            try {
                return (Boolean)fileFs.getClass().getMethod("isRoutable", Path.class).invoke((Object)fileFs, file) == false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public ZipHandlerBase(@NotNull String path) {
        if (path == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        super(path);
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        ResourceHandle<GenericZipFile> zipRef = this.acquireZipHandle();
        List<? extends GenericZipFile.GenericZipEntry> entries = zipRef.get().getEntries();
        ZipEntryMap result2 = new ZipEntryMap(entries.size());
        boolean crcAsTimestamp = ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue();
        for (GenericZipFile.GenericZipEntry genericZipEntry : entries) {
            this.processEntry(result2, LOG, genericZipEntry.getName(), genericZipEntry.isDirectory() ? null : (parent2, name2) -> {
                long fileStamp = crcAsTimestamp ? ze.getCrc() : this.getEntryFileStamp();
                return new ArchiveHandler.EntryInfo((CharSequence)name2, false, ze.getSize(), fileStamp, (ArchiveHandler.EntryInfo)parent2);
            });
        }
        ZipEntryMap zipEntryMap = result2;
        Object object = zipEntryMap;
        if (object == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        return object;
        finally {
            if (zipRef != null) {
                zipRef.close();
            }
        }
    }

    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block15: {
            byte[] byArray;
            InputStream stream;
            ResourceHandle<GenericZipFile> zipRef;
            block16: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(4);
                }
                zipRef = this.acquireZipHandle();
                GenericZipFile zip = zipRef.get();
                GenericZipFile.GenericZipEntry entry = zip.getEntry(relativePath);
                if (entry == null) break block15;
                long length = entry.getSize();
                if (FileSizeLimit.isTooLarge(length, FileUtilRt.getExtension(entry.getName()))) {
                    throw new FileTooBigException(this.getPath() + "!/" + relativePath);
                }
                stream = entry.getInputStream();
                if (stream == null) break block15;
                byArray = StreamUtil.readBytes(stream, (int)length);
                if (byArray != null) break block16;
                ZipHandlerBase.$$$reportNull$$$0(5);
            }
            return byArray;
            {
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            finally {
                if (zipRef != null) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getPath() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<GenericZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFileWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchiveCrcHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getZipFileWrapper";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

