/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiLock;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiToDocumentSynchronizer;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.ReparseableASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;

@ApiStatus.Internal
public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    @NotNull
    public TreeChangeEventImpl performActualPsiChange(@NotNull PsiFile file) {
        if (file == null) {
            DiffLog.$$$reportNull$$$0(0);
        }
        TreeAspect modelAspect = PomManager.getModel(file.getProject()).getModelAspect(TreeAspect.class);
        TreeChangeEventImpl event = new TreeChangeEventImpl(modelAspect, file.getNode());
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file, event);
        }
        file.subtreeChanged();
        TreeChangeEventImpl treeChangeEventImpl = event;
        if (treeChangeEventImpl == null) {
            DiffLog.$$$reportNull$$$0(1);
        }
        return treeChangeEventImpl;
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            DiffLog.$$$reportNull$$$0(2);
        }
        if (newNode == null) {
            DiffLog.$$$reportNull$$$0(3);
        }
        if (oldNode instanceof FileASTNode && newNode instanceof FileASTNode) {
            this.appendReplaceFileElement((FileASTNode)oldNode, (FileASTNode)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    void appendReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            DiffLog.$$$reportNull$$$0(4);
        }
        if (newRoot == null) {
            DiffLog.$$$reportNull$$$0(5);
        }
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    void appendReplaceFileElement(@NotNull FileASTNode oldNode, @NotNull FileASTNode newNode) {
        if (oldNode == null) {
            DiffLog.$$$reportNull$$$0(6);
        }
        if (newNode == null) {
            DiffLog.$$$reportNull$$$0(7);
        }
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        if (oldParent == null) {
            DiffLog.$$$reportNull$$$0(8);
        }
        if (oldNode == null) {
            DiffLog.$$$reportNull$$$0(9);
        }
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            DiffLog.$$$reportNull$$$0(10);
        }
        if (newNode == null) {
            DiffLog.$$$reportNull$$$0(11);
        }
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    @Nullable
    private static PsiElement getPsi(@NotNull ASTNode node, @NotNull PsiFile file) {
        if (node == null) {
            DiffLog.$$$reportNull$$$0(12);
        }
        if (file == null) {
            DiffLog.$$$reportNull$$$0(13);
        }
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, ((PsiFileImpl)file).getTreeElement());
        PsiElement psiChild = file.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    public void doActualPsiChange(final @NotNull PsiFile file) {
        if (file == null) {
            DiffLog.$$$reportNull$$$0(14);
        }
        CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(() -> {
            FileViewProvider viewProvider = file.getViewProvider();
            PsiLock psiLock = ((AbstractFileViewProvider)viewProvider).getFilePsiLock();
            synchronized (psiLock) {
                viewProvider.beforeContentsSynchronized();
                Document document = viewProvider.getDocument();
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
                PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                if (transaction == null) {
                    final PomModel model = PomManager.getModel(file.getProject());
                    model.runTransaction(new PomTransactionBase(file){

                        @Override
                        @NotNull
                        public PomModelEvent runInner() {
                            return new PomModelEvent(model, DiffLog.this.performActualPsiChange(file));
                        }
                    });
                } else {
                    this.performActualPsiChange(file);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "performActualPsiChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performActualPsiChange";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeReplaced";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendReplaceElementWithEvents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendReplaceFileElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nodeDeleted";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nodeInserted";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doActualPsiChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class LogEntry {
        LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull TreeChangeEventImpl var2);
    }

    private static final class ReplaceEntry
    extends LogEntry {
        private final ASTNode myOldChild;
        private final ASTNode myNewChild;

        private ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            if (oldNode == null) {
                ReplaceEntry.$$$reportNull$$$0(0);
            }
            if (newNode == null) {
                ReplaceEntry.$$$reportNull$$$0(1);
            }
            this.myOldChild = oldNode;
            this.myNewChild = newNode;
            this.ensureOldParent();
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull TreeChangeEventImpl changeEvent) {
            PsiElement psiOldChild;
            if (file == null) {
                ReplaceEntry.$$$reportNull$$$0(2);
            }
            if (changeEvent == null) {
                ReplaceEntry.$$$reportNull$$$0(3);
            }
            ASTNode parent2 = this.ensureOldParent();
            PsiElement psiParent = parent2.getPsi();
            PsiElement psiElement = psiOldChild = file.isPhysical() ? this.myOldChild.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setFile(file);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(this.myNewChild, file);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file.getManager()).beforeChildReplacement(event);
            }
            if (!(this.myOldChild instanceof FileElement) || !(this.myNewChild instanceof FileElement)) {
                changeEvent.addElementaryChange(this.myOldChild.getTreeParent());
            }
            ((ReparseableASTNode)((Object)this.myOldChild)).applyReplaceOnReparse(this.myNewChild);
            DebugUtil.checkTreeStructure(parent2);
        }

        @NotNull
        private ASTNode ensureOldParent() {
            ASTNode parent2 = this.myOldChild.getTreeParent();
            if (parent2 == null) {
                throw PsiInvalidElementAccessException.createByNode(this.myOldChild, "new:" + this.myNewChild);
            }
            ASTNode aSTNode = parent2;
            if (aSTNode == null) {
                ReplaceEntry.$$$reportNull$$$0(4);
            }
            return aSTNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeEvent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog$ReplaceEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog$ReplaceEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ensureOldParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doActualPsiChange";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ReplaceElementWithEvents
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldRoot;
        @NotNull
        private final CompositeElement myNewRoot;

        private ReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
            if (oldRoot == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(0);
            }
            if (newRoot == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(1);
            }
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
            TreeUtil.ensureParsed(this.myOldRoot.getFirstChildNode());
            TreeUtil.ensureParsed(this.myNewRoot.getFirstChildNode());
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull TreeChangeEventImpl event) {
            if (file == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(2);
            }
            if (event == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(3);
            }
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog$ReplaceElementWithEvents";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ReplaceFileElement
    extends LogEntry {
        @NotNull
        private final FileASTNode myOldNode;
        @NotNull
        private final FileASTNode myNewNode;

        private ReplaceFileElement(@NotNull FileASTNode oldNode, @NotNull FileASTNode newNode) {
            if (oldNode == null) {
                ReplaceFileElement.$$$reportNull$$$0(0);
            }
            if (newNode == null) {
                ReplaceFileElement.$$$reportNull$$$0(1);
            }
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull TreeChangeEventImpl event) {
            if (file == null) {
                ReplaceFileElement.$$$reportNull$$$0(2);
            }
            if (event == null) {
                ReplaceFileElement.$$$reportNull$$$0(3);
            }
            event.addElementaryChange(this.myOldNode);
            ((ReparseableASTNode)((Object)this.myOldNode)).applyReplaceFileOnReparse(file, this.myNewNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog$ReplaceFileElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DeleteEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myOldNode;

        private DeleteEntry(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                DeleteEntry.$$$reportNull$$$0(0);
            }
            if (oldNode == null) {
                DeleteEntry.$$$reportNull$$$0(1);
            }
            this.myOldParent = oldParent;
            this.myOldNode = oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull TreeChangeEventImpl changeEvent) {
            PsiElement psiChild;
            if (file == null) {
                DeleteEntry.$$$reportNull$$$0(2);
            }
            if (changeEvent == null) {
                DeleteEntry.$$$reportNull$$$0(3);
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiElement = psiChild = file.isPhysical() ? this.myOldNode.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file);
                ((PsiManagerEx)file.getManager()).beforeChildRemoval(event);
            }
            changeEvent.addElementaryChange(this.myOldParent);
            ((ReparseableASTNode)((Object)this.myOldParent)).applyDeleteOnReparse(this.myOldNode);
            DebugUtil.checkTreeStructure(this.myOldParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeEvent";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog$DeleteEntry";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InsertEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myNewNode;
        private final int myPos;

        private InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            if (oldParent == null) {
                InsertEntry.$$$reportNull$$$0(0);
            }
            if (newNode == null) {
                InsertEntry.$$$reportNull$$$0(1);
            }
            assert (pos >= 0) : pos;
            this.myOldParent = oldParent;
            this.myNewNode = newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull TreeChangeEventImpl changeEvent) {
            if (file == null) {
                InsertEntry.$$$reportNull$$$0(2);
            }
            if (changeEvent == null) {
                InsertEntry.$$$reportNull$$$0(3);
            }
            ASTNode anchor = null;
            ASTNode firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i = 0; i < this.myPos; ++i) {
                anchor = anchor == null ? firstChildNode : anchor.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file);
                ((PsiManagerEx)file.getManager()).beforeChildAddition(event);
            }
            changeEvent.addElementaryChange(this.myOldParent);
            ((ReparseableASTNode)((Object)this.myOldParent)).applyInsertOnReparse(this.myNewNode, anchor);
            DebugUtil.checkTreeStructure(this.myOldParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeEvent";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DiffLog$InsertEntry";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

