/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.IncompleteDependenciesService;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaParameterType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

@ApiStatus.Internal
public final class IncompleteModelUtil {
    public static boolean isHierarchyResolved(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            IncompleteModelUtil.$$$reportNull$$$0(0);
        }
        HashSet<PsiClass> processed = new HashSet<PsiClass>();
        ArrayDeque<PsiClass> stack = new ArrayDeque<PsiClass>();
        stack.push(psiClass);
        while (!stack.isEmpty()) {
            PsiClass currentClass = (PsiClass)stack.pop();
            if (!processed.add(currentClass)) continue;
            for (PsiClassType type : currentClass.getSuperTypes()) {
                PsiClass resolved = type.resolve();
                if (resolved == null) {
                    return false;
                }
                stack.push(resolved);
            }
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isUnresolvedClassType(@Nullable PsiType psiType) {
        ArrayDeque<PsiType> stack = new ArrayDeque<PsiType>();
        if (psiType != null) {
            stack.push(psiType);
        }
        while (!stack.isEmpty()) {
            PsiClass resolved;
            PsiType currentType = (PsiType)stack.pop();
            if (currentType instanceof PsiLambdaParameterType) {
                return true;
            }
            if (currentType instanceof PsiIntersectionType) {
                Collections.addAll(stack, ((PsiIntersectionType)currentType).getConjuncts());
            }
            if (currentType instanceof PsiDisjunctionType) {
                stack.addAll(((PsiDisjunctionType)currentType).getDisjunctions());
            }
            if (!(currentType instanceof PsiClassType) || (resolved = ((PsiClassType)currentType).resolve()) != null && IncompleteModelUtil.isHierarchyResolved(resolved)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean hasUnresolvedComponent(@Nullable PsiType psiType) {
        return IncompleteModelUtil.hasUnresolvedComponentRecursively(psiType, new HashSet<PsiClass>());
    }

    private static boolean hasUnresolvedComponentRecursively(@Nullable PsiType psiType, @NotNull HashSet<PsiClass> visited2) {
        if (visited2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(1);
        }
        if (psiType == null) {
            return false;
        }
        PsiType type = psiType.getDeepComponentType();
        if (IncompleteModelUtil.isUnresolvedClassType(psiType)) {
            return true;
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
            if (psiClass != null && !visited2.add(psiClass)) {
                return false;
            }
            for (PsiType parameter : ((PsiClassType)type).getParameters()) {
                if (!IncompleteModelUtil.hasUnresolvedComponentRecursively(parameter, visited2)) continue;
                return true;
            }
        }
        if (type instanceof PsiWildcardType) {
            return IncompleteModelUtil.hasUnresolvedComponentRecursively(((PsiWildcardType)type).getBound(), visited2);
        }
        if (type instanceof PsiCapturedWildcardType) {
            return IncompleteModelUtil.hasUnresolvedComponentRecursively(((PsiCapturedWildcardType)type).getLowerBound(), visited2) || IncompleteModelUtil.hasUnresolvedComponentRecursively(((PsiCapturedWildcardType)type).getUpperBound(), visited2);
        }
        return false;
    }

    public static boolean isIncompleteModel(@NotNull PsiElement context2) {
        if (context2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(2);
        }
        return !context2.getProject().getService(IncompleteDependenciesService.class).getState().isComplete();
    }

    public static boolean isPotentiallyConvertible(@Nullable PsiType targetType, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(3);
        }
        PsiType rightType = expression2.getType();
        return IncompleteModelUtil.isPotentiallyConvertible(targetType, expression2, rightType, expression2);
    }

    public static boolean isPotentiallyConvertible(@Nullable PsiType leftType, @NotNull PsiType rightType, @NotNull PsiElement context2) {
        if (rightType == null) {
            IncompleteModelUtil.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(5);
        }
        return IncompleteModelUtil.isPotentiallyConvertible(leftType, null, rightType, context2);
    }

    private static boolean isPotentiallyConvertible(@Nullable PsiType leftType, @Nullable PsiExpression rightExpr, @Nullable PsiType rightType, @NotNull PsiElement context2) {
        boolean pendingRight;
        boolean pendingLeft;
        if (context2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(6);
        }
        if (leftType instanceof PsiLambdaParameterType || rightType instanceof PsiLambdaParameterType) {
            return true;
        }
        boolean bl = pendingLeft = leftType == null || IncompleteModelUtil.hasUnresolvedComponent(leftType);
        boolean bl2 = rightType == null || (rightExpr == null ? IncompleteModelUtil.hasUnresolvedComponent(rightType) : IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(rightExpr)) ? true : (pendingRight = false);
        if (pendingLeft && pendingRight) {
            return true;
        }
        if (!pendingLeft && !pendingRight) {
            return leftType.isConvertibleFrom(rightType);
        }
        if (pendingLeft && IncompleteModelUtil.isStrictlyInconvertible(leftType, rightType, context2)) {
            return false;
        }
        return !pendingRight || !IncompleteModelUtil.isStrictlyInconvertible(rightType, leftType, context2);
    }

    private static boolean isStrictlyInconvertible(@Nullable PsiType pendingType, @Nullable PsiType resolvedType, @NotNull PsiElement context2) {
        if (context2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(7);
        }
        if (pendingType != null) {
            if (resolvedType instanceof PsiPrimitiveType && ((PsiPrimitiveType)resolvedType).getBoxedType(context2) != null) {
                return true;
            }
            PsiClass rightTypeClass = PsiUtil.resolveClassInClassTypeOnly(resolvedType);
            if (rightTypeClass != null && rightTypeClass.hasModifierProperty("final") && rightTypeClass.getTypeParameters().length == 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean mayHaveUnknownTypeDueToPendingReference(@NotNull PsiExpression expression2) {
        PsiType type;
        if (expression2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(8);
        }
        if ((type = expression2.getType()) != null && !(type instanceof PsiMethodReferenceType)) {
            return IncompleteModelUtil.hasUnresolvedComponent(type);
        }
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiMethodCallExpression && IncompleteModelUtil.canBePendingReference(((PsiMethodCallExpression)expression2).getMethodExpression())) {
            return true;
        }
        if (expression2 instanceof PsiReferenceExpression && IncompleteModelUtil.canBePendingReference((PsiReferenceExpression)expression2)) {
            return true;
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            return IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(((PsiArrayAccessExpression)expression2).getArrayExpression());
        }
        return false;
    }

    private static boolean mayHaveNullTypeDueToPendingReference(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            IncompleteModelUtil.$$$reportNull$$$0(9);
        }
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement target = ((PsiReferenceExpression)expression2).resolve();
        if (!(target instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable local = (PsiLocalVariable)target;
        if (!local.getTypeElement().isInferredType()) {
            return false;
        }
        PsiExpression initializer = local.getInitializer();
        if (initializer == null) {
            return false;
        }
        PsiType initializerType = initializer.getType();
        return initializerType == null && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(initializer) || PsiTypes.nullType().equals(initializerType) && IncompleteModelUtil.mayHaveNullTypeDueToPendingReference(initializer);
    }

    public static List<PsiImportStatementBase> getPotentialImports(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent2;
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(10);
        }
        if ((parent2 = ref.getParent()) instanceof PsiImportStatementBase || ref.isQualified()) {
            return Collections.emptyList();
        }
        boolean maybeClass = IncompleteModelUtil.canBeClass(ref);
        if (!(ref.getContainingFile() instanceof PsiJavaFile)) {
            return Collections.emptyList();
        }
        PsiImportList list = ((PsiJavaFile)ref.getContainingFile()).getImportList();
        ArrayList<PsiImportStatementBase> imports = new ArrayList<PsiImportStatementBase>();
        if (list != null) {
            for (PsiImportStatementBase statement : list.getAllImportStatements()) {
                String name2;
                PsiJavaCodeReferenceElement reference2;
                if (statement instanceof PsiImportStaticStatement && ((PsiImportStaticStatement)statement).resolveTargetClass() != null || !statement.isOnDemand() && ((reference2 = statement.getImportReference()) == null || (name2 = reference2.getReferenceName()) == null || !name2.equals(ref.getReferenceName()) || reference2.resolve() != null) || !maybeClass && !(statement instanceof PsiImportStaticStatement)) continue;
                imports.add(statement);
            }
        }
        return imports;
    }

    private static boolean canBeClass(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent2;
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(11);
        }
        if ((parent2 = ref.getParent()) instanceof PsiMethodCallExpression) {
            return false;
        }
        if (!(ref instanceof PsiReferenceExpression)) {
            return true;
        }
        return parent2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent2).getQualifierExpression() == ref;
    }

    public static boolean canBePendingReference(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(12);
        }
        if (ref instanceof PsiReferenceExpression) {
            PsiType qualifierType;
            PsiExpression qualifier = ((PsiReferenceExpression)ref).getQualifierExpression();
            if (qualifier == null) {
                PsiClass psiClass = PsiUtil.getContainingClass(ref);
                while (psiClass != null) {
                    if (!IncompleteModelUtil.isHierarchyResolved(psiClass)) {
                        return true;
                    }
                    psiClass = PsiUtil.getContainingClass(psiClass);
                }
                return !IncompleteModelUtil.getPotentialImports(ref).isEmpty();
            }
            if (qualifier instanceof PsiReferenceExpression) {
                PsiElement qualifierTarget = ((PsiReferenceExpression)qualifier).resolve();
                if (qualifierTarget == null && IncompleteModelUtil.canBePendingReference((PsiReferenceExpression)qualifier)) {
                    return true;
                }
                if (qualifierTarget instanceof PsiClass && IncompleteModelUtil.isHierarchyResolved((PsiClass)qualifierTarget)) {
                    return false;
                }
            }
            return IncompleteModelUtil.isUnresolvedClassType(qualifierType = qualifier.getType()) || qualifierType == null && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(qualifier) || PsiTypes.nullType().equals(qualifierType) && IncompleteModelUtil.mayHaveNullTypeDueToPendingReference(qualifier);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/IncompleteModelUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isHierarchyResolved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUnresolvedComponentRecursively";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncompleteModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPotentiallyConvertible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isStrictlyInconvertible";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHaveUnknownTypeDueToPendingReference";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHaveNullTypeDueToPendingReference";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getPotentialImports";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePendingReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

