/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadActionProcessor;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbAware;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwnerEx;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaMultiReleaseUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiClassUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class PsiElementFinderImpl
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public PsiElementFinderImpl(Project project) {
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(project);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(1);
        }
        if (this.skipIndices()) {
            return null;
        }
        return this.myFileManager.findClass(qualifiedName, scope2);
    }

    private boolean skipIndices() {
        DumbService dumbService = DumbService.getInstance(this.myProject);
        return dumbService.isAlternativeResolveEnabled();
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(3);
        }
        if (this.skipIndices()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiElementFinderImpl.$$$reportNull$$$0(4);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = this.myFileManager.findClasses(qualifiedName, scope2);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Override
    public boolean hasClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2, @NotNull Predicate<PsiClass> filter) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(6);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(8);
        }
        if (this.skipIndices()) {
            return false;
        }
        return this.myFileManager.hasClass(qualifiedName, scope2, filter);
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(9);
        }
        return this.myFileManager.findPackage(qualifiedName);
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(10);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(11);
        }
        HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
        String qualifiedName = psiPackage.getQualifiedName();
        for (PsiDirectory dir2 : psiPackage.getDirectories(scope2)) {
            PsiDirectory[] subDirs;
            for (PsiDirectory subDir : subDirs = dir2.getSubdirectories()) {
                String subQualifiedName;
                PsiPackage aPackage;
                if (JavaMultiReleaseUtil.getVersion(subDir.getVirtualFile()) != null || (aPackage = JavaDirectoryService.getInstance().getPackage(subDir)) == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                packagesMap.put(aPackage.getQualifiedName(), aPackage);
            }
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(12);
        }
        return psiPackageArray;
    }

    @Override
    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(13);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(14);
        }
        PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope2);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(15);
        }
        return psiClassArray;
    }

    @Override
    public PsiClass @NotNull [] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(16);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(17);
        }
        ArrayList<PsiClass> list = null;
        String packageName = psiPackage.getQualifiedName();
        for (PsiDirectory dir2 : psiPackage.getDirectories(scope2)) {
            PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir2, scope2);
            if (classes.length == 0) continue;
            if (list == null) {
                list = new ArrayList<PsiClass>();
            }
            for (PsiClass aClass : classes) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName != null) {
                    qualifiedName = StringUtil.getPackageName(qualifiedName);
                }
                if (!Comparing.strEqual(qualifiedName, packageName) || shortName != null && !shortName.equals(aClass.getName())) continue;
                list.add(aClass);
            }
        }
        if (list == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiElementFinderImpl.$$$reportNull$$$0(18);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (list.size() > 1) {
            ContainerUtil.quickSort(list, PsiClassUtil.createScopeComparator(scope2));
        }
        PsiClass[] psiClassArray = list.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(19);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(20);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(21);
        }
        HashSet<String> names = null;
        FileIndexFacade facade = FileIndexFacade.getInstance(this.myProject);
        for (PsiDirectory dir2 : psiPackage.getDirectories(scope2)) {
            for (PsiFile file : dir2.getFiles(scope2)) {
                Set<String> inFile;
                VirtualFile vFile;
                if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (vFile = file.getVirtualFile()) != null && !(file instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope2.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                Set<String> set = inFile = file instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file).getClasses());
                if (inFile.isEmpty()) continue;
                if (names == null) {
                    names = new HashSet<String>();
                }
                names.addAll(inFile);
            }
        }
        Set<String> set = names == null ? Collections.emptySet() : names;
        if (set == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2, final @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(23);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(24);
        }
        if (consumer == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(25);
        }
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return PackageIndex.getInstance(this.myProject).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile dir2) {
                PsiDirectory psiDir;
                return !scope2.contains(dir2) || (psiDir = psiManager.findDirectory(dir2)) == null || consumer.process(psiDir);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFinderImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFinderImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

