/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectoryContainer;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.search.EverythingGlobalScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class PsiPackageBase
extends PsiElementBase
implements Queryable,
PsiDirectoryContainer {
    private static final Logger LOG = Logger.getInstance(PsiPackageBase.class);
    private final PsiManager myManager;
    @NotNull
    private final String myQualifiedName;

    protected abstract @Unmodifiable Collection<PsiDirectory> getAllDirectories(@NotNull GlobalSearchScope var1);

    protected abstract PsiPackageBase findPackage(@NotNull String var1);

    public PsiPackageBase(PsiManager manager, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiPackageBase.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.myManager == ((PsiPackageBase)o).myManager && this.myQualifiedName.equals(((PsiPackageBase)o).myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            PsiPackageBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public PsiDirectory @NotNull [] getDirectories() {
        PsiDirectory[] psiDirectoryArray = this.getDirectories(new EverythingGlobalScope());
        if (psiDirectoryArray == null) {
            PsiPackageBase.$$$reportNull$$$0(2);
        }
        return psiDirectoryArray;
    }

    @Override
    public PsiDirectory @NotNull [] getDirectories(@NotNull GlobalSearchScope scope2) {
        Collection<PsiDirectory> directories;
        if (scope2 == null) {
            PsiPackageBase.$$$reportNull$$$0(3);
        }
        PsiDirectory[] psiDirectoryArray = (directories = this.getAllDirectories(scope2)).isEmpty() ? PsiDirectory.EMPTY_ARRAY : directories.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PsiPackageBase.$$$reportNull$$$0(4);
        }
        return psiDirectoryArray;
    }

    @Override
    public RowIcon getElementIcon(int elementFlags) {
        return IconManager.getInstance().createLayeredIcon(this, IconManager.getInstance().getPlatformIcon(PlatformIcons.Package), elementFlags);
    }

    @Override
    public String getName() {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        int index = this.myQualifiedName.lastIndexOf(46);
        if (index <= 0) {
            return this.myQualifiedName;
        }
        return this.myQualifiedName.substring(index + 1);
    }

    @Override
    @Nullable
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name2 == null) {
            PsiPackageBase.$$$reportNull$$$0(5);
        }
        this.checkSetName(name2);
        for (PsiDirectory dir2 : dirs = this.getDirectories()) {
            dir2.setName(name2);
        }
        String nameAfterRename = PsiUtilCore.getQualifiedNameAfterRename(this.getQualifiedName(), name2);
        return this.findPackage(nameAfterRename);
    }

    public void checkSetName(@NotNull String name2) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name2 == null) {
            PsiPackageBase.$$$reportNull$$$0(6);
        }
        for (PsiDirectory dir2 : dirs = this.getDirectories()) {
            dir2.checkSetName(name2);
        }
    }

    @Nullable
    public PsiPackageBase getParentPackage() {
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        return this.findPackage(StringUtil.getPackageName(this.myQualifiedName));
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        LOG.error("method not implemented in " + this.getClass());
        if (PsiElement.EMPTY_ARRAY == null) {
            PsiPackageBase.$$$reportNull$$$0(7);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getParent() {
        return this.getParentPackage();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    @Nullable
    public String getText() {
        return null;
    }

    @Override
    public char @NotNull [] textToCharArray() {
        if (ArrayUtilRt.EMPTY_CHAR_ARRAY == null) {
            PsiPackageBase.$$$reportNull$$$0(8);
        }
        return ArrayUtilRt.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            PsiPackageBase.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiPackageBase.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    public PsiElement copy() {
        LOG.error("method not implemented in " + this.getClass());
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiPackageBase.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiPackageBase.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiPackageBase.$$$reportNull$$$0(13);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiPackageBase.$$$reportNull$$$0(14);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiDirectory[] dirs;
        this.checkDelete();
        for (PsiDirectory dir2 : dirs = this.getDirectories()) {
            dir2.delete();
        }
    }

    @Override
    @Deprecated
    public void checkDelete() throws IncorrectOperationException {
        for (PsiDirectory dir2 : this.getDirectories()) {
            dir2.checkDelete();
        }
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiPackageBase.$$$reportNull$$$0(15);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isWritable() {
        PsiDirectory[] dirs;
        for (PsiDirectory dir2 : dirs = this.getDirectories()) {
            if (dir2.isWritable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiPackageBase:" + this.getQualifiedName();
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiPackageBase.$$$reportNull$$$0(16);
        }
        info.put("packageName", this.getName());
        info.put("packageQualifiedName", this.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkSetName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

