/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondTypeImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiUnnamedPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.SyntaxTraverser;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.ClassReferencePointer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaVarTypeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaPsiPatternUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntArrayList;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type) {
        if (type == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = CachedValuesManager.getProjectPsiDependentCache(this, __ -> this.calculateType());
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType(this);
        if (inferredType != null) {
            PsiType psiType = inferredType;
            if (psiType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(3);
            }
            return psiType;
        }
        PsiType type = null;
        boolean ellipsis = false;
        SmartList<PsiAnnotation> annotations2 = new SmartList<PsiAnnotation>();
        SmartList<TypeAnnotationProvider> arrayComponentAnnotations = new SmartList<TypeAnnotationProvider>();
        PsiElement parent2 = this.getParent();
        PsiElement firstChild = this.getFirstChild();
        if (firstChild == null && parent2 instanceof PsiUnnamedPattern) {
            type = JavaPsiPatternUtil.getDeconstructedImplicitPatternType((PsiPattern)parent2);
        }
        for (PsiElement child = firstChild; child != null; child = child.getNextSibling()) {
            List<PsiType> types2;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations2.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type = new PsiDiamondTypeImpl(this.getManager(), this);
                    break;
                }
                type = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken(child, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type == null) : this;
                String text = child.getText();
                type = annotations2.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text) : new PsiPrimitiveType(text, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.VAR_KEYWORD)) {
                assert (type == null) : this;
                type = this.inferVarType(parent2);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type == null) : this;
                type = new PsiClassReferenceType(PsiTypeElementImpl.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                assert (type != null) : this;
                arrayComponentAnnotations.add(PsiTypeElementImpl.createProvider(annotations2));
                annotations2 = new SmartList();
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) {
                assert (type != null) : this;
                arrayComponentAnnotations.add(PsiTypeElementImpl.createProvider(annotations2));
                annotations2 = new SmartList();
                ellipsis = true;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.QUEST)) {
                assert (type == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward(child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward(boundKind);
                type = PsiUtil.isJavaToken(boundKind, JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken(boundKind, JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded(this.getManager()));
                type = type.annotate(PsiTypeElementImpl.createProvider(annotations2));
                break;
            }
            if (child instanceof ASTNode) {
                ((ASTNode)((Object)child)).getElementType();
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.AND)) {
                types2 = this.collectTypes();
                assert (!types2.isEmpty()) : this;
                type = PsiIntersectionType.createIntersection(false, types2.toArray(PsiType.createArray(types2.size())));
                break;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.OR)) continue;
            types2 = this.collectTypes();
            assert (!types2.isEmpty()) : this;
            type = PsiDisjunctionType.createDisjunction(types2, this.getManager());
            break;
        }
        if (type == null) {
            PsiType psiType = PsiTypes.nullType();
            if (psiType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(4);
            }
            return psiType;
        }
        if (!arrayComponentAnnotations.isEmpty()) {
            type = PsiTypeElementImpl.createArray(type, arrayComponentAnnotations, ellipsis);
        }
        if (parent2 instanceof PsiModifierListOwner) {
            type = JavaSharedImplUtil.applyAnnotations(type, ((PsiModifierListOwner)parent2).getModifierList());
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    private static PsiType createArray(PsiType elementType, List<TypeAnnotationProvider> providers, boolean ellipsis) {
        PsiType result2 = elementType;
        for (int i = providers.size() - 1; i >= 0; --i) {
            TypeAnnotationProvider provider = providers.get(i);
            result2 = ellipsis && i == 0 ? new PsiEllipsisType(result2, provider) : new PsiArrayType(result2, provider);
        }
        providers.clear();
        return result2;
    }

    private PsiType inferVarType(PsiElement parent2) {
        if (parent2 instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)parent2;
            if (parameter instanceof PsiPatternVariable) {
                return JavaPsiPatternUtil.getDeconstructedImplicitPatternVariableType((PsiPatternVariable)parameter);
            }
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue != null) {
                    PsiType type = JavaGenericsUtil.getCollectionItemType(iteratedValue);
                    return type != null ? JavaVarTypeUtil.getUpwardProjection(type) : null;
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return parameter.getType();
            }
        } else {
            for (PsiElement e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!PsiTreeUtil.processElements(e, PsiReferenceExpression.class, ref -> !ref.isReferenceTo(parent2))) {
                    return null;
                }
                if (!(e instanceof PsiArrayInitializerExpression)) {
                    PsiExpression expression2 = (PsiExpression)e;
                    RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                    PsiType type = RecursionManager.doPreventingRecursion(expression2, true, () -> expression2.getType());
                    if (stamp.mayCacheNow()) {
                        return type == null ? null : JavaVarTypeUtil.getUpwardProjection(type);
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isInferredType() {
        return PsiUtil.isJavaToken(this.getFirstChild(), JavaTokenType.VAR_KEYWORD) || PsiAugmentProvider.isInferredType(this);
    }

    @NotNull
    private static ClassReferencePointer getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement root;
        PsiElement parent2;
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = parent2 = (root = SyntaxTraverser.psiApi().parents(ref.getParent()).takeWhile(it -> it instanceof PsiTypeElement || it instanceof PsiReferenceParameterList || it instanceof PsiJavaCodeReferenceElement).last()) instanceof PsiTypeElement ? root.getParent() : null;
        if (parent2 instanceof PsiMethod || parent2 instanceof PsiVariable) {
            PsiModifierListOwner owner = (PsiModifierListOwner)parent2;
            int[] pathFromRoot = PsiTypeElementImpl.getPathFromRoot(ref);
            return PsiTypeElementImpl.computeFromTypeOwner(owner, pathFromRoot, new WeakReference<PsiJavaCodeReferenceElement>(ref));
        }
        ClassReferencePointer classReferencePointer = ClassReferencePointer.constant(ref);
        if (classReferencePointer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(7);
        }
        return classReferencePointer;
    }

    private static int[] getPathFromRoot(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent2;
        block8: {
            if (ref == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(8);
            }
            IntArrayList result2 = null;
            while (true) {
                if ((parent2 = ref.getParent()) instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement parentRef = (PsiJavaCodeReferenceElement)parent2;
                    if (parentRef.getQualifier() == ref) {
                        if (result2 == null) {
                            result2 = new IntArrayList();
                        }
                        result2.add(0, -1);
                        ref = parentRef;
                        continue;
                    }
                    throw new IllegalStateException("Unexpected parent (going not from qualifier): " + parent2.getText());
                }
                if (!(parent2 instanceof PsiTypeElement)) break block8;
                PsiElement nextParent = parent2.getParent();
                while (nextParent instanceof PsiTypeElement) {
                    parent2 = nextParent;
                    nextParent = nextParent.getParent();
                }
                if (!(nextParent instanceof PsiReferenceParameterList)) break;
                PsiReferenceParameterList list = (PsiReferenceParameterList)nextParent;
                int index = ArrayUtil.indexOf(list.getTypeParameterElements(), parent2);
                PsiElement nextRef = nextParent.getParent();
                if (!(nextRef instanceof PsiJavaCodeReferenceElement)) {
                    throw new IllegalStateException("Must be a reference: " + nextRef.getText());
                }
                ref = (PsiJavaCodeReferenceElement)nextRef;
                if (result2 == null) {
                    result2 = new IntArrayList();
                }
                result2.add(0, index);
            }
            return result2 == null ? ArrayUtil.EMPTY_INT_ARRAY : result2.toIntArray();
        }
        throw new IllegalStateException("Unexpected parent: " + parent2.getText());
    }

    @Contract(value="_,_,true -> !null")
    @Nullable
    private static PsiJavaCodeReferenceElement findReference(@NotNull PsiType type, int[] root, boolean check2) {
        if (type == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(9);
        }
        int offset = 0;
        while (true) {
            if (type instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)type).getBound();
                if (bound == null) {
                    if (check2) {
                        throw new IllegalStateException("Bound expected: " + type.getCanonicalText());
                    }
                    return null;
                }
                type = bound;
            }
            if (!((type = type.getDeepComponentType()) instanceof PsiClassReferenceType)) {
                if (check2) {
                    throw new IllegalStateException("Reference type expected: " + type.getCanonicalText());
                }
                return null;
            }
            PsiClassReferenceType classType = (PsiClassReferenceType)type;
            PsiJavaCodeReferenceElement ref = classType.getReference();
            if (offset == root.length) {
                return ref;
            }
            int nextIndex = root[offset++];
            while (nextIndex == -1) {
                PsiElement qualifier = ref.getQualifier();
                if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                    if (check2) {
                        throw new IllegalStateException("Qualifier expected: " + ref.getCanonicalText());
                    }
                    return null;
                }
                ref = (PsiJavaCodeReferenceElement)qualifier;
                if (offset == root.length) {
                    return ref;
                }
                nextIndex = root[offset++];
            }
            PsiReferenceParameterList list = ref.getParameterList();
            if (list == null) {
                if (check2) {
                    throw new IllegalStateException("Parameter list expected: " + ref.getCanonicalText());
                }
                return null;
            }
            PsiType[] arguments = list.getTypeArguments();
            if (nextIndex >= arguments.length) {
                if (check2) {
                    throw new IllegalStateException("Type parameter #" + nextIndex + " expected: " + ref.getCanonicalText());
                }
                return null;
            }
            type = arguments[nextIndex];
        }
    }

    @NotNull
    private static ClassReferencePointer computeFromTypeOwner(final @NotNull PsiModifierListOwner parent2, final int[] pathFromRoot, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        if (parent2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(11);
        }
        return new ClassReferencePointer(){

            @Contract(value="true -> !null")
            @Nullable
            private PsiJavaCodeReferenceElement retrieveReference(boolean check2) {
                PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)ref.get();
                if (element != null && element.isValid()) {
                    return element;
                }
                if (check2) {
                    PsiUtilCore.ensureValid(parent2);
                }
                if (!parent2.isValid()) {
                    return null;
                }
                PsiType type = PsiUtil.getTypeByPsiElement(parent2);
                if (type == null) {
                    if (check2) {
                        throw new IllegalStateException("Type of " + parent2.getClass() + " is null");
                    }
                    return null;
                }
                return PsiTypeElementImpl.findReference(type, pathFromRoot, check2);
            }

            @Override
            @Nullable
            public PsiJavaCodeReferenceElement retrieveReference() {
                return this.retrieveReference(false);
            }

            @Override
            @NotNull
            public PsiJavaCodeReferenceElement retrieveNonNullReference() {
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.retrieveReference(true);
                if (psiJavaCodeReferenceElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiJavaCodeReferenceElement;
            }

            public String toString() {
                String msg = "Type element reference of " + parent2.getClass() + " #" + parent2.getClass().getSimpleName() + ", path=" + Arrays.toString(pathFromRoot);
                return parent2.isValid() ? msg + " #" + parent2.getLanguage() : msg + ", invalid";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiTypeElementImpl$1", "retrieveNonNullReference"));
            }
        };
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations2) {
        if (annotations2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(12);
        }
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create(ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true));
        if (typeAnnotationProvider == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    private @Unmodifiable @NotNull List<PsiType> collectTypes() {
        List<PsiTypeElement> typeElements = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiTypeElement.class);
        List<PsiType> list = ContainerUtil.map(typeElements, typeElement -> typeElement.getType());
        if (list == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(17);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(18);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(19);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(20);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        PsiModifierList modifierList2;
        PsiIdentifier identifier;
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(21);
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText('@' + qualifiedName, this);
        PsiElement firstChild = this.getFirstChild();
        for (PsiElement child = this.getLastChild(); child != firstChild; child = child.getPrevSibling()) {
            if (!PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET) && !PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) continue;
            PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore(annotation, child);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(22);
            }
            return psiAnnotation;
        }
        if (firstChild instanceof PsiJavaCodeReferenceElement && (identifier = PsiTreeUtil.getChildOfType(firstChild, PsiIdentifier.class)) != null && identifier != firstChild.getFirstChild()) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)firstChild.addBefore(annotation, identifier);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(23);
            }
            return psiAnnotation;
        }
        PsiElement parent2 = this.getParent();
        while (parent2 instanceof PsiTypeElement && ((PsiTypeElement)parent2).getType() instanceof PsiArrayType) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof PsiModifierListOwner && (modifierList2 = ((PsiModifierListOwner)parent2).getModifierList()) != null) {
            PsiTypeParameterList list;
            PsiTypeParameterList psiTypeParameterList = list = parent2 instanceof PsiTypeParameterListOwner ? ((PsiTypeParameterListOwner)parent2).getTypeParameterList() : null;
            if (list == null || list.textMatches("")) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)modifierList2.add(annotation);
                if (psiAnnotation == null) {
                    PsiTypeElementImpl.$$$reportNull$$$0(24);
                }
                return psiAnnotation;
            }
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore(annotation, firstChild);
        if (psiAnnotation == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(25);
        }
        return psiAnnotation;
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result2;
        if (newElement == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(26);
        }
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result2 = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result2);
        }
        return result2;
    }

    @Override
    public boolean acceptsAnnotations() {
        if (this.isInferredType()) {
            return false;
        }
        PsiType type = this.getType();
        return !PsiTypes.voidType().equals(type) && !PsiTypes.nullType().equals(type);
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiElement originalMethod;
        PsiElement originalVariable;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiVariable && (originalVariable = parent2.getOriginalElement()) != parent2 && originalVariable instanceof PsiVariable) {
            return ((PsiVariable)originalVariable).getTypeElement();
        }
        if (parent2 instanceof PsiMethod && (originalMethod = parent2.getOriginalElement()) != parent2 && originalMethod instanceof PsiMethod) {
            return ((PsiMethod)originalMethod).getReturnTypeElement();
        }
        if (parent2 instanceof PsiTypeElement || parent2 instanceof PsiJavaCodeReferenceElement || parent2 instanceof PsiReferenceParameterList) {
            return PsiImplUtil.getCorrespondingOriginalElementOfType(this, PsiTypeElement.class);
        }
        return this;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComputable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComputable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeFromTypeOwner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

