/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public abstract class InputOutputConstraintFormula
implements ConstraintFormula {
    private PsiType myT;

    protected InputOutputConstraintFormula(PsiType t) {
        this.myT = t;
    }

    public abstract PsiExpression getExpression();

    protected abstract InputOutputConstraintFormula createSelfConstraint(PsiType var1, PsiExpression var2);

    protected abstract void collectReturnTypeVariables(InferenceSession var1, PsiExpression var2, PsiType var3, Set<? super InferenceVariable> var4);

    public Set<InferenceVariable> getInputVariables(InferenceSession session) {
        PsiExpression psiExpression = this.getExpression();
        PsiType type = this.myT;
        if (psiExpression instanceof PsiFunctionalExpression) {
            PsiType functionType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiMethod interfaceMethod;
            InferenceVariable inferenceVariable = session.getInferenceVariable(type);
            if (inferenceVariable != null) {
                HashSet<InferenceVariable> result2 = new HashSet<InferenceVariable>();
                result2.add(inferenceVariable);
                return result2;
            }
            if (LambdaUtil.isFunctionalType(type) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionType = psiExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(type, (PsiLambdaExpression)psiExpression, false) : type))) != null) {
                PsiType returnType;
                HashSet<InferenceVariable> result3 = new HashSet<InferenceVariable>();
                PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                if (psiExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)psiExpression).hasFormalParameterTypes() || psiExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)psiExpression).isExact()) {
                    for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                        session.collectDependencies(substitutor2.substitute(parameter.getType()), result3);
                    }
                }
                if ((returnType = interfaceMethod.getReturnType()) != null) {
                    this.collectReturnTypeVariables(session, psiExpression, substitutor2.substitute(returnType), result3);
                }
                return result3;
            }
        }
        if (psiExpression instanceof PsiParenthesizedExpression) {
            PsiExpression expression3 = ((PsiParenthesizedExpression)psiExpression).getExpression();
            return expression3 != null ? this.createSelfConstraint(type, expression3).getInputVariables(session) : null;
        }
        if (psiExpression instanceof PsiConditionalExpression) {
            Set<InferenceVariable> elseResult;
            PsiExpression thenExpression = ((PsiConditionalExpression)psiExpression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)psiExpression).getElseExpression();
            Set<InferenceVariable> thenResult = thenExpression != null ? this.createSelfConstraint(type, thenExpression).getInputVariables(session) : null;
            Set<InferenceVariable> set = elseResult = elseExpression != null ? this.createSelfConstraint(type, elseExpression).getInputVariables(session) : null;
            if (thenResult == null) {
                return elseResult;
            }
            if (elseResult == null) {
                return thenResult;
            }
            thenResult.addAll(elseResult);
            return thenResult;
        }
        if (psiExpression instanceof PsiSwitchExpression) {
            Set<InferenceVariable> variables2 = PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)psiExpression).stream().flatMap(expression2 -> {
                Set<InferenceVariable> inputVariables = this.createSelfConstraint(type, (PsiExpression)expression2).getInputVariables(session);
                return inputVariables != null ? inputVariables.stream() : Stream.empty();
            }).collect(Collectors.toSet());
            return variables2.isEmpty() ? null : variables2;
        }
        return null;
    }

    @Nullable
    public Set<InferenceVariable> getOutputVariables(Set<InferenceVariable> inputVariables, InferenceSession session) {
        HashSet<InferenceVariable> mentionedVariables = new HashSet<InferenceVariable>();
        session.collectDependencies(this.myT, mentionedVariables);
        if (inputVariables != null) {
            mentionedVariables.removeAll(inputVariables);
        }
        return mentionedVariables.isEmpty() ? null : mentionedVariables;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public PsiType getCurrentType() {
        return this.myT;
    }

    public String toString() {
        return this.getExpression().getText() + " -> " + this.myT.getPresentableText();
    }
}

