/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceCompatibilityConstraint.class);
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(this.myT)));
            return false;
        }
        PsiType groundTargetType = this.myExpression.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(classResolveResult);
        if (interfaceMethod == null) {
            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(this.myT)));
            return false;
        }
        PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, classResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(substitutor2);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType = substitutor2.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters2 = this.myExpression.getTypeParameters();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this.myExpression);
        PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
        if (this.myExpression.isExact()) {
            PsiParameter[] parameters;
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiClass applicableMemberContainingClass = applicableMember.getContainingClass();
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, applicableMember, applicableMemberContainingClass, this.myExpression);
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters2.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters2[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters.length + 1) {
                PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(this.myExpression);
                PsiClass qualifierClass = PsiUtil.resolveClassInType(qualifierType);
                if (qualifierClass != null) {
                    PsiType pType = signature.getParameterTypes()[0];
                    constraints.add(new StrictSubtypingConstraint(session.substituteWithInferenceVariables(qualifierType), pType));
                }
                for (int i = 1; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters[i - 1].getType())), PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[i], this.myExpression)));
                }
            } else if (targetParameters.length == parameters.length) {
                for (int i = 0; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters[i].getType())), PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[i], this.myExpression)));
                }
            } else {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.parameter.types.in.method.reference", new Object[0]));
                return false;
            }
            if (!PsiTypes.voidType().equals(returnType) && returnType != null) {
                PsiType applicableMethodReturnType = null;
                if (applicableMember instanceof PsiMethod) {
                    PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(this.myExpression, (PsiMethod)applicableMember);
                    PsiType psiType = applicableMethodReturnType = getClassReturnType != null ? getClassReturnType : ((PsiMethod)applicableMember).getReturnType();
                }
                if (PsiTypes.voidType().equals(applicableMethodReturnType)) {
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.types.expected.not.void.got.void.method.reference", new Object[0]));
                    return false;
                }
                if (applicableMethodReturnType == null && (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) && qContainingClass != null) {
                    applicableMethodReturnType = JavaPsiFacade.getElementFactory(applicableMember.getProject()).createType(qContainingClass, PsiSubstitutor.EMPTY);
                }
                if (applicableMethodReturnType != null) {
                    applicableMethodReturnType = psiSubstitutor.substitute(applicableMethodReturnType);
                    applicableMethodReturnType = Registry.is("unsound.capture.conversion.java.spec.change") ? applicableMethodReturnType : PsiUtil.captureToplevelWildcards(applicableMethodReturnType, this.myExpression);
                    constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(applicableMethodReturnType)));
                }
            }
            return true;
        }
        for (PsiType paramType : signature.getParameterTypes()) {
            if (session.isProperType(paramType)) continue;
            return false;
        }
        JavaResolveResult resolve = this.myExpression.advancedResolve(false);
        PsiElement element = resolve.getElement();
        if (element == null) {
            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.declaration.for.the.method.reference.not.found", new Object[0]));
            return false;
        }
        if (resolve instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolve).isApplicable()) {
            return false;
        }
        if (PsiTypes.voidType().equals(returnType) || returnType == null) {
            return true;
        }
        if (element instanceof PsiMethod) {
            PsiType getClassReturnType;
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, method);
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, method, containingClass, this.myExpression);
            PsiType referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : ((getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(this.myExpression, method)) != null ? getClassReturnType : method.getReturnType());
            LOG.assertTrue(referencedMethodReturnType != null, method);
            if (typeParameters2.length == 0) {
                PsiTypeParameter[] methodTypeParameters;
                PsiTypeParameter[] psiTypeParameterArray = methodTypeParameters = method.isConstructor() ? containingClass.getTypeParameters() : method.getTypeParameters();
                if (methodTypeParameters.length > 0) {
                    PsiClass interfaceClass = classResolveResult.getElement();
                    LOG.assertTrue(interfaceClass != null);
                    if (PsiTypesUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(methodTypeParameters))) {
                        session.initBounds((PsiElement)this.myExpression, psiSubstitutor, methodTypeParameters);
                        session.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve, groundTargetType);
                        session.registerReturnTypeConstraints(psiSubstitutor.substitute(referencedMethodReturnType), returnType, this.myExpression);
                        return true;
                    }
                }
            }
            if (PsiTypes.voidType().equals(referencedMethodReturnType)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.expected.non.void.got.void.method.reference", new Object[0]));
                return false;
            }
            int idx = 0;
            for (PsiTypeParameter param : method.getTypeParameters()) {
                if (idx >= typeParameters2.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters2[idx++]);
            }
            if (qContainingClass != null && PsiUtil.isRawSubstitutor(qContainingClass, qualifierResolveResult.getSubstitutor()) && PsiMethodReferenceCompatibilityConstraint.getParameterization(signature, qualifierResolveResult, method, this.myExpression, qContainingClass) == null) {
                if (!PsiMethodReferenceUtil.isSecondSearchPossible(signature.getParameterTypes(), qualifierResolveResult, this.myExpression)) {
                    session.initBounds((PsiElement)this.myExpression, qContainingClass.getTypeParameters());
                } else {
                    referencedMethodReturnType = TypeConversionUtil.erasure(referencedMethodReturnType);
                }
            }
            referencedMethodReturnType = psiSubstitutor.substitute(referencedMethodReturnType);
            referencedMethodReturnType = Registry.is("unsound.capture.conversion.java.spec.change") ? referencedMethodReturnType : PsiUtil.captureToplevelWildcards(referencedMethodReturnType, this.myExpression);
            constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(referencedMethodReturnType)));
        }
        return true;
    }

    public static PsiSubstitutor getSubstitutor(MethodSignature signature, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMember member, @Nullable PsiClass containingClass, PsiMethodReferenceExpression methodReferenceExpression) {
        PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
        if (qContainingClass != null && containingClass != null) {
            if (PsiUtil.isRawSubstitutor(qContainingClass, psiSubstitutor)) {
                PsiClassType parameterization = PsiMethodReferenceCompatibilityConstraint.getParameterization(signature, qualifierResolveResult, member, methodReferenceExpression, qContainingClass);
                if (parameterization != null) {
                    PsiType pType = PsiUtil.captureToplevelWildcards(parameterization, methodReferenceExpression);
                    psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(qContainingClass, (PsiClassType)pType);
                } else {
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
            }
            if (qContainingClass.isInheritor(containingClass, true)) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, qContainingClass, psiSubstitutor)) != null);
            }
        }
        return psiSubstitutor;
    }

    private static PsiClassType getParameterization(MethodSignature signature, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMember member, PsiMethodReferenceExpression methodReferenceExpression, PsiClass qContainingClass) {
        PsiClassType subclassType;
        if (member instanceof PsiMethod && PsiMethodReferenceUtil.isSecondSearchPossible(signature.getParameterTypes(), qualifierResolveResult, methodReferenceExpression) && (subclassType = StrictSubtypingConstraint.getSubclassType(qContainingClass, signature.getParameterTypes()[0], true)) != null && !subclassType.isRaw()) {
            return subclassType;
        }
        return null;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

