/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.util.SameThreadExecutorService;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;

public final class ConcurrencyUtil {
    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map == null) {
            ConcurrencyUtil.$$$reportNull$$$0(1);
        }
        if (key == null) {
            ConcurrencyUtil.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(3);
        }
        if ((v = map.get(key)) != null) {
            Object v2 = v;
            if (v2 == null) {
                ConcurrencyUtil.$$$reportNull$$$0(4);
            }
            return v2;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(5);
        }
        return v3;
    }

    @NotNull
    public static <T> T cacheOrGet(@NotNull AtomicReference<T> ref, @NotNull T defaultValue) {
        T value2;
        if (ref == null) {
            ConcurrencyUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(7);
        }
        if ((value2 = ref.get()) != null) {
            T t = value2;
            if (t == null) {
                ConcurrencyUtil.$$$reportNull$$$0(8);
            }
            return t;
        }
        T t = ref.updateAndGet(prev -> prev == null ? defaultValue : prev);
        if (t == null) {
            ConcurrencyUtil.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    public static <T> T computeIfAbsent(@NotNull UserDataHolder holder, @NotNull Key<T> key, @NotNull @NotNull Supplier<? extends @NotNull T> defaultValue) {
        T data;
        if (holder == null) {
            ConcurrencyUtil.$$$reportNull$$$0(10);
        }
        if (key == null) {
            ConcurrencyUtil.$$$reportNull$$$0(11);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(12);
        }
        if ((data = holder.getUserData(key)) != null) {
            T t = data;
            if (t == null) {
                ConcurrencyUtil.$$$reportNull$$$0(13);
            }
            return t;
        }
        if (holder instanceof UserDataHolderEx) {
            T t = ((UserDataHolderEx)holder).putUserDataIfAbsent(key, defaultValue.get());
            if (t == null) {
                ConcurrencyUtil.$$$reportNull$$$0(14);
            }
            return t;
        }
        T t = ConcurrencyUtil.slowPath(holder, key, defaultValue);
        if (t == null) {
            ConcurrencyUtil.$$$reportNull$$$0(15);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T slowPath(@NotNull UserDataHolder holder, @NotNull Key<T> key, @NotNull Supplier<? extends T> defaultValue) {
        if (holder == null) {
            ConcurrencyUtil.$$$reportNull$$$0(16);
        }
        if (key == null) {
            ConcurrencyUtil.$$$reportNull$$$0(17);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(18);
        }
        UserDataHolder userDataHolder = holder;
        synchronized (userDataHolder) {
            T data = holder.getUserData(key);
            if (data != null) {
                return data;
            }
            data = defaultValue.get();
            holder.putUserData(key, data);
            return data;
        }
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String name2) {
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(19);
        }
        return ConcurrencyUtil.newSingleThreadExecutor(name2, 5);
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String name2, int priority) {
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(20);
        }
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(name2, true, priority));
    }

    @NotNull
    public static ExecutorService newSameThreadExecutorService() {
        return new SameThreadExecutorService();
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(@NonNls @NotNull String name2, boolean isDaemon, int priority) {
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(24);
        }
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r, name2);
            thread.setDaemon(isDaemon);
            thread.setPriority(priority);
            return thread;
        };
        if (threadFactory == null) {
            ConcurrencyUtil.$$$reportNull$$$0(25);
        }
        return threadFactory;
    }

    /*
     * WARNING - void declaration
     */
    public static void getAll(long timeout, @NotNull TimeUnit timeUnit, @NotNull @NotNull Collection<? extends @NotNull Future<?>> collection) throws ExecutionException, InterruptedException, TimeoutException {
        void futures;
        if (timeUnit == null) {
            ConcurrencyUtil.$$$reportNull$$$0(33);
        }
        if (collection == null) {
            ConcurrencyUtil.$$$reportNull$$$0(34);
        }
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        for (Future future : futures) {
            long toWait = deadline - System.nanoTime();
            if (toWait < 0L) {
                throw new TimeoutException();
            }
            try {
                future.get(toWait, TimeUnit.NANOSECONDS);
            }
            catch (CancellationException cancellationException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderThreadName(@NotNull String name2, @NotNull Runnable runnable) {
        Thread currentThread;
        String oldThreadName;
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(38);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(39);
        }
        if (name2.equals(oldThreadName = (currentThread = Thread.currentThread()).getName())) {
            runnable.run();
        } else {
            currentThread.setName(name2);
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(oldThreadName);
            }
        }
    }

    @ApiStatus.Obsolete
    public static <E extends Throwable> void withLock(@NotNull Lock lock2, @NotNull ThrowableRunnable<E> runnable) throws E {
        if (lock2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(44);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(45);
        }
        lock2.lock();
        try {
            runnable.run();
        }
        finally {
            lock2.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 36: 
            case 39: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIfAbsent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newNamedThreadFactory";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "underThreadNameRunnable";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "once";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeIfAbsent";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "slowPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newSingleThreadExecutor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "newNamedThreadFactory";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescence";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "joinAll";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "underThreadNameRunnable";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runUnderThreadName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "once";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "withLock";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "manifestExceptionsIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

