/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

@ApiStatus.Internal
public final class DebugAttachDetectorArgs {
    private static final Logger LOG = Logger.getInstance(DebugAttachDetectorArgs.class);
    @Nullable
    private static final String DEBUG_ARGS = DebugAttachDetectorArgs.findDebugArgs();
    @Nullable
    private static final Properties AGENT_PROPERTIES = DebugAttachDetectorArgs.findAgentProperties();

    public static boolean isDebugEnabled() {
        return DEBUG_ARGS != null;
    }

    public static boolean isAttached() {
        if (!DebugAttachDetectorArgs.isDebugEnabled()) {
            return false;
        }
        if (!DebugAttachDetectorArgs.isDebugServer()) {
            return true;
        }
        Properties properties2 = AGENT_PROPERTIES;
        if (properties2 == null) {
            return true;
        }
        return DebugAttachDetectorArgs.isAttached(properties2);
    }

    private static boolean isAttached(@NotNull Properties properties2) {
        String property2;
        if (properties2 == null) {
            DebugAttachDetectorArgs.$$$reportNull$$$0(0);
        }
        return (property2 = properties2.getProperty("sun.jdwp.listenerAddress")) != null && property2.isEmpty();
    }

    private static boolean isDebugServer() {
        String args = DEBUG_ARGS;
        return args != null && args.contains("server=y");
    }

    @Nullable
    private static String findDebugArgs() {
        try {
            for (String value2 : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!value2.contains("-agentlib:jdwp")) continue;
                return value2;
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return null;
    }

    @Nullable
    private static Properties findAgentProperties() {
        Class<?> vmSupportClass;
        try {
            vmSupportClass = Class.forName("jdk.internal.vm.VMSupport");
        }
        catch (Exception e) {
            try {
                vmSupportClass = Class.forName("sun.misc.VMSupport");
            }
            catch (Exception ignored) {
                LOG.warn("Unable to init DebugAttachDetector, VMSupport class not found");
                return null;
            }
        }
        try {
            return (Properties)vmSupportClass.getMethod("getAgentProperties", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(ex);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/com/intellij/util/DebugAttachDetectorArgs", "isAttached"));
    }
}

